/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.toml;

import gg.skytils.vigilance.impl.nightconfig.core.io.CharacterInput;
import gg.skytils.vigilance.impl.nightconfig.core.io.CharsWrapper;
import gg.skytils.vigilance.impl.nightconfig.core.io.ParsingException;
import gg.skytils.vigilance.impl.nightconfig.core.io.Utils;
import gg.skytils.vigilance.impl.nightconfig.toml.Toml;
import gg.skytils.vigilance.impl.nightconfig.toml.TomlParser;

final class StringParser {
    private static final char[] SINGLE_QUOTE = new char[]{'\''};

    static String parseBasic(CharacterInput input2, TomlParser parser) {
        char c;
        CharsWrapper.Builder builder = parser.createBuilder();
        boolean escape = false;
        while ((c = input2.readChar()) != '\"' || escape) {
            if (escape) {
                builder.write(StringParser.escape(c, input2));
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            builder.write(c);
        }
        return builder.toString();
    }

    static String parseLiteral(CharacterInput input2, TomlParser parser) {
        String str2 = input2.readCharsUntil(SINGLE_QUOTE).toString();
        input2.readChar();
        return str2;
    }

    static String parseMultiBasic(CharacterInput input2, TomlParser parser) {
        char c;
        CharsWrapper.Builder builder = parser.createBuilder();
        while ((c = input2.readChar()) != '\"' || input2.peek() != 34 || input2.peek(1) != 34) {
            if (c == '\\') {
                char next = input2.readChar();
                if (next == '\n' || next == '\r' && input2.peekChar() == '\n' || (next == '\t' || next == ' ') && StringParser.isWhitespace(Toml.readLine(input2))) {
                    char nextNonSpace = Toml.readNonSpaceChar(input2, true);
                    input2.pushBack(nextNonSpace);
                    continue;
                }
                if (next == '\t' || next == ' ') {
                    throw new ParsingException("Invalid escapement: \\" + next);
                }
                builder.write(StringParser.escape(next, input2));
                continue;
            }
            builder.write(c);
        }
        input2.skipPeeks();
        return StringParser.buildMultilineString(builder);
    }

    static String parseMultiLiteral(CharacterInput input2, TomlParser parser) {
        char c;
        CharsWrapper.Builder builder = parser.createBuilder();
        while ((c = input2.readChar()) != '\'' || input2.peek() != 39 || input2.peek(1) != 39) {
            builder.append(c);
        }
        input2.skipPeeks();
        return StringParser.buildMultilineString(builder);
    }

    private static String buildMultilineString(CharsWrapper.Builder builder) {
        if (builder.get(0) == '\n') {
            return builder.toString(1);
        }
        if (builder.get(0) == '\r' && builder.get(1) == '\n') {
            return builder.toString(2);
        }
        return builder.toString();
    }

    private static char escape(char c, CharacterInput input2) {
        switch (c) {
            case '\"': 
            case '\\': {
                return c;
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'u': {
                CharsWrapper chars = input2.readChars(4);
                return (char)Utils.parseInt(chars, 16);
            }
            case 'U': {
                CharsWrapper chars = input2.readChars(8);
                return (char)Utils.parseInt(chars, 16);
            }
        }
        throw new ParsingException("Invalid escapement: \\" + c);
    }

    private static boolean isWhitespace(CharSequence csq) {
        for (int i = 0; i < csq.length(); ++i) {
            char c = csq.charAt(i);
            if (c == '\t' || c == ' ') continue;
            return false;
        }
        return true;
    }

    private StringParser() {
    }
}

