/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils.rendering;

import gg.skytils.skytilsmod.utils.Utils;
import gg.skytils.skytilsmod.utils.rendering.Mesh;
import gg.skytils.skytilsmod.utils.rendering.VertexBuffer;
import gg.skytils.skytilsmod.utils.rendering.VertexScope;
import java.io.Closeable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 %2\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00012\u00020\u0003:\u0001%B-\b\u0000\u0012\u0006\u0010\u0011\u001a\u00020\u0007\u0012\u0006\u0010 \u001a\u00020\u0007\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0004\b#\u0010$J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ,\u0010\u000f\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u000b2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b \u0010\u0012\u001a\u0004\b!\u0010\u0014\u00a8\u0006&"}, d2={"Lgg/skytils/skytilsmod/utils/rendering/VertexArray;", "Ljava/lang/ref/PhantomReference;", "Lgg/skytils/skytilsmod/utils/rendering/Mesh;", "Ljava/io/Closeable;", "", "close", "()V", "", "drawMode", "render", "(I)V", "T", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "block", "whileBound", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "id", "I", "getId", "()I", "Lgg/skytils/skytilsmod/utils/rendering/VertexScope;", "scope", "Lgg/skytils/skytilsmod/utils/rendering/VertexScope;", "getScope", "()Lgg/skytils/skytilsmod/utils/rendering/VertexScope;", "Ljava/util/HashSet;", "Lgg/skytils/skytilsmod/utils/rendering/VertexBuffer;", "vbos", "Ljava/util/HashSet;", "getVbos", "()Ljava/util/HashSet;", "vertexCount", "getVertexCount", "mesh", "<init>", "(IILgg/skytils/skytilsmod/utils/rendering/VertexScope;Lgg/skytils/skytilsmod/utils/rendering/Mesh;)V", "Companion", "SkytilsMod"})
public final class VertexArray
extends PhantomReference<Mesh<?>>
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    private final int vertexCount;
    @NotNull
    private final VertexScope scope;
    @NotNull
    private final HashSet<VertexBuffer> vbos;
    @NotNull
    private static final ReferenceQueue<Mesh<?>> referenceQueue = new ReferenceQueue();
    @NotNull
    private static final Set<VertexArray> cleanupQueue;

    public VertexArray(int id, int vertexCount, @NotNull VertexScope scope2, @NotNull Mesh<?> mesh) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Intrinsics.checkNotNullParameter(mesh, "mesh");
        super(mesh, referenceQueue);
        this.id = id;
        this.vertexCount = vertexCount;
        this.scope = scope2;
        this.vbos = new HashSet();
        cleanupQueue.add(this);
        Companion.drainCleanupQueue();
    }

    public final int getId() {
        return this.id;
    }

    public final int getVertexCount() {
        return this.vertexCount;
    }

    @NotNull
    public final VertexScope getScope() {
        return this.scope;
    }

    @NotNull
    public final HashSet<VertexBuffer> getVbos() {
        return this.vbos;
    }

    @Override
    public void close() {
        Utils.INSTANCE.checkThreadAndQueue(new Function0<Unit>(this){
            final /* synthetic */ VertexArray this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                VertexArray.Companion.getCleanupQueue().remove(this.this$0);
                GL30.glDeleteVertexArrays((int)this.this$0.getId());
            }
        });
    }

    public final void render(int drawMode) {
        this.whileBound((Function1)new Function1<VertexArray, Unit>(drawMode){
            final /* synthetic */ int $drawMode;
            {
                this.$drawMode = $drawMode;
                super(1);
            }

            public final void invoke(@NotNull VertexArray $this$whileBound) {
                int p0;
                Intrinsics.checkNotNullParameter($this$whileBound, "$this$whileBound");
                Iterable $this$forEach$iv = $this$whileBound.getScope().getAttributes();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    p0 = ((Number)element$iv).intValue();
                    boolean bl = false;
                    GL20.glEnableVertexAttribArray((int)p0);
                }
                GL11.glDrawArrays((int)this.$drawMode, (int)0, (int)$this$whileBound.getVertexCount());
                $this$forEach$iv = $this$whileBound.getScope().getAttributes();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    p0 = ((Number)element$iv).intValue();
                    boolean bl = false;
                    GL20.glDisableVertexAttribArray((int)p0);
                }
            }
        });
    }

    public final <T> T whileBound(@NotNull Function1<? super VertexArray, ? extends T> block2) {
        Intrinsics.checkNotNullParameter(block2, "block");
        GL30.glBindVertexArray((int)this.id);
        T res = block2.invoke(this);
        GL30.glBindVertexArray((int)0);
        return res;
    }

    static {
        Set set2 = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set2, "newSetFromMap(...)");
        cleanupQueue = set2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lgg/skytils/skytilsmod/utils/rendering/VertexArray$Companion;", "", "", "drainCleanupQueue", "()V", "", "Lgg/skytils/skytilsmod/utils/rendering/VertexArray;", "cleanupQueue", "Ljava/util/Set;", "getCleanupQueue", "()Ljava/util/Set;", "Ljava/lang/ref/ReferenceQueue;", "Lgg/skytils/skytilsmod/utils/rendering/Mesh;", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "getReferenceQueue", "()Ljava/lang/ref/ReferenceQueue;", "<init>", "SkytilsMod"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReferenceQueue<Mesh<?>> getReferenceQueue() {
            return referenceQueue;
        }

        @NotNull
        public final Set<VertexArray> getCleanupQueue() {
            return cleanupQueue;
        }

        public final void drainCleanupQueue() {
            while (true) {
                Reference<Mesh<?>> reference = this.getReferenceQueue().poll();
                if (reference == null) break;
                ((VertexArray)reference).close();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

