/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.tweaker;

import gg.skytils.skytilsmod.tweaker.SkytilsLoadingPluginKt;
import gg.skytils.skytilsmod.tweaker.TweakerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import kotlin.KotlinVersion;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.Name(value="Skytils On Top")
@IFMLLoadingPlugin.SortingIndex(value=69)
public class SkytilsLoadingPlugin
implements IFMLLoadingPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"Skytils Loading Plugin");
    public static final String missingDependency = "<html><p>Skytils has detected a possible missing dependency<br>The most likely reason is Essential failed to load.<br>Wait a bit, then restart your game.<br>Essential might also not work in your country.<br>Check the Skytils Discord for any announcements, and<br>if there are none, ask for support.</p></html>";
    public static final String badMixinVersionMessage = "<html><p>Skytils has detected an older version of Mixin.<br>Many of my features require Mixin 0.8 or later!<br>In order to resolve this conflict you must remove<br>any mods with a Mixin version below 0.8.<br>You can also try to rename Skytils to be above other mods alphabetically<br>by changing Skytils.jar to !Skytils.jar<br>If you have already done this and are still getting this error,<br>ask for support in the Discord.";
    public static final String liteloaderUserMessage = "<html><p>Skytils has detected that you are using LiteLoader.<br>LiteLoader bundles an older, incompatible version of Mixin.<br>In order to resolve this conflict you must launch<br>Minecraft without LiteLoader.<br>If you have already done this and are still getting this error,<br>ask for support in the Discord.</p></html>";
    private static final String voidChatMessage = "<html><p>Skytils has detected that you are using VoidChat.<br>VoidChat breaks many of my features!<br>In order to resolve this conflict you must remove<br>VoidChat from your Minecraft mods folder.<br>A good alternative is Patcher at https://sk1er.club/mods/Patcher.<br>If you have already done this and are still getting this error,<br>ask for support in the Discord.</p></html>";
    private static final String betterFPSMessage = "<html><p>Skytils has detected that you are using BetterFPS.<br>BetterFPS breaks my core plugins, and also breaks the game!<br>In order to resolve this conflict you must remove<br>BetterFPS from your Minecraft mods folder.<br>You probably will not notice a change in your FPS.<br>Video showcasing breaking changes: https://streamable.com/q4ip5u.<br>If you have already done this and are still getting this error,<br>ask for support in the Discord.</p></html>";
    private static final String essentialUpdateDeniedMessage = "<html><p>Skytils has detected that your Essential is out of date and you have denied the update. <br>In order for Skytils to function, we rely on many APIs provided by Essential. <br>Please restart your game and accept Essential's update pop-up. <br>Alternatively, click the \"Accept Essential Update\" button below and restart your game.</p></html>";
    private static final String essentialUpdateAcceptedMessage = "<html><p>Skytils has detected that your Essential is out of date but you have accepted the update. <br>Please restart your game and allow Essential to update.</p></html>";
    private static final String essentialUpdateAvailableMessage = "<html><p>A new Essential update is available! <br>Skytils requires this new update in order to function properly. <br>Please restart your game and accept Essential's update pop-up. <br>Alternatively, click the \"Accept Essential Update\" button below and restart your game.</p></html>";
    private final SkytilsLoadingPluginKt kotlinPlugin;

    public SkytilsLoadingPlugin() {
        if (System.getProperty("skytils.skipStartChecks") == null) {
            if (!this.checkForClass("kotlin.KotlinVersion") || !this.checkForClass("gg.essential.api.EssentialAPI")) {
                TweakerUtil.showMessage(missingDependency, new JButton[0]);
                TweakerUtil.exit();
            }
            if (!KotlinVersion.CURRENT.isAtLeast(1, 9, 0)) {
                EssentialPendingUpdateMode essentialUpdateMode = this.checkPendingEssentialUpdateStatus();
                if (essentialUpdateMode == EssentialPendingUpdateMode.Denied) {
                    this.updatePendingEssentialUpdateStatus(false);
                    JButton acceptEssentialUpdate = new JButton("Accept Essential Update");
                    acceptEssentialUpdate.addActionListener(e -> {
                        this.updatePendingEssentialUpdateStatus(true);
                        TweakerUtil.exit();
                    });
                    TweakerUtil.showMessage(essentialUpdateDeniedMessage, acceptEssentialUpdate);
                    TweakerUtil.exit();
                } else if (essentialUpdateMode == EssentialPendingUpdateMode.Accepted) {
                    TweakerUtil.showMessage(essentialUpdateAcceptedMessage, new JButton[0]);
                    TweakerUtil.exit();
                } else if (essentialUpdateMode == EssentialPendingUpdateMode.Pending) {
                    JButton acceptEssentialUpdate = new JButton("Accept Essential Update");
                    acceptEssentialUpdate.addActionListener(e -> {
                        this.updatePendingEssentialUpdateStatus(true);
                        TweakerUtil.exit();
                    });
                    TweakerUtil.showMessage(essentialUpdateAvailableMessage, acceptEssentialUpdate);
                    TweakerUtil.exit();
                } else if (essentialUpdateMode == EssentialPendingUpdateMode.NoUpdate) {
                    TweakerUtil.showMessage("You should not be here, please contact `sychic` on discord. <br>Join discord.gg/skytils and ping Sychic in #general.", new JButton[0]);
                    TweakerUtil.exit();
                }
            }
            if (this.checkForClass("com.sky.voidchat.EDFMLLoadingPlugin")) {
                TweakerUtil.showMessage(voidChatMessage, new JButton[0]);
                TweakerUtil.exit();
            }
            if (this.checkForClass("me.guichaguri.betterfps.BetterFpsHelper")) {
                TweakerUtil.showMessage(betterFPSMessage, new JButton[0]);
                TweakerUtil.exit();
            }
        }
        this.kotlinPlugin = new SkytilsLoadingPluginKt();
    }

    private boolean checkForClass(String className) {
        try {
            Class.forName(className, false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EssentialPendingUpdateMode checkPendingEssentialUpdateStatus() {
        Path propertiesPath = Launch.minecraftHome.toPath().resolve(Paths.get("essential/essential-loader.properties", new String[0]));
        if (!Files.exists(propertiesPath, new LinkOption[0])) {
            LOGGER.fatal("Unable to find essential/essential-loader.properties file. How did this happen?");
            return EssentialPendingUpdateMode.NoUpdate;
        }
        try (InputStream input2 = Files.newInputStream(propertiesPath.toFile().toPath(), new OpenOption[0]);){
            Properties properties2 = new Properties();
            properties2.load(input2);
            String value = properties2.getProperty("pendingUpdateResolution");
            if (value.equals("true")) {
                EssentialPendingUpdateMode essentialPendingUpdateMode = EssentialPendingUpdateMode.Accepted;
                return essentialPendingUpdateMode;
            }
            if (value.equals("false")) {
                EssentialPendingUpdateMode essentialPendingUpdateMode = EssentialPendingUpdateMode.Denied;
                return essentialPendingUpdateMode;
            }
            if (properties2.containsKey("pendingUpdateVersion")) {
                EssentialPendingUpdateMode essentialPendingUpdateMode = EssentialPendingUpdateMode.Pending;
                return essentialPendingUpdateMode;
            }
            LOGGER.info("Failed to find `pendingUpdateResolution` and `pendingUpdateVersion` in properties file.");
            EssentialPendingUpdateMode essentialPendingUpdateMode = EssentialPendingUpdateMode.NoUpdate;
            return essentialPendingUpdateMode;
        }
        catch (IOException ioe) {
            LOGGER.fatal("Failed to read essential/essential-loader.properties file", (Throwable)ioe);
            return EssentialPendingUpdateMode.NoUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePendingEssentialUpdateStatus(boolean accepted) {
        Path propertiesPath = Launch.minecraftHome.toPath().resolve(Paths.get("essential/essential-loader.properties", new String[0]));
        if (Files.exists(propertiesPath, new LinkOption[0])) {
            try {
                Properties properties2 = new Properties();
                try (InputStream input2 = Files.newInputStream(propertiesPath, new OpenOption[0]);){
                    properties2.load(input2);
                }
                if (accepted) {
                    properties2.setProperty("pendingUpdateResolution", "true");
                } else {
                    properties2.remove("pendingUpdateResolution");
                }
                Path temp = Files.createTempFile(propertiesPath.getParent(), "skytils-temp-essential-loader", ".properties", new FileAttribute[0]);
                try (OutputStream output2 = Files.newOutputStream(temp, new OpenOption[0]);){
                    properties2.store(output2, "Updated by Skytils version 1.10.8");
                }
                try {
                    LOGGER.debug("Attempting atomic move of {} to {}", new Object[]{temp, propertiesPath});
                    Files.move(temp, propertiesPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (FileSystemException fse) {
                    try {
                        LOGGER.fatal("Atomic move failed", (Throwable)fse);
                        Files.move(temp, propertiesPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable) {
                        LOGGER.debug("Deleting temp file {}", new Object[]{temp});
                        Files.deleteIfExists(temp);
                        throw throwable;
                    }
                    LOGGER.debug("Deleting temp file {}", new Object[]{temp});
                    Files.deleteIfExists(temp);
                }
                LOGGER.debug("Deleting temp file {}", new Object[]{temp});
                Files.deleteIfExists(temp);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            LOGGER.fatal("Unable to find essential/essential-loader.properties file. How did we get here?");
        }
    }

    public String[] getASMTransformerClass() {
        return this.kotlinPlugin.getASMTransformerClass();
    }

    public String getModContainerClass() {
        return this.kotlinPlugin.getModContainerClass();
    }

    public String getSetupClass() {
        return this.kotlinPlugin.getSetupClass();
    }

    public void injectData(Map<String, Object> data2) {
        this.kotlinPlugin.injectData(data2);
    }

    public String getAccessTransformerClass() {
        return this.kotlinPlugin.getAccessTransformerClass();
    }

    private static enum EssentialPendingUpdateMode {
        Denied,
        Accepted,
        Pending,
        NoUpdate;

    }
}

