/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.expression.impl.ast.expressions;

import gg.skytils.mixinextras.expression.impl.ExpressionSource;
import gg.skytils.mixinextras.expression.impl.ast.expressions.BinaryExpression;
import gg.skytils.mixinextras.expression.impl.ast.expressions.Expression;
import gg.skytils.mixinextras.expression.impl.ast.expressions.IntLiteralExpression;
import gg.skytils.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import gg.skytils.mixinextras.expression.impl.flow.FlowValue;
import gg.skytils.mixinextras.expression.impl.point.ExpressionContext;

public class UnaryExpression
extends SimpleExpression {
    public final Operator operator;
    public final Expression expression;

    public UnaryExpression(ExpressionSource src, Operator operator, Expression expression) {
        super(src);
        this.operator = operator;
        this.expression = expression;
    }

    @Override
    public boolean matches(FlowValue node, ExpressionContext ctx) {
        switch (this.operator) {
            case MINUS: {
                switch (node.getInsn().getOpcode()) {
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: {
                        return UnaryExpression.inputsMatch(node, ctx, this.expression);
                    }
                }
            }
            case BITWISE_NOT: {
                return new BinaryExpression(null, this.expression, BinaryExpression.Operator.BITWISE_XOR, new IntLiteralExpression(null, -1L)).matches(node, ctx);
            }
        }
        return false;
    }

    public static enum Operator {
        MINUS,
        BITWISE_NOT;

    }
}

