/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.expression.impl.ast.expressions;

import gg.skytils.mixinextras.expression.impl.ExpressionSource;
import gg.skytils.mixinextras.expression.impl.ast.expressions.Expression;
import gg.skytils.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import gg.skytils.mixinextras.expression.impl.ast.identifiers.MemberIdentifier;
import gg.skytils.mixinextras.expression.impl.flow.FlowValue;
import gg.skytils.mixinextras.expression.impl.flow.postprocessing.MethodCallType;
import gg.skytils.mixinextras.expression.impl.point.ExpressionContext;
import gg.skytils.mixinextras.lib.apache.commons.ArrayUtils;
import java.util.List;

public class MethodCallExpression
extends SimpleExpression {
    public final Expression receiver;
    public final MemberIdentifier name;
    public final List<Expression> arguments;

    public MethodCallExpression(ExpressionSource src, Expression receiver2, MemberIdentifier name, List<Expression> arguments2) {
        super(src);
        this.receiver = receiver2;
        this.name = name;
        this.arguments = arguments2;
    }

    @Override
    public boolean matches(FlowValue node, ExpressionContext ctx) {
        if (!MethodCallType.NORMAL.matches(node)) {
            return false;
        }
        if (!this.name.matches(ctx.pool, node)) {
            return false;
        }
        Expression[] inputs = ArrayUtils.add(this.arguments.toArray(new Expression[0]), 0, this.receiver);
        return MethodCallExpression.inputsMatch(node, ctx, ctx.allowIncompleteListInputs, inputs);
    }
}

