/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.expression.impl.ast.expressions;

import gg.skytils.mixinextras.expression.impl.ExpressionSource;
import gg.skytils.mixinextras.expression.impl.ast.expressions.Expression;
import gg.skytils.mixinextras.expression.impl.ast.expressions.SimpleExpression;
import gg.skytils.mixinextras.expression.impl.ast.identifiers.MemberIdentifier;
import gg.skytils.mixinextras.expression.impl.flow.FlowValue;
import gg.skytils.mixinextras.expression.impl.point.ExpressionContext;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;

public class MemberAccessExpression
extends SimpleExpression {
    public final Expression receiver;
    public final MemberIdentifier name;

    public MemberAccessExpression(ExpressionSource src, Expression receiver2, MemberIdentifier name) {
        super(src);
        this.receiver = receiver2;
        this.name = name;
    }

    @Override
    public boolean matches(FlowValue node, ExpressionContext ctx) {
        AbstractInsnNode insn = node.getInsn();
        switch (insn.getOpcode()) {
            case 180: 
            case 190: {
                return this.name.matches(ctx.pool, node) && MemberAccessExpression.inputsMatch(node, ctx, this.receiver);
            }
        }
        return false;
    }

    @Override
    public void capture(FlowValue node, ExpressionContext ctx) {
        if (node.getInsn().getOpcode() == 190) {
            ctx.decorate(node.getInsn(), "mixinextras_simpleOperationArgs", new Type[]{node.getInput(0).getType()});
            ctx.decorate(node.getInsn(), "mixinextras_simpleOperationReturnType", Type.INT_TYPE);
            ctx.decorate(node.getInsn(), "mixinextras_simpleOperationParamNames", new String[]{"array", "index"});
        }
        super.capture(node, ctx);
    }
}

