/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.protobuf.internal;

import gg.skytils.ktx-serialization.KSerializer;
import gg.skytils.ktx-serialization.SerializationException;
import gg.skytils.ktx-serialization.SerializationStrategy;
import gg.skytils.ktx-serialization.builtins.BuiltinSerializersKt;
import gg.skytils.ktx-serialization.descriptors.PolymorphicKind;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptor;
import gg.skytils.ktx-serialization.descriptors.SerialKind;
import gg.skytils.ktx-serialization.descriptors.StructureKind;
import gg.skytils.ktx-serialization.encoding.CompositeEncoder;
import gg.skytils.ktx-serialization.encoding.Encoder;
import gg.skytils.ktx-serialization.internal.MapLikeSerializer;
import gg.skytils.ktx-serialization.modules.SerializersModule;
import gg.skytils.ktx-serialization.protobuf.ProtoBuf;
import gg.skytils.ktx-serialization.protobuf.ProtoIntegerType;
import gg.skytils.ktx-serialization.protobuf.internal.HelpersKt;
import gg.skytils.ktx-serialization.protobuf.internal.MapRepeatedEncoder;
import gg.skytils.ktx-serialization.protobuf.internal.NestedRepeatedEncoder;
import gg.skytils.ktx-serialization.protobuf.internal.ObjectEncoder;
import gg.skytils.ktx-serialization.protobuf.internal.PackedArrayEncoder;
import gg.skytils.ktx-serialization.protobuf.internal.ProtobufTaggedEncoder;
import gg.skytils.ktx-serialization.protobuf.internal.ProtobufWriter;
import gg.skytils.ktx-serialization.protobuf.internal.RepeatedEncoder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010=\u001a\u00020<\u0012\u0006\u0010F\u001a\u00020E\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\bH\u0010IJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ+\u0010\u0010\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0016\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000e\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u0019\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000e\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001c\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000e\u001a\u00020\u001bH\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ#\u0010\u001f\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000e\u001a\u00020\u001eH\u0014\u00a2\u0006\u0004\b\u001f\u0010 J+\u0010#\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b#\u0010$J#\u0010&\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000e\u001a\u00020%H\u0014\u00a2\u0006\u0004\b&\u0010'J#\u0010(\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000e\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b(\u0010)J#\u0010*\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000e\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b*\u0010+J#\u0010-\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000e\u001a\u00020,H\u0014\u00a2\u0006\u0004\b-\u0010.J#\u00100\u001a\u00020\u000f2\n\u0010\u0014\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u000e\u001a\u00020/H\u0014\u00a2\u0006\u0004\b0\u00101J\u0017\u00103\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u000202H\u0002\u00a2\u0006\u0004\b3\u00104J+\u00105\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u000e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b5\u0010\u0011J\u001f\u00107\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u00106\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b7\u00108J\u001f\u00109\u001a\u00060\u0012j\u0002`\u0013*\u00020\u00022\u0006\u00106\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b9\u0010:R\u0014\u0010\u0003\u001a\u00020\u00028\u0004X\u0085\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010;R\u0014\u0010=\u001a\u00020<8\u0004X\u0085\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u001a\u0010D\u001a\u00020?8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\bB\u0010C\u001a\u0004\b@\u0010AR\u0014\u0010F\u001a\u00020E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010G\u00a8\u0006J"}, d2={"Lgg/skytils/ktx-serialization/protobuf/internal/ProtobufEncoder;", "Lgg/skytils/ktx-serialization/protobuf/internal/ProtobufTaggedEncoder;", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "descriptor", "", "collectionSize", "Lgg/skytils/ktx-serialization/encoding/CompositeEncoder;", "beginCollection", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;I)Lgg/skytils/ktx-serialization/encoding/CompositeEncoder;", "beginStructure", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;)Lgg/skytils/ktx-serialization/encoding/CompositeEncoder;", "T", "Lgg/skytils/ktx-serialization/SerializationStrategy;", "serializer", "value", "", "encodeSerializableValue", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "", "Lgg/skytils/ktx-serialization/protobuf/internal/ProtoDesc;", "tag", "", "encodeTaggedBoolean", "(JZ)V", "", "encodeTaggedByte", "(JB)V", "", "encodeTaggedChar", "(JC)V", "", "encodeTaggedDouble", "(JD)V", "enumDescriptor", "ordinal", "encodeTaggedEnum", "(JLgg/skytils/ktx-serialization/descriptors/SerialDescriptor;I)V", "", "encodeTaggedFloat", "(JF)V", "encodeTaggedInt", "(JI)V", "encodeTaggedLong", "(JJ)V", "", "encodeTaggedShort", "(JS)V", "", "encodeTaggedString", "(JLjava/lang/String;)V", "", "serializeByteArray", "([B)V", "serializeMap", "index", "shouldEncodeElementDefault", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;I)Z", "getTag", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;I)J", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "Lgg/skytils/ktx-serialization/protobuf/ProtoBuf;", "proto", "Lgg/skytils/ktx-serialization/protobuf/ProtoBuf;", "Lgg/skytils/ktx-serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule$annotations", "()V", "serializersModule", "Lgg/skytils/ktx-serialization/protobuf/internal/ProtobufWriter;", "writer", "Lgg/skytils/ktx-serialization/protobuf/internal/ProtobufWriter;", "<init>", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufWriter;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nProtobufEncoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufEncoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufEncoder\n+ 2 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n*L\n1#1,211:1\n34#2:212\n34#2:213\n34#2:214\n34#2:215\n34#2:216\n34#2:217\n34#2:218\n*S KotlinDebug\n*F\n+ 1 ProtobufEncoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufEncoder\n*L\n74#1:212\n87#1:213\n95#1:214\n103#1:215\n111#1:216\n125#1:217\n146#1:218\n*E\n"})
public class ProtobufEncoder
extends ProtobufTaggedEncoder {
    @JvmField
    @NotNull
    protected final ProtoBuf proto;
    @NotNull
    private final ProtobufWriter writer;
    @JvmField
    @NotNull
    protected final SerialDescriptor descriptor;

    public ProtobufEncoder(@NotNull ProtoBuf proto, @NotNull ProtobufWriter writer, @NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.proto = proto;
        this.writer = writer;
        this.descriptor = descriptor2;
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.proto.getSerializersModule();
    }

    public static /* synthetic */ void getSerializersModule$annotations() {
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.proto.getEncodeDefaults$kotlinx_serialization_protobuf();
    }

    @Override
    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor2, int collectionSize) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        SerialKind serialKind = descriptor2.getKind();
        if (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE)) {
            ProtobufEncoder protobufEncoder;
            long tag = this.getCurrentTagOrDefault();
            if (HelpersKt.isPacked(tag) && HelpersKt.isPackable(descriptor2.getElementDescriptor(0))) {
                protobufEncoder = new PackedArrayEncoder(this.proto, this.writer, this.getCurrentTagOrDefault(), descriptor2, null, 16, null);
            } else {
                if (tag == 19500L) {
                    this.writer.writeInt(collectionSize);
                }
                protobufEncoder = Intrinsics.areEqual(this.descriptor.getKind(), StructureKind.LIST.INSTANCE) && tag != 19500L && !Intrinsics.areEqual(this.descriptor, descriptor2) ? (ProtobufEncoder)new NestedRepeatedEncoder(this.proto, this.writer, tag, descriptor2, null, 16, null) : (ProtobufEncoder)new RepeatedEncoder(this.proto, this.writer, tag, descriptor2);
            }
            compositeEncoder = protobufEncoder;
        } else if (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE)) {
            compositeEncoder = new MapRepeatedEncoder(this.proto, this.getCurrentTag(), this.writer, descriptor2);
        } else {
            throw new SerializationException("This serial kind is not supported as collection: " + descriptor2);
        }
        return compositeEncoder;
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeEncoder compositeEncoder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        SerialKind serialKind = descriptor2.getKind();
        if (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE)) {
            compositeEncoder = HelpersKt.isPackable(descriptor2.getElementDescriptor(0)) && HelpersKt.isPacked(this.getCurrentTagOrDefault()) ? (ProtobufEncoder)new PackedArrayEncoder(this.proto, this.writer, this.getCurrentTagOrDefault(), descriptor2, null, 16, null) : (ProtobufEncoder)new RepeatedEncoder(this.proto, this.writer, this.getCurrentTagOrDefault(), descriptor2);
        } else if ((Intrinsics.areEqual(serialKind, StructureKind.CLASS.INSTANCE) ? true : Intrinsics.areEqual(serialKind, StructureKind.OBJECT.INSTANCE)) ? true : serialKind instanceof PolymorphicKind) {
            long tag = this.getCurrentTagOrDefault();
            compositeEncoder = tag == 19500L && Intrinsics.areEqual(descriptor2, this.descriptor) ? this : (ProtobufEncoder)new ObjectEncoder(this.proto, this.getCurrentTagOrDefault(), this.writer, null, descriptor2, 8, null);
        } else if (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE)) {
            compositeEncoder = new MapRepeatedEncoder(this.proto, this.getCurrentTagOrDefault(), this.writer, descriptor2);
        } else {
            throw new SerializationException("This serial kind is not supported as structure: " + descriptor2);
        }
        return compositeEncoder;
    }

    @Override
    protected void encodeTaggedInt(long tag, int value) {
        if (tag == 19500L) {
            this.writer.writeInt(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeInt(value, (int)($this$protoId$iv & Integer.MAX_VALUE), HelpersKt.getIntegerType(tag));
        }
    }

    @Override
    protected void encodeTaggedByte(long tag, byte value) {
        this.encodeTaggedInt(tag, value);
    }

    @Override
    protected void encodeTaggedShort(long tag, short value) {
        this.encodeTaggedInt(tag, value);
    }

    @Override
    protected void encodeTaggedBoolean(long tag, boolean value) {
        this.encodeTaggedInt(tag, value ? 1 : 0);
    }

    @Override
    protected void encodeTaggedChar(long tag, char value) {
        this.encodeTaggedInt(tag, value);
    }

    @Override
    protected void encodeTaggedLong(long tag, long value) {
        if (tag == 19500L) {
            this.writer.writeLong(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeLong(value, (int)($this$protoId$iv & Integer.MAX_VALUE), HelpersKt.getIntegerType(tag));
        }
    }

    @Override
    protected void encodeTaggedFloat(long tag, float value) {
        if (tag == 19500L) {
            this.writer.writeFloat(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeFloat(value, (int)($this$protoId$iv & Integer.MAX_VALUE));
        }
    }

    @Override
    protected void encodeTaggedDouble(long tag, double value) {
        if (tag == 19500L) {
            this.writer.writeDouble(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeDouble(value, (int)($this$protoId$iv & Integer.MAX_VALUE));
        }
    }

    @Override
    protected void encodeTaggedString(long tag, @NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (tag == 19500L) {
            this.writer.writeString(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeString(value, (int)($this$protoId$iv & Integer.MAX_VALUE));
        }
    }

    @Override
    protected void encodeTaggedEnum(long tag, @NotNull SerialDescriptor enumDescriptor, int ordinal) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        if (tag == 19500L) {
            this.writer.writeInt(HelpersKt.extractProtoId(enumDescriptor, ordinal, true));
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeInt(HelpersKt.extractProtoId(enumDescriptor, ordinal, true), (int)($this$protoId$iv & Integer.MAX_VALUE), ProtoIntegerType.DEFAULT);
        }
    }

    @Override
    protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
        Intrinsics.checkNotNullParameter($this$getTag, "<this>");
        return HelpersKt.extractParameters($this$getTag, index);
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        if (serializer2 instanceof MapLikeSerializer) {
            this.serializeMap(serializer2, value);
        } else if (Intrinsics.areEqual(serializer2.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor())) {
            Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.ByteArray");
            this.serializeByteArray((byte[])value);
        } else {
            serializer2.serialize(this, value);
        }
    }

    private final void serializeByteArray(byte[] value) {
        long tag = this.popTagOrDefault();
        if (tag == 19500L) {
            this.writer.writeBytes(value);
        } else {
            long $this$protoId$iv = tag;
            boolean $i$f$getProtoId = false;
            this.writer.writeBytes(value, (int)($this$protoId$iv & Integer.MAX_VALUE));
        }
    }

    private final <T> void serializeMap(SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNull(serializer2, "null cannot be cast to non-null type kotlinx.serialization.internal.MapLikeSerializer<kotlin.Any?, kotlin.Any?, T of kotlinx.serialization.protobuf.internal.ProtobufEncoder.serializeMap, *>");
        MapLikeSerializer casted = (MapLikeSerializer)serializer2;
        KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer(casted.getKeySerializer(), casted.getValueSerializer());
        KSerializer kSerializer = BuiltinSerializersKt.SetSerializer(mapEntrySerial);
        Encoder encoder2 = this;
        Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        kSerializer.serialize(encoder2, ((Map)value).entrySet());
    }
}

