/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.internal;

import gg.skytils.ktx-serialization.internal.PrimitiveArrayBuilder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000f\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\b\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\fH\u0010\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0011\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f8\u0010@RX\u0090\u000e\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lgg/skytils/ktx-serialization/internal/FloatArrayBuilder;", "Lgg/skytils/ktx-serialization/internal/PrimitiveArrayBuilder;", "", "", "c", "", "append$kotlinx_serialization_core", "(F)V", "append", "build$kotlinx_serialization_core", "()[F", "build", "", "requiredCapacity", "ensureCapacity$kotlinx_serialization_core", "(I)V", "ensureCapacity", "buffer", "[F", "<set-?>", "position", "I", "getPosition$kotlinx_serialization_core", "()I", "bufferWithData", "<init>", "([F)V", "kotlinx-serialization-core"})
@PublishedApi
public final class FloatArrayBuilder
extends PrimitiveArrayBuilder<float[]> {
    @NotNull
    private float[] buffer;
    private int position;

    public FloatArrayBuilder(@NotNull float[] bufferWithData) {
        Intrinsics.checkNotNullParameter(bufferWithData, "bufferWithData");
        this.buffer = bufferWithData;
        this.position = bufferWithData.length;
        this.ensureCapacity$kotlinx_serialization_core(10);
    }

    @Override
    public int getPosition$kotlinx_serialization_core() {
        return this.position;
    }

    @Override
    public void ensureCapacity$kotlinx_serialization_core(int requiredCapacity) {
        if (this.buffer.length < requiredCapacity) {
            float[] fArray = Arrays.copyOf(this.buffer, RangesKt.coerceAtLeast(requiredCapacity, this.buffer.length * 2));
            Intrinsics.checkNotNullExpressionValue(fArray, "copyOf(...)");
            this.buffer = fArray;
        }
    }

    public final void append$kotlinx_serialization_core(float c) {
        PrimitiveArrayBuilder.ensureCapacity$kotlinx_serialization_core$default(this, 0, 1, null);
        int n = this.getPosition$kotlinx_serialization_core();
        this.position = n + 1;
        this.buffer[n] = c;
    }

    @Override
    @NotNull
    public float[] build$kotlinx_serialization_core() {
        float[] fArray = Arrays.copyOf(this.buffer, this.getPosition$kotlinx_serialization_core());
        Intrinsics.checkNotNullExpressionValue(fArray, "copyOf(...)");
        return fArray;
    }
}

