/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.utils.io.core;

import gg.skytils.ktor.utils.io.bits.Memory;
import gg.skytils.ktor.utils.io.core.Buffer;
import gg.skytils.ktor.utils.io.core.BufferPrimitivesKt;
import gg.skytils.ktor.utils.io.core.internal.ChunkBuffer;
import gg.skytils.ktor.utils.io.core.internal.UnsafeKt;
import gg.skytils.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000L\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0014\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0080\b\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001c\u0010\u0006\u001a\u00020\u0001*\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0080\b\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0013\u0010\t\u001a\u00020\b*\u00020\bH\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a$\u0010\t\u001a\u00020\b*\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0082\u0010\u00a2\u0006\u0004\b\t\u0010\r\u001a\u0014\u0010\u000e\u001a\u00020\b*\u00020\bH\u0080\u0010\u00a2\u0006\u0004\b\u000e\u0010\n\u001a8\u0010\u0012\u001a\u00020\u0010*\u00020\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0080\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0014\u0010\u0015\u001a\u00020\u0014*\u00020\bH\u0080\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a9\u0010\u001f\u001a\u00020\u0000*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000H\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a\u001b\u0010\"\u001a\u00020!*\u00020\u00172\b\b\u0002\u0010 \u001a\u00020\u0001\u00a2\u0006\u0004\b\"\u0010#\u001a#\u0010&\u001a\u00020\u0010*\u0004\u0018\u00010\b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\b0$H\u0000\u00a2\u0006\u0004\b&\u0010'\u001a\u0013\u0010(\u001a\u00020\u0000*\u00020\bH\u0000\u00a2\u0006\u0004\b(\u0010)\u001a\u001c\u0010(\u001a\u00020\u0000*\u00020\b2\u0006\u0010*\u001a\u00020\u0000H\u0082\u0010\u00a2\u0006\u0004\b(\u0010+\u0082\u0002\u0012\n\u0005\b\u009920\u0001\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006,"}, d2={"", "", "coerceAtMostMaxInt", "(J)I", "", "message", "coerceAtMostMaxIntOrFail", "(JLjava/lang/String;)I", "Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;", "copyAll", "(Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;)Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;", "head", "prev", "(Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;)Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;", "findTail", "Lkotlin/Function1;", "", "block", "forEachChunk", "(Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;Lkotlin/jvm/functions/Function1;)V", "", "isEmpty", "(Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;)Z", "Lgg/skytils/ktor/utils/io/core/Buffer;", "Lgg/skytils/ktor/utils/io/bits/Memory;", "destination", "destinationOffset", "offset", "max", "peekTo-yRinSxo", "(Lio/ktor/utils/io/core/Buffer;Ljava/nio/ByteBuffer;JJJ)J", "peekTo", "count", "", "readBytes", "(Lgg/skytils/ktor/utils/io/core/Buffer;I)[B", "Lgg/skytils/ktor/utils/io/pool/ObjectPool;", "pool", "releaseAll", "(Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;Lgg/skytils/ktor/utils/io/pool/ObjectPool;)V", "remainingAll", "(Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;)J", "n", "(Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;J)J", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nBuffers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buffers.kt\nio/ktor/utils/io/core/BuffersKt\n+ 2 Buffer.kt\nio/ktor/utils/io/core/Buffer\n+ 3 MemoryJvm.kt\nio/ktor/utils/io/bits/Memory\n*L\n1#1,121:1\n69#2:122\n69#2:123\n69#2:124\n69#2:126\n15#3:125\n*S KotlinDebug\n*F\n+ 1 Buffers.kt\nio/ktor/utils/io/core/BuffersKt\n*L\n12#1:122\n80#1:123\n88#1:124\n107#1:126\n105#1:125\n*E\n"})
public final class BuffersKt {
    @NotNull
    public static final byte[] readBytes(@NotNull Buffer $this$readBytes, int count2) {
        Intrinsics.checkNotNullParameter($this$readBytes, "<this>");
        if (count2 == 0) {
            return UnsafeKt.EmptyByteArray;
        }
        byte[] result2 = new byte[count2];
        BufferPrimitivesKt.readFully$default($this$readBytes, result2, 0, 0, 6, null);
        return result2;
    }

    public static /* synthetic */ byte[] readBytes$default(Buffer buffer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            Buffer this_$iv = buffer;
            boolean $i$f$getReadRemaining = false;
            n = this_$iv.getWritePosition() - this_$iv.getReadPosition();
        }
        return BuffersKt.readBytes(buffer, n);
    }

    public static final void releaseAll(@Nullable ChunkBuffer $this$releaseAll, @NotNull ObjectPool<ChunkBuffer> pool) {
        Intrinsics.checkNotNullParameter(pool, "pool");
        ChunkBuffer current = $this$releaseAll;
        while (current != null) {
            ChunkBuffer next = current.cleanNext();
            current.release(pool);
            current = next;
        }
    }

    public static final void forEachChunk(@NotNull ChunkBuffer $this$forEachChunk, @NotNull Function1<? super ChunkBuffer, Unit> block2) {
        Intrinsics.checkNotNullParameter($this$forEachChunk, "<this>");
        Intrinsics.checkNotNullParameter(block2, "block");
        boolean $i$f$forEachChunk = false;
        ChunkBuffer current = $this$forEachChunk;
        while (true) {
            block2.invoke(current);
            if (current.getNext() == null) break;
        }
    }

    @NotNull
    public static final ChunkBuffer copyAll(@NotNull ChunkBuffer $this$copyAll) {
        Intrinsics.checkNotNullParameter($this$copyAll, "<this>");
        ChunkBuffer copied2 = $this$copyAll.duplicate();
        ChunkBuffer chunkBuffer = $this$copyAll.getNext();
        if (chunkBuffer == null) {
            return copied2;
        }
        ChunkBuffer next = chunkBuffer;
        return BuffersKt.copyAll(next, copied2, copied2);
    }

    private static final ChunkBuffer copyAll(ChunkBuffer $this$copyAll, ChunkBuffer head2, ChunkBuffer prev) {
        while (true) {
            ChunkBuffer next;
            ChunkBuffer copied2 = $this$copyAll.duplicate();
            prev.setNext(copied2);
            if ($this$copyAll.getNext() == null) {
                return head2;
            }
            ChunkBuffer chunkBuffer = head2;
            $this$copyAll = next;
            head2 = chunkBuffer;
            prev = copied2;
        }
    }

    @NotNull
    public static final ChunkBuffer findTail(@NotNull ChunkBuffer $this$findTail) {
        Intrinsics.checkNotNullParameter($this$findTail, "<this>");
        while ($this$findTail.getNext() != null) {
            ChunkBuffer next;
            $this$findTail = next;
        }
        return $this$findTail;
    }

    public static final long remainingAll(@NotNull ChunkBuffer $this$remainingAll) {
        Intrinsics.checkNotNullParameter($this$remainingAll, "<this>");
        return BuffersKt.remainingAll($this$remainingAll, 0L);
    }

    private static final long remainingAll(ChunkBuffer $this$remainingAll, long n) {
        while (true) {
            ChunkBuffer next;
            Buffer this_$iv = $this$remainingAll;
            boolean $i$f$getReadRemaining = false;
            long rem = (long)(this_$iv.getWritePosition() - this_$iv.getReadPosition()) + n;
            if ($this$remainingAll.getNext() == null) {
                return rem;
            }
            $this$remainingAll = next;
            n = rem;
        }
    }

    public static final boolean isEmpty(@NotNull ChunkBuffer $this$isEmpty) {
        Intrinsics.checkNotNullParameter($this$isEmpty, "<this>");
        while (true) {
            ChunkBuffer next;
            Buffer this_$iv = $this$isEmpty;
            boolean $i$f$getReadRemaining = false;
            if (this_$iv.getWritePosition() - this_$iv.getReadPosition() > 0) {
                return false;
            }
            if ($this$isEmpty.getNext() == null) {
                return true;
            }
            $this$isEmpty = next;
        }
    }

    public static final int coerceAtMostMaxInt(long $this$coerceAtMostMaxInt) {
        boolean $i$f$coerceAtMostMaxInt = false;
        return (int)Math.min($this$coerceAtMostMaxInt, Integer.MAX_VALUE);
    }

    public static final int coerceAtMostMaxIntOrFail(long $this$coerceAtMostMaxIntOrFail, @NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        boolean $i$f$coerceAtMostMaxIntOrFail = false;
        if ($this$coerceAtMostMaxIntOrFail > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(message);
        }
        return (int)$this$coerceAtMostMaxIntOrFail;
    }

    public static final long peekTo-yRinSxo(@NotNull Buffer $this$peekTo_u2dyRinSxo, @NotNull ByteBuffer destination, long destinationOffset, long offset, long max) {
        Intrinsics.checkNotNullParameter($this$peekTo_u2dyRinSxo, "$this$peekTo");
        Intrinsics.checkNotNullParameter(destination, "destination");
        boolean bl = false;
        long l = (long)destination.limit() - destinationOffset;
        Buffer this_$iv = $this$peekTo_u2dyRinSxo;
        boolean $i$f$getReadRemaining = false;
        long l2 = this_$iv.getWritePosition() - this_$iv.getReadPosition();
        long size2 = Math.min(l, Math.min(max, l2));
        Memory.copyTo-JT6ljtQ($this$peekTo_u2dyRinSxo.getMemory-SK3TCg8(), destination, (long)$this$peekTo_u2dyRinSxo.getReadPosition() + offset, size2, destinationOffset);
        return size2;
    }
}

