/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.plugins.cors;

import gg.skytils.ktor.http.ContentType;
import gg.skytils.ktor.http.HttpHeaders;
import gg.skytils.ktor.http.HttpMethod;
import gg.skytils.ktor.util.CaseInsensitiveSet;
import gg.skytils.ktor.util.CollectionsJvmKt;
import gg.skytils.ktor.util.KtorDsl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@KtorDsl
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0010\b\u0007\u0018\u0000 L2\u00020\u0001:\u0001LB\u0007\u00a2\u0006\u0004\bK\u0010\u001bJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0006J!\u0010\f\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0006J5\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00102\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J!\u0010\u0019\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u0019\u0010\rJ\r\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0015\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0006J\u0017\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0006J\u0017\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010'\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010\"\u001a\u0004\b(\u0010$\"\u0004\b)\u0010&R\"\u0010*\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010\"\u001a\u0004\b+\u0010$\"\u0004\b,\u0010&R#\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020-8\u0006\u00a2\u0006\u0012\n\u0004\b.\u0010/\u0012\u0004\b2\u0010\u001b\u001a\u0004\b0\u00101R)\u00104\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t038\u0006\u00a2\u0006\f\n\u0004\b4\u00105\u001a\u0004\b6\u00107R#\u00108\u001a\b\u0012\u0004\u0012\u00020\u00020-8\u0006\u00a2\u0006\u0012\n\u0004\b8\u0010/\u0012\u0004\b:\u0010\u001b\u001a\u0004\b9\u00101R\u001d\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00020-8\u0006\u00a2\u0006\f\n\u0004\b;\u0010/\u001a\u0004\b<\u00101R*\u0010?\u001a\u00020=2\u0006\u0010>\u001a\u00020=8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010@\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001d\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00150-8\u0006\u00a2\u0006\f\n\u0004\bE\u0010/\u001a\u0004\bF\u00101R,\u0010G\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t038\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\bG\u00105\u001a\u0004\bH\u00107R\u0014\u0010I\u001a\u00020\u00028\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bI\u0010J\u00a8\u0006M"}, d2={"Lgg/skytils/ktor/server/plugins/cors/CORSConfig;", "", "", "host", "", "addHost", "(Ljava/lang/String;)V", "header", "allowHeader", "Lkotlin/Function1;", "", "predicate", "allowHeaders", "(Lkotlin/jvm/functions/Function1;)V", "headerPrefix", "allowHeadersPrefixed", "", "schemes", "subDomains", "allowHost", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "Lgg/skytils/ktor/http/HttpMethod;", "method", "allowMethod", "(Lgg/skytils/ktor/http/HttpMethod;)V", "allowOrigins", "allowXHttpMethodOverride", "()V", "anyHost", "exposeHeader", "validateWildcardRequirements", "wildcardInFrontOfDomain", "(Ljava/lang/String;)Z", "allowCredentials", "Z", "getAllowCredentials", "()Z", "setAllowCredentials", "(Z)V", "allowNonSimpleContentTypes", "getAllowNonSimpleContentTypes", "setAllowNonSimpleContentTypes", "allowSameOrigin", "getAllowSameOrigin", "setAllowSameOrigin", "", "exposedHeaders", "Ljava/util/Set;", "getExposedHeaders", "()Ljava/util/Set;", "getExposedHeaders$annotations", "", "headerPredicates", "Ljava/util/List;", "getHeaderPredicates", "()Ljava/util/List;", "headers", "getHeaders", "getHeaders$annotations", "hosts", "getHosts", "", "newMaxAge", "maxAgeInSeconds", "J", "getMaxAgeInSeconds", "()J", "setMaxAgeInSeconds", "(J)V", "methods", "getMethods", "originPredicates", "getOriginPredicates$ktor_server_cors", "wildcardWithDot", "Ljava/lang/String;", "<init>", "Companion", "ktor-server-cors"})
@SourceDebugExtension(value={"SMAP\nCORSConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CORSConfig.kt\nio/ktor/server/plugins/cors/CORSConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
public final class CORSConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String wildcardWithDot;
    @NotNull
    private final Set<String> hosts = new HashSet();
    @NotNull
    private final Set<String> headers = new CaseInsensitiveSet();
    @NotNull
    private final Set<HttpMethod> methods = new HashSet();
    @NotNull
    private final Set<String> exposedHeaders = new CaseInsensitiveSet();
    private boolean allowCredentials;
    @NotNull
    private final List<Function1<String, Boolean>> originPredicates = new ArrayList();
    @NotNull
    private final List<Function1<String, Boolean>> headerPredicates = new ArrayList();
    private long maxAgeInSeconds = 86400L;
    private boolean allowSameOrigin = true;
    private boolean allowNonSimpleContentTypes;
    public static final long CORS_DEFAULT_MAX_AGE = 86400L;
    @NotNull
    private static final Set<HttpMethod> CorsDefaultMethods;
    @NotNull
    private static final Set<String> CorsSimpleRequestHeaders;
    @NotNull
    private static final Set<String> CorsSimpleResponseHeaders;
    @NotNull
    private static final Set<ContentType> CorsSimpleContentTypes;

    public CORSConfig() {
        this.wildcardWithDot = "*.";
    }

    @NotNull
    public final Set<String> getHosts() {
        return this.hosts;
    }

    @NotNull
    public final Set<String> getHeaders() {
        return this.headers;
    }

    public static /* synthetic */ void getHeaders$annotations() {
    }

    @NotNull
    public final Set<HttpMethod> getMethods() {
        return this.methods;
    }

    @NotNull
    public final Set<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public static /* synthetic */ void getExposedHeaders$annotations() {
    }

    public final boolean getAllowCredentials() {
        return this.allowCredentials;
    }

    public final void setAllowCredentials(boolean bl) {
        this.allowCredentials = bl;
    }

    @NotNull
    public final List<Function1<String, Boolean>> getOriginPredicates$ktor_server_cors() {
        return this.originPredicates;
    }

    @NotNull
    public final List<Function1<String, Boolean>> getHeaderPredicates() {
        return this.headerPredicates;
    }

    public final long getMaxAgeInSeconds() {
        return this.maxAgeInSeconds;
    }

    public final void setMaxAgeInSeconds(long newMaxAge) {
        if (!(newMaxAge >= 0L)) {
            boolean bl = false;
            String string = "maxAgeInSeconds shouldn't be negative: " + newMaxAge;
            throw new IllegalStateException(string.toString());
        }
        this.maxAgeInSeconds = newMaxAge;
    }

    public final boolean getAllowSameOrigin() {
        return this.allowSameOrigin;
    }

    public final void setAllowSameOrigin(boolean bl) {
        this.allowSameOrigin = bl;
    }

    public final boolean getAllowNonSimpleContentTypes() {
        return this.allowNonSimpleContentTypes;
    }

    public final void setAllowNonSimpleContentTypes(boolean bl) {
        this.allowNonSimpleContentTypes = bl;
    }

    public final void anyHost() {
        this.hosts.add("*");
    }

    public final void allowHost(@NotNull String host2, @NotNull List<String> schemes, @NotNull List<String> subDomains) {
        Intrinsics.checkNotNullParameter(host2, "host");
        Intrinsics.checkNotNullParameter(schemes, "schemes");
        Intrinsics.checkNotNullParameter(subDomains, "subDomains");
        if (Intrinsics.areEqual(host2, "*")) {
            this.anyHost();
            return;
        }
        if (!(!StringsKt.contains$default((CharSequence)host2, "://", false, 2, null))) {
            boolean $i$a$-require-CORSConfig$allowHost$22 = false;
            String $i$a$-require-CORSConfig$allowHost$22 = "scheme should be specified as a separate parameter schemes";
            throw new IllegalArgumentException($i$a$-require-CORSConfig$allowHost$22.toString());
        }
        for (String schema : schemes) {
            this.addHost(schema + "://" + host2);
            for (String subDomain : subDomains) {
                this.validateWildcardRequirements(subDomain);
                this.addHost(schema + "://" + subDomain + '.' + host2);
            }
        }
    }

    public static /* synthetic */ void allowHost$default(CORSConfig cORSConfig, String string, List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            String[] stringArray = new String[]{"http", "https"};
            list = CollectionsKt.listOf(stringArray);
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        cORSConfig.allowHost(string, list, list2);
    }

    private final void addHost(String host2) {
        this.validateWildcardRequirements(host2);
        this.hosts.add(host2);
    }

    private final void validateWildcardRequirements(String host2) {
        if (!StringsKt.contains$default((CharSequence)host2, '*', false, 2, null)) {
            return;
        }
        if (!this.wildcardInFrontOfDomain(host2)) {
            boolean $i$a$-require-CORSConfig$validateWildcardRequirements$32 = false;
            String $i$a$-require-CORSConfig$validateWildcardRequirements$32 = "wildcard must appear in front of the domain, e.g. *.domain.com";
            throw new IllegalArgumentException($i$a$-require-CORSConfig$validateWildcardRequirements$32.toString());
        }
        if (!(CORSConfig.validateWildcardRequirements$countMatches(host2, this.wildcardWithDot) == 1)) {
            boolean bl = false;
            String string = "wildcard cannot appear more than once";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final boolean wildcardInFrontOfDomain(String host2) {
        int indexOfWildcard = StringsKt.indexOf$default((CharSequence)host2, this.wildcardWithDot, 0, false, 6, null);
        return StringsKt.contains$default((CharSequence)host2, this.wildcardWithDot, false, 2, null) && !StringsKt.endsWith$default(host2, this.wildcardWithDot, false, 2, null) && (indexOfWildcard <= 0 || StringsKt.endsWith$default(StringsKt.substringBefore$default(host2, this.wildcardWithDot, null, 2, null), "://", false, 2, null));
    }

    public final void exposeHeader(@NotNull String header) {
        Intrinsics.checkNotNullParameter(header, "header");
        if (!CorsSimpleResponseHeaders.contains(header)) {
            this.exposedHeaders.add(header);
        }
    }

    public final void allowXHttpMethodOverride() {
        this.allowHeader(HttpHeaders.INSTANCE.getXHttpMethodOverride());
    }

    public final void allowOrigins(@NotNull Function1<? super String, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        this.originPredicates.add(predicate);
    }

    public final void allowHeadersPrefixed(@NotNull String headerPrefix) {
        Intrinsics.checkNotNullParameter(headerPrefix, "headerPrefix");
        String string = headerPrefix.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        String prefix2 = string;
        this.headerPredicates.add(new Function1<String, Boolean>(prefix2){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter(name, "name");
                return StringsKt.startsWith$default(name, this.$prefix, false, 2, null);
            }
        });
    }

    public final void allowHeaders(@NotNull Function1<? super String, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        this.headerPredicates.add(predicate);
    }

    public final void allowHeader(@NotNull String header) {
        Intrinsics.checkNotNullParameter(header, "header");
        if (StringsKt.equals(header, HttpHeaders.INSTANCE.getContentType(), true)) {
            this.allowNonSimpleContentTypes = true;
            return;
        }
        if (!CorsSimpleRequestHeaders.contains(header)) {
            this.headers.add(header);
        }
    }

    public final void allowMethod(@NotNull HttpMethod method2) {
        Intrinsics.checkNotNullParameter(method2, "method");
        if (!CorsDefaultMethods.contains(method2)) {
            this.methods.add(method2);
        }
    }

    private static final int validateWildcardRequirements$countMatches(String $this$validateWildcardRequirements_u24countMatches, String subString) {
        return CollectionsKt.sumOfInt(StringsKt.windowed$default($this$validateWildcardRequirements_u24countMatches, subString.length(), 0, false, new Function1<CharSequence, Integer>(subString){
            final /* synthetic */ String $subString;
            {
                this.$subString = $subString;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull CharSequence it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it, this.$subString) ? 1 : 0;
            }
        }, 6, null));
    }

    static {
        Object[] objectArray = new HttpMethod[]{HttpMethod.Companion.getGet(), HttpMethod.Companion.getPost(), HttpMethod.Companion.getHead()};
        CorsDefaultMethods = SetsKt.setOf(objectArray);
        objectArray = new String[]{HttpHeaders.INSTANCE.getAccept(), HttpHeaders.INSTANCE.getAcceptLanguage(), HttpHeaders.INSTANCE.getContentLanguage(), HttpHeaders.INSTANCE.getContentType()};
        CorsSimpleRequestHeaders = CORSConfig.Companion.caseInsensitiveSet((String[])objectArray);
        objectArray = new String[]{HttpHeaders.INSTANCE.getCacheControl(), HttpHeaders.INSTANCE.getContentLanguage(), HttpHeaders.INSTANCE.getContentType(), HttpHeaders.INSTANCE.getExpires(), HttpHeaders.INSTANCE.getLastModified(), HttpHeaders.INSTANCE.getPragma()};
        CorsSimpleResponseHeaders = CORSConfig.Companion.caseInsensitiveSet((String[])objectArray);
        objectArray = new ContentType[]{ContentType.Application.INSTANCE.getFormUrlEncoded(), ContentType.MultiPart.INSTANCE.getFormData(), ContentType.Text.INSTANCE.getPlain()};
        CorsSimpleContentTypes = CollectionsJvmKt.unmodifiable(SetsKt.setOf(objectArray));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0014J)\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\"\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00058\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00058\u0006\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\r\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0012\u0010\u000fR\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0016\u0010\u000fR\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lgg/skytils/ktor/server/plugins/cors/CORSConfig$Companion;", "", "", "", "elements", "", "caseInsensitiveSet", "([Ljava/lang/String;)Ljava/util/Set;", "", "CORS_DEFAULT_MAX_AGE", "J", "Lgg/skytils/ktor/http/HttpMethod;", "CorsDefaultMethods", "Ljava/util/Set;", "getCorsDefaultMethods", "()Ljava/util/Set;", "Lgg/skytils/ktor/http/ContentType;", "CorsSimpleContentTypes", "getCorsSimpleContentTypes", "getCorsSimpleContentTypes$annotations", "()V", "CorsSimpleRequestHeaders", "getCorsSimpleRequestHeaders", "CorsSimpleResponseHeaders", "getCorsSimpleResponseHeaders", "<init>", "ktor-server-cors"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<HttpMethod> getCorsDefaultMethods() {
            return CorsDefaultMethods;
        }

        @NotNull
        public final Set<String> getCorsSimpleRequestHeaders() {
            return CorsSimpleRequestHeaders;
        }

        @NotNull
        public final Set<String> getCorsSimpleResponseHeaders() {
            return CorsSimpleResponseHeaders;
        }

        @NotNull
        public final Set<ContentType> getCorsSimpleContentTypes() {
            return CorsSimpleContentTypes;
        }

        public static /* synthetic */ void getCorsSimpleContentTypes$annotations() {
        }

        private final Set<String> caseInsensitiveSet(String ... elements) {
            return new CaseInsensitiveSet((Iterable<String>)ArraysKt.asList(elements));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

