/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.network.util;

import gg.skytils.ktor.utils.io.pool.DefaultPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="ByteBufferPool is moved to `io` module", replaceWith=@ReplaceWith(expression="ByteBufferPool", imports={"gg.skytils.ktor.utils.io.pool.ByteBufferPool"}), level=DeprecationLevel.ERROR)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lgg/skytils/ktor/network/util/DirectByteBufferPool;", "Lgg/skytils/ktor/utils/io/pool/DefaultPool;", "Ljava/nio/ByteBuffer;", "instance", "clearInstance", "(Ljava/nio/ByteBuffer;)Ljava/nio/ByteBuffer;", "produceInstance", "()Ljava/nio/ByteBuffer;", "", "validateInstance", "(Ljava/nio/ByteBuffer;)V", "", "bufferSize", "I", "size", "<init>", "(II)V", "ktor-network"})
public final class DirectByteBufferPool
extends DefaultPool<ByteBuffer> {
    private final int bufferSize;

    public DirectByteBufferPool(int bufferSize, int size2) {
        super(size2);
        this.bufferSize = bufferSize;
    }

    @Override
    @NotNull
    protected ByteBuffer produceInstance() {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        Intrinsics.checkNotNullExpressionValue(byteBuffer, "allocateDirect(bufferSize)");
        return byteBuffer;
    }

    @Override
    @NotNull
    protected ByteBuffer clearInstance(@NotNull ByteBuffer instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        instance.clear();
        instance.order(ByteOrder.BIG_ENDIAN);
        return instance;
    }

    @Override
    protected void validateInstance(@NotNull ByteBuffer instance) {
        Intrinsics.checkNotNullParameter(instance, "instance");
        if (!instance.isDirect()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(instance.capacity() == this.bufferSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

