/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.network.tls;

import gg.skytils.ktor.http.IpParserKt;
import gg.skytils.ktor.network.tls.TLSException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u001f\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001f\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\f\u0010\n\u001a\u0019\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\r*\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\r*\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000f\"\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\"\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"", "serverName", "certificateHost", "", "matchHostnameWithCertificate", "(Ljava/lang/String;Ljava/lang/String;)Z", "Ljava/security/cert/X509Certificate;", "certificate", "", "verifyHostnameInCertificate", "(Ljava/lang/String;Ljava/security/cert/X509Certificate;)V", "ipString", "verifyIpInCertificate", "", "hosts", "(Ljava/security/cert/X509Certificate;)Ljava/util/List;", "ips", "", "DNS_NAME_TYPE", "I", "IP_ADDRESS_TYPE", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nHostnameUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HostnameUtils.kt\nio/ktor/network/tls/HostnameUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1747#2,3:104\n766#2:107\n857#2,2:108\n1549#2:110\n1620#2,3:111\n1747#2,3:114\n766#2:117\n857#2,2:118\n1549#2:120\n1620#2,3:121\n766#2:124\n857#2,2:125\n1549#2:127\n1620#2,3:128\n*S KotlinDebug\n*F\n+ 1 HostnameUtils.kt\nio/ktor/network/tls/HostnameUtilsKt\n*L\n21#1:104,3\n31#1:107\n31#1:108,2\n32#1:110\n32#1:111,3\n35#1:114,3\n95#1:117\n95#1:118,2\n96#1:120\n96#1:121,3\n100#1:124\n100#1:125,2\n101#1:127\n101#1:128,3\n*E\n"})
public final class HostnameUtilsKt {
    private static final int DNS_NAME_TYPE = 2;
    private static final int IP_ADDRESS_TYPE = 7;

    public static final void verifyHostnameInCertificate(@NotNull String serverName, @NotNull X509Certificate certificate) {
        boolean bl;
        List<String> hosts;
        block6: {
            Intrinsics.checkNotNullParameter(serverName, "serverName");
            Intrinsics.checkNotNullParameter(certificate, "certificate");
            if (IpParserKt.hostIsIp(serverName)) {
                HostnameUtilsKt.verifyIpInCertificate(serverName, certificate);
                return;
            }
            hosts = HostnameUtilsKt.hosts(certificate);
            if (hosts.isEmpty()) {
                return;
            }
            Iterable $this$any$iv = hosts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!HostnameUtilsKt.matchHostnameWithCertificate(serverName, it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        throw new TLSException("No server host: " + serverName + " in the server certificate. Provided in certificate: " + CollectionsKt.joinToString$default(hosts, null, null, null, 0, null, null, 63, null), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void verifyIpInCertificate(@NotNull String ipString, @NotNull X509Certificate certificate) {
        boolean bl;
        List ips;
        block9: {
            Collection destination$iv$iv;
            Intrinsics.checkNotNullParameter(ipString, "ipString");
            Intrinsics.checkNotNullParameter(certificate, "certificate");
            Collection<List<?>> collection = certificate.getSubjectAlternativeNames();
            if (collection != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = collection;
                boolean $i$f$filter22 = false;
                void var7_6 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    List it = (List)element$iv$iv;
                    boolean bl2 = false;
                    Object e = it.get(0);
                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Int");
                    if (!((Integer)e == 7)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $i$f$filter22 = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                destination$iv$iv2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    List bl2 = (List)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    Object e = it.get(1);
                    Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.String");
                    collection2.add((String)e);
                }
            } else {
                return;
            }
            ips = (List)destination$iv$iv;
            if (ips.isEmpty()) {
                return;
            }
            Iterable $this$any$iv = ips;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it, ipString)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        throw new TLSException("No server host: " + ipString + " in the server certificate. The certificate was issued for: " + CollectionsKt.joinToString$default(ips, null, null, null, 0, null, null, 63, null) + '.', null, 2, null);
    }

    public static final boolean matchHostnameWithCertificate(@NotNull String serverName, @NotNull String certificateHost) {
        Intrinsics.checkNotNullParameter(serverName, "serverName");
        Intrinsics.checkNotNullParameter(certificateHost, "certificateHost");
        if (StringsKt.equals(serverName, certificateHost, true)) {
            return true;
        }
        char[] cArray = new char[]{'.'};
        List nameChunks = CollectionsKt.asReversed(StringsKt.split$default((CharSequence)serverName, cArray, false, 0, 6, null));
        char[] cArray2 = new char[]{'.'};
        List certificateChunks = CollectionsKt.asReversed(StringsKt.split$default((CharSequence)certificateHost, cArray2, false, 0, 6, null));
        int nameIndex = 0;
        int certificateIndex = 0;
        boolean wildcardFound = false;
        int labels = 0;
        while (nameIndex < nameChunks.size() && certificateIndex < certificateChunks.size()) {
            String nameChunk = (String)nameChunks.get(nameIndex);
            if (nameIndex == 0 && ((CharSequence)nameChunk).length() == 0) {
                ++nameIndex;
                continue;
            }
            String certificateChunk = (String)certificateChunks.get(certificateIndex);
            if (certificateIndex == 0 && ((CharSequence)certificateChunk).length() == 0) {
                ++certificateIndex;
                continue;
            }
            if (!wildcardFound && StringsKt.equals(nameChunk, certificateChunk, true)) {
                ++labels;
                ++nameIndex;
                ++certificateIndex;
                continue;
            }
            if (Intrinsics.areEqual(certificateChunk, "*")) {
                wildcardFound = true;
                ++nameIndex;
                ++certificateIndex;
                continue;
            }
            return false;
        }
        boolean wildcardUsedCorrect = !wildcardFound || labels >= 2;
        return nameIndex == nameChunks.size() && certificateIndex == certificateChunks.size() && wildcardUsedCorrect;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> hosts(X509Certificate $this$hosts) {
        List list;
        Collection<List<?>> collection = $this$hosts.getSubjectAlternativeNames();
        if (collection != null) {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                List it = (List)element$iv$iv;
                boolean bl = false;
                Object e = it.get(0);
                Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Int");
                if (!((Integer)e == 2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List bl = (List)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Object e = it.get(1);
                Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.String");
                collection2.add((String)e);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> ips(X509Certificate $this$ips) {
        List list;
        Collection<List<?>> collection = $this$ips.getSubjectAlternativeNames();
        if (collection != null) {
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                List it = (List)element$iv$iv;
                boolean bl = false;
                Object e = it.get(0);
                Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.Int");
                if (!((Integer)e == 7)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List bl = (List)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Object e = it.get(1);
                Intrinsics.checkNotNull(e, "null cannot be cast to non-null type kotlin.String");
                collection2.add((String)e);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

