/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import swing.RoundedRectanglePanel;

public class SkytilsInstallerFrame
extends JFrame
implements ActionListener,
MouseListener {
    private static final Pattern IN_MODS_SUBFOLDER = Pattern.compile("1\\.8\\.9[/\\\\]?$");
    private static final int w = 550;
    private static final int h = 500;
    private DescriptionPanel descriptionPanel;
    private FolderPanel chooser;
    private FooterPanel footer;

    public SkytilsInstallerFrame() {
        try {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("assets/skytils/logo.png")));
            this.setName("SkytilsInstallerFrame");
            this.setTitle("Skytils Installer");
            this.setUndecorated(true);
            this.setResizable(false);
            this.setSize(550, 500);
            this.setShape(new RoundRectangle2D.Double(0.0, 0.0, 550.0, 500.0, 16.0, 16.0));
            JPanel testPanel = new JPanel();
            testPanel.setBackground(new Color(4286197));
            LogoPanel logo = new LogoPanel(235, 235, 16, 16, new Color(8492031));
            testPanel.add((Component)logo, "First");
            this.descriptionPanel = new DescriptionPanel(440, 125, 16, 16, new Color(8492031));
            this.descriptionPanel.forge.addMouseListener(this);
            testPanel.add((Component)this.descriptionPanel, "Center");
            this.chooser = new FolderPanel(440, 71, 16, 16, new Color(8492031));
            this.chooser.folderButton.addActionListener(this);
            testPanel.add((Component)this.chooser, "East");
            this.footer = new FooterPanel(275 + (SkytilsInstallerFrame.getOperatingSystem() == OperatingSystem.LINUX ? 60 : 0), 45, 16, 16, new Color(8492031));
            this.footer.openFolder.addActionListener(this);
            this.footer.install.addActionListener(this);
            this.footer.install.setEnabled(true);
            this.footer.install.requestFocus();
            this.footer.close.addActionListener(this);
            testPanel.add((Component)this.footer, "Last");
            this.setContentPane(testPanel);
        }
        catch (Exception ex) {
            SkytilsInstallerFrame.showErrorPopup(ex);
        }
    }

    public static void main(String[] args2) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SkytilsInstallerFrame frame = new SkytilsInstallerFrame();
            frame.centerFrame(frame);
            frame.setVisible(true);
        }
        catch (Exception ex) {
            SkytilsInstallerFrame.showErrorPopup(ex);
        }
    }

    public static OperatingSystem getOperatingSystem() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (osName.startsWith("win")) {
            return OperatingSystem.WINDOWS;
        }
        if (osName.contains("mac")) {
            return OperatingSystem.MACOS;
        }
        if (osName.contains("solaris") || osName.contains("sunos")) {
            return OperatingSystem.SOLARIS;
        }
        if (osName.contains("linux") || osName.contains("unix")) {
            return OperatingSystem.LINUX;
        }
        return OperatingSystem.UNKNOWN;
    }

    private static String getStacktraceText(Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().replace("\t", "  ");
    }

    private static void showErrorPopup(Throwable ex) {
        ex.printStackTrace();
        JTextArea textArea = new JTextArea(SkytilsInstallerFrame.getStacktraceText(ex));
        textArea.setEditable(false);
        Font currentFont = textArea.getFont();
        Font newFont = new Font("Monospaced", currentFont.getStyle(), currentFont.getSize());
        textArea.setFont(newFont);
        JScrollPane errorScrollPane = new JScrollPane(textArea);
        errorScrollPane.setPreferredSize(new Dimension(600, 400));
        JOptionPane.showMessageDialog(null, errorScrollPane, "Error", 0);
    }

    public static File getThisFile() {
        try {
            return new File(SkytilsInstallerFrame.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException ex) {
            SkytilsInstallerFrame.showErrorPopup(ex);
            return null;
        }
    }

    public void onFolderSelect() {
        File currentDirectory = new File(this.chooser.folderLocation.getText());
        JFileChooser jFileChooser = new JFileChooser(currentDirectory);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (jFileChooser.showOpenDialog(this) == 0) {
            File newDirectory = jFileChooser.getSelectedFile();
            this.chooser.folderLocation.setText(newDirectory.getPath());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("an action happened");
        if (e.getSource() == this.footer.close) {
            this.dispose();
            System.exit(0);
        }
        if (e.getSource() == this.chooser.folderButton) {
            System.out.println("selecting!");
            this.onFolderSelect();
        }
        if (e.getSource() == this.footer.install) {
            this.onInstall();
        }
        if (e.getSource() == this.footer.openFolder) {
            this.onOpenFolder();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String forgeUrl = "https://files.minecraftforge.net/maven/net/minecraftforge/forge/index_1.8.9.html";
        if (e.getSource() == this.descriptionPanel.forge) {
            try {
                Desktop.getDesktop().browse(new URI(forgeUrl));
            }
            catch (IOException | URISyntaxException ex) {
                SkytilsInstallerFrame.showErrorPopup(ex);
            }
            catch (UnsupportedOperationException ex) {
                ex.printStackTrace();
                JTextArea textArea = new JTextArea("Failed to open url open it manually instead\n" + forgeUrl);
                textArea.setEditable(false);
                Font currentFont = textArea.getFont();
                Font newFont = new Font("Monospaced", currentFont.getStyle(), currentFont.getSize());
                textArea.setFont(newFont);
                JScrollPane errorScrollPane = new JScrollPane(textArea);
                errorScrollPane.setPreferredSize(new Dimension(600, 400));
                JOptionPane.showMessageDialog(null, errorScrollPane, "Error", 0);
            }
        }
    }

    public void onInstall() {
        try {
            File modsFolder = new File(this.chooser.folderLocation.getText());
            if (!modsFolder.exists()) {
                this.showErrorMessage("Folder not found: " + modsFolder.getPath());
                return;
            }
            if (!modsFolder.isDirectory()) {
                this.showErrorMessage("Not a folder: " + modsFolder.getPath());
                return;
            }
            this.tryInstall(modsFolder);
        }
        catch (Exception e) {
            SkytilsInstallerFrame.showErrorPopup(e);
        }
    }

    private void tryInstall(File modsFolder) {
        File thisFile = SkytilsInstallerFrame.getThisFile();
        if (thisFile != null) {
            boolean failed;
            boolean inSubFolder = IN_MODS_SUBFOLDER.matcher(modsFolder.getPath()).find();
            File newFile = new File(modsFolder, "Skytils-" + this.getVersionFromMcmodInfo() + ".jar");
            if (thisFile.equals(newFile)) {
                this.showErrorMessage("You are opening this file from where the file should be installed... there's nothing to be done!");
                return;
            }
            boolean deletingFailure = false;
            if (modsFolder.isDirectory() && (failed = this.findSkytilsAndDelete(modsFolder.listFiles()))) {
                deletingFailure = true;
            }
            if (inSubFolder) {
                if (modsFolder.getParentFile().isDirectory() && (failed = this.findSkytilsAndDelete(modsFolder.getParentFile().listFiles()))) {
                    deletingFailure = true;
                }
            } else {
                boolean failed2;
                File subFolder = new File(modsFolder, "1.8.9");
                if (subFolder.exists() && subFolder.isDirectory() && (failed2 = this.findSkytilsAndDelete(subFolder.listFiles()))) {
                    deletingFailure = true;
                }
            }
            if (deletingFailure) {
                return;
            }
            if (thisFile.isDirectory()) {
                this.showErrorMessage("This file is a directory... Are we in a development environment?");
                return;
            }
            try {
                Files.copy(thisFile.toPath(), newFile.toPath(), new CopyOption[0]);
            }
            catch (Exception ex) {
                SkytilsInstallerFrame.showErrorPopup(ex);
                return;
            }
            this.showMessage("Skytils has been successfully installed into your mods folder.");
            this.dispose();
            System.exit(0);
        }
    }

    private boolean findSkytilsAndDelete(File[] files2) {
        if (files2 == null) {
            return false;
        }
        for (File file2 : files2) {
            if (file2.isDirectory() || !file2.getPath().endsWith(".jar")) continue;
            try {
                InputStream inputStream2;
                String modID;
                JarFile jarFile = new JarFile(file2);
                ZipEntry mcModInfo = jarFile.getEntry("mcmod.info");
                if (mcModInfo != null && (modID = this.getModIDFromInputStream(inputStream2 = jarFile.getInputStream(mcModInfo))).equals("skytils")) {
                    jarFile.close();
                    try {
                        boolean deleted = file2.delete();
                        if (deleted) continue;
                        throw new Exception();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.showErrorMessage("Was not able to delete the other Skytils files found in your mods folder!" + System.lineSeparator() + "Please make sure that your minecraft is currently closed and try again, or feel" + System.lineSeparator() + "free to open your mods folder and delete those files manually.");
                        return true;
                    }
                }
                jarFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void onOpenFolder() {
        try {
            Desktop.getDesktop().open(this.getModsFolder());
        }
        catch (Exception e) {
            SkytilsInstallerFrame.showErrorPopup(e);
        }
    }

    public File getModsFolder() {
        String userHome = System.getProperty("user.home", ".");
        File modsFolder = this.getFile(userHome, "minecraft/mods/1.8.9");
        if (!modsFolder.exists()) {
            modsFolder = this.getFile(userHome, "minecraft/mods");
        }
        if (!modsFolder.exists() && !modsFolder.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + modsFolder);
        }
        return modsFolder;
    }

    public File getFile(String userHome, String minecraftPath) {
        File workingDirectory;
        switch (SkytilsInstallerFrame.getOperatingSystem()) {
            case LINUX: 
            case SOLARIS: {
                workingDirectory = new File(userHome, '.' + minecraftPath + '/');
                break;
            }
            case WINDOWS: {
                String applicationData = System.getenv("APPDATA");
                if (applicationData != null) {
                    workingDirectory = new File(applicationData, "." + minecraftPath + '/');
                    break;
                }
                workingDirectory = new File(userHome, '.' + minecraftPath + '/');
                break;
            }
            case MACOS: {
                workingDirectory = new File(userHome, "Library/Application Support/" + minecraftPath);
                break;
            }
            default: {
                workingDirectory = new File(userHome, minecraftPath + '/');
            }
        }
        return workingDirectory;
    }

    public void centerFrame(JFrame frame) {
        Rectangle rectangle = frame.getBounds();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle screenRectangle = new Rectangle(0, 0, screenSize.width, screenSize.height);
        int newX = screenRectangle.x + (screenRectangle.width - rectangle.width) / 2;
        int newY = screenRectangle.y + (screenRectangle.height - rectangle.height) / 2;
        if (newX < 0) {
            newX = 0;
        }
        if (newY < 0) {
            newY = 0;
        }
        frame.setBounds(newX, newY, rectangle.width, rectangle.height);
    }

    public void showMessage(String message) {
        JOptionPane.showMessageDialog(null, message, "Skytils", 1);
    }

    public void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(null, message, "Skytils - Error", 0);
    }

    private String getVersionFromMcmodInfo() {
        String version2 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("mcmod.info"), "mcmod.info not found.")));
            while ((version2 = bufferedReader.readLine()) != null) {
                if (!version2.contains("\"version\": \"")) continue;
                version2 = version2.split(Pattern.quote("\"version\": \""))[1];
                version2 = version2.substring(0, version2.length() - 2);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version2;
    }

    private String getModIDFromInputStream(InputStream inputStream2) {
        String version2 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
            while ((version2 = bufferedReader.readLine()) != null) {
                if (!version2.contains("\"modid\": \"")) continue;
                version2 = version2.split(Pattern.quote("\"modid\": \""))[1];
                version2 = version2.substring(0, version2.length() - 2);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version2;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private static class FooterPanel
    extends RoundedRectanglePanel {
        public final JButton install;
        public final JButton openFolder;
        public final JButton close;

        public FooterPanel(int width, int height, int radiusW, int radiusH, Color color) {
            super(radiusW, radiusH);
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            this.install = new JButton();
            this.install.setName("Install Button");
            this.install.setText("Install");
            this.add(this.install);
            this.openFolder = new JButton();
            this.openFolder.setName("Open Folder Button");
            this.openFolder.setText("Open Mods Folder");
            this.add(this.openFolder);
            this.close = new JButton();
            this.close.setName("Close Button");
            this.close.setText("Cancel");
            this.add(this.close);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.install).addComponent(this.openFolder).addComponent(this.close));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.install).addComponent(this.openFolder).addComponent(this.close));
            this.setBackground(color);
            this.setForeground(color);
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    private class FolderPanel
    extends RoundedRectanglePanel {
        public final JButton folderButton;
        public final JTextField folderLocation;

        public FolderPanel(int width, int height, int radiusW, int radiusH, Color color) throws IOException {
            super(radiusW, radiusH);
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            JLabel folderLabel = new JLabel();
            folderLabel.setName("Folder Label");
            folderLabel.setText("Mods Folder");
            folderLabel.setFont(new Font("Dialog", 1, 12));
            this.add(folderLabel);
            this.folderLocation = new JTextField();
            this.folderLocation.setName("Folder Field");
            this.folderLocation.setText(SkytilsInstallerFrame.this.getModsFolder().getAbsolutePath());
            this.folderLocation.setEditable(false);
            this.folderLocation.setPreferredSize(new Dimension(width * 2 / 3, 20));
            this.add(this.folderLocation);
            BufferedImage myPicture = ImageIO.read(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("assets/skytils/gui/folder.png"), "Folder icon not found."));
            Image scaled = myPicture.getScaledInstance(16, 16, 4);
            this.folderButton = new JButton(new ImageIcon(scaled));
            this.folderButton.setName("ButtonFolder");
            this.add(this.folderButton);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(folderLabel).addComponent(this.folderLocation)).addComponent(this.folderButton));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(folderLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.folderLocation).addComponent(this.folderButton)));
            this.setBackground(color);
            this.setForeground(color);
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    private static class DescriptionPanel
    extends RoundedRectanglePanel {
        public final JTextArea forge;

        public DescriptionPanel(int width, int height, int radiusW, int radiusH, Color color) {
            super(radiusW, radiusH);
            JTextArea desc = new JTextArea();
            desc.setName("DescriptionText");
            desc.setText("This installer will copy Skytils into your forge mods folder for you, and replace any old versions that already exist. Close this if you prefer to do this yourself!");
            desc.setEditable(false);
            desc.setHighlighter(null);
            desc.setEnabled(true);
            desc.setFont(new Font("Dialog", 0, 14));
            desc.setLineWrap(true);
            desc.setWrapStyleWord(true);
            desc.setOpaque(false);
            desc.setBounds(radiusW, radiusH, width - radiusW * 2, height - radiusH * 2);
            this.forge = new JTextArea();
            this.forge.setName("Forge Text");
            this.forge.setText("However, you still need to install Forge client in order to be able to run this mod. Click here to visit the download page for Forge 1.8.9!");
            this.forge.setForeground(new Color(5574386));
            this.forge.setEditable(false);
            this.forge.setHighlighter(null);
            this.forge.setEnabled(true);
            this.forge.setFont(new Font("Dialog", 0, 13));
            this.forge.setLineWrap(true);
            this.forge.setWrapStyleWord(true);
            this.forge.setOpaque(false);
            this.forge.setCursor(Cursor.getPredefinedCursor(12));
            this.forge.setBounds(radiusW, height - radiusH, width - radiusW * 2, height - radiusH * 2);
            this.add((Component)desc, "First");
            this.add((Component)this.forge, "Last");
            this.setBackground(color);
            this.setForeground(color);
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    private class LogoPanel
    extends RoundedRectanglePanel {
        public LogoPanel(int width, int height, int radiusW, int radiusH, Color color) throws IOException {
            super(radiusW, radiusH);
            int img = (int)((float)height * 0.8f);
            BufferedImage myPicture = ImageIO.read(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream("assets/skytils/logo.png"), "Logo not found."));
            Image scaled = myPicture.getScaledInstance(img, img, 4);
            JLabel logo = new JLabel(new ImageIcon(scaled));
            logo.setName("SkytilsLogo");
            logo.setBounds(0, 0, img, img);
            logo.setFont(new Font("Dialog", 1, 18));
            logo.setHorizontalAlignment(0);
            logo.setPreferredSize(new Dimension(img, img));
            JLabel version2 = new JLabel("Skytils v" + SkytilsInstallerFrame.this.getVersionFromMcmodInfo() + " for MC 1.8.9");
            version2.setName("Mod Version");
            version2.setFont(new Font("Dialog", 1, 16));
            version2.setHorizontalAlignment(0);
            this.add(logo);
            this.add(version2);
            this.setBackground(color);
            this.setForeground(color);
            this.setPreferredSize(new Dimension(width, height));
        }
    }

    public static enum OperatingSystem {
        LINUX,
        SOLARIS,
        WINDOWS,
        MACOS,
        UNKNOWN;

    }
}

