/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.shader;

import codes.biscuit.skyblockaddons.utils.SkyblockAddonsMessageFactory;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

public class ShaderHelper {
    private static final Logger LOGGER = LogManager.getLogger((MessageFactory)new SkyblockAddonsMessageFactory(ShaderHelper.class.getSimpleName()));
    private static final boolean SHADERS_SUPPORTED;
    private static final boolean VBOS_SUPPORTED;
    private static final boolean VAOS_SUPPORTED;
    private static final boolean USING_ARB_SHADERS;
    private static final boolean USING_ARB_VBOS;
    private static final boolean USING_ARB_VAOS;
    public static final int GL_LINK_STATUS;
    public static final int GL_ARRAY_BUFFER;
    public static final int GL_DYNAMIC_DRAW;
    public static final int GL_COMPILE_STATUS;
    public static final int GL_VERTEX_SHADER;
    public static final int GL_FRAGMENT_SHADER;

    public static void glLinkProgram(int program) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glLinkProgramARB((int)program);
        } else {
            GL20.glLinkProgram((int)program);
        }
    }

    public static String glGetProgramInfoLog(int program, int maxLength) {
        return USING_ARB_SHADERS ? ARBShaderObjects.glGetInfoLogARB((int)program, (int)maxLength) : GL20.glGetProgramInfoLog((int)program, (int)maxLength);
    }

    public static int glGetProgrami(int program, int pname) {
        return USING_ARB_SHADERS ? ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)pname) : GL20.glGetProgrami((int)program, (int)pname);
    }

    public static void glUseProgram(int program) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glUseProgramObjectARB((int)program);
        } else {
            GL20.glUseProgram((int)program);
        }
    }

    public static void glBindBuffer(int target, int buffer) {
        if (USING_ARB_VBOS) {
            ARBVertexBufferObject.glBindBufferARB((int)target, (int)buffer);
        } else {
            GL15.glBindBuffer((int)target, (int)buffer);
        }
    }

    public static void glBufferData(int target, ByteBuffer data, int usage) {
        if (USING_ARB_VBOS) {
            ARBVertexBufferObject.glBufferDataARB((int)target, (ByteBuffer)data, (int)usage);
        } else {
            GL15.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        }
    }

    public static int glGenBuffers() {
        return USING_ARB_VBOS ? ARBVertexBufferObject.glGenBuffersARB() : GL15.glGenBuffers();
    }

    public static void glAttachShader(int program, int shaderIn) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)shaderIn);
        } else {
            GL20.glAttachShader((int)program, (int)shaderIn);
        }
    }

    public static void glDeleteShader(int p_153180_0_) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glDeleteObjectARB((int)p_153180_0_);
        } else {
            GL20.glDeleteShader((int)p_153180_0_);
        }
    }

    public static int glCreateShader(int type) {
        return USING_ARB_SHADERS ? ARBShaderObjects.glCreateShaderObjectARB((int)type) : GL20.glCreateShader((int)type);
    }

    public static void glShaderSource(int shaderIn, ByteBuffer string) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glShaderSourceARB((int)shaderIn, (ByteBuffer)string);
        } else {
            GL20.glShaderSource((int)shaderIn, (ByteBuffer)string);
        }
    }

    public static void glCompileShader(int shaderIn) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glCompileShaderARB((int)shaderIn);
        } else {
            GL20.glCompileShader((int)shaderIn);
        }
    }

    public static int glGetShaderi(int shaderIn, int pname) {
        return USING_ARB_SHADERS ? ARBShaderObjects.glGetObjectParameteriARB((int)shaderIn, (int)pname) : GL20.glGetShaderi((int)shaderIn, (int)pname);
    }

    public static String glGetShaderInfoLog(int shaderIn, int maxLength) {
        return USING_ARB_SHADERS ? ARBShaderObjects.glGetInfoLogARB((int)shaderIn, (int)maxLength) : GL20.glGetShaderInfoLog((int)shaderIn, (int)maxLength);
    }

    public static void glUniform1f(int location, float v0) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glUniform1fARB((int)location, (float)v0);
        } else {
            GL20.glUniform1f((int)location, (float)v0);
        }
    }

    public static void glUniform3f(int location, float v0, float v1, float v2) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glUniform3fARB((int)location, (float)v0, (float)v1, (float)v2);
        } else {
            GL20.glUniform3f((int)location, (float)v0, (float)v1, (float)v2);
        }
    }

    public static void glEnableVertexAttribArray(int index) {
        if (USING_ARB_SHADERS) {
            ARBVertexShader.glEnableVertexAttribArrayARB((int)index);
        } else {
            GL20.glEnableVertexAttribArray((int)index);
        }
    }

    public static int glGetUniformLocation(int programObj, CharSequence name) {
        return USING_ARB_SHADERS ? ARBShaderObjects.glGetUniformLocationARB((int)programObj, (CharSequence)name) : GL20.glGetUniformLocation((int)programObj, (CharSequence)name);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long buffer_buffer_offset) {
        if (USING_ARB_SHADERS) {
            ARBVertexShader.glVertexAttribPointerARB((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)buffer_buffer_offset);
        } else {
            GL20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)buffer_buffer_offset);
        }
    }

    public static int glGenVertexArrays() {
        return USING_ARB_VAOS ? ARBVertexArrayObject.glGenVertexArrays() : GL30.glGenVertexArrays();
    }

    public static void glBindVertexArray(int array) {
        if (USING_ARB_VAOS) {
            ARBVertexArrayObject.glBindVertexArray((int)array);
        } else {
            GL30.glBindVertexArray((int)array);
        }
    }

    public static boolean isSHADERS_SUPPORTED() {
        return SHADERS_SUPPORTED;
    }

    public static boolean isVBOS_SUPPORTED() {
        return VBOS_SUPPORTED;
    }

    public static boolean isVAOS_SUPPORTED() {
        return VAOS_SUPPORTED;
    }

    static {
        StringBuilder infoBuilder = new StringBuilder();
        ContextCapabilities capabilities = GLContext.getCapabilities();
        boolean openGL33Supported = capabilities.OpenGL30;
        VAOS_SUPPORTED = openGL33Supported || capabilities.GL_ARB_vertex_array_object;
        infoBuilder.append("VAOs are ").append(VAOS_SUPPORTED ? "" : "not ").append("available. ");
        if (VAOS_SUPPORTED) {
            if (capabilities.OpenGL30) {
                infoBuilder.append("OpenGL 3.0 is supported. ");
                USING_ARB_VAOS = false;
            } else {
                infoBuilder.append("GL_ARB_vertex_array_object is supported. ");
                USING_ARB_VAOS = true;
            }
        } else {
            infoBuilder.append("OpenGL 3.0 is not supported and GL_ARB_vertex_array_object is not supported. ");
            USING_ARB_VAOS = false;
        }
        boolean openGL21Supported = capabilities.OpenGL20;
        SHADERS_SUPPORTED = openGL21Supported || capabilities.GL_ARB_vertex_shader && capabilities.GL_ARB_fragment_shader && capabilities.GL_ARB_shader_objects;
        infoBuilder.append("Shaders are ").append(SHADERS_SUPPORTED ? "" : "not ").append("available. ");
        if (SHADERS_SUPPORTED) {
            if (capabilities.OpenGL20) {
                infoBuilder.append("OpenGL 2.0 is supported. ");
                USING_ARB_SHADERS = false;
                GL_LINK_STATUS = 35714;
                GL_COMPILE_STATUS = 35713;
                GL_VERTEX_SHADER = 35633;
                GL_FRAGMENT_SHADER = 35632;
            } else {
                infoBuilder.append("ARB_shader_objects, ARB_vertex_shader, and ARB_fragment_shader are supported. ");
                USING_ARB_SHADERS = true;
                GL_LINK_STATUS = 35714;
                GL_COMPILE_STATUS = 35713;
                GL_VERTEX_SHADER = 35633;
                GL_FRAGMENT_SHADER = 35632;
            }
        } else {
            infoBuilder.append("OpenGL 2.0 is not supported and ARB_shader_objects, ARB_vertex_shader, and ARB_fragment_shader are not supported. ");
            USING_ARB_SHADERS = false;
            GL_LINK_STATUS = 0;
            GL_COMPILE_STATUS = 0;
            GL_VERTEX_SHADER = 0;
            GL_FRAGMENT_SHADER = 0;
        }
        USING_ARB_VBOS = !capabilities.OpenGL15 && capabilities.GL_ARB_vertex_buffer_object;
        VBOS_SUPPORTED = capabilities.OpenGL15 || USING_ARB_VBOS;
        infoBuilder.append("VBOs are ").append(VBOS_SUPPORTED ? "" : "not ").append("available. ");
        if (VBOS_SUPPORTED) {
            if (USING_ARB_VBOS) {
                infoBuilder.append("ARB_vertex_buffer_object is supported. ");
                GL_ARRAY_BUFFER = 34962;
                GL_DYNAMIC_DRAW = 35048;
            } else {
                infoBuilder.append("OpenGL 1.5 is supported. ");
                GL_ARRAY_BUFFER = 34962;
                GL_DYNAMIC_DRAW = 35048;
            }
        } else {
            infoBuilder.append("OpenGL 1.5 is not supported and ARB_vertex_buffer_object is not supported. ");
            GL_ARRAY_BUFFER = 0;
            GL_DYNAMIC_DRAW = 0;
        }
        LOGGER.info(infoBuilder.toString());
    }
}

