/*
 * Decompiled with CFR 0.152.
 */
package codes.biscuit.skyblockaddons.shader;

import codes.biscuit.skyblockaddons.SkyblockAddons;
import codes.biscuit.skyblockaddons.shader.ShaderHelper;
import codes.biscuit.skyblockaddons.shader.ShaderLoader;
import codes.biscuit.skyblockaddons.shader.Uniform;
import codes.biscuit.skyblockaddons.shader.UniformType;
import codes.biscuit.skyblockaddons.shader.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.shader.ShaderLinkHelper;
import org.lwjgl.opengl.OpenGLException;

public abstract class Shader {
    protected static final SkyblockAddons main = SkyblockAddons.getInstance();
    private final String VERTEX;
    private final String FRAGMENT;
    private final VertexFormat VERTEX_FORMAT;
    protected int program;
    private final List<Uniform<?>> uniforms = new ArrayList();

    public Shader(String vertex, String fragment) throws Exception {
        this(vertex, fragment, null);
    }

    private Shader(String vertex, String fragment, VertexFormat vertexFormat) throws Exception {
        this.VERTEX = vertex;
        this.FRAGMENT = fragment;
        this.VERTEX_FORMAT = vertexFormat;
        this.init();
    }

    private void init() throws Exception {
        this.program = ShaderLinkHelper.func_148074_b().func_148078_c();
        if (this.VERTEX != null) {
            ShaderLoader vertexShaderLoader = ShaderLoader.load(ShaderLoader.ShaderType.VERTEX, this.VERTEX);
            vertexShaderLoader.attachShader(this);
        }
        if (this.FRAGMENT != null) {
            ShaderLoader fragmentShaderLoader = ShaderLoader.load(ShaderLoader.ShaderType.FRAGMENT, this.FRAGMENT);
            fragmentShaderLoader.attachShader(this);
        }
        ShaderHelper.glLinkProgram(this.program);
        int linkStatus = ShaderHelper.glGetProgrami(this.program, ShaderHelper.GL_LINK_STATUS);
        if (linkStatus == 0) {
            throw new OpenGLException("Error encountered when linking program containing VS " + this.VERTEX + " and FS " + this.FRAGMENT + ": " + ShaderHelper.glGetProgramInfoLog(this.program, 32768));
        }
        this.registerUniforms();
    }

    protected void registerUniforms() {
    }

    public void updateUniforms() {
        for (Uniform<?> uniform : this.uniforms) {
            uniform.update();
        }
    }

    public void enable() {
        ShaderHelper.glUseProgram(this.program);
    }

    public void disable() {
        ShaderHelper.glUseProgram(0);
    }

    public boolean isUsingFixedPipeline() {
        return this.VERTEX_FORMAT == null;
    }

    public <T> void registerUniform(UniformType<T> uniformType, String name, Supplier<T> uniformValuesSupplier) {
        this.uniforms.add(new Uniform<T>(this, uniformType, name, uniformValuesSupplier));
    }

    public int getProgram() {
        return this.program;
    }
}

