/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.tools.obfuscation.mirror;

import java.lang.annotation.Annotation;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.spongepowered.asm.mixin.injection.struct.MemberInfo;
import org.spongepowered.asm.obfuscation.mapping.common.MappingMethod;
import org.spongepowered.asm.util.SignaturePrinter;
import org.spongepowered.tools.obfuscation.mirror.AnnotationHandle;
import org.spongepowered.tools.obfuscation.mirror.FieldHandle;
import org.spongepowered.tools.obfuscation.mirror.MethodHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeHandle;
import org.spongepowered.tools.obfuscation.mirror.TypeUtils;

public class TypeHandleSimulated
extends TypeHandle {
    private final TypeElement simulatedType;

    public TypeHandleSimulated(String name2, TypeMirror type2) {
        this(TypeUtils.getPackage(type2), name2, type2);
    }

    public TypeHandleSimulated(PackageElement pkg, String name2, TypeMirror type2) {
        super(pkg, name2);
        this.simulatedType = (TypeElement)((DeclaredType)type2).asElement();
    }

    @Override
    protected TypeElement getTargetElement() {
        return this.simulatedType;
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isImaginary() {
        return false;
    }

    @Override
    public boolean isSimulated() {
        return true;
    }

    @Override
    public AnnotationHandle getAnnotation(Class<? extends Annotation> annotationClass) {
        return null;
    }

    @Override
    public TypeHandle getSuperclass() {
        return null;
    }

    @Override
    public String findDescriptor(MemberInfo memberInfo) {
        return memberInfo != null ? memberInfo.desc : null;
    }

    @Override
    public FieldHandle findField(String name2, String type2, boolean caseSensitive) {
        return new FieldHandle(null, name2, type2);
    }

    @Override
    public MethodHandle findMethod(String name2, String desc, boolean caseSensitive) {
        return new MethodHandle(null, name2, desc);
    }

    @Override
    public MappingMethod getMappingMethod(String name2, String desc) {
        String rawSignature;
        String signature2 = new SignaturePrinter(name2, desc).setFullyQualified(true).toDescriptor();
        MethodHandle method = TypeHandleSimulated.findMethodRecursive(this, name2, signature2, rawSignature = TypeUtils.stripGenerics(signature2), true);
        return method != null ? method.asMapping(true) : super.getMappingMethod(name2, desc);
    }

    private static MethodHandle findMethodRecursive(TypeHandle target, String name2, String signature2, String rawSignature, boolean matchCase) {
        TypeElement elem = target.getTargetElement();
        if (elem == null) {
            return null;
        }
        MethodHandle method = TypeHandle.findMethod(target, name2, signature2, rawSignature, matchCase);
        if (method != null) {
            return method;
        }
        for (TypeMirror typeMirror : elem.getInterfaces()) {
            method = TypeHandleSimulated.findMethodRecursive(typeMirror, name2, signature2, rawSignature, matchCase);
            if (method == null) continue;
            return method;
        }
        TypeMirror superClass = elem.getSuperclass();
        if (superClass == null || superClass.getKind() == TypeKind.NONE) {
            return null;
        }
        return TypeHandleSimulated.findMethodRecursive(superClass, name2, signature2, rawSignature, matchCase);
    }

    private static MethodHandle findMethodRecursive(TypeMirror target, String name2, String signature2, String rawSignature, boolean matchCase) {
        if (!(target instanceof DeclaredType)) {
            return null;
        }
        TypeElement element = (TypeElement)((DeclaredType)target).asElement();
        return TypeHandleSimulated.findMethodRecursive(new TypeHandle(element), name2, signature2, rawSignature, matchCase);
    }
}

