/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.tracker;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.misc.TrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.SlayerAPI;
import at.hannibal2.skyhanni.data.TrackerManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ItemPriceSource;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import at.hannibal2.skyhanni.utils.tracker.ItemTrackerData;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniTracker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 2*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\u00012B\u008f\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b\u0012B\u0010\u000e\u001a\"\u0012\u001e\b\u0001\u0012\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b0\f0\u000b\"\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b0\f\u0012\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u001f\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001d\u00a2\u0006\u0004\b\u001f\u0010 J7\u0010$\u001a\u00020#2\u0006\u0010!\u001a\u00028\u00002\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00180\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001d\u00a2\u0006\u0004\b$\u0010%J=\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010!\u001a\u00028\u00002\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b*\u0010+J%\u00100\u001a\u00020\u00102\u0006\u0010,\u001a\u00020#2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u0004\u00a2\u0006\u0004\b0\u00101\u00a8\u00063"}, d2={"Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData;", "Data", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniTracker;", "", "name", "Lkotlin/Function0;", "createNewSession", "Lkotlin/Function1;", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage;", "getStorage", "", "Lkotlin/Pair;", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniTracker$DisplayMode;", "extraStorage", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;[Lkotlin/Pair;Lkotlin/jvm/functions/Function1;)V", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "internalName", "", "amount", "", "command", "", "addItem", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;IZ)V", "", "lists", "addPriceFromButton", "(Ljava/util/List;)V", "data", "filter", "", "drawItems", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData;Lkotlin/jvm/functions/Function1;Ljava/util/List;)D", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;", "item", "hidden", "newDrop", "buildLore", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData;Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;ZZLat/hannibal2/skyhanni/utils/NEUInternalName;)Ljava/util/List;", "profit", "", "totalAmount", "action", "addTotalProfit", "(DJLjava/lang/String;)Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "Companion", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSkyHanniItemTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkyHanniItemTracker.kt\nat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker\n+ 2 CollectionUtils.kt\nat/hannibal2/skyhanni/utils/CollectionUtils\n*L\n1#1,210:1\n317#2,35:211\n*S KotlinDebug\n*F\n+ 1 SkyHanniItemTracker.kt\nat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker\n*L\n67#1:211,35\n*E\n"})
public final class SkyHanniItemTracker<Data extends ItemTrackerData>
extends SkyHanniTracker<Data> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final NEUInternalName SKYBLOCK_COIN = NEUInternalName.Companion.getSKYBLOCK_COIN();

    public SkyHanniItemTracker(@NotNull String name2, @NotNull Function0<? extends Data> createNewSession, @NotNull Function1<? super ProfileSpecificStorage, ? extends Data> getStorage, @NotNull Pair<? extends SkyHanniTracker.DisplayMode, ? extends Function1<? super ProfileSpecificStorage, ? extends Data>>[] extraStorage, @NotNull Function1<? super Data, ? extends List<Searchable>> drawDisplay) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(createNewSession, "createNewSession");
        Intrinsics.checkNotNullParameter(getStorage, "getStorage");
        Intrinsics.checkNotNullParameter(extraStorage, "extraStorage");
        Intrinsics.checkNotNullParameter(drawDisplay, "drawDisplay");
        super(name2, createNewSession, getStorage, Arrays.copyOf(extraStorage, extraStorage.length), drawDisplay);
    }

    public final void addItem(@NotNull NEUInternalName internalName, int amount, boolean command2) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        this.modify(arg_0 -> SkyHanniItemTracker.addItem$lambda$0(internalName, amount, command2, arg_0));
        SkyHanniTracker.SharedTracker<ItemTrackerData> sharedTracker = this.getSharedTracker();
        if (sharedTracker != null) {
            Boolean isHidden;
            SkyHanniTracker.SharedTracker<ItemTrackerData> sharedData = sharedTracker;
            boolean bl = false;
            ItemTrackerData.TrackedItem trackedItem = ((ItemTrackerData)sharedData.get(SkyHanniTracker.DisplayMode.TOTAL)).getItems().get(internalName);
            Boolean bl2 = isHidden = trackedItem != null ? Boolean.valueOf(trackedItem.getHidden()) : null;
            if (isHidden != null) {
                sharedData.modify(arg_0 -> SkyHanniItemTracker.addItem$lambda$2$lambda$1(internalName, isHidden, arg_0));
            }
        }
        if (command2) {
            TrackerManager.INSTANCE.setCommandEditTrackerSuccess(true);
            String displayName = ItemUtils.INSTANCE.getItemName(internalName);
            if (amount > 0) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Manually added to " + this.getName() + ": \u00a7r" + displayName + " \u00a77(" + amount + "x\u00a77)", false, null, 6, null);
            } else {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Manually removed from " + this.getName() + ": \u00a7r" + displayName + " \u00a77(" + -amount + "x\u00a77)", false, null, 6, null);
            }
            return;
        }
        Pair<String, Double> pair = SlayerAPI.INSTANCE.getItemNameAndPrice(internalName, amount);
        String itemName = pair.component1();
        double price = ((Number)pair.component2()).doubleValue();
        if (SkyHanniTracker.Companion.getConfig().warnings.chat && price >= (double)SkyHanniTracker.Companion.getConfig().warnings.minimumChat) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7a+Tracker Drop\u00a77: \u00a7r" + itemName, false, null, 6, null);
        }
        if (SkyHanniTracker.Companion.getConfig().warnings.title && price >= (double)SkyHanniTracker.Companion.getConfig().warnings.minimumTitle) {
            LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, "\u00a7a+ " + itemName, DurationKt.toDuration(5, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addPriceFromButton(@NotNull List<Searchable> lists) {
        Intrinsics.checkNotNullParameter(lists, "lists");
        if (this.isInventoryOpen()) {
            void prefix$iv;
            List<Renderable> list;
            void this_$iv$iv;
            void $this$addSearchableSelector$iv;
            void this_$iv;
            CollectionUtils collectionUtils = CollectionUtils.INSTANCE;
            List<Searchable> list2 = lists;
            String string2 = "";
            boolean $i$f$addSearchableSelector = false;
            void var6_6 = this_$iv;
            Renderable.Companion companion = Renderable.Companion;
            void var8_8 = $this$addSearchableSelector$iv;
            boolean $i$f$buildSelector = false;
            void var10_10 = this_$iv$iv;
            ItemPriceSource[] universe$iv$iv$iv = ItemPriceSource.values();
            boolean $i$f$buildSelector2 = false;
            List<Renderable> $this$buildSelector_u24lambda_u2421$iv$iv$iv = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, (String)prefix$iv, null, null, 6, null);
            int n = universe$iv$iv$iv.length;
            for (int j = 0; j < n; ++j) {
                ItemPriceSource entry$iv$iv$iv;
                ItemPriceSource type2 = entry$iv$iv$iv = universe$iv$iv$iv[j];
                boolean bl2 = false;
                String display$iv$iv$iv = type2.getSellName();
                ItemPriceSource it = entry$iv$iv$iv;
                boolean bl3 = false;
                if (it.ordinal() == SkyHanniTracker.Companion.getConfig().priceSource.ordinal()) {
                    CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, "\u00a7a[" + display$iv$iv$iv + "\u00a7a]", null, null, 6, null);
                } else {
                    CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, "\u00a7e[", null, null, 6, null);
                    $this$buildSelector_u24lambda_u2421$iv$iv$iv.add(Renderable.Companion.link$default(Renderable.Companion, "\u00a7e" + display$iv$iv$iv, false, new Function0<Unit>((Object)entry$iv$iv$iv, this){
                        final /* synthetic */ Object $entry;
                        final /* synthetic */ SkyHanniItemTracker this$0;
                        {
                            this.$entry = $entry;
                            this.this$0 = skyHanniItemTracker;
                        }

                        public final void invoke() {
                            ItemPriceSource it = (ItemPriceSource)((Object)this.$entry);
                            boolean bl = false;
                            SkyHanniTracker.Companion.getConfig().priceSource = (ItemPriceSource)((Object)ItemPriceSource.getEntries().get(it.ordinal()));
                            this.this$0.update();
                        }
                    }, 2, null));
                    CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, "\u00a7e]", null, null, 6, null);
                }
                CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, " ", null, null, 6, null);
            }
            List list3 = CollectionsKt.build(list);
            var8_8.add(SearchableKt.toSearchable$default(Renderable.Companion.horizontalContainer$default(companion, list3, 0, null, null, 14, null), null, 1, null));
        }
    }

    public final double drawItems(@NotNull Data data2, @NotNull Function1<? super NEUInternalName, Boolean> filter2, @NotNull List<Searchable> lists) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter(lists, "lists");
        double profit = 0.0;
        Map items = new LinkedHashMap();
        for (Map.Entry<NEUInternalName, ItemTrackerData.TrackedItem> entry : ((ItemTrackerData)data2).getItems().entrySet()) {
            NEUInternalName internalName = entry.getKey();
            ItemTrackerData.TrackedItem itemProfit = entry.getValue();
            if (!filter2.invoke(internalName).booleanValue()) continue;
            long l = itemProfit.getTotalAmount();
            double pricePer = Intrinsics.areEqual(internalName, SKYBLOCK_COIN) ? 1.0 : ((ItemTrackerData)data2).getCustomPricePer(internalName);
            long price = (long)(pricePer * (double)l);
            boolean hidden = itemProfit.getHidden();
            if (this.isInventoryOpen() || !hidden) {
                Long l2 = price;
                items.put(internalName, l2);
            }
            if (hidden && SkyHanniTracker.Companion.getConfig().excludeHiddenItemsInPrice) continue;
            profit += (double)price;
        }
        TrackerConfig.HideCheapItemsConfig limitList = SkyHanniTracker.Companion.getConfig().hideCheapItems;
        int pos = 0;
        List hiddenItemTexts = new ArrayList();
        for (Map.Entry entry : CollectionUtils.INSTANCE.sortedDesc(items).entrySet()) {
            ItemTrackerData.TrackedItem itemProfit;
            NEUInternalName internalName = (NEUInternalName)entry.getKey();
            long price = ((Number)entry.getValue()).longValue();
            if (((ItemTrackerData)data2).getItems().get(internalName) == null) {
                throw new IllegalStateException(("Item not found for " + internalName).toString());
            }
            long amount = itemProfit.getTotalAmount();
            long displayAmount = Intrinsics.areEqual(internalName, SKYBLOCK_COIN) ? itemProfit.getTimesGained() : amount;
            String cleanName = Intrinsics.areEqual(internalName, SKYBLOCK_COIN) ? ((ItemTrackerData)data2).getCoinName(itemProfit) : ItemUtils.INSTANCE.getItemName(internalName);
            String priceFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, price, false, 1, null);
            boolean hidden = itemProfit.getHidden();
            boolean newDrop = Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(itemProfit.getLastTimeUpdated-uFjCsEo()), DurationKt.toDuration(10, DurationUnit.SECONDS)) < 0 && SkyHanniTracker.Companion.getConfig().showRecentDrops;
            String numberColor = newDrop ? "\u00a7a\u00a7l" : "\u00a77";
            String name2 = StringsKt.replace$default(StringUtils.INSTANCE.removeColor(cleanName, true), "\u00a7r", "", false, 4, null);
            String displayName = hidden ? "\u00a78\u00a7m" + name2 : cleanName;
            displayName = ' ' + numberColor + NumberUtil.INSTANCE.addSeparators(displayAmount) + "x " + displayName + "\u00a77: \u00a76" + priceFormat;
            if (((Boolean)limitList.enabled.get()).booleanValue() && ++pos > ((Number)limitList.alwaysShowBest.get()).intValue() && price < (long)(((Number)limitList.minPrice.get()).intValue() * 1000)) {
                ((Collection)hiddenItemTexts).add(displayName);
                continue;
            }
            List<String> lore = this.buildLore(data2, itemProfit, hidden, newDrop, internalName);
            Renderable renderable2 = this.isInventoryOpen() ? Renderable.Companion.clickAndHover$default(Renderable.Companion, displayName, lore, false, () -> SkyHanniItemTracker.drawItems$lambda$7(data2, internalName, cleanName, name2, this, hidden), null, 20, null) : Renderable.Companion.string$default(Renderable.Companion, displayName, 0.0, null, null, null, 30, null);
            lists.add(SearchableKt.toSearchable(renderable2, name2));
        }
        if (hiddenItemTexts.size() > 0) {
            Searchable text = SearchableKt.toSearchable$default(Renderable.Companion.hoverTips$default(Renderable.Companion, " \u00a77" + hiddenItemTexts.size() + " cheap items are hidden.", hiddenItemTexts, null, null, null, false, false, false, null, null, 1020, null), null, 1, null);
            lists.add(text);
        }
        return profit;
    }

    private final List<String> buildLore(Data data2, ItemTrackerData.TrackedItem item, boolean hidden, boolean newDrop, NEUInternalName internalName) {
        List<String> list;
        List<String> $this$buildLore_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual(internalName, SKYBLOCK_COIN) ? $this$buildLore_u24lambda_u248.addAll((Collection)((ItemTrackerData)data2).getCoinDescription(item)) : $this$buildLore_u24lambda_u248.addAll((Collection)((ItemTrackerData)data2).getDescription(item.getTimesGained()));
        $this$buildLore_u24lambda_u248.add("");
        if (newDrop) {
            $this$buildLore_u24lambda_u248.add("\u00a7aYou obtained this item recently.");
            $this$buildLore_u24lambda_u248.add("");
        }
        $this$buildLore_u24lambda_u248.add("\u00a7eClick to " + (hidden ? "show" : "hide") + '!');
        $this$buildLore_u24lambda_u248.add("\u00a7eControl + Click to remove this item!");
        $this$buildLore_u24lambda_u248.add("");
        $this$buildLore_u24lambda_u248.add("\u00a77Use \u00a7e/shedittracker " + ItemUtils.INSTANCE.getReadableInternalName(internalName) + " <amount>");
        $this$buildLore_u24lambda_u248.add("\u00a77to edit the number.");
        $this$buildLore_u24lambda_u248.add("\u00a77Use negative numbers to remove items.");
        if (SkyHanniMod.feature.dev.debug.enabled) {
            $this$buildLore_u24lambda_u248.add("");
            $this$buildLore_u24lambda_u248.add("\u00a77" + internalName);
        }
        return CollectionsKt.build(list);
    }

    @NotNull
    public final Searchable addTotalProfit(double profit, long totalAmount, @NotNull String action) {
        List<Object> list;
        String profitPrefix;
        Intrinsics.checkNotNullParameter(action, "action");
        String profitFormat = NumberUtil.INSTANCE.addSeparators((long)profit);
        String string2 = profitPrefix = profit < 0.0 ? "\u00a7c" : "\u00a76";
        if (totalAmount > 0L) {
            double profitPerCatch = profit / (double)totalAmount;
            String profitPerCatchFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, profitPerCatch, false, 1, null);
            list = CollectionsKt.listOf("\u00a77Profit per " + action + ": " + profitPrefix + profitPerCatchFormat);
        } else {
            list = CollectionsKt.emptyList();
        }
        List tips = list;
        String text = "\u00a7eTotal Profit: " + profitPrefix + profitFormat + " coins";
        return SearchableKt.toSearchable$default(Renderable.Companion.hoverTips$default(Renderable.Companion, text, tips, null, null, null, false, false, false, null, null, 1020, null), null, 1, null);
    }

    private static final Unit addItem$lambda$0(NEUInternalName $internalName, int $amount, boolean $command, ItemTrackerData it) {
        Intrinsics.checkNotNullParameter($internalName, "$internalName");
        Intrinsics.checkNotNullParameter(it, "it");
        it.addItem($internalName, $amount, $command);
        return Unit.INSTANCE;
    }

    private static final Unit addItem$lambda$2$lambda$1(NEUInternalName $internalName, Boolean $isHidden, ItemTrackerData it) {
        block0: {
            Intrinsics.checkNotNullParameter($internalName, "$internalName");
            Intrinsics.checkNotNullParameter(it, "it");
            ItemTrackerData.TrackedItem trackedItem = it.getItems().get($internalName);
            if (trackedItem == null) break block0;
            trackedItem.setHidden($isHidden);
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawItems$lambda$7$lambda$6(NEUInternalName $internalName, boolean $hidden, ItemTrackerData it) {
        block0: {
            Intrinsics.checkNotNullParameter($internalName, "$internalName");
            Intrinsics.checkNotNullParameter(it, "it");
            ItemTrackerData.TrackedItem trackedItem = it.getItems().get($internalName);
            if (trackedItem == null) break block0;
            trackedItem.setHidden(!$hidden);
        }
        return Unit.INSTANCE;
    }

    private static final Unit drawItems$lambda$7(ItemTrackerData $data, NEUInternalName $internalName, String $cleanName, String $name, SkyHanniItemTracker this$0, boolean $hidden) {
        Intrinsics.checkNotNullParameter($data, "$data");
        Intrinsics.checkNotNullParameter($internalName, "$internalName");
        Intrinsics.checkNotNullParameter($cleanName, "$cleanName");
        Intrinsics.checkNotNullParameter($name, "$name");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (KeyboardManager.INSTANCE.isModifierKeyDown()) {
            $data.getItems().remove($internalName);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Removed " + $cleanName + " \u00a7efrom " + $name + '.', false, null, 6, null);
        } else {
            this$0.modify(arg_0 -> SkyHanniItemTracker.drawItems$lambda$7$lambda$6($internalName, $hidden, arg_0));
        }
        this$0.update();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker$Companion;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "SKYBLOCK_COIN", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "getSKYBLOCK_COIN", "()Lat/hannibal2/skyhanni/utils/NEUInternalName;", "1.8.9"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NEUInternalName getSKYBLOCK_COIN() {
            return SKYBLOCK_COIN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

