/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.repopatterns;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.config.features.dev.RepoPatternConfig;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.LorenzEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.utils.PreInitFinishedEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.repopatterns.CommonPatternInfo;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternDump;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternImpl;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternKeyOwner;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternList;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternListImpl;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import com.google.gson.Gson;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0003J+\u0010\u001f\u001a\u00020\u00062\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J+\u0010#\u001a\u00020\u00062\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b%\u0010\bJ\u001d\u0010\u0014\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00042\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b\u0014\u0010)J\u0017\u0010+\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020*H\u0007\u00a2\u0006\u0004\b+\u0010,J)\u00100\u001a\u00020/2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b0\u00101J1\u00105\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\u00042\u000e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u0004022\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b5\u00106J\u001d\u0010<\u001a\b\u0012\u0004\u0012\u000209082\u0006\u00107\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b:\u0010;R\u001f\u0010A\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030>0=8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0018\u0010B\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR \u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\"\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0G8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010IR*\u0010J\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030>0\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010M\u001a\u00020L8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0014\u0010O\u001a\u00020L8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010NR\u0014\u0010P\u001a\u00020L8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010NR\"\u0010Q\u001a\u00020L8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010N\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u001c\u0010Z\u001a\n W*\u0004\u0018\u00010V0V8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010YR\u0011\u0010\\\u001a\u00020L8F\u00a2\u0006\u0006\u001a\u0004\b[\u0010SR\u001c\u0010^\u001a\n W*\u0004\u0018\u00010]0]8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b^\u0010_R\u001f\u0010`\u001a\n W*\u0004\u0018\u000109098\u0006\u00a2\u0006\f\n\u0004\b`\u0010a\u001a\u0004\bb\u0010c\u00a8\u0006d"}, d2={"Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternManager;", "", "<init>", "()V", "", "reason", "", "crash", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternKeyOwner;", "owner", "key", "checkExclusivity", "(Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternKeyOwner;Ljava/lang/String;)V", "checkNameSpaceExclusivity", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternDump;", "dump", "loadPatternsFromDump", "(Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternDump;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "reloadPatterns", "Ljava/util/NavigableMap;", "remotePatterns", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternImpl;", "it", "loadStandalonePattern", "(Ljava/util/NavigableMap;Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternImpl;)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternListImpl;", "arrayPattern", "loadArrayPatterns", "(Ljava/util/NavigableMap;Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternListImpl;)V", "verifyKeyShape", "sourceLabel", "Ljava/io/File;", "file", "(Ljava/lang/String;Ljava/io/File;)V", "Lat/hannibal2/skyhanni/events/utils/PreInitFinishedEvent;", "onPreInitFinished", "(Lat/hannibal2/skyhanni/events/utils/PreInitFinishedEvent;)V", "fallback", "parentKeyHolder", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "of", "(Ljava/lang/String;Ljava/lang/String;Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternKeyOwner;)Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "", "fallbacks", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternList;", "ofList", "(Ljava/lang/String;[Ljava/lang/String;Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternKeyOwner;)Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternList;", "prefix", "", "Ljava/util/regex/Pattern;", "getUnusedPatterns$1_8_9", "(Ljava/lang/String;)Ljava/util/List;", "getUnusedPatterns", "", "Lat/hannibal2/skyhanni/utils/repopatterns/CommonPatternInfo;", "getAllPatterns", "()Ljava/util/Collection;", "allPatterns", "regexes", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternDump;", "getRemotePattern", "()Ljava/util/NavigableMap;", "remotePattern", "", "exclusivity", "Ljava/util/Map;", "usedKeys", "Ljava/util/NavigableMap;", "", "wasPreInitialized", "Z", "isInDevEnv", "insideTest", "inTestDuplicateUsage", "getInTestDuplicateUsage", "()Z", "setInTestDuplicateUsage", "(Z)V", "Lat/hannibal2/skyhanni/config/features/dev/RepoPatternConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dev/RepoPatternConfig;", "config", "getLocalLoading", "localLoading", "Lorg/apache/logging/log4j/Logger;", "logger", "Lorg/apache/logging/log4j/Logger;", "keyShape", "Ljava/util/regex/Pattern;", "getKeyShape", "()Ljava/util/regex/Pattern;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nRepoPatternManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepoPatternManager.kt\nat/hannibal2/skyhanni/utils/repopatterns/RepoPatternManager\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,339:1\n12#2,7:340\n136#3,9:347\n216#3:356\n217#3:358\n145#3:359\n216#3,2:379\n126#3:388\n153#3,3:389\n77#3:436\n97#3,5:437\n126#3:446\n153#3,3:447\n1#4:357\n1#4:372\n1628#5,3:360\n1053#5:363\n1557#5:364\n1628#5,3:365\n1557#5:368\n1628#5,3:369\n1368#5:373\n1454#5,5:374\n1485#5:392\n1510#5,2:393\n1512#5:398\n1513#5,3:406\n1557#5:450\n1628#5,3:451\n535#6:381\n520#6,6:382\n381#6,7:399\n535#6:409\n520#6,16:410\n535#6:429\n520#6,6:430\n522#6,4:442\n1104#7,3:395\n1104#7,3:426\n*S KotlinDebug\n*F\n+ 1 RepoPatternManager.kt\nat/hannibal2/skyhanni/utils/repopatterns/RepoPatternManager\n*L\n156#1:340,7\n204#1:347,9\n204#1:356\n204#1:358\n204#1:359\n298#1:379,2\n323#1:388\n323#1:389,3\n328#1:436\n328#1:437,5\n335#1:446\n335#1:447,3\n204#1:357\n221#1:360,3\n226#1:363\n226#1:364\n226#1:365,3\n228#1:368\n228#1:369,3\n255#1:373\n255#1:374,5\n324#1:392\n324#1:393,2\n324#1:398\n324#1:406,3\n211#1:450\n211#1:451,3\n323#1:381\n323#1:382,6\n324#1:399,7\n326#1:409\n326#1:410,16\n328#1:429\n328#1:430,6\n326#1:442,4\n324#1:395,3\n327#1:426,3\n*E\n"})
public final class RepoPatternManager {
    @NotNull
    public static final RepoPatternManager INSTANCE;
    @Nullable
    private static RepoPatternDump regexes;
    @NotNull
    private static Map<String, RepoPatternKeyOwner> exclusivity;
    @NotNull
    private static NavigableMap<String, CommonPatternInfo<?, ?>> usedKeys;
    private static boolean wasPreInitialized;
    private static final boolean isInDevEnv;
    private static final boolean insideTest;
    private static boolean inTestDuplicateUsage;
    private static final Logger logger;
    private static final Pattern keyShape;

    private RepoPatternManager() {
    }

    @NotNull
    public final Collection<CommonPatternInfo<?, ?>> getAllPatterns() {
        Collection<CommonPatternInfo<?, ?>> collection = usedKeys.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return collection;
    }

    private final NavigableMap<String, String> getRemotePattern() {
        Object object;
        if (this.getLocalLoading()) {
            object = MapsKt.emptyMap();
        } else {
            object = regexes;
            if (object == null || (object = ((RepoPatternDump)object).getRegexes()) == null) {
                object = MapsKt.emptyMap();
            }
        }
        return new TreeMap(object);
    }

    public final boolean getInTestDuplicateUsage() {
        return inTestDuplicateUsage;
    }

    public final void setInTestDuplicateUsage(boolean bl) {
        inTestDuplicateUsage = bl;
    }

    private final RepoPatternConfig getConfig() {
        RepoPatternConfig repoPatternConfig;
        if (!insideTest) {
            repoPatternConfig = SkyHanniMod.feature.dev.repoPattern;
        } else {
            RepoPatternConfig repoPatternConfig2;
            RepoPatternConfig $this$_get_config__u24lambda_u240 = repoPatternConfig2 = new RepoPatternConfig();
            boolean bl = false;
            $this$_get_config__u24lambda_u240.tolerateDuplicateUsage = inTestDuplicateUsage;
            repoPatternConfig = repoPatternConfig2;
        }
        return repoPatternConfig;
    }

    public final boolean getLocalLoading() {
        return (Boolean)this.getConfig().forceLocal.get() != false || !insideTest && PlatformUtils.INSTANCE.isDevEnvironment();
    }

    public final void crash(@NotNull String reason) {
        Intrinsics.checkNotNullParameter(reason, "reason");
        if (isInDevEnv || LorenzEvent.Companion.isInGuardedEventHandler()) {
            throw new RuntimeException(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void checkExclusivity(@NotNull RepoPatternKeyOwner owner, @NotNull String key) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(key, "key");
        RepoPatternKeyOwner parentKeyHolder = owner.getParent();
        Map<String, RepoPatternKeyOwner> map2 = exclusivity;
        synchronized (map2) {
            boolean bl = false;
            RepoPatternManager $this$checkExclusivity_u24lambda_u244_u24lambda_u241 = INSTANCE;
            boolean bl2 = false;
            RepoPatternKeyOwner previousOwner = exclusivity.get(key);
            if (!Intrinsics.areEqual(previousOwner, owner) && previousOwner != null && !previousOwner.getTransient()) {
                if (!$this$checkExclusivity_u24lambda_u244_u24lambda_u241.getConfig().tolerateDuplicateUsage) {
                    $this$checkExclusivity_u24lambda_u244_u24lambda_u241.crash("Non unique access to regex at \"" + key + "\". First obtained by " + previousOwner.getOwnerClass() + " / " + previousOwner.getProperty() + ", tried to use at " + owner.getOwnerClass() + " / " + owner.getProperty());
                }
            } else {
                exclusivity.put(key, owner);
            }
            RepoPatternManager $this$checkExclusivity_u24lambda_u244_u24lambda_u243 = INSTANCE;
            boolean bl3 = false;
            RepoPatternKeyOwner repoPatternKeyOwner = RepoPatternKeyOwner.copy$default(owner, null, null, true, null, true, 11, null);
            Ref.ObjectRef parent = new Ref.ObjectRef();
            parent.element = key;
            RepoPatternKeyOwner previousParentOwnerMutable = null;
            while (previousParentOwnerMutable == null && ((CharSequence)parent.element).length() > 0) {
                void transient_;
                if (StringUtils.INSTANCE.substringBeforeLastOrNull((String)parent.element, ".") == null) {
                    Object cfr_ignored_0 = parent.element;
                    return;
                }
                parent.element = parent.element;
                previousParentOwnerMutable = exclusivity.get(parent.element);
                Object object = previousParentOwnerMutable;
                if (object != null) continue;
                RepoPatternManager $this$checkExclusivity_u24lambda_u244_u24lambda_u243_u24lambda_u242 = $this$checkExclusivity_u24lambda_u244_u24lambda_u243;
                boolean bl4 = false;
                exclusivity.put((String)parent.element, (RepoPatternKeyOwner)transient_);
                object = Unit.INSTANCE;
            }
            RepoPatternKeyOwner previousParentOwner = previousParentOwnerMutable;
            if (!(previousParentOwner == null || Intrinsics.areEqual(previousParentOwner, parentKeyHolder) || previousParentOwner.getShares() && Intrinsics.areEqual(previousParentOwner.getParent(), parentKeyHolder) || $this$checkExclusivity_u24lambda_u244_u24lambda_u243.getConfig().tolerateDuplicateUsage)) {
                $this$checkExclusivity_u24lambda_u244_u24lambda_u243.crash("Non unique access to array regex at \"" + (String)parent.element + "\". First obtained by " + previousParentOwner.getOwnerClass() + " / " + previousParentOwner.getProperty() + ", tried to use at " + owner.getOwnerClass() + " / " + owner.getProperty() + (parentKeyHolder != null ? "with parentKeyHolder " + parentKeyHolder.getOwnerClass() + " / " + parentKeyHolder.getProperty() : ""));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkNameSpaceExclusivity(@NotNull RepoPatternKeyOwner owner, @NotNull String key) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(key, "key");
        Map<String, RepoPatternKeyOwner> map2 = exclusivity;
        synchronized (map2) {
            boolean bl = false;
            RepoPatternKeyOwner preRegistered = exclusivity.get(key);
            if (preRegistered != null && !RepoPatternManager.INSTANCE.getConfig().tolerateDuplicateUsage) {
                INSTANCE.crash("Non unique access to array regex at \"" + key + "\". First obtained by " + preRegistered.getOwnerClass() + " / " + preRegistered.getProperty() + ", tried to use at " + owner.getOwnerClass() + " / " + owner.getProperty());
            }
            Unit unit = Unit.INSTANCE;
        }
        this.checkExclusivity(owner, key);
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        RepoPatternDump repoPatternDump;
        void constant$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String string2 = "regexes";
        RepoPatternManager repoPatternManager = this;
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant((String)constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            repoPatternDump = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), (String)constant$iv, gson$iv, RepoPatternDump.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + (String)constant$iv + '\'', e$iv);
        }
        repoPatternManager.loadPatternsFromDump(repoPatternDump);
    }

    public final void loadPatternsFromDump(@NotNull RepoPatternDump dump) {
        Intrinsics.checkNotNullParameter(dump, "dump");
        regexes = null;
        regexes = dump;
        this.reloadPatterns();
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property<Boolean> property = this.getConfig().forceLocal;
        Intrinsics.checkNotNullExpressionValue(property, "forceLocal");
        ConditionalUtils.INSTANCE.afterChange(property, RepoPatternManager::onConfigLoad$lambda$6);
    }

    private final void reloadPatterns() {
        NavigableMap<String, String> remotePatterns = this.getRemotePattern();
        for (CommonPatternInfo it : usedKeys.values()) {
            CommonPatternInfo commonPatternInfo = it;
            if (commonPatternInfo instanceof RepoPatternListImpl) {
                this.loadArrayPatterns(remotePatterns, (RepoPatternListImpl)it);
                continue;
            }
            if (commonPatternInfo instanceof RepoPatternImpl) {
                this.loadStandalonePattern(remotePatterns, (RepoPatternImpl)it);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void loadStandalonePattern(NavigableMap<String, String> remotePatterns, RepoPatternImpl it) {
        String remotePattern = (String)remotePatterns.get(it.getKey());
        try {
            if (remotePattern != null) {
                it.setValue(Pattern.compile(remotePattern));
                it.setLoadedRemotely(true);
                it.setWasOverridden(!Intrinsics.areEqual(remotePattern, it.getDefaultPattern()));
                return;
            }
        }
        catch (PatternSyntaxException e) {
            logger.error("Error while loading pattern from repo", (Throwable)e);
        }
        it.setValue(Pattern.compile(it.getDefaultPattern()));
        it.setLoadedRemotely(false);
        it.setWasOverridden(false);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadArrayPatterns(NavigableMap<String, String> remotePatterns, RepoPatternListImpl arrayPattern) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object;
        void $this$mapTo$iv;
        void $this$mapNotNullTo$iv$iv;
        String prefix = arrayPattern.getKey() + '.';
        NavigableMap<String, String> remotePatternList = StringUtils.INSTANCE.subMapOfStringsStartingWith(prefix, remotePatterns);
        Object $this$mapNotNull$iv = remotePatternList;
        boolean $i$f$mapNotNull = false;
        Map map2 = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Pair $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair it$iv$iv;
            Map.Entry entry;
            Map.Entry element$iv$iv = entry = iterator2.next();
            boolean bl = false;
            Map.Entry it2 = element$iv$iv;
            boolean bl2 = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
            Integer index = StringsKt.toIntOrNull(StringsKt.removePrefix((String)k, (CharSequence)prefix));
            if ((index == null ? null : TuplesKt.to(index, it2.getValue())) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List patternMap = (List)destination$iv$iv;
        if (this.getLocalLoading()) {
            RepoPatternManager.loadArrayPatterns$setDefaultPatterns(arrayPattern);
            return;
        }
        $this$mapNotNull$iv = patternMap;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            $this$forEach$iv$iv$iv = (Pair)item$iv;
            object = destination$iv;
            boolean bl = false;
            object.add(((Number)it3.getFirst()).intValue());
        }
        if (!Intrinsics.areEqual(destination$iv, CollectionsKt.toSet(CollectionsKt.getIndices(patternMap)))) {
            logger.error("Incorrect index set for " + arrayPattern);
            RepoPatternManager.loadArrayPatterns$setDefaultPatterns(arrayPattern);
        }
        Iterable $this$sortedBy$iv = patternMap;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getFirst()));
            }
        });
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add((String)pair.getSecond());
        }
        List patternStrings = (List)destination$iv$iv2;
        try {
            $this$map$iv = patternStrings;
            object = arrayPattern;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(Pattern.compile(string2));
            }
            ((RepoPatternListImpl)object).setValue((List)destination$iv$iv3);
            arrayPattern.setLoadedRemotely(true);
            arrayPattern.setWasOverridden(!Intrinsics.areEqual(patternStrings, arrayPattern.getDefaultPattern()));
            return;
        }
        catch (PatternSyntaxException e) {
            logger.error("Error while loading pattern from repo", (Throwable)e);
            RepoPatternManager.loadArrayPatterns$setDefaultPatterns(arrayPattern);
            return;
        }
    }

    public final Pattern getKeyShape() {
        return keyShape;
    }

    public final void verifyKeyShape(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Pattern pattern = keyShape;
        Intrinsics.checkNotNullExpressionValue(pattern, "keyShape");
        if (!RegexUtils.INSTANCE.matches(pattern, key)) {
            boolean bl = false;
            String string2 = "pattern key: \"" + key + "\" failed shape requirements";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dump(@NotNull String sourceLabel, @NotNull File file) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(sourceLabel, "sourceLabel");
        Intrinsics.checkNotNullParameter(file, "file");
        Gson gson2 = ConfigManager.Companion.getGson();
        Collection collection = usedKeys.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        String string2 = sourceLabel;
        Gson gson3 = gson2;
        boolean $i$f$flatMap = false;
        void var6_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CommonPatternInfo it = (CommonPatternInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = MapsKt.toList(it.dump());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Map<String, String> map2 = MapsKt.toMap(list);
        String string3 = string2;
        String data2 = gson3.toJson((Object)new RepoPatternDump(string3, map2));
        file.getParentFile().mkdirs();
        Intrinsics.checkNotNull(data2);
        FilesKt.writeText$default(file, data2, null, 2, null);
    }

    @HandleEvent
    public final void onPreInitFinished(@NotNull PreInitFinishedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        wasPreInitialized = true;
        String dumpDirective = System.getenv("SKYHANNI_DUMP_REGEXES");
        Object object = dumpDirective;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return;
        }
        String[] stringArray = new String[]{":"};
        object = StringsKt.split$default((CharSequence)dumpDirective, stringArray, false, 2, 2, null);
        String sourceLabel = (String)object.get(0);
        String path = (String)object.get(1);
        this.dump(sourceLabel, new File(path));
        if (System.getenv("SKYHANNI_DUMP_REGEXES_EXIT") != null) {
            logger.info("Exiting after dumping RepoPattern regex patterns to " + path);
            FMLCommonHandler.instance().exitJava(0, false);
        }
    }

    @NotNull
    public final RepoPattern of(@NotNull String key, @NotNull String fallback, @Nullable RepoPatternKeyOwner parentKeyHolder) {
        RepoPatternImpl repoPatternImpl;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(fallback, "fallback");
        this.verifyKeyShape(key);
        if (wasPreInitialized && !this.getConfig().tolerateLateRegistration) {
            this.crash("Illegal late initialization of repo pattern. Repo pattern needs to be created during pre-initialization.");
        }
        if (((Map)usedKeys).containsKey(key)) {
            CommonPatternInfo commonPatternInfo = (CommonPatternInfo)usedKeys.get(key);
            if (commonPatternInfo != null) {
                commonPatternInfo.setHasObtainedLock$1_8_9(false);
            }
        }
        RepoPatternImpl it = repoPatternImpl = new RepoPatternImpl(fallback, key, parentKeyHolder);
        boolean bl = false;
        ((Map)usedKeys).put(key, it);
        return repoPatternImpl;
    }

    public static /* synthetic */ RepoPattern of$default(RepoPatternManager repoPatternManager, String string2, String string3, RepoPatternKeyOwner repoPatternKeyOwner, int n, Object object) {
        if ((n & 4) != 0) {
            repoPatternKeyOwner = null;
        }
        return repoPatternManager.of(string2, string3, repoPatternKeyOwner);
    }

    @NotNull
    public final RepoPatternList ofList(@NotNull String key, @NotNull String[] fallbacks, @Nullable RepoPatternKeyOwner parentKeyHolder) {
        RepoPatternListImpl repoPatternListImpl;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(fallbacks, "fallbacks");
        this.verifyKeyShape(key);
        if (wasPreInitialized && !this.getConfig().tolerateLateRegistration) {
            this.crash("Illegal late initialization of repo pattern. Repo pattern needs to be created during pre-initialization.");
        }
        if (((Map)usedKeys).containsKey(key)) {
            CommonPatternInfo commonPatternInfo = (CommonPatternInfo)usedKeys.get(key);
            if (commonPatternInfo != null) {
                commonPatternInfo.setHasObtainedLock$1_8_9(false);
            }
        }
        Map $this$forEach$iv = StringUtils.INSTANCE.subMapOfStringsStartingWith(key, usedKeys);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            ((CommonPatternInfo)it.getValue()).setHasObtainedLock$1_8_9(false);
        }
        RepoPatternListImpl it = repoPatternListImpl = new RepoPatternListImpl(ArraysKt.toList(fallbacks), key, parentKeyHolder);
        boolean bl = false;
        ((Map)usedKeys).put(key, it);
        return repoPatternListImpl;
    }

    public static /* synthetic */ RepoPatternList ofList$default(RepoPatternManager repoPatternManager, String string2, String[] stringArray, RepoPatternKeyOwner repoPatternKeyOwner, int n, Object object) {
        if ((n & 4) != 0) {
            repoPatternKeyOwner = null;
        }
        return repoPatternManager.ofList(string2, stringArray, repoPatternKeyOwner);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pattern> getUnusedPatterns$1_8_9(@NotNull String prefix) {
        Map.Entry unused;
        char it;
        int count$iv;
        CharSequence $this$count$iv;
        Map $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Map.Entry it2;
        Map.Entry element$iv$iv;
        Object $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        if (this.getLocalLoading()) {
            return CollectionsKt.emptyList();
        }
        try {
            this.verifyKeyShape(prefix);
        }
        catch (IllegalArgumentException e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("prefix", prefix)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "getUnusedPatterns failed do to invalid key shape", pairArray, false, false, false, 56, null);
            return CollectionsKt.emptyList();
        }
        String prefixWithDot = prefix + '.';
        NavigableMap<String, String> patterns = StringUtils.INSTANCE.subMapOfStringsStartingWith(prefixWithDot, this.getRemotePattern());
        NavigableMap<String, CommonPatternInfo<?, ?>> holders = StringUtils.INSTANCE.subMapOfStringsStartingWith(prefixWithDot, usedKeys);
        Object $this$filter$iv = holders;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it2 = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(!((CommonPatternInfo)it2.getValue()).getShares())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it2 = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Object k = it2.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
            object.add(StringsKt.removePrefix((String)k, (CharSequence)prefixWithDot));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object2;
            element$iv$iv = iterator2.next();
            it2 = (String)((Object)element$iv$iv);
            boolean bl = false;
            $this$count$iv = (CharSequence)((Object)it2);
            boolean $i$f$count = false;
            count$iv = 0;
            for (int j = 0; j < $this$count$iv.length(); ++j) {
                char element$iv;
                it = element$iv = $this$count$iv.charAt(j);
                boolean bl2 = false;
                if (!(it == '.')) continue;
                ++count$iv;
            }
            Integer key$iv$iv = count$iv;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Object noShareHolder = destination$iv$iv;
        $this$filter$iv = patterns;
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            it2 = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(!holders.keySet().contains(it2.getKey()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            block17: {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Map.Entry it3;
                Map.Entry element$iv$iv2;
                void $this$filterTo$iv$iv2;
                unused = element$iv$iv = iterator2.next();
                boolean bl4 = false;
                Object k = unused.getKey();
                Intrinsics.checkNotNullExpressionValue(k, "<get-key>(...)");
                $this$count$iv = (CharSequence)k;
                boolean $i$f$count = false;
                count$iv = 0;
                for (int j = 0; j < $this$count$iv.length(); ++j) {
                    char element$iv;
                    it = element$iv = $this$count$iv.charAt(j);
                    boolean bl5 = false;
                    if (!(it == '.')) continue;
                    ++count$iv;
                }
                int dot = count$iv;
                Object $this$filter$iv2 = noShareHolder;
                boolean $i$f$filter2 = false;
                Object object3 = $this$filter$iv2;
                Object destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$filterTo2 = false;
                Iterator iterator3 = $this$filterTo$iv$iv2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    it3 = element$iv$iv2 = iterator3.next();
                    boolean bl6 = false;
                    if (!(((Number)it3.getKey()).intValue() < dot)) continue;
                    destination$iv$iv2.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
                }
                $this$filter$iv2 = destination$iv$iv2;
                boolean $i$f$flatMap = false;
                $this$filterTo$iv$iv2 = $this$flatMap$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                iterator3 = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    it3 = element$iv$iv2 = iterator3.next();
                    boolean bl7 = false;
                    Iterable list$iv$iv = (Iterable)it3.getValue();
                    CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
                }
                Set possibleConflicts = CollectionsKt.toSet((List)destination$iv$iv2);
                Object k2 = unused.getKey();
                Intrinsics.checkNotNullExpressionValue(k2, "<get-key>(...)");
                String key = StringsKt.removePrefix((String)k2, (CharSequence)prefixWithDot);
                while (((CharSequence)key).length() > 0) {
                    if (possibleConflicts.contains(key)) {
                        bl = false;
                        break block17;
                    }
                    if (StringUtils.INSTANCE.substringBeforeLastOrNull(key, ".") != null) continue;
                    bl = true;
                    break block17;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            unused = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Object v = it2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
            String string2 = (String)v;
            int n = 0;
            Pattern pattern = Pattern.compile(string2, n);
            Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
            object.add(pattern);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit onConfigLoad$lambda$6(Boolean $this$afterChange) {
        INSTANCE.reloadPatterns();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void loadArrayPatterns$setDefaultPatterns(RepoPatternListImpl $arrayPattern) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = (Iterable)$arrayPattern.getDefaultPattern();
        RepoPatternListImpl repoPatternListImpl = $arrayPattern;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Pattern.compile((String)p0));
        }
        repoPatternListImpl.setValue((List)destination$iv$iv);
        $arrayPattern.setLoadedRemotely(false);
        $arrayPattern.setWasOverridden(false);
    }

    static {
        boolean bl;
        INSTANCE = new RepoPatternManager();
        exclusivity = new LinkedHashMap();
        usedKeys = new TreeMap();
        try {
            Object v = Launch.blackboard.get("fml.deobfuscatedEnvironment");
            Intrinsics.checkNotNull(v, "null cannot be cast to non-null type kotlin.Boolean");
            bl = (Boolean)v;
        }
        catch (Exception exception) {
            bl = true;
        }
        isInDevEnv = bl;
        insideTest = Launch.blackboard == null;
        inTestDuplicateUsage = true;
        logger = LogManager.getLogger((String)"SkyHanni");
        keyShape = Pattern.compile("^(?:[a-z0-9]+\\.)*[a-z0-9]+$");
    }
}

