/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiScreenElementWrapper;
import at.hannibal2.skyhanni.deps.moulconfig.internal.KeybindHelper;
import at.hannibal2.skyhanni.events.GuiKeyPressEvent;
import at.hannibal2.skyhanni.events.LorenzKeyPressEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0006J\r\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0006J\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u0006J\r\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\u0006J\r\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\u0006J\r\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u0006J\r\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0006J\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0011\u0010\u001b\u001a\u00020\u0004*\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0011\u0010\u001e\u001a\u00020\u0004*\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0011\u0010 \u001a\u00020\u0004*\u00020\u001d\u00a2\u0006\u0004\b \u0010\u001fJ\u0015\u0010\"\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001d\u00a2\u0006\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00040&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lat/hannibal2/skyhanni/utils/KeyboardManager;", "", "<init>", "()V", "", "isCommandKeyDown", "()Z", "isMenuKeyDown", "isControlKeyDown", "isDeleteWordDown", "isDeleteLineDown", "isShiftKeyDown", "isPastingKeysDown", "isCopyingKeysDown", "isModifierKeyDown", "", "getModifierKeyName", "()Ljava/lang/String;", "Lnet/minecraftforge/client/event/GuiScreenEvent$KeyboardInputEvent$Pre;", "event", "", "onGuiScreenKeybind", "(Lnet/minecraftforge/client/event/GuiScreenEvent$KeyboardInputEvent$Pre;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lnet/minecraft/client/settings/KeyBinding;", "isActive", "(Lnet/minecraft/client/settings/KeyBinding;)Z", "", "isKeyHeld", "(I)Z", "isKeyClicked", "keyCode", "getKeyName", "(I)Ljava/lang/String;", "lastClickedMouseButton", "I", "", "pressedKeys", "Ljava/util/Map;", "WasdInputMatrix", "1.8.9"})
public final class KeyboardManager {
    @NotNull
    public static final KeyboardManager INSTANCE = new KeyboardManager();
    private static int lastClickedMouseButton = -1;
    @NotNull
    private static final Map<Integer, Boolean> pressedKeys = new LinkedHashMap();

    private KeyboardManager() {
    }

    private final boolean isCommandKeyDown() {
        return this.isKeyHeld(219) || this.isKeyHeld(220);
    }

    private final boolean isMenuKeyDown() {
        return this.isKeyHeld(56) || this.isKeyHeld(184);
    }

    private final boolean isControlKeyDown() {
        return this.isKeyHeld(29) || this.isKeyHeld(157);
    }

    public final boolean isDeleteWordDown() {
        return this.isKeyHeld(14) && (SystemUtils.IS_OS_MAC ? this.isMenuKeyDown() : this.isControlKeyDown());
    }

    public final boolean isDeleteLineDown() {
        return this.isKeyHeld(14) && (SystemUtils.IS_OS_MAC ? this.isCommandKeyDown() : this.isControlKeyDown() && this.isShiftKeyDown());
    }

    public final boolean isShiftKeyDown() {
        return this.isKeyHeld(42) || this.isKeyHeld(54);
    }

    public final boolean isPastingKeysDown() {
        return this.isModifierKeyDown() && this.isKeyHeld(47);
    }

    public final boolean isCopyingKeysDown() {
        return this.isModifierKeyDown() && this.isKeyHeld(46);
    }

    public final boolean isModifierKeyDown() {
        return SystemUtils.IS_OS_MAC ? this.isCommandKeyDown() : this.isControlKeyDown();
    }

    @NotNull
    public final String getModifierKeyName() {
        return SystemUtils.IS_OS_MAC ? "Command" : "Control";
    }

    @SubscribeEvent
    public final void onGuiScreenKeybind(@NotNull GuiScreenEvent.KeyboardInputEvent.Pre event) {
        Intrinsics.checkNotNullParameter(event, "event");
        GuiScreen guiScreen = event.gui;
        GuiContainer guiContainer = guiScreen instanceof GuiContainer ? (GuiContainer)guiScreen : null;
        if (guiContainer == null) {
            return;
        }
        GuiContainer guiScreen2 = guiContainer;
        if (new GuiKeyPressEvent(guiScreen2).postAndCatch()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        boolean isConfigScreen = currentScreen instanceof GuiScreenElementWrapper;
        if (isConfigScreen) {
            return;
        }
        if (currentScreen instanceof GuiChat) {
            return;
        }
        if (Mouse.getEventButtonState() && Mouse.getEventButton() != -1) {
            int key = Mouse.getEventButton() - 100;
            new LorenzKeyPressEvent(key).postAndCatch();
            lastClickedMouseButton = key;
            return;
        }
        if (Keyboard.getEventKeyState() && Keyboard.getEventKey() != 0) {
            int key = Keyboard.getEventKey();
            new LorenzKeyPressEvent(key).postAndCatch();
            lastClickedMouseButton = -1;
            return;
        }
        if (Mouse.getEventButton() == -1 && lastClickedMouseButton != -1) {
            if (this.isKeyHeld(lastClickedMouseButton)) {
                new LorenzKeyPressEvent(lastClickedMouseButton).postAndCatch();
                return;
            }
            lastClickedMouseButton = -1;
        }
        if (Keyboard.getEventKey() == 0) {
            new LorenzKeyPressEvent(Keyboard.getEventCharacter() + 256).postAndCatch();
        }
    }

    public final boolean isActive(@NotNull KeyBinding $this$isActive) {
        Intrinsics.checkNotNullParameter($this$isActive, "<this>");
        if (!Keyboard.isCreated()) {
            return false;
        }
        try {
            if (this.isKeyHeld($this$isActive.func_151463_i())) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("keyCode", $this$isActive.func_151463_i())};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error while checking if a key is pressed.", pairArray, false, false, false, 56, null);
            return false;
        }
        return $this$isActive.func_151470_d() || $this$isActive.func_151468_f();
    }

    public final boolean isKeyHeld(int $this$isKeyHeld) {
        boolean bl;
        if ($this$isKeyHeld == 0) {
            bl = false;
        } else if ($this$isKeyHeld < 0) {
            bl = Mouse.isButtonDown((int)($this$isKeyHeld + 100));
        } else if ($this$isKeyHeld >= 256) {
            int pressedKey;
            int n = pressedKey = Keyboard.getEventKey() == 0 ? Keyboard.getEventCharacter() + 256 : Keyboard.getEventKey();
            bl = Keyboard.getEventKeyState() && $this$isKeyHeld == pressedKey;
        } else {
            bl = Keyboard.isKeyDown((int)$this$isKeyHeld);
        }
        return bl;
    }

    public final boolean isKeyClicked(int $this$isKeyClicked) {
        boolean bl;
        if (this.isKeyHeld($this$isKeyClicked)) {
            if (!Intrinsics.areEqual(pressedKeys.get($this$isKeyClicked), true)) {
                Integer n = $this$isKeyClicked;
                pressedKeys.put(n, true);
                bl = true;
            } else {
                bl = false;
            }
        } else {
            Integer n = $this$isKeyClicked;
            pressedKeys.put(n, false);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String getKeyName(int keyCode) {
        String string2 = KeybindHelper.getKeyName(keyCode);
        Intrinsics.checkNotNullExpressionValue(string2, "getKeyName(...)");
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0012\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0016\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0018\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\u00a8\u0006\u0019"}, d2={"Lat/hannibal2/skyhanni/utils/KeyboardManager$WasdInputMatrix;", "", "Lnet/minecraft/client/settings/KeyBinding;", "<init>", "()V", "keyBinding", "", "contains", "(Lnet/minecraft/client/settings/KeyBinding;)Z", "", "iterator", "()Ljava/util/Iterator;", "getW", "()Lnet/minecraft/client/settings/KeyBinding;", "w", "getA", "a", "getS", "s", "getD", "d", "getUp", "up", "getDown", "down", "1.8.9"})
    public static final class WasdInputMatrix
    implements Iterable<KeyBinding>,
    KMappedMarker {
        @NotNull
        public static final WasdInputMatrix INSTANCE = new WasdInputMatrix();

        private WasdInputMatrix() {
        }

        public final boolean contains(@NotNull KeyBinding keyBinding) {
            Intrinsics.checkNotNullParameter(keyBinding, "keyBinding");
            KeyBinding keyBinding2 = keyBinding;
            return Intrinsics.areEqual(keyBinding2, this.getW()) || Intrinsics.areEqual(keyBinding2, this.getA()) || Intrinsics.areEqual(keyBinding2, this.getS()) || Intrinsics.areEqual(keyBinding2, this.getD()) || Intrinsics.areEqual(keyBinding2, this.getUp()) || Intrinsics.areEqual(keyBinding2, this.getDown());
        }

        @NotNull
        public final KeyBinding getW() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74351_w;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @NotNull
        public final KeyBinding getA() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74370_x;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @NotNull
        public final KeyBinding getS() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74368_y;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @NotNull
        public final KeyBinding getD() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74366_z;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @NotNull
        public final KeyBinding getUp() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74314_A;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @NotNull
        public final KeyBinding getDown() {
            KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74311_E;
            Intrinsics.checkNotNull(keyBinding);
            return keyBinding;
        }

        @Override
        @NotNull
        public Iterator<KeyBinding> iterator() {
            return new Iterator<KeyBinding>(){
                private KeyBinding current;
                {
                    this.current = WasdInputMatrix.INSTANCE.getW();
                }

                public final KeyBinding getCurrent() {
                    return this.current;
                }

                public final void setCurrent(KeyBinding keyBinding) {
                    Intrinsics.checkNotNullParameter(keyBinding, "<set-?>");
                    this.current = keyBinding;
                }

                public boolean hasNext() {
                    return !Intrinsics.areEqual(this.current, WasdInputMatrix.INSTANCE.getDown());
                }

                public KeyBinding next() {
                    KeyBinding keyBinding;
                    KeyBinding keyBinding2;
                    KeyBinding it = keyBinding2 = this.current;
                    boolean bl = false;
                    KeyBinding keyBinding3 = it;
                    if (Intrinsics.areEqual(keyBinding3, WasdInputMatrix.INSTANCE.getW())) {
                        keyBinding = WasdInputMatrix.INSTANCE.getA();
                    } else if (Intrinsics.areEqual(keyBinding3, WasdInputMatrix.INSTANCE.getA())) {
                        keyBinding = WasdInputMatrix.INSTANCE.getS();
                    } else if (Intrinsics.areEqual(keyBinding3, WasdInputMatrix.INSTANCE.getS())) {
                        keyBinding = WasdInputMatrix.INSTANCE.getD();
                    } else if (Intrinsics.areEqual(keyBinding3, WasdInputMatrix.INSTANCE.getD())) {
                        keyBinding = WasdInputMatrix.INSTANCE.getUp();
                    } else if (Intrinsics.areEqual(keyBinding3, WasdInputMatrix.INSTANCE.getUp())) {
                        keyBinding = WasdInputMatrix.INSTANCE.getDown();
                    } else {
                        throw new IndexOutOfBoundsException();
                    }
                    this.current = keyBinding;
                    return keyBinding2;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }
    }
}

