/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test.graph;

import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.dev.GraphConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.model.GraphNodeTag;
import at.hannibal2.skyhanni.data.model.TextInput;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.test.graph.GraphEditor;
import at.hannibal2.skyhanni.test.graph.GraphingNode;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.ScrollValue;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\tH\u0002\u00a2\u0006\u0004\b!\u0010\fJ'\u0010#\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u0019\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010)R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00101\u001a\u0002008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020\u000f038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u0010/R\u001c\u00109\u001a\n 6*\u0004\u0018\u000105058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006:"}, d2={"Lat/hannibal2/skyhanni/test/graph/GraphNodeEditor;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "event", "", "onGuiRender", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "getNodeNames", "()Ljava/util/List;", "updateNodeNames", "updateToggleTags", "Lat/hannibal2/skyhanni/data/model/GraphNodeTag;", "tag", "toggleTag", "(Lat/hannibal2/skyhanni/data/model/GraphNodeTag;)V", "Lat/hannibal2/skyhanni/test/graph/GraphingNode;", "node", "updateTagView", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;)V", "drawTagNames", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Ljava/util/List;", "", "checkIsland", "(Lat/hannibal2/skyhanni/data/model/GraphNodeTag;)Z", "", "name", "createTagName", "(Ljava/lang/String;Lat/hannibal2/skyhanni/data/model/GraphNodeTag;Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawNodeNames", "text", "createNodeTextLine", "(Ljava/lang/String;Ljava/lang/String;Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;", "scrollValueNodes", "Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;", "scrollValueTags", "Lat/hannibal2/skyhanni/data/model/TextInput;", "textInput", "Lat/hannibal2/skyhanni/data/model/TextInput;", "nodesDisplay", "Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastUpdate", "J", "", "tagsToShow", "Lat/hannibal2/skyhanni/config/features/dev/GraphConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dev/GraphConfig;", "config", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGraphNodeEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphNodeEditor.kt\nat/hannibal2/skyhanni/test/graph/GraphNodeEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,239:1\n1782#2,4:240\n1782#2,4:244\n1782#2,4:248\n774#2:252\n865#2,2:253\n1557#2:255\n1628#2,3:256\n1053#2:259\n1755#2,3:260\n1#3:263\n*S KotlinDebug\n*F\n+ 1 GraphNodeEditor.kt\nat/hannibal2/skyhanni/test/graph/GraphNodeEditor\n*L\n56#1:240,4\n80#1:244,4\n85#1:248,4\n138#1:252\n138#1:253,2\n182#1:255\n182#1:256,3\n182#1:259\n184#1:260,3\n*E\n"})
public final class GraphNodeEditor {
    @NotNull
    public static final GraphNodeEditor INSTANCE = new GraphNodeEditor();
    @NotNull
    private static final ScrollValue scrollValueNodes = new ScrollValue();
    @NotNull
    private static final ScrollValue scrollValueTags = new ScrollValue();
    @NotNull
    private static final TextInput textInput = new TextInput();
    @NotNull
    private static List<? extends Renderable> nodesDisplay = CollectionsKt.emptyList();
    private static long lastUpdate = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final List<GraphNodeTag> tagsToShow = CollectionsKt.toMutableList((Collection)GraphNodeTag.getEntries());

    private GraphNodeEditor() {
    }

    @SubscribeEvent
    public final void onGuiRender(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Position position = this.getConfig().namedNodesList;
        Intrinsics.checkNotNullExpressionValue(position, "namedNodesList");
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, this.getNodeNames(), 0, "Graph Nodes List", false, 10, null);
    }

    private final List<Renderable> getNodeNames() {
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastUpdate), DurationKt.toDuration(250, DurationUnit.MILLISECONDS)) > 0) {
            this.updateNodeNames();
        }
        return nodesDisplay;
    }

    private final void updateNodeNames() {
        int n;
        List<Renderable> list;
        lastUpdate = SimpleTimeMark.Companion.now-uFjCsEo();
        List<Renderable> $this$updateNodeNames_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List<Searchable> list2 = INSTANCE.drawNodeNames();
        Iterable $this$count$iv = GraphEditor.INSTANCE.getNodes();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                GraphingNode it = (GraphingNode)element$iv;
                boolean bl2 = false;
                String string2 = it.getName();
                boolean bl3 = string2 != null ? !StringsKt.isBlank(string2) : false;
                if (!bl3 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int total = n;
        int shown = list2.size();
        $this$updateNodeNames_u24lambda_u242.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7eGraph Nodes: " + shown + '/' + total, CollectionsKt.listOf("\u00a7eClick to toggle node tags!"), false, GraphNodeEditor::updateNodeNames$lambda$2$lambda$1, null, 20, null));
        int height = RangesKt.coerceAtMost(shown * 10, 250);
        if (!((Collection)list2).isEmpty()) {
            $this$updateNodeNames_u24lambda_u242.add(SearchableKt.buildSearchableScrollable(list2, height, textInput, scrollValueNodes, 10.0));
        }
        nodesDisplay = CollectionsKt.build(list);
    }

    private final void updateToggleTags() {
        List<Renderable> list;
        lastUpdate = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration(60, DurationUnit.SECONDS));
        List<Renderable> $this$updateToggleTags_u24lambda_u247 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$updateToggleTags_u24lambda_u247, "\u00a7eToggle Visible Tags", null, null, 6, null);
        Map map2 = new LinkedHashMap();
        for (GraphNodeTag tag : GraphNodeTag.getEntries()) {
            int n;
            Iterable $this$count$iv = GraphEditor.INSTANCE.getNodes();
            boolean $i$f$count22 = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    GraphingNode it = (GraphingNode)element$iv;
                    boolean bl2 = false;
                    if (!it.getTags().contains((Object)tag) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int nodes = n;
            Integer $i$f$count22 = nodes;
            map2.put(tag, $i$f$count22);
        }
        for (GraphNodeTag tag : CollectionUtils.INSTANCE.sortedDesc(map2).keySet()) {
            int n;
            boolean isVisible = tagsToShow.contains((Object)tag);
            Iterable $this$count$iv = GraphEditor.INSTANCE.getNodes();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    GraphingNode it = (GraphingNode)element$iv;
                    boolean bl3 = false;
                    if (!it.getTags().contains((Object)tag) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int nodes = n;
            String visibilityText = isVisible ? " \u00a7aVisible" : " \u00a77Invisible";
            String name2 = " - " + tag.getDisplayName() + " \u00a78(" + nodes + " nodes) " + visibilityText;
            $this$updateToggleTags_u24lambda_u247.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, name2, CollectionsKt.listOf("\u00a7eClick to " + (isVisible ? "hide" : "show") + " nodes with this tag!"), false, () -> GraphNodeEditor.updateToggleTags$lambda$7$lambda$5(tag), null, 20, null));
        }
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$updateToggleTags_u24lambda_u247, "", null, null, 6, null);
        $this$updateToggleTags_u24lambda_u247.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7cGo Back!", CollectionsKt.listOf("\u00a7eClick to go back to the node list!"), false, GraphNodeEditor::updateToggleTags$lambda$7$lambda$6, null, 20, null));
        nodesDisplay = CollectionsKt.build(list);
    }

    private final void toggleTag(GraphNodeTag tag) {
        boolean bl = tagsToShow.contains((Object)tag) ? tagsToShow.remove((Object)tag) : tagsToShow.add(tag);
    }

    private final void updateTagView(GraphingNode node) {
        List<Renderable> list;
        lastUpdate = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration(60, DurationUnit.SECONDS));
        List<Renderable> $this$updateTagView_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List<Renderable> list2 = INSTANCE.drawTagNames(node);
        int size = list2.size();
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$updateTagView_u24lambda_u248, "\u00a7eGraph Nodes: " + size, null, null, 6, null);
        int height = RangesKt.coerceAtMost(size * 10, 250);
        if (!((Collection)list2).isEmpty()) {
            $this$updateTagView_u24lambda_u248.add(Renderable.Companion.scrollList$default(Renderable.Companion, list2, height, scrollValueTags, 10.0, null, false, null, null, 240, null));
        }
        nodesDisplay = CollectionsKt.build(list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Renderable> drawTagNames(GraphingNode node) {
        void $this$filterTo$iv$iv;
        List<Renderable> list;
        List<Renderable> $this$drawTagNames_u24lambda_u2411 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$drawTagNames_u24lambda_u2411, "\u00a7eChange tag for node '" + node.getName() + "\u00a7e'", null, null, 6, null);
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$drawTagNames_u24lambda_u2411, "", null, null, 6, null);
        Iterable $this$filter$iv = GraphNodeTag.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GraphNodeTag it = (GraphNodeTag)((Object)element$iv$iv);
            boolean bl2 = false;
            if (!(node.getTags().contains((Object)it) || INSTANCE.checkIsland(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (GraphNodeTag tag : (List)destination$iv$iv) {
            String state = node.getTags().contains((Object)tag) ? "\u00a7aYES" : "\u00a7cNO";
            String name2 = state + " \u00a7r" + tag.getDisplayName();
            $this$drawTagNames_u24lambda_u2411.add(INSTANCE.createTagName(name2, tag, node));
        }
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$drawTagNames_u24lambda_u2411, "", null, null, 6, null);
        $this$drawTagNames_u24lambda_u2411.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7cGo Back!", CollectionsKt.listOf("\u00a7eClick to go back to the node list!"), false, GraphNodeEditor::drawTagNames$lambda$11$lambda$10, null, 20, null));
        return CollectionsKt.build(list);
    }

    private final boolean checkIsland(GraphNodeTag tag) {
        boolean bl;
        IslandType islandType = tag.getOnlyIsland();
        if (islandType != null) {
            IslandType it = islandType;
            boolean bl2 = false;
            bl = it == LorenzUtils.INSTANCE.getSkyBlockIsland();
        } else {
            bl = true;
        }
        return bl;
    }

    private final Renderable createTagName(String name2, GraphNodeTag tag, GraphingNode node) {
        String[] stringArray = new String[]{"Tag " + tag.name(), "\u00a77" + tag.getDescription(), "", "\u00a7eClick to set tag for " + node.getName() + " to " + tag.name() + '!'};
        return Renderable.Companion.clickAndHover$default(Renderable.Companion, name2, CollectionsKt.listOf(stringArray), false, () -> GraphNodeEditor.createTagName$lambda$13(node, tag), null, 20, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Searchable> drawNodeNames() {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        List<Searchable> list;
        List<Searchable> $this$drawNodeNames_u24lambda_u2420 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$map$iv = GraphEditor.INSTANCE.getNodes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GraphingNode graphingNode = (GraphingNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TuplesKt.to(it, GraphEditor.INSTANCE.distanceSqToPlayer(it.getPosition())));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        for (Pair pair : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getSecond()));
            }
        })) {
            String string2;
            String string3;
            Object it;
            String element$iv22;
            GraphingNode node = (GraphingNode)pair.component1();
            double distance = ((Number)pair.component2()).doubleValue();
            if (!((Collection)node.getTags()).isEmpty()) {
                boolean bl2;
                block9: {
                    Iterable $this$any$iv = node.getTags();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (String element$iv22 : $this$any$iv) {
                            it = (GraphNodeTag)((Object)element$iv22);
                            boolean bl4 = false;
                            if (!tagsToShow.contains(it)) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
            }
            if ((string3 = node.getName()) == null) continue;
            it = element$iv22 = string3;
            boolean bl5 = false;
            string3 = !StringsKt.isBlank(it) ? element$iv22 : null;
            if (string3 == null) {
                continue;
            }
            String name2 = string3;
            String color = Intrinsics.areEqual(node, GraphEditor.INSTANCE.getActiveNode()) ? "\u00a7a" : "\u00a77";
            String distanceFormat = NumberUtil.INSTANCE.addSeparators((int)Math.sqrt(distance));
            List<GraphNodeTag> tags = node.getTags();
            boolean bl6 = false;
            if (tags.isEmpty()) {
                string2 = " \u00a7cNo tag\u00a7r";
            } else {
                String text = CollectionsKt.joinToString$default(node.getTags(), ", ", null, null, 0, null, GraphNodeEditor::drawNodeNames$lambda$20$lambda$19$lambda$18, 30, null);
                string2 = " \u00a7f(" + text + ')';
            }
            String tagText = string2;
            String text = color + "Node \u00a7r" + name2 + tagText + " \u00a77[" + distanceFormat + ']';
            $this$drawNodeNames_u24lambda_u2420.add(INSTANCE.createNodeTextLine(text, name2, node));
        }
        return CollectionsKt.build(list);
    }

    /*
     * WARNING - void declaration
     */
    private final Searchable createNodeTextLine(String text, String name2, GraphingNode node) {
        void $this$createNodeTextLine_u24lambda_u2421;
        List list;
        List list2 = list = CollectionsKt.createListBuilder();
        String string2 = text;
        Renderable.Companion companion = Renderable.Companion;
        boolean bl = false;
        $this$createNodeTextLine_u24lambda_u2421.add("Node '" + name2 + '\'');
        $this$createNodeTextLine_u24lambda_u2421.add("");
        if (!((Collection)node.getTags()).isEmpty()) {
            $this$createNodeTextLine_u24lambda_u2421.add("Tags: ");
            for (GraphNodeTag tag : node.getTags()) {
                $this$createNodeTextLine_u24lambda_u2421.add(" \u00a78- \u00a7r" + tag.getDisplayName());
            }
            $this$createNodeTextLine_u24lambda_u2421.add("");
        }
        $this$createNodeTextLine_u24lambda_u2421.add("\u00a7eClick to select/deselect this node!");
        $this$createNodeTextLine_u24lambda_u2421.add("\u00a7eControl-Click to edit the tags for this node!");
        Unit unit = Unit.INSTANCE;
        return SearchableKt.toSearchable(Renderable.Companion.clickAndHover$default(companion, string2, CollectionsKt.build(list), false, () -> GraphNodeEditor.createNodeTextLine$lambda$22(node), null, 20, null), name2);
    }

    public final boolean isEnabled() {
        return GraphEditor.INSTANCE.isEnabled();
    }

    private final GraphConfig getConfig() {
        return GraphEditor.INSTANCE.getConfig();
    }

    private static final Unit updateNodeNames$lambda$2$lambda$1() {
        INSTANCE.updateToggleTags();
        return Unit.INSTANCE;
    }

    private static final Unit updateToggleTags$lambda$7$lambda$5(GraphNodeTag $tag) {
        Intrinsics.checkNotNullParameter((Object)$tag, "$tag");
        INSTANCE.toggleTag($tag);
        INSTANCE.updateToggleTags();
        return Unit.INSTANCE;
    }

    private static final Unit updateToggleTags$lambda$7$lambda$6() {
        INSTANCE.updateNodeNames();
        return Unit.INSTANCE;
    }

    private static final Unit drawTagNames$lambda$11$lambda$10() {
        INSTANCE.updateNodeNames();
        return Unit.INSTANCE;
    }

    private static final Unit createTagName$lambda$13(GraphingNode $node, GraphNodeTag $tag) {
        Intrinsics.checkNotNullParameter($node, "$node");
        Intrinsics.checkNotNullParameter((Object)$tag, "$tag");
        boolean bl = $node.getTags().contains((Object)$tag) ? $node.getTags().remove((Object)$tag) : $node.getTags().add($tag);
        INSTANCE.updateTagView($node);
        return Unit.INSTANCE;
    }

    private static final CharSequence drawNodeNames$lambda$20$lambda$19$lambda$18(GraphNodeTag it) {
        Intrinsics.checkNotNullParameter((Object)it, "it");
        return it.getInternalName();
    }

    private static final Unit createNodeTextLine$lambda$22(GraphingNode $node) {
        Intrinsics.checkNotNullParameter($node, "$node");
        if (KeyboardManager.INSTANCE.isModifierKeyDown()) {
            INSTANCE.updateTagView($node);
        } else {
            GraphEditor.INSTANCE.setActiveNode($node);
            INSTANCE.updateNodeNames();
        }
        return Unit.INSTANCE;
    }
}

