/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test.graph;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.dev.GraphConfig;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.model.Graph;
import at.hannibal2.skyhanni.data.model.GraphKt;
import at.hannibal2.skyhanni.data.model.GraphNode;
import at.hannibal2.skyhanni.data.model.GraphNodeTag;
import at.hannibal2.skyhanni.data.model.TextInput;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.test.graph.GraphEditorBugFinder;
import at.hannibal2.skyhanni.test.graph.GraphingEdge;
import at.hannibal2.skyhanni.test.graph.GraphingNode;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.RaycastUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0011\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0017\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010 \u001a\u00020\t*\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u001b\u0010#\u001a\u00020\t*\u00020\u00072\u0006\u0010\"\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0013\u0010&\u001a\u00020%*\u00020\u001eH\u0002\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020\t\u00a2\u0006\u0004\b(\u0010\u0003J\u000f\u0010)\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b)\u0010\u0003J\u000f\u0010*\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b*\u0010\u0003J\u000f\u0010+\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b+\u0010\u0003J\u000f\u0010,\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b,\u0010\u0003J\u001b\u00100\u001a\u00020\t*\u00020-2\u0006\u0010/\u001a\u00020.H\u0002\u00a2\u0006\u0004\b0\u00101J#\u00105\u001a\u00020\t2\u0006\u00102\u001a\u00020-2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000403\u00a2\u0006\u0004\b5\u00106J\u000f\u00107\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b7\u0010\u0003J\r\u00108\u001a\u00020\t\u00a2\u0006\u0004\b8\u0010\u0003J%\u0010<\u001a\u0004\u0018\u00010;2\b\u00109\u001a\u0004\u0018\u00010\u001e2\b\u0010:\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0004\b<\u0010=J#\u0010>\u001a\u00020\u00042\b\u00109\u001a\u0004\u0018\u00010\u001e2\b\u0010:\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0004\b>\u0010?J\u000f\u0010B\u001a\u00020@H\u0002\u00a2\u0006\u0004\bA\u0010\u0013J\u0015\u0010F\u001a\u00020\t2\u0006\u0010C\u001a\u00020@\u00a2\u0006\u0004\bD\u0010EJ\u000f\u0010G\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bG\u0010\u0003J\u000f\u0010H\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bH\u0010\u0003J\u000f\u0010I\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bI\u0010\u0003J\u0011\u0010K\u001a\u00020J*\u00020.\u00a2\u0006\u0004\bK\u0010LR\u0019\u0010Q\u001a\n N*\u0004\u0018\u00010M0M8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u0016\u0010R\u001a\u00020;8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010SR\u001d\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001e0T8\u0006\u00a2\u0006\f\n\u0004\bU\u0010V\u001a\u0004\bW\u0010\u0013R\u001a\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00140T8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bX\u0010VR.\u0010Z\u001a\u0004\u0018\u00010\u001e2\b\u0010Y\u001a\u0004\u0018\u00010\u001e8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bZ\u0010[\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_R(\u0010`\u001a\u0004\u0018\u00010\u001e2\b\u0010Y\u001a\u0004\u0018\u00010\u001e8\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\b`\u0010[\"\u0004\ba\u0010_R\u0018\u0010b\u001a\u0004\u0018\u00010\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bb\u0010cR\u0018\u0010d\u001a\u0004\u0018\u00010.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bd\u0010eR\u0016\u0010f\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010gR\u0016\u0010h\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010gR$\u0010i\u001a\u00020\u00042\u0006\u0010Y\u001a\u00020\u00048\u0002@BX\u0082\u000e\u00a2\u0006\f\n\u0004\bi\u0010g\"\u0004\bj\u0010kR\u0016\u0010l\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bl\u0010gR\u0014\u0010n\u001a\u00020m8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bn\u0010oR\u0014\u0010p\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bp\u0010qR\u0014\u0010r\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\br\u0010qR\u0014\u0010s\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bs\u0010qR\u0014\u0010t\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bt\u0010qR\u0014\u0010u\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bu\u0010qR\u0014\u0010v\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bv\u0010qR\u0014\u0010w\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bw\u0010qR\u0016\u0010x\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bx\u0010gR\u001a\u0010z\u001a\b\u0012\u0004\u0012\u00020\u001e0y8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bz\u0010{R\u001a\u0010|\u001a\b\u0012\u0004\u0012\u00020\u00140y8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b|\u0010{\u00a8\u0006}"}, d2={"Lat/hannibal2/skyhanni/test/graph/GraphEditor;", "", "<init>", "()V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "event", "", "onRender", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "drawGhostPosition", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "", "buildDisplay", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/test/graph/GraphingEdge;", "findEdgeBetweenActiveAndClosed", "()Lat/hannibal2/skyhanni/test/graph/GraphingEdge;", "checkDissolve", "text", "feedBackInTutorial", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/test/graph/GraphingNode;", "node", "drawNode", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;Lat/hannibal2/skyhanni/test/graph/GraphingNode;)V", "edge", "drawEdge", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;Lat/hannibal2/skyhanni/test/graph/GraphingEdge;)V", "Ljava/awt/Color;", "getNodeColor", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Ljava/awt/Color;", "commandIn", "chatAtDisable", "input", "save", "editModeClicks", "Lnet/minecraft/client/settings/KeyBinding;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "vector", "handleEditClicks", "(Lnet/minecraft/client/settings/KeyBinding;Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "keyBinding", "Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;", "cir", "onMinecraftInput", "(Lnet/minecraft/client/settings/KeyBinding;Lorg/spongepowered/asm/mixin/injection/callback/CallbackInfoReturnable;)V", "addNode", "toggleGhostPosition", "node1", "node2", "", "getEdgeIndex", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Ljava/lang/Integer;", "addEdge", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Z", "Lat/hannibal2/skyhanni/data/model/Graph;", "compileGraph-rIAQGNA", "compileGraph", "graph", "import-0y7Y464", "(Ljava/util/List;)V", "import", "testDijkstra", "clear", "prune", "", "distanceSqToPlayer", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)D", "Lat/hannibal2/skyhanni/config/features/dev/GraphConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dev/GraphConfig;", "config", "id", "I", "", "nodes", "Ljava/util/List;", "getNodes", "edges", "value", "activeNode", "Lat/hannibal2/skyhanni/test/graph/GraphingNode;", "getActiveNode", "()Lat/hannibal2/skyhanni/test/graph/GraphingNode;", "setActiveNode", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;)V", "closedNode", "setClosedNode", "selectedEdge", "Lat/hannibal2/skyhanni/test/graph/GraphingEdge;", "ghostPosition", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "seeThroughBlocks", "Z", "inEditMode", "inTextMode", "setInTextMode", "(Z)V", "inTutorialMode", "Lat/hannibal2/skyhanni/data/model/TextInput;", "textBox", "Lat/hannibal2/skyhanni/data/model/TextInput;", "nodeColor", "Ljava/awt/Color;", "activeColor", "closedColor", "dijkstraColor", "edgeColor", "edgeDijkstraColor", "edgeSelectedColor", "dissolvePossible", "", "highlightedNodes", "Ljava/util/Set;", "highlightedEdges", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGraphEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphEditor.kt\nat/hannibal2/skyhanni/test/graph/GraphEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,667:1\n1863#2,2:668\n1863#2,2:670\n1782#2,4:673\n2318#2,14:677\n1557#2:691\n1628#2,3:692\n774#2:695\n865#2,2:696\n1782#2,4:698\n1755#2,3:702\n360#2,7:705\n1567#2:712\n1598#2,4:713\n1567#2:717\n1598#2,3:718\n1611#2,9:721\n1863#2:730\n1864#2:732\n1620#2:733\n1601#2:734\n1557#2:735\n1628#2,2:736\n774#2:738\n865#2,2:739\n1557#2:741\n1628#2,3:742\n1053#2:745\n1630#2:746\n1872#2,3:747\n1557#2:750\n1628#2,2:751\n1611#2,9:753\n1863#2:762\n1864#2:764\n1620#2:765\n1630#2:766\n1567#2:767\n1598#2,4:768\n1557#2:772\n1628#2,2:773\n1630#2:779\n295#2,2:780\n295#2,2:782\n1557#2:784\n1628#2,3:785\n774#2:788\n865#2,2:789\n1279#2,2:791\n1293#2,4:793\n1863#2,2:797\n1#3:672\n1#3:731\n1#3:763\n126#4:775\n153#4,3:776\n*S KotlinDebug\n*F\n+ 1 GraphEditor.kt\nat/hannibal2/skyhanni/test/graph/GraphEditor\n*L\n102#1:668,2\n103#1:670,2\n179#1:673,4\n193#1:677,14\n220#1:691\n220#1:692,3\n414#1:695\n414#1:696,2\n443#1:698,4\n493#1:702,3\n518#1:705,7\n533#1:712\n533#1:713,4\n534#1:717\n534#1:718,3\n534#1:721,9\n534#1:730\n534#1:732\n534#1:733\n534#1:734\n535#1:735\n535#1:736,2\n536#1:738\n536#1:739,2\n536#1:741\n536#1:742,3\n539#1:745\n535#1:746\n541#1:747,3\n548#1:750\n548#1:751,2\n553#1:753,9\n553#1:762\n553#1:764\n553#1:765\n548#1:766\n557#1:767\n557#1:768,4\n559#1:772\n559#1:773,2\n559#1:779\n581#1:780,2\n582#1:782,2\n586#1:784\n586#1:785,3\n589#1:788\n589#1:789,2\n604#1:791,2\n604#1:793,4\n605#1:797,2\n534#1:731\n553#1:763\n560#1:775\n560#1:776,3\n*E\n"})
public final class GraphEditor {
    @NotNull
    public static final GraphEditor INSTANCE = new GraphEditor();
    private static int id;
    @NotNull
    private static final List<GraphingNode> nodes;
    @NotNull
    private static final List<GraphingEdge> edges;
    @Nullable
    private static GraphingNode activeNode;
    @Nullable
    private static GraphingNode closedNode;
    @Nullable
    private static GraphingEdge selectedEdge;
    @Nullable
    private static LorenzVec ghostPosition;
    private static boolean seeThroughBlocks;
    private static boolean inEditMode;
    private static boolean inTextMode;
    private static boolean inTutorialMode;
    @NotNull
    private static final TextInput textBox;
    @NotNull
    private static final Color nodeColor;
    @NotNull
    private static final Color activeColor;
    @NotNull
    private static final Color closedColor;
    @NotNull
    private static final Color dijkstraColor;
    @NotNull
    private static final Color edgeColor;
    @NotNull
    private static final Color edgeDijkstraColor;
    @NotNull
    private static final Color edgeSelectedColor;
    private static boolean dissolvePossible;
    @NotNull
    private static final Set<GraphingNode> highlightedNodes;
    @NotNull
    private static final Set<GraphingEdge> highlightedEdges;

    private GraphEditor() {
    }

    public final GraphConfig getConfig() {
        return SkyHanniMod.feature.dev.devTool.graph;
    }

    public final boolean isEnabled() {
        return this.getConfig() != null && this.getConfig().enabled;
    }

    @NotNull
    public final List<GraphingNode> getNodes() {
        return nodes;
    }

    @Nullable
    public final GraphingNode getActiveNode() {
        return activeNode;
    }

    public final void setActiveNode(@Nullable GraphingNode value) {
        activeNode = value;
        selectedEdge = this.findEdgeBetweenActiveAndClosed();
        this.checkDissolve();
    }

    private final void setClosedNode(GraphingNode value) {
        closedNode = value;
        selectedEdge = this.findEdgeBetweenActiveAndClosed();
    }

    private final void setInTextMode(boolean value) {
        inTextMode = value;
        if (value) {
            Object object = activeNode;
            if (object != null && (object = ((GraphingNode)object).getName()) != null) {
                Object it = object;
                boolean bl = false;
                textBox.setTextBox((String)it);
            }
            textBox.makeActive();
        } else {
            textBox.clear();
            textBox.disable();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void onRender(@NotNull LorenzRenderWorldEvent event) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GraphingNode)element$iv;
            boolean bl = false;
            INSTANCE.drawNode(event, (GraphingNode)it);
        }
        $this$forEach$iv = edges;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GraphingEdge)element$iv;
            boolean bl = false;
            INSTANCE.drawEdge(event, (GraphingEdge)it);
        }
        this.drawGhostPosition(event);
    }

    private final void drawGhostPosition(LorenzRenderWorldEvent event) {
        LorenzVec lorenzVec = ghostPosition;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec ghostPosition = lorenzVec;
        if (LocationUtils.INSTANCE.distanceToPlayer(ghostPosition) >= (double)this.getConfig().maxNodeDistance) {
            return;
        }
        Color color = activeNode == null ? Color.RED : Color.GRAY;
        Intrinsics.checkNotNull(color);
        RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, ghostPosition, color, seeThroughBlocks, false, 0.0, 0.0, 0.0, 0.2f, true, 120, null);
    }

    @SubscribeEvent
    public final void onOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Position position = this.getConfig().infoDisplay;
        Intrinsics.checkNotNullExpressionValue(position, "infoDisplay");
        RenderUtils.renderStrings$default(RenderUtils.INSTANCE, position, this.buildDisplay(), 0, "Graph Info", 2, null);
    }

    private final List<String> buildDisplay() {
        List<String> list;
        List<String> $this$buildDisplay_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$buildDisplay_u24lambda_u243.add("\u00a7eExit: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().exitKey));
        if (!inEditMode && !inTextMode) {
            $this$buildDisplay_u24lambda_u243.add("\u00a7ePlace: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().placeKey));
            $this$buildDisplay_u24lambda_u243.add("\u00a7eSelect: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().selectKey));
            $this$buildDisplay_u24lambda_u243.add("\u00a7eSelect (Look): \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().selectRaycastKey));
            $this$buildDisplay_u24lambda_u243.add("\u00a7eConnect: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().connectKey));
            $this$buildDisplay_u24lambda_u243.add("\u00a7eTest: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().dijkstraKey));
            $this$buildDisplay_u24lambda_u243.add("\u00a7eVision: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().throughBlocksKey));
            $this$buildDisplay_u24lambda_u243.add("\u00a7eSave: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().saveKey));
            $this$buildDisplay_u24lambda_u243.add("\u00a7eLoad: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().loadKey));
            $this$buildDisplay_u24lambda_u243.add("\u00a7eClear: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().clearKey));
            $this$buildDisplay_u24lambda_u243.add("\u00a7eTutorial: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().tutorialKey));
            $this$buildDisplay_u24lambda_u243.add("\u00a7eToggle Ghost Position: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().toggleGhostPosition));
            $this$buildDisplay_u24lambda_u243.add(" ");
            if (activeNode != null) {
                $this$buildDisplay_u24lambda_u243.add("\u00a7eText: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().textKey));
                if (dissolvePossible) {
                    $this$buildDisplay_u24lambda_u243.add("\u00a7eDissolve: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().dissolveKey));
                }
                if (selectedEdge != null) {
                    $this$buildDisplay_u24lambda_u243.add("\u00a7eSplit: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().splitKey));
                }
            }
        }
        if (!inTextMode) {
            if (activeNode != null) {
                $this$buildDisplay_u24lambda_u243.add("\u00a7eEdit active node: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().editKey));
            } else if (ghostPosition != null) {
                $this$buildDisplay_u24lambda_u243.add("Edit Ghost Position: \u00a76" + KeyboardManager.INSTANCE.getKeyName(GraphEditor.INSTANCE.getConfig().editKey));
            }
        }
        if (inEditMode) {
            $this$buildDisplay_u24lambda_u243.add("\u00a7ex+ \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getW().func_151463_i()));
            $this$buildDisplay_u24lambda_u243.add("\u00a7ex- \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getS().func_151463_i()));
            $this$buildDisplay_u24lambda_u243.add("\u00a7ez+ \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getA().func_151463_i()));
            $this$buildDisplay_u24lambda_u243.add("\u00a7ez- \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getD().func_151463_i()));
            $this$buildDisplay_u24lambda_u243.add("\u00a7ey+ \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getUp().func_151463_i()));
            $this$buildDisplay_u24lambda_u243.add("\u00a7ey- \u00a76" + KeyboardManager.INSTANCE.getKeyName(KeyboardManager.WasdInputMatrix.INSTANCE.getDown().func_151463_i()));
        }
        if (inTextMode) {
            $this$buildDisplay_u24lambda_u243.add("\u00a7eFormat: " + textBox.finalText());
            $this$buildDisplay_u24lambda_u243.add("\u00a7eRaw:     " + TextInput.editText$default(textBox, LorenzColor.YELLOW, null, 2, null));
        }
        return CollectionsKt.build(list);
    }

    private final GraphingEdge findEdgeBetweenActiveAndClosed() {
        GraphingEdge graphingEdge;
        Integer n = this.getEdgeIndex(activeNode, closedNode);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            graphingEdge = edges.get(it);
        } else {
            graphingEdge = null;
        }
        return graphingEdge;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDissolve() {
        int n;
        if (activeNode == null) {
            dissolvePossible = false;
            return;
        }
        Iterable $this$count$iv = edges;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                GraphingEdge it = (GraphingEdge)element$iv;
                boolean bl = false;
                if (!it.isInEdge(activeNode) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        dissolvePossible = n == 2;
    }

    private final void feedBackInTutorial(String text) {
        if (inTutorialMode) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, text, false, null, 6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Object t;
        void $this$minBy$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        this.input();
        if (nodes.isEmpty()) {
            return;
        }
        Iterable iterable = nodes;
        GraphEditor graphEditor = this;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = minElem$iv;
        } else {
            GraphingNode it = (GraphingNode)minElem$iv;
            boolean bl = false;
            double minValue$iv = INSTANCE.distanceSqToPlayer(it.getPosition());
            do {
                Object e$iv = iterator$iv.next();
                GraphingNode it2 = (GraphingNode)e$iv;
                $i$a$-minByOrThrow-GraphEditor$onTick$1 = false;
                double v$iv = INSTANCE.distanceSqToPlayer(it2.getPosition());
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = minElem$iv;
        }
        graphEditor.setClosedNode((GraphingNode)t);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawNode(LorenzRenderWorldEvent $this$drawNode, GraphingNode node) {
        void $this$mapTo$iv$iv;
        if (LocationUtils.INSTANCE.distanceToPlayer(node.getPosition()) > (double)this.getConfig().maxNodeDistance) {
            return;
        }
        RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, $this$drawNode, node.getPosition(), this.getNodeColor(node), seeThroughBlocks, false, 0.0, 0.0, 0.0, 0.2f, true, 120, null);
        String string2 = node.getName();
        if (string2 == null) {
            return;
        }
        String nodeName = string2;
        RenderUtils renderUtils = RenderUtils.INSTANCE;
        LorenzVec lorenzVec = node.getPosition();
        boolean bl = seeThroughBlocks || this.distanceSqToPlayer(node.getPosition()) < 100.0;
        RenderUtils.drawDynamicText$default(renderUtils, $this$drawNode, lorenzVec, nodeName, 0.8, -15.0f, 0.0, 12.0, bl, true, 80, 16, null);
        List<GraphNodeTag> tags = node.getTags();
        if (tags.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = tags;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GraphNodeTag graphNodeTag = (GraphNodeTag)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getDisplayName());
        }
        String tagText = CollectionsKt.joinToString$default((List)destination$iv$iv, " \u00a7f+ ", null, null, 0, null, null, 62, null);
        RenderUtils renderUtils2 = RenderUtils.INSTANCE;
        LorenzVec lorenzVec2 = node.getPosition();
        boolean bl3 = seeThroughBlocks || this.distanceSqToPlayer(node.getPosition()) < 100.0;
        RenderUtils.drawDynamicText$default(renderUtils2, $this$drawNode, lorenzVec2, tagText, 0.8, 0.0f, 0.0, 12.0, bl3, true, 80, 16, null);
    }

    private final void drawEdge(LorenzRenderWorldEvent $this$drawEdge, GraphingEdge edge) {
        if (LocationUtils.INSTANCE.distanceToPlayer(edge.getNode1().getPosition()) > (double)this.getConfig().maxNodeDistance) {
            return;
        }
        RenderUtils.INSTANCE.draw3DLine_nea($this$drawEdge, edge.getNode1().getPosition().add(0.5, 0.5, 0.5), edge.getNode2().getPosition().add(0.5, 0.5, 0.5), Intrinsics.areEqual(selectedEdge, edge) ? edgeSelectedColor : (highlightedEdges.contains(edge) ? edgeDijkstraColor : edgeColor), 7, !seeThroughBlocks);
    }

    private final Color getNodeColor(GraphingNode $this$getNodeColor) {
        GraphingNode graphingNode = $this$getNodeColor;
        return Intrinsics.areEqual(graphingNode, activeNode) ? (Intrinsics.areEqual($this$getNodeColor, closedNode) ? ColorUtils.INSTANCE.blendRGB(activeColor, closedColor, 0.5) : activeColor) : (Intrinsics.areEqual(graphingNode, closedNode) ? closedColor : (highlightedNodes.contains(graphingNode) ? dijkstraColor : nodeColor));
    }

    public final void commandIn() {
        boolean bl = this.getConfig().enabled = !this.getConfig().enabled;
        if (this.getConfig().enabled) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Graph Editor is now active.", false, null, 6, null);
        } else {
            this.chatAtDisable();
        }
    }

    private final void chatAtDisable() {
        ChatUtils.clickableChat-gdl2klw$default(ChatUtils.INSTANCE, "Graph Editor is now inactive. \u00a7lClick to activate.", new Function0<Unit>((Object)INSTANCE){

            public final void invoke() {
                ((GraphEditor)this.receiver).commandIn();
            }
        }, null, 0L, false, null, false, 124, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void input() {
        Object edge;
        Object minimumNode2;
        if (LorenzUtils.INSTANCE.isAnyGuiActive()) {
            return;
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().exitKey)) {
            if (inTextMode) {
                this.setInTextMode(false);
                this.feedBackInTutorial("Exited Text Mode.");
                return;
            }
            if (inEditMode) {
                inEditMode = false;
                this.feedBackInTutorial("Exited Edit Mode.");
                return;
            }
            this.getConfig().enabled = false;
            this.chatAtDisable();
        }
        if (inTextMode) {
            textBox.handle();
            String text = textBox.finalText();
            if (((CharSequence)text).length() == 0) {
                GraphingNode graphingNode = activeNode;
                if (graphingNode != null) {
                    graphingNode.setName(null);
                }
            } else {
                GraphingNode graphingNode = activeNode;
                if (graphingNode != null) {
                    graphingNode.setName(text);
                }
            }
            return;
        }
        if (activeNode != null && KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().textKey)) {
            this.setInTextMode(true);
            this.feedBackInTutorial("Entered Text Mode.");
            return;
        }
        if (inEditMode) {
            this.editModeClicks();
            inEditMode = false;
        }
        if ((activeNode != null || ghostPosition != null) && KeyboardManager.INSTANCE.isKeyHeld(this.getConfig().editKey)) {
            inEditMode = true;
            return;
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().saveKey)) {
            this.save();
            return;
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().loadKey)) {
            BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            this.label = 1;
                            v0 = OSUtils.INSTANCE.readFromClipboard(this);
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if ((var2_3 = (String)v0) == null) ** GOTO lbl-1000
                            it = var2_3;
                            $i$a$-let-GraphEditor$input$1$1 = false;
                            try {
                                var6_6 = Graph.Companion.fromJson-d5YCfOw((String)it);
                            }
                            catch (Exception e) {
                                var8_8 = new Pair[]{TuplesKt.to("json", it)};
                                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Import of graph failed.", var8_8, true, false, false, 48, null);
                                var6_6 = null;
                            }
                            v1 = var6_6;
                            v2 = v1 != null ? Graph.box-impl(v1) : null;
                            v3 = var3_9 = v2 != null ? v2.unbox-impl() : null;
                            if (var3_9 != null) {
                                it = var3_9;
                                $i$a$-let-GraphEditor$input$1$2 = false;
                                GraphEditor.INSTANCE.import-0y7Y464((List<? extends GraphNode>)it);
                                ChatUtils.chat$default(ChatUtils.INSTANCE, "Loaded Graph from clip board.", false, null, 6, null);
                                v4 = Unit.INSTANCE;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v4 = null;
                            }
                            return v4;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
            return;
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().clearKey)) {
            String json = GraphKt.toJson-0y7Y464(this.compileGraph-rIAQGNA());
            OSUtils.INSTANCE.copyToClipboard(json);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Copied Graph to Clipboard and cleared the graph.", false, null, 6, null);
            this.clear();
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().placeKey)) {
            this.addNode();
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().toggleGhostPosition)) {
            this.toggleGhostPosition();
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().selectKey)) {
            GraphingNode graphingNode;
            if (Intrinsics.areEqual(activeNode, closedNode)) {
                this.feedBackInTutorial("De-selected active node.");
                graphingNode = null;
            } else {
                this.feedBackInTutorial("Selected new active node.");
                graphingNode = closedNode;
            }
            this.setActiveNode(graphingNode);
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().selectRaycastKey)) {
            RaycastUtils.Ray playerRay = RaycastUtils.INSTANCE.createPlayerLookDirectionRay();
            double minimumDistance = Double.MAX_VALUE;
            minimumNode2 = null;
            for (GraphingNode node : nodes) {
                LorenzVec nodeCenterPosition = node.getPosition().add(0.5, 0.5, 0.5);
                double distance = RaycastUtils.INSTANCE.findDistanceToRay(playerRay, nodeCenterPosition);
                if (distance > minimumDistance) continue;
                if (minimumDistance > 1.0) {
                    minimumNode2 = node;
                    minimumDistance = distance;
                    continue;
                }
                if (minimumNode2 != null && !(this.distanceSqToPlayer(((GraphingNode)minimumNode2).getPosition()) > this.distanceSqToPlayer(node.getPosition()))) continue;
                minimumNode2 = node;
                minimumDistance = distance;
            }
            this.setActiveNode((GraphingNode)minimumNode2);
        }
        if (!Intrinsics.areEqual(activeNode, closedNode) && KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().connectKey)) {
            edge = this.getEdgeIndex(activeNode, closedNode);
            if (edge == null) {
                this.addEdge(activeNode, closedNode);
                this.feedBackInTutorial("Added new edge.");
            } else {
                edges.remove((Integer)edge);
                this.checkDissolve();
                selectedEdge = this.findEdgeBetweenActiveAndClosed();
                this.feedBackInTutorial("Removed edge.");
            }
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().throughBlocksKey)) {
            seeThroughBlocks = !seeThroughBlocks;
            this.feedBackInTutorial(seeThroughBlocks ? "Graph is visible though walls." : "Graph is invisible behind walls.");
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().dijkstraKey)) {
            this.feedBackInTutorial("Calculated shortest route and cleared active node.");
            this.testDijkstra();
        }
        if (KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().tutorialKey)) {
            inTutorialMode = !inTutorialMode;
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Tutorial mode is now " + (inTutorialMode ? "active" : "inactive") + '.', false, null, 6, null);
        }
        if (selectedEdge != null && KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().splitKey)) {
            GraphingEdge graphingEdge = selectedEdge;
            if (graphingEdge == null) {
                return;
            }
            edge = graphingEdge;
            this.feedBackInTutorial("Split Edge into a Node and two edges.");
            LorenzVec middle = ((GraphingEdge)edge).getNode1().getPosition().middle(((GraphingEdge)edge).getNode2().getPosition()).roundLocationToBlock();
            int minimumNode2 = id;
            id = minimumNode2 + 1;
            GraphingNode node = new GraphingNode(minimumNode2, middle, null, null, 12, null);
            nodes.add(node);
            edges.remove(edge);
            this.addEdge(node, ((GraphingEdge)edge).getNode1());
            this.addEdge(node, ((GraphingEdge)edge).getNode2());
            this.setActiveNode(node);
        }
        if (dissolvePossible && KeyboardManager.INSTANCE.isKeyClicked(this.getConfig().dissolveKey)) {
            void $this$filterTo$iv$iv;
            this.feedBackInTutorial("Dissolved the node, now it is gone.");
            Iterable $this$filter$iv = edges;
            boolean $i$f$filter = false;
            minimumNode2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GraphingEdge it = (GraphingEdge)element$iv$iv;
                boolean bl = false;
                if (!it.isInEdge(activeNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List edgePair = (List)destination$iv$iv;
            GraphingEdge edge1 = (GraphingEdge)edgePair.get(0);
            GraphingEdge edge2 = (GraphingEdge)edgePair.get(1);
            GraphingNode neighbors1 = Intrinsics.areEqual(edge1.getNode1(), activeNode) ? edge1.getNode2() : edge1.getNode1();
            GraphingNode neighbors2 = Intrinsics.areEqual(edge2.getNode1(), activeNode) ? edge2.getNode2() : edge2.getNode1();
            edges.removeAll(edgePair);
            Collection collection = nodes;
            GraphingNode graphingNode = activeNode;
            TypeIntrinsics.asMutableCollection(collection).remove(graphingNode);
            this.setActiveNode(null);
            this.addEdge(neighbors1, neighbors2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void save() {
        if (nodes.isEmpty()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Copied nothing since the graph is empty.", false, null, 6, null);
            return;
        }
        List<? extends GraphNode> compileGraph = this.compileGraph-rIAQGNA();
        if (this.getConfig().useAsIslandArea) {
            IslandGraphs.INSTANCE.setNewGraph-0y7Y464(compileGraph);
            GraphEditorBugFinder.INSTANCE.runTests();
        }
        String json = GraphKt.toJson-0y7Y464(compileGraph);
        OSUtils.INSTANCE.copyToClipboard(json);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Copied Graph to Clipboard.", false, null, 6, null);
        if (this.getConfig().showsStats) {
            int n;
            void $this$count$iv;
            GraphingNode it;
            double d;
            Iterable iterable = edges;
            Object object = NumberUtil.INSTANCE;
            double d2 = 0.0;
            for (Object t : iterable) {
                GraphingEdge graphingEdge = (GraphingEdge)t;
                d = d2;
                boolean bl = false;
                double d3 = ((GraphingEdge)((Object)it)).getNode1().getPosition().distance(((GraphingEdge)((Object)it)).getNode2().getPosition());
                d2 = d + d3;
            }
            d = d2;
            String length = ((NumberUtil)object).addSeparators((int)d);
            iterable = nodes;
            NumberUtil numberUtil = NumberUtil.INSTANCE;
            StringBuilder stringBuilder = new StringBuilder().append("\u00a7lStats\n\u00a7eNamed Nodes: ");
            object = ChatUtils.INSTANCE;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (GraphingNode)element$iv;
                    boolean bl = false;
                    if (!(it.getName() != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n2 = n;
            ChatUtils.chat$default((ChatUtils)object, stringBuilder.append(numberUtil.addSeparators(n2)).append("\n\u00a7eNodes: ").append(NumberUtil.INSTANCE.addSeparators(nodes.size())).append("\n\u00a7eEdges: ").append(NumberUtil.INSTANCE.addSeparators(edges.size())).append("\n\u00a7eLength: ").append(length).toString(), false, null, 6, null);
        }
    }

    private final void editModeClicks() {
        LorenzVec vector = LocationUtils.INSTANCE.calculatePlayerFacingDirection();
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getW(), vector);
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getA(), vector.rotateXZ(Math.toRadians(90.0)));
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getS(), vector.rotateXZ(Math.toRadians(180.0)));
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getD(), vector.rotateXZ(Math.toRadians(270.0)));
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getUp(), new LorenzVec(0, 1, 0));
        this.handleEditClicks(KeyboardManager.WasdInputMatrix.INSTANCE.getDown(), new LorenzVec(0, -1, 0));
    }

    private final void handleEditClicks(KeyBinding $this$handleEditClicks, LorenzVec vector) {
        block0: {
            block1: {
                if (!KeyboardManager.INSTANCE.isKeyClicked($this$handleEditClicks.func_151463_i())) break block0;
                GraphingNode graphingNode = activeNode;
                if (graphingNode == null) break block1;
                GraphingNode it = graphingNode;
                boolean bl = false;
                it.setPosition(it.getPosition().plus(vector));
                break block0;
            }
            KeyBinding $this$handleEditClicks_u24lambda_u2413 = $this$handleEditClicks;
            boolean bl = false;
            LorenzVec lorenzVec = ghostPosition;
            if (lorenzVec == null) break block0;
            LorenzVec it = lorenzVec;
            boolean bl2 = false;
            ghostPosition = it.plus(vector);
        }
    }

    public final void onMinecraftInput(@NotNull KeyBinding keyBinding, @NotNull CallbackInfoReturnable<Boolean> cir) {
        Intrinsics.checkNotNullParameter(keyBinding, "keyBinding");
        Intrinsics.checkNotNullParameter(cir, "cir");
        if (!this.isEnabled()) {
            return;
        }
        if (!inEditMode) {
            return;
        }
        if (!KeyboardManager.WasdInputMatrix.INSTANCE.contains(keyBinding)) {
            return;
        }
        cir.setReturnValue(false);
    }

    private final void addNode() {
        boolean bl;
        LorenzVec position;
        block8: {
            GraphingNode closedNode = GraphEditor.closedNode;
            if (closedNode != null && this.distanceSqToPlayer(closedNode.getPosition()) < 9.0 && Intrinsics.areEqual(closedNode, activeNode)) {
                this.feedBackInTutorial("Removed node, since you where closer than 3 blocks from a the active node.");
                nodes.remove(closedNode);
                edges.removeIf(arg_0 -> GraphEditor.addNode$lambda$15(arg_0 -> GraphEditor.addNode$lambda$14(closedNode, arg_0), arg_0));
                if (Intrinsics.areEqual(closedNode, activeNode)) {
                    this.setActiveNode(null);
                }
                INSTANCE.setClosedNode(null);
                return;
            }
            LorenzVec lorenzVec = ghostPosition;
            if (lorenzVec == null) {
                lorenzVec = LocationUtils.INSTANCE.playerEyeLocation().roundLocationToBlock();
            }
            position = lorenzVec;
            Iterable $this$any$iv = nodes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GraphingNode it = (GraphingNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getPosition(), position)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            this.feedBackInTutorial("Can't create node, here is already another one.");
            return;
        }
        int n = id;
        id = n + 1;
        GraphingNode node = new GraphingNode(n, position, null, null, 12, null);
        nodes.add(node);
        this.feedBackInTutorial("Added graph node.");
        if (activeNode == null) {
            return;
        }
        this.addEdge(activeNode, node);
    }

    public final void toggleGhostPosition() {
        if (ghostPosition != null) {
            ghostPosition = null;
            this.feedBackInTutorial("Disabled Ghost Position.");
        } else {
            ghostPosition = LocationUtils.INSTANCE.playerEyeLocation().roundLocationToBlock();
            this.feedBackInTutorial("Enabled Ghost Position.");
        }
    }

    private final Integer getEdgeIndex(GraphingNode node1, GraphingNode node2) {
        Integer n;
        if (node1 != null && node2 != null && !Intrinsics.areEqual(node1, node2)) {
            int n2;
            block4: {
                GraphingEdge e = new GraphingEdge(node1, node2);
                boolean bl = false;
                List<GraphingEdge> $this$indexOfFirst$iv = edges;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<GraphingEdge> iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    GraphingEdge item$iv;
                    GraphingEdge it = item$iv = iterator2.next();
                    boolean bl2 = false;
                    if (Intrinsics.areEqual(it, e)) {
                        n2 = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            Integer n3 = n2;
            int it = ((Number)n3).intValue();
            boolean bl = false;
            n = it != -1 ? n3 : null;
        } else {
            n = null;
        }
        return n;
    }

    private final boolean addEdge(GraphingNode node1, GraphingNode node2) {
        boolean bl;
        if (node1 != null && node2 != null && !Intrinsics.areEqual(node1, node2)) {
            GraphingEdge edge = new GraphingEdge(node1, node2);
            if (edge.isInEdge(activeNode)) {
                this.checkDissolve();
                selectedEdge = this.findEdgeBetweenActiveAndClosed();
            }
            bl = edges.add(edge);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<? extends GraphNode> compileGraph-rIAQGNA() {
        void $this$mapTo$iv$iv;
        Collection collection;
        Iterable $this$mapNotNull$iv;
        void $this$mapIndexedTo$iv$iv;
        int n;
        Collection collection2;
        void $this$mapIndexedTo$iv$iv2;
        this.prune();
        Iterable $this$mapIndexed$iv = nodes;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
            void index2;
            void node;
            int n2;
            if ((n2 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphingNode graphingNode = (GraphingNode)item$iv$iv;
            int n3 = n2;
            collection2 = destination$iv$iv;
            n = 0;
            collection2.add(TuplesKt.to(node.getId(), (int)index2));
        }
        Map indexedTable = MapsKt.toMap((List)destination$iv$iv);
        Iterable $this$mapIndexed$iv2 = nodes;
        boolean $i$f$mapIndexed2 = false;
        destination$iv$iv = $this$mapIndexed$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv2, 10));
        boolean $i$f$mapIndexedTo2 = false;
        int index$iv$iv2 = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            List list;
            void $this$mapNotNullTo$iv$iv;
            void index;
            void it;
            int node;
            if ((node = index$iv$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphingNode index2 = (GraphingNode)item$iv$iv;
            n = node;
            collection2 = destination$iv$iv2;
            boolean bl = false;
            Iterable iterable2 = it.getTags();
            String string2 = it.getName();
            LorenzVec lorenzVec = it.getPosition();
            void var18_40 = index;
            boolean $i$f$mapNotNull = false;
            collection = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                GraphNodeTag it2 = (GraphNodeTag)((Object)element$iv$iv);
                boolean bl3 = false;
                if (it2.getInternalName() == null) continue;
                boolean bl4 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List list2 = list = (List)destination$iv$iv3;
            String string3 = string2;
            LorenzVec lorenzVec2 = lorenzVec;
            void var40_60 = var18_40;
            collection2.add(new GraphNode((int)var40_60, lorenzVec2, string3, list2));
        }
        List nodes = (List)destination$iv$iv2;
        Iterable $this$map$iv = GraphEditor.nodes;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$sortedBy$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2;
            GraphingEdge it;
            void $this$filterTo$iv$iv;
            GraphingNode node = (GraphingNode)item$iv$iv;
            collection2 = destination$iv$iv4;
            boolean bl = false;
            Iterable $this$filter$iv = edges;
            boolean $i$f$filter = false;
            $this$mapNotNull$iv = $this$filter$iv;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GraphingEdge)element$iv$iv;
                boolean bl5 = false;
                if (!it.isInEdge(node)) continue;
                destination$iv$iv5.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv5;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void edge;
                it = (GraphingEdge)item$iv$iv2;
                collection = destination$iv$iv5;
                boolean bl6 = false;
                GraphingNode otherNode = Intrinsics.areEqual(node, edge.getNode1()) ? edge.getNode2() : edge.getNode1();
                Object v = indexedTable.get(otherNode.getId());
                Intrinsics.checkNotNull(v);
                collection.add(TuplesKt.to(nodes.get(((Number)v).intValue()), node.getPosition().distance(otherNode.getPosition())));
            }
            $this$map$iv2 = (List)destination$iv$iv5;
            boolean $i$f$sortedBy = false;
            collection2.add(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getSecond();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getSecond()));
                }
            }));
        }
        List neighbours = (List)destination$iv$iv4;
        Iterable $this$forEachIndexed$iv = nodes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GraphNode item$iv$iv = (GraphNode)item$iv;
            int index = n4;
            boolean bl = false;
            it.setNeighbours(MapsKt.toMap((Iterable)neighbours.get(index)));
        }
        return Graph.constructor-impl(nodes);
    }

    /*
     * WARNING - void declaration
     */
    public final void import-0y7Y464(@NotNull List<? extends GraphNode> graph) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapIndexedTo$iv$iv;
        Object destination$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter(graph, "graph");
        this.clear();
        Iterable iterable = Graph.box-impl(graph);
        Collection<Object> collection2 = nodes;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterator it;
            GraphNode graphNode = (GraphNode)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Iterable iterable2 = ((GraphNode)((Object)it)).getTagNames();
            object = ((GraphNode)((Object)it)).getName();
            LorenzVec lorenzVec = ((GraphNode)((Object)it)).getPosition();
            int n = ((GraphNode)((Object)it)).getId();
            boolean $i$f$mapNotNull = false;
            void var18_31 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                GraphNodeTag it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                String tag = (String)element$iv$iv;
                boolean bl3 = false;
                if (GraphNodeTag.Companion.byId(tag) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            List<GraphNodeTag> list2 = CollectionsKt.toMutableList(list);
            Object object2 = object;
            LorenzVec lorenzVec2 = lorenzVec;
            int n2 = n;
            collection.add(new GraphingNode(n2, lorenzVec2, (String)object2, list2));
        }
        collection2.addAll((List)destination$iv$iv2);
        Iterable $this$mapIndexed$iv = Graph.box-impl(graph);
        boolean $i$f$mapIndexed = false;
        destination$iv$iv2 = $this$mapIndexed$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void it;
            int $this$mapNotNull$iv;
            if (($this$mapNotNull$iv = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object = (GraphNode)item$iv$iv2;
            int n = $this$mapNotNull$iv;
            collection2 = destination$iv$iv3;
            boolean bl5 = false;
            collection2.add(TuplesKt.to(it, nodes.get((int)index)));
        }
        Map translation = MapsKt.toMap((List)destination$iv$iv3);
        $this$mapIndexed$iv = Graph.box-impl(graph);
        collection2 = edges;
        boolean $i$f$map2 = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            void node;
            GraphNode item$iv$iv2 = (GraphNode)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            Map<GraphNode, Double> $this$map$iv3 = node.getNeighbours();
            boolean $i$f$map3 = false;
            Map<GraphNode, Double> bl5 = $this$map$iv3;
            Collection destination$iv$iv4 = new ArrayList($this$map$iv3.size());
            boolean $i$f$mapTo3 = false;
            for (Map.Entry item$iv$iv3 : $this$mapTo$iv$iv3.entrySet()) {
                void it;
                destination$iv$iv = item$iv$iv3;
                Collection collection3 = destination$iv$iv4;
                boolean bl6 = false;
                Object v = translation.get(node);
                Intrinsics.checkNotNull(v);
                GraphingNode graphingNode = (GraphingNode)v;
                Object v2 = translation.get(it.getKey());
                Intrinsics.checkNotNull(v2);
                collection3.add(new GraphingEdge(graphingNode, (GraphingNode)v2));
            }
            collection.add((List)destination$iv$iv4);
        }
        collection2.addAll(CollectionsKt.distinct(CollectionsKt.flatten((List)destination$iv$iv3)));
        GraphingNode graphingNode = CollectionsKt.lastOrNull(nodes);
        id = graphingNode != null ? graphingNode.getId() + 1 : 0;
        this.checkDissolve();
        selectedEdge = this.findEdgeBetweenActiveAndClosed();
    }

    /*
     * WARNING - void declaration
     */
    private final void testDijkstra() {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Object v4;
        Object element$iv3;
        GraphNode current;
        List<? extends GraphNode> compiled;
        block9: {
            Object v2;
            GraphingNode savedActive;
            block8: {
                GraphingNode graphingNode = closedNode;
                if (graphingNode == null) {
                    return;
                }
                GraphingNode savedCurrent = graphingNode;
                GraphingNode graphingNode2 = activeNode;
                if (graphingNode2 == null) {
                    return;
                }
                savedActive = graphingNode2;
                compiled = this.compileGraph-rIAQGNA();
                this.import-0y7Y464(compiled);
                highlightedEdges.clear();
                highlightedNodes.clear();
                Iterable $this$firstOrNull$iv = Graph.box-impl(compiled);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    GraphNode it = (GraphNode)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getPosition(), savedCurrent.getPosition())) continue;
                    v2 = element$iv2;
                    break block8;
                }
                v2 = null;
            }
            GraphNode graphNode = v2;
            if (graphNode == null) {
                return;
            }
            current = graphNode;
            Iterable $this$firstOrNull$iv = Graph.box-impl(compiled);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv3 : $this$firstOrNull$iv) {
                GraphNode it = (GraphNode)element$iv3;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getPosition(), savedActive.getPosition())) continue;
                v4 = element$iv3;
                break block9;
            }
            v4 = null;
        }
        GraphNode graphNode = v4;
        if (graphNode == null) {
            return;
        }
        GraphNode goal = graphNode;
        List<? extends GraphNode> path = GraphKt.findShortestPathAsGraph-LidtmbA(compiled, current, goal);
        Iterable $this$map$iv = Graph.box-impl(path);
        boolean $i$f$map = false;
        element$iv3 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GraphNode graphNode2 = (GraphNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(nodes.get(it.getId()));
        }
        List inGraph = (List)destination$iv$iv;
        highlightedNodes.addAll(inGraph);
        Iterable $this$filter$iv = edges;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GraphingEdge it = (GraphingEdge)element$iv$iv;
            boolean bl = false;
            if (!(highlightedNodes.contains(it.getNode1()) && highlightedNodes.contains(it.getNode2()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List edge = (List)destination$iv$iv2;
        highlightedEdges.addAll(edge);
    }

    private final void clear() {
        id = 0;
        nodes.clear();
        edges.clear();
        this.setActiveNode(null);
        this.setClosedNode(null);
        dissolvePossible = false;
        ghostPosition = null;
    }

    private final void prune() {
        Iterable $this$associateWith$iv = nodes;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            GraphingNode graphingNode = (GraphingNode)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Boolean bl2 = false;
            map2.put(t, bl2);
        }
        Map<GraphingNode, Boolean> hasNeighbours = MapsKt.toMutableMap(result$iv);
        Iterable $this$forEach$iv = edges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GraphingEdge it = (GraphingEdge)element$iv;
            boolean bl = false;
            hasNeighbours.put(it.getNode1(), true);
            hasNeighbours.put(it.getNode2(), true);
        }
        nodes.removeIf(arg_0 -> GraphEditor.prune$lambda$40(arg_0 -> GraphEditor.prune$lambda$39(hasNeighbours, arg_0), arg_0));
    }

    public final double distanceSqToPlayer(@NotNull LorenzVec $this$distanceSqToPlayer) {
        double d;
        Intrinsics.checkNotNullParameter($this$distanceSqToPlayer, "<this>");
        LorenzVec lorenzVec = ghostPosition;
        if (lorenzVec != null) {
            LorenzVec it = lorenzVec;
            boolean bl = false;
            d = $this$distanceSqToPlayer.distanceSq(it);
        } else {
            d = $this$distanceSqToPlayer.distanceSq(LocationUtils.INSTANCE.playerLocation());
        }
        return d;
    }

    private static final boolean addNode$lambda$14(GraphingNode $closedNode, GraphingEdge it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isInEdge($closedNode);
    }

    private static final boolean addNode$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean prune$lambda$39(Map $hasNeighbours, GraphingNode it) {
        Intrinsics.checkNotNullParameter($hasNeighbours, "$hasNeighbours");
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual($hasNeighbours.get(it), false);
    }

    private static final boolean prune$lambda$40(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        nodes = new ArrayList();
        edges = new ArrayList();
        seeThroughBlocks = true;
        textBox = new TextInput();
        nodeColor = LorenzColor.BLUE.addOpacity(200);
        activeColor = LorenzColor.GREEN.addOpacity(200);
        closedColor = LorenzColor.YELLOW.addOpacity(200);
        dijkstraColor = LorenzColor.LIGHT_PURPLE.addOpacity(200);
        edgeColor = LorenzColor.GOLD.addOpacity(150);
        edgeDijkstraColor = LorenzColor.DARK_BLUE.addOpacity(150);
        edgeSelectedColor = LorenzColor.DARK_RED.addOpacity(150);
        highlightedNodes = new LinkedHashSet();
        highlightedEdges = new LinkedHashSet();
    }
}

