/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test.command;

import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.mob.MobData;
import at.hannibal2.skyhanni.data.mob.MobFilter;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.OSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Rotations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000e\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00162\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u001a\u001a\u00020\u0005*\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lat/hannibal2/skyhanni/test/command/CopyNearbyEntitiesCommand;", "", "<init>", "()V", "", "", "args", "", "command", "([Ljava/lang/String;)V", "Lnet/minecraft/item/ItemStack;", "stack", "", "resultList", "printItemStackData", "(Lnet/minecraft/item/ItemStack;Ljava/util/List;)V", "Lnet/minecraft/entity/Entity;", "entity", "Lat/hannibal2/skyhanni/data/mob/Mob;", "mob", "getType", "(Lnet/minecraft/entity/Entity;Lat/hannibal2/skyhanni/data/mob/Mob;)Ljava/lang/String;", "", "getMobInfo", "(Lat/hannibal2/skyhanni/data/mob/Mob;)Ljava/util/List;", "Lnet/minecraft/entity/EntityLivingBase;", "asString", "(Lnet/minecraft/entity/EntityLivingBase;)Ljava/lang/String;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nCopyNearbyEntitiesCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyNearbyEntitiesCommand.kt\nat/hannibal2/skyhanni/test/command/CopyNearbyEntitiesCommand\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n607#2:266\n1557#3:267\n1628#3,3:268\n1557#3:271\n1628#3,3:272\n1#4:275\n*S KotlinDebug\n*F\n+ 1 CopyNearbyEntitiesCommand.kt\nat/hannibal2/skyhanni/test/command/CopyNearbyEntitiesCommand\n*L\n48#1:266\n173#1:267\n173#1:268,3\n241#1:271\n241#1:272,3\n*E\n"})
public final class CopyNearbyEntitiesCommand {
    @NotNull
    public static final CopyNearbyEntitiesCommand INSTANCE = new CopyNearbyEntitiesCommand();

    private CopyNearbyEntitiesCommand() {
    }

    /*
     * WARNING - void declaration
     */
    public final void command(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        int searchRadius = 10;
        if (args2.length == 1) {
            searchRadius = Integer.parseInt(args2[0]);
        }
        LorenzVec start2 = LocationUtils.INSTANCE.playerLocation();
        List resultList = new ArrayList();
        int counter = 0;
        Sequence<Entity> $this$sortedBy$iv = EntityUtils.INSTANCE.getAllEntities();
        boolean $i$f$sortedBy = false;
        Iterator<Entity> iterator2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Entity it = (Entity)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.func_145782_y());
                it = (Entity)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.func_145782_y());
            }
        }).iterator();
        while (iterator2.hasNext()) {
            int i2;
            InventoryPlayer inventory2;
            Entity entity = iterator2.next();
            BlockPos position = entity.func_180425_c();
            Intrinsics.checkNotNull(position);
            LorenzVec vec = LorenzVecKt.toLorenzVec(position);
            double distance = start2.distance(vec);
            Mob mob = MobData.INSTANCE.getEntityToMob().get(entity);
            if (!(distance < (double)searchRadius)) continue;
            String simpleName2 = entity.getClass().getSimpleName();
            resultList.add("entity: " + simpleName2);
            IChatComponent displayName = entity.func_145748_c_();
            resultList.add("name: '" + entity.func_70005_c_() + '\'');
            if (entity instanceof EntityArmorStand) {
                resultList.add("cleanName: '" + EntityUtils.INSTANCE.cleanName(entity) + '\'');
            }
            resultList.add("displayName: '" + displayName.func_150254_d() + '\'');
            resultList.add("entityId: " + entity.func_145782_y());
            resultList.add("Type of Mob: " + this.getType(entity, mob));
            resultList.add("uuid version: " + entity.func_110124_au().version() + " (" + entity.func_110124_au() + ')');
            resultList.add("location data:");
            resultList.add("-  vec: " + vec);
            resultList.add("-  distance: " + distance);
            float rotationYaw = entity.field_70177_z;
            float rotationPitch = entity.field_70125_A;
            resultList.add("-  rotationYaw: " + rotationYaw);
            resultList.add("-  rotationPitch: " + rotationPitch);
            Entity riddenByEntity = entity.field_70153_n;
            resultList.add("riddenByEntity: " + riddenByEntity);
            Entity ridingEntity = entity.field_70154_o;
            resultList.add("ridingEntity: " + ridingEntity);
            if (entity instanceof EntityLivingBase) {
                resultList.add("EntityLivingBase:");
                int baseMaxHealth = LorenzUtils.INSTANCE.getBaseMaxHealth((EntityLivingBase)entity);
                int health = (int)((EntityLivingBase)entity).func_110143_aJ();
                resultList.add("-  baseMaxHealth: " + baseMaxHealth);
                resultList.add("-  health: " + health);
            }
            if (entity instanceof EntityPlayer && (inventory2 = ((EntityPlayer)entity).field_71071_by) != null) {
                resultList.add("armor:");
                Intrinsics.checkNotNullExpressionValue(inventory2.field_70460_b, "armorInventory");
                ItemStack[] health = inventory2.field_70460_b;
                int n = health.length;
                for (int j = 0; j < n; ++j) {
                    i2 = j;
                    ItemStack itemStack2 = health[j];
                    Object object = itemStack2;
                    if (object == null || (object = ItemUtils.INSTANCE.getName((ItemStack)object)) == null) {
                        object = "null";
                    }
                    Object name2 = object;
                    resultList.add("-  at: " + i2 + ": " + (String)name2);
                }
            }
            if ((inventory2 = entity) instanceof EntityArmorStand) {
                ItemStack[] itemStackArray;
                resultList.add("EntityArmorStand:");
                Rotations rotations = ((EntityArmorStand)entity).func_175418_s();
                Intrinsics.checkNotNullExpressionValue(rotations, "getHeadRotation(...)");
                LorenzVec headRotation = LorenzVecKt.toLorenzVec(rotations);
                Rotations rotations2 = ((EntityArmorStand)entity).func_175408_t();
                Intrinsics.checkNotNullExpressionValue(rotations2, "getBodyRotation(...)");
                LorenzVec bodyRotation = LorenzVecKt.toLorenzVec(rotations2);
                resultList.add("-  headRotation: " + headRotation);
                resultList.add("-  bodyRotation: " + bodyRotation);
                resultList.add("-  inventory:");
                Intrinsics.checkNotNullExpressionValue(((EntityArmorStand)entity).func_70035_c(), "getInventory(...)");
                int itemStack2 = itemStackArray.length;
                for (i2 = 0; i2 < itemStack2; ++i2) {
                    int id = i2;
                    ItemStack stack = itemStackArray[i2];
                    resultList.add("-  id " + id + " (" + stack + ')');
                    this.printItemStackData(stack, resultList);
                }
            } else if (inventory2 instanceof EntityEnderman) {
                resultList.add("EntityEnderman:");
                IBlockState heldBlockState = EntityUtils.INSTANCE.getBlockInHand((EntityEnderman)entity);
                resultList.add("-  heldBlockState: " + heldBlockState);
                if (heldBlockState != null) {
                    Block block = heldBlockState.func_177230_c();
                    resultList.add("-  block: " + block);
                }
            } else if (inventory2 instanceof EntityMagmaCube) {
                resultList.add("EntityMagmaCube:");
                float squishFactor = ((EntityMagmaCube)entity).field_70811_b;
                int slimeSize = ((EntityMagmaCube)entity).func_70809_q();
                resultList.add("-  factor: " + squishFactor);
                resultList.add("-  slimeSize: " + slimeSize);
            } else if (inventory2 instanceof EntityItem) {
                resultList.add("EntityItem:");
                ItemStack stack = ((EntityItem)entity).func_92059_d();
                Intrinsics.checkNotNull(stack);
                String stackName = ItemUtils.INSTANCE.getName(stack);
                String stackDisplayName = stack.func_82833_r();
                String cleanName = ItemUtils.INSTANCE.cleanName(stack);
                boolean itemEnchanted = ItemUtils.INSTANCE.isEnchanted(stack);
                int itemDamage = stack.func_77952_i();
                int stackSize = stack.field_77994_a;
                int maxStackSize = stack.func_77976_d();
                resultList.add("-  name: '" + stackName + '\'');
                resultList.add("-  stackDisplayName: '" + stackDisplayName + '\'');
                resultList.add("-  cleanName: '" + cleanName + '\'');
                resultList.add("-  itemEnchanted: '" + itemEnchanted + '\'');
                resultList.add("-  itemDamage: '" + itemDamage + '\'');
                resultList.add("-  stackSize: '" + stackSize + '\'');
                resultList.add("-  maxStackSize: '" + maxStackSize + '\'');
            } else if (inventory2 instanceof EntityOtherPlayerMP) {
                resultList.add("EntityOtherPlayerMP:");
                String skinTexture = EntityUtils.INSTANCE.getSkinTexture((EntityPlayer)entity);
                resultList.add("-  skin texture: " + skinTexture);
            } else if (inventory2 instanceof EntityCreeper) {
                resultList.add("EntityCreeper:");
                int creeperState = ((EntityCreeper)entity).func_70832_p();
                boolean ignite = ((EntityCreeper)entity).func_146078_ca();
                boolean powered = ((EntityCreeper)entity).func_70830_n();
                resultList.add("-  creeperState: '" + creeperState + '\'');
                resultList.add("-  ignite: '" + ignite + '\'');
                resultList.add("-  powered: '" + powered + '\'');
            } else if (inventory2 instanceof EntityWither) {
                resultList.add("EntityWither:");
                int invulTime = ((EntityWither)entity).func_82212_n();
                resultList.add("-  invulTime: '" + invulTime + '\'');
            }
            if (mob != null && mob.getMobType() != Mob.Type.PLAYER) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                resultList.add("MobInfo: ");
                Object inventory2 = this.getMobInfo(mob);
                List list = resultList;
                boolean $i$f$map = false;
                void ignite = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String stackSize = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add("-  " + (String)it);
                }
                list.addAll((List)destination$iv$iv);
            }
            resultList.add("");
            resultList.add("");
            ++counter;
        }
        if (counter != 0) {
            String string2 = CollectionsKt.joinToString$default(resultList, "\n", null, null, 0, null, null, 62, null);
            OSUtils.INSTANCE.copyToClipboard(string2);
            ChatUtils.chat$default(ChatUtils.INSTANCE, counter + " entities copied into the clipboard!", false, null, 6, null);
        } else {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "No entities found in a search radius of " + searchRadius + '!', false, null, 6, null);
        }
    }

    private final void printItemStackData(ItemStack stack, List<String> resultList) {
        if (stack != null) {
            String skullTexture = ItemUtils.INSTANCE.getSkullTexture(stack);
            if (skullTexture != null) {
                resultList.add("-     skullTexture:");
                resultList.add("-     " + skullTexture);
            }
            String cleanName = ItemUtils.INSTANCE.cleanName(stack);
            String stackName = ItemUtils.INSTANCE.getName(stack);
            String type2 = stack.getClass().getName();
            resultList.add("-     name: '" + stackName + '\'');
            resultList.add("-     cleanName: '" + cleanName + '\'');
            resultList.add("-     type: " + type2);
        }
    }

    private final String getType(Entity entity, Mob mob) {
        StringBuilder stringBuilder;
        StringBuilder $this$getType_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (entity instanceof EntityLivingBase && MobFilter.INSTANCE.isDisplayNPC((EntityLivingBase)entity)) {
            $this$getType_u24lambda_u242.append("DisplayNPC, ");
        }
        if (entity instanceof EntityPlayer && EntityUtils.INSTANCE.isNPC((EntityPlayer)entity)) {
            $this$getType_u24lambda_u242.append("NPC, ");
        }
        if (entity instanceof EntityPlayer && MobFilter.INSTANCE.isRealPlayer((EntityPlayer)entity)) {
            $this$getType_u24lambda_u242.append("RealPlayer, ");
        }
        Mob mob2 = mob;
        if ((mob2 != null ? mob2.getMobType() : null) == Mob.Type.SUMMON) {
            $this$getType_u24lambda_u242.append("Summon, ");
        }
        if (MobFilter.INSTANCE.isSkyBlockMob(entity)) {
            StringBuilder stringBuilder2;
            $this$getType_u24lambda_u242.append("SkyblockMob(");
            if (mob == null) {
                $this$getType_u24lambda_u242.append(LocationUtils.INSTANCE.distanceToPlayer(entity) > 22.0 ? "Not in Range" : "None");
                stringBuilder2 = $this$getType_u24lambda_u242.append(")");
            } else {
                $this$getType_u24lambda_u242.append(mob.getMobType().name());
                if (Intrinsics.areEqual(mob.getBaseEntity(), entity)) {
                    $this$getType_u24lambda_u242.append("/Base");
                }
                $this$getType_u24lambda_u242.append(")\"");
                $this$getType_u24lambda_u242.append(mob.getName());
                stringBuilder2 = $this$getType_u24lambda_u242.append("\"");
            }
            $this$getType_u24lambda_u242.append(", ");
        }
        StringBuilder stringBuilder3 = ((CharSequence)$this$getType_u24lambda_u242).length() > 0 ? $this$getType_u24lambda_u242.delete($this$getType_u24lambda_u242.length() - 2, $this$getType_u24lambda_u242.length()) : $this$getType_u24lambda_u242.append("NONE");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getMobInfo(@NotNull Mob mob) {
        void it;
        Object object;
        int $i$f$map;
        List<String> list;
        Object object2;
        List<String> list2;
        Intrinsics.checkNotNullParameter(mob, "mob");
        List<String> $this$getMobInfo_u24lambda_u245 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getMobInfo_u24lambda_u245.add("Name: " + mob.getName());
        $this$getMobInfo_u24lambda_u245.add("Type: " + (Object)((Object)mob.getMobType()));
        $this$getMobInfo_u24lambda_u245.add("Base Entity: " + INSTANCE.asString(mob.getBaseEntity()));
        EntityArmorStand entityArmorStand = mob.getArmorStand();
        $this$getMobInfo_u24lambda_u245.add("ArmorStand: " + (entityArmorStand != null ? INSTANCE.asString((EntityLivingBase)entityArmorStand) : null));
        if (!((Collection)mob.getExtraEntities()).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$getMobInfo_u24lambda_u245.add("Extra Entities");
            object2 = mob.getExtraEntities();
            list = $this$getMobInfo_u24lambda_u245;
            $i$f$map = 0;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                EntityLivingBase entityLivingBase = (EntityLivingBase)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add("  " + INSTANCE.asString((EntityLivingBase)it2));
            }
            list.addAll((List)destination$iv$iv);
        }
        if (mob.getHologram1Delegate().isInitialized()) {
            EntityArmorStand entityArmorStand2 = mob.getHologram1();
            $this$getMobInfo_u24lambda_u245.add("Hologram1: " + (entityArmorStand2 != null ? INSTANCE.asString((EntityLivingBase)entityArmorStand2) : null));
        }
        if (mob.getHologram2Delegate().isInitialized()) {
            EntityArmorStand entityArmorStand3 = mob.getHologram2();
            $this$getMobInfo_u24lambda_u245.add("Hologram2: " + (entityArmorStand3 != null ? INSTANCE.asString((EntityLivingBase)entityArmorStand3) : null));
        }
        if (mob.getOwner() != null) {
            $this$getMobInfo_u24lambda_u245.add("Owner: " + mob.getOwner().getOwnerName());
        }
        object2 = mob.getLevelOrTier();
        $i$f$map = ((Number)object2).intValue();
        object = new StringBuilder().append("Level or Tier: ");
        list = $this$getMobInfo_u24lambda_u245;
        boolean bl3 = false;
        boolean bl4 = it != -1;
        list.add(((StringBuilder)object).append(bl4 ? object2 : null).toString());
        if (mob.getMobType() == Mob.Type.DUNGEON) {
            $this$getMobInfo_u24lambda_u245.add("Is Starred: " + mob.getHasStar());
            StringBuilder stringBuilder = new StringBuilder().append("Attribute: ");
            Object object3 = mob.getAttribute();
            if (object3 == null) {
                object3 = "NONE";
            }
            $this$getMobInfo_u24lambda_u245.add(stringBuilder.append(object3).toString());
        }
        if (!Intrinsics.areEqual(mob.getBoundingBox(), mob.getBaseEntity().func_174813_aQ())) {
            $this$getMobInfo_u24lambda_u245.add("Bounding Box: " + mob.getBoundingBox());
        }
        return CollectionsKt.build(list2);
    }

    private final String asString(EntityLivingBase $this$asString) {
        return $this$asString.func_145782_y() + " - " + $this$asString.getClass().getSimpleName() + " \"" + $this$asString.func_70005_c_() + '\"';
    }
}

