/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test;

import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.utils.ChatUtils;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lat/hannibal2/skyhanni/test/SkyBlockIslandTest;", "", "<init>", "()V", "", "", "args", "", "onCommand", "([Ljava/lang/String;)V", "search", "Lat/hannibal2/skyhanni/data/IslandType;", "find", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/data/IslandType;", "testIsland", "Lat/hannibal2/skyhanni/data/IslandType;", "getTestIsland", "()Lat/hannibal2/skyhanni/data/IslandType;", "setTestIsland", "(Lat/hannibal2/skyhanni/data/IslandType;)V", "1.8.9"})
public final class SkyBlockIslandTest {
    @NotNull
    public static final SkyBlockIslandTest INSTANCE = new SkyBlockIslandTest();
    @Nullable
    private static IslandType testIsland;

    private SkyBlockIslandTest() {
    }

    @Nullable
    public final IslandType getTestIsland() {
        return testIsland;
    }

    public final void setTestIsland(@Nullable IslandType islandType) {
        testIsland = islandType;
    }

    public final void onCommand(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        if (args2.length == 0) {
            ChatUtils.INSTANCE.userError("Usage: /shtestisland <island name>/reset");
            return;
        }
        String string2 = ArraysKt.joinToString$default(args2, (CharSequence)" ", null, null, 0, null, null, 62, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String search = string2;
        if (Intrinsics.areEqual(search, "reset")) {
            IslandType islandType = testIsland;
            if (islandType != null) {
                IslandType it = islandType;
                boolean bl = false;
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Disabled test island (was " + it.getDisplayName() + ')', false, null, 6, null);
                testIsland = null;
                return;
            }
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Test island was not set.", false, null, 6, null);
            return;
        }
        IslandType found = this.find(search);
        if (found == null) {
            ChatUtils.INSTANCE.userError("Unknown island type! (" + search + ')');
            return;
        }
        testIsland = found;
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Set test island to " + found.getDisplayName(), false, null, 6, null);
    }

    private final IslandType find(String search) {
        for (IslandType type2 : IslandType.values()) {
            if (StringsKt.equals(type2.name(), search, true)) {
                return type2;
            }
            if (!StringsKt.equals(type2.getDisplayName(), search, true)) continue;
            return type2;
        }
        return null;
    }
}

