/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.test.SkyBlockIslandTest;
import at.hannibal2.skyhanni.test.SkyHanniDebugsAndTests;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\rJ\u0017\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0012\u0010\rJ\u0017\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\r\u00a8\u0006\u0014"}, d2={"Lat/hannibal2/skyhanni/test/DebugCommand;", "", "<init>", "()V", "", "", "args", "", "command", "([Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "profileType", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "profileName", "skyblockStatus", "globalRender", "repoAutoUpdate", "repoLocation", "player", "1.8.9"})
public final class DebugCommand {
    @NotNull
    public static final DebugCommand INSTANCE = new DebugCommand();

    private DebugCommand() {
    }

    public final void command(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        if (args2.length == 2 && Intrinsics.areEqual(args2[0], "profileName")) {
            String string2 = args2[1].toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            HypixelData.INSTANCE.setProfileName(string2);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7eManually set profileName to '" + HypixelData.INSTANCE.getProfileName() + '\'', false, null, 6, null);
            return;
        }
        List list = new ArrayList();
        list.add("```");
        list.add("= Debug Information for SkyHanni " + SkyHanniMod.Companion.getVersion() + " =");
        list.add("");
        String search = ArraysKt.joinToString$default(args2, (CharSequence)" ", null, null, 0, null, null, 62, null);
        list.add(((CharSequence)search).length() > 0 ? (StringUtils.INSTANCE.equalsIgnoreColor(search, "all") ? "search for everything:" : "search '" + search + "':") : "no search specified, only showing interesting stuff:");
        DebugDataCollectEvent event = new DebugDataCollectEvent(list, search);
        this.player(event);
        this.repoAutoUpdate(event);
        this.repoLocation(event);
        this.globalRender(event);
        this.skyblockStatus(event);
        this.profileName(event);
        this.profileType(event);
        event.postAndCatch();
        if (event.getEmpty()) {
            list.add("");
            list.add("Nothing interesting to show right now!");
            list.add("Looking for something specific? /shdebug <search>");
            list.add("Wanna see everything? /shdebug all");
        }
        list.add("```");
        OSUtils.INSTANCE.copyToClipboard(CollectionsKt.joinToString$default(list, "\n", null, null, 0, null, null, 62, null));
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7eCopied SkyHanni debug data in the clipboard.", false, null, 6, null);
    }

    private final void profileType(DebugDataCollectEvent event) {
        boolean classic;
        event.title("Profile Type");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            event.addIrrelevant("Not on SkyBlock");
            return;
        }
        if (ProfileStorageData.INSTANCE.getPlayerSpecific() == null) {
            event.addData("playerSpecific is null!");
            return;
        }
        boolean bl = classic = !LorenzUtils.INSTANCE.getNoTradeMode();
        if (classic) {
            event.addIrrelevant("on classic");
        } else {
            if (HypixelData.INSTANCE.getIronman()) {
                event.addData("on ironman");
            }
            if (HypixelData.INSTANCE.getStranded()) {
                event.addData("on stranded");
            }
            if (HypixelData.INSTANCE.getBingo()) {
                event.addData("on bingo");
            }
        }
    }

    private final void profileName(DebugDataCollectEvent event) {
        event.title("Profile Name");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            event.addIrrelevant("Not on SkyBlock");
            return;
        }
        if (!Intrinsics.areEqual(HypixelData.INSTANCE.getProfileName(), "")) {
            event.addIrrelevant("profileName: '" + HypixelData.INSTANCE.getProfileName() + '\'');
        } else {
            event.addData("profile name is empty!");
        }
    }

    private final void skyblockStatus(DebugDataCollectEvent event) {
        event.title("SkyBlock Status");
        if (!LorenzUtils.INSTANCE.getOnHypixel()) {
            event.addData("not on Hypixel");
            return;
        }
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            event.addData("not on SkyBlock, but on Hypixel");
            return;
        }
        if (LorenzUtils.INSTANCE.getSkyBlockIsland() == IslandType.UNKNOWN) {
            event.addData("Unknown SkyBlock island!");
            return;
        }
        if (LorenzUtils.INSTANCE.getSkyBlockIsland() != HypixelData.INSTANCE.getSkyBlockIsland()) {
            event.addData(DebugCommand::skyblockStatus$lambda$0);
            return;
        }
        event.addIrrelevant(DebugCommand::skyblockStatus$lambda$1);
    }

    private final void globalRender(DebugDataCollectEvent event) {
        event.title("Global Render");
        if (SkyHanniDebugsAndTests.INSTANCE.getGlobalRender()) {
            event.addIrrelevant("normal enabled");
        } else {
            event.addData(DebugCommand::globalRender$lambda$2);
        }
    }

    private final void repoAutoUpdate(DebugDataCollectEvent event) {
        event.title("Repo Auto Update");
        if (SkyHanniMod.feature.dev.repo.repoAutoUpdate) {
            event.addIrrelevant("normal enabled");
        } else {
            event.addData("The repo does not auto update because auto update is disabled!");
        }
    }

    private final void repoLocation(DebugDataCollectEvent event) {
        event.title("Repo Location");
        event.addIrrelevant("repo location: '" + RepoManager.Companion.getRepoLocation() + '\'');
    }

    private final void player(DebugDataCollectEvent event) {
        event.title("Player");
        event.addIrrelevant(DebugCommand::player$lambda$3);
    }

    private static final Unit skyblockStatus$lambda$0(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("using a test island!");
        $this$addData.add("test island: " + (Object)((Object)SkyBlockIslandTest.INSTANCE.getTestIsland()));
        $this$addData.add("real island: " + (Object)((Object)HypixelData.INSTANCE.getSkyBlockIsland()));
        return Unit.INSTANCE;
    }

    private static final Unit skyblockStatus$lambda$1(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter($this$addIrrelevant, "$this$addIrrelevant");
        $this$addIrrelevant.add("on Hypixel SkyBlock");
        $this$addIrrelevant.add("skyBlockIsland: " + (Object)((Object)LorenzUtils.INSTANCE.getSkyBlockIsland()));
        $this$addIrrelevant.add("skyBlockArea: '" + LorenzUtils.INSTANCE.getSkyBlockArea() + '\'');
        $this$addIrrelevant.add("isOnAlphaServer: '" + LorenzUtils.INSTANCE.isOnAlphaServer() + '\'');
        return Unit.INSTANCE;
    }

    private static final Unit globalRender$lambda$2(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        $this$addData.add("Global renderer is disabled!");
        $this$addData.add("No renderable elements from SkyHanni will show up anywhere!");
        return Unit.INSTANCE;
    }

    private static final Unit player$lambda$3(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter($this$addIrrelevant, "$this$addIrrelevant");
        $this$addIrrelevant.add("name: '" + LorenzUtils.INSTANCE.getPlayerName() + '\'');
        $this$addIrrelevant.add("uuid: '" + LorenzUtils.INSTANCE.getPlayerUuid() + '\'');
        return Unit.INSTANCE;
    }
}

