/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.slayer.ItemProfitTrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ItemAddManager;
import at.hannibal2.skyhanni.data.SlayerAPI;
import at.hannibal2.skyhanni.data.jsonobjects.repo.SlayerProfitTrackerItemsJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.ItemAddEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.PurseChangeCause;
import at.hannibal2.skyhanni.events.PurseChangeEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.SlayerChangeEvent;
import at.hannibal2.skyhanni.events.SlayerQuestCompleteEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.tracker.ItemTrackerData;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniItemTracker;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.Expose;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001ZB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010&\u001a\u00020\u00062\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"2\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020$2\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010*\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020/H\u0007\u00a2\u0006\u0004\b0\u00101J\u0017\u00103\u001a\u00020\u00062\u0006\u0010\n\u001a\u000202H\u0007\u00a2\u0006\u0004\b3\u00104J\r\u00105\u001a\u00020$\u00a2\u0006\u0004\b5\u00106J\u001b\u0010:\u001a\u00020\u00062\f\u00109\u001a\b\u0012\u0004\u0012\u00020807\u00a2\u0006\u0004\b:\u0010;R\u001c\u0010@\u001a\n =*\u0004\u0018\u00010<0<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0016\u0010A\u001a\u0002088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0016\u0010C\u001a\u0002088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010BR&\u0010E\u001a\u0014\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160D8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u001b\u0010L\u001a\u00020G8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010KR\u0018\u0010Q\u001a\u00020N*\u00020M8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR(\u0010S\u001a\u0014\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0+0R8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bS\u0010FR5\u0010V\u001a \u0012\u0004\u0012\u00020M\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u0002080+0U0T8\u0006\u00a2\u0006\f\n\u0004\bV\u0010W\u001a\u0004\bX\u0010Y\u00a8\u0006["}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker;", "", "<init>", "()V", "", "price", "", "addSlayerCosts", "(D)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/PurseChangeEvent;", "onPurseChange", "(Lat/hannibal2/skyhanni/events/PurseChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/SlayerChangeEvent;", "onSlayerChange", "(Lat/hannibal2/skyhanni/events/SlayerChangeEvent;)V", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "Lat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker$Data;", "getTracker", "()Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "Lat/hannibal2/skyhanni/events/SlayerQuestCompleteEvent;", "onQuestComplete", "(Lat/hannibal2/skyhanni/events/SlayerQuestCompleteEvent;)V", "Lat/hannibal2/skyhanni/events/ItemAddEvent;", "onItemAdd", "(Lat/hannibal2/skyhanni/events/ItemAddEvent;)V", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "internalName", "", "amount", "", "command", "tryAddItem", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;IZ)V", "isAllowedItem", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;)Z", "data", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker$Data;)Ljava/util/List;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "isEnabled", "()Z", "", "", "args", "clearProfitCommand", "([Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/config/features/slayer/ItemProfitTrackerConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/ItemProfitTrackerConfig;", "config", "itemLogCategory", "Ljava/lang/String;", "baseSlayerType", "", "trackers", "Ljava/util/Map;", "Ljava/util/regex/Pattern;", "autoSlayerBankPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getAutoSlayerBankPattern", "()Ljava/util/regex/Pattern;", "autoSlayerBankPattern", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;", "", "getTimesDropped", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)J", "timesDropped", "", "allowedItems", "Lkotlin/Function1;", "Lkotlin/Pair;", "coinFormat", "Lkotlin/jvm/functions/Function1;", "getCoinFormat", "()Lkotlin/jvm/functions/Function1;", "Data", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSlayerProfitTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlayerProfitTracker.kt\nat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 4 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n1#2:262\n1#2:271\n12#3,7:263\n8#4:270\n381#5,7:272\n381#5,7:279\n1557#6:286\n1628#6,3:287\n1557#6:290\n1628#6,3:291\n*S KotlinDebug\n*F\n+ 1 SlayerProfitTracker.kt\nat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker\n*L\n120#1:271\n102#1:263,7\n120#1:270\n136#1:272,7\n138#1:279,7\n228#1:286\n228#1:287,3\n230#1:290\n230#1:291,3\n*E\n"})
public final class SlayerProfitTracker {
    @NotNull
    public static final SlayerProfitTracker INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static String itemLogCategory;
    @NotNull
    private static String baseSlayerType;
    @NotNull
    private static final Map<String, SkyHanniItemTracker<Data>> trackers;
    @NotNull
    private static final RepoPattern autoSlayerBankPattern$delegate;
    @NotNull
    private static Map<String, ? extends List<NEUInternalName>> allowedItems;
    @NotNull
    private static final Function1<ItemTrackerData.TrackedItem, Pair<String, List<String>>> coinFormat;

    private SlayerProfitTracker() {
    }

    private final ItemProfitTrackerConfig getConfig() {
        return SkyHanniMod.feature.slayer.itemProfitTracker;
    }

    private final Pattern getAutoSlayerBankPattern() {
        return (Pattern)autoSlayerBankPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final long getTimesDropped(ItemTrackerData.TrackedItem $this$timesDropped) {
        return $this$timesDropped.getTimesGained();
    }

    private final void addSlayerCosts(double price) {
        block1: {
            if (!(price < 0.0)) {
                boolean bl = false;
                String string2 = "slayer costs can not be positive";
                throw new IllegalArgumentException(string2.toString());
            }
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block1;
            skyHanniItemTracker.modify(arg_0 -> SlayerProfitTracker.addSlayerCosts$lambda$1(price, arg_0));
        }
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        SlayerProfitTrackerItemsJson slayerProfitTrackerItemsJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "SlayerProfitTrackerItems";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            slayerProfitTrackerItemsJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, SlayerProfitTrackerItemsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        allowedItems = slayerProfitTrackerItemsJson.getSlayers();
    }

    @SubscribeEvent
    public final void onPurseChange(@NotNull PurseChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        double coins = event.getCoins();
        if (event.getReason() == PurseChangeCause.GAIN_MOB_KILL && SlayerAPI.INSTANCE.isInCorrectArea()) {
            this.tryAddItem(NEUInternalName.Companion.getSKYBLOCK_COIN(), (int)coins, false);
        }
        if (event.getReason() == PurseChangeCause.LOSE_SLAYER_QUEST_STARTED) {
            this.addSlayerCosts(coins);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getAutoSlayerBankPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u242 = it$iv;
            boolean bl2 = false;
            String string2 = $this$onChat_u24lambda_u242.group("coins");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            INSTANCE.addSlayerCosts(-NumberUtil.INSTANCE.formatDouble(string2));
        }
    }

    @SubscribeEvent
    public final void onSlayerChange(@NotNull SlayerChangeEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            String newSlayer = event.getNewSlayer();
            itemLogCategory = StringUtils.removeColor$default(StringUtils.INSTANCE, newSlayer, false, 1, null);
            baseSlayerType = StringsKt.substringBeforeLast$default(itemLogCategory, " ", null, 2, null);
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block0;
            skyHanniItemTracker.update();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SkyHanniItemTracker<Data> getTracker() {
        Object object;
        void $this$getOrPut$iv;
        if (Intrinsics.areEqual(itemLogCategory, "")) {
            return null;
        }
        Map<String, SkyHanniItemTracker<Data>> map2 = trackers;
        String key$iv = itemLogCategory;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Function1<ProfileSpecificStorage, Data> getStorage = SlayerProfitTracker::getTracker$lambda$7$lambda$4;
            SkyHanniItemTracker<Data> answer$iv = new SkyHanniItemTracker<Data>(itemLogCategory + " Profit Tracker", SlayerProfitTracker::getTracker$lambda$7$lambda$5, getStorage, new Pair[0], SlayerProfitTracker::getTracker$lambda$7$lambda$6);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SkyHanniItemTracker)object;
    }

    @SubscribeEvent
    public final void onQuestComplete(@NotNull SlayerQuestCompleteEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block0;
            skyHanniItemTracker.modify(SlayerProfitTracker::onQuestComplete$lambda$8);
        }
    }

    @SubscribeEvent
    public final void onItemAdd(@NotNull ItemAddEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!SlayerAPI.INSTANCE.isInCorrectArea()) {
            return;
        }
        if (!SlayerAPI.INSTANCE.hasActiveSlayerQuest()) {
            return;
        }
        this.tryAddItem(event.getInternalName(), event.getAmount(), event.getSource() == ItemAddManager.Source.COMMAND);
    }

    private final void tryAddItem(NEUInternalName internalName, int amount, boolean command2) {
        block1: {
            if (!this.isAllowedItem(internalName) && !Intrinsics.areEqual(internalName, NEUInternalName.Companion.getSKYBLOCK_COIN())) {
                ChatUtils.INSTANCE.debug("Ignored non-slayer item pickup: '" + internalName + "' '" + itemLogCategory + '\'');
                return;
            }
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block1;
            skyHanniItemTracker.addItem(internalName, amount, command2);
        }
    }

    private final boolean isAllowedItem(NEUInternalName internalName) {
        List<NEUInternalName> list = allowedItems.get(baseSlayerType);
        if (list == null) {
            return false;
        }
        List<NEUInternalName> allowedList = list;
        return allowedList.contains(internalName);
    }

    private final List<Searchable> drawDisplay(Data data2) {
        List<Searchable> list;
        List<Searchable> $this$drawDisplay_u24lambda_u2410 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        SkyHanniItemTracker<Data> skyHanniItemTracker = INSTANCE.getTracker();
        if (skyHanniItemTracker != null) {
            SkyHanniItemTracker<Data> tracker = skyHanniItemTracker;
            CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u2410, "\u00a7e\u00a7l" + itemLogCategory + " Profit Tracker", null, null, null, 14, null);
            double profit = tracker.drawItems((Data)((ItemTrackerData)data2), SlayerProfitTracker::drawDisplay$lambda$10$lambda$9, $this$drawDisplay_u24lambda_u2410);
            long slayerSpawnCost = data2.getSlayerSpawnCost();
            if (slayerSpawnCost != 0L) {
                String slayerSpawnCostFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, slayerSpawnCost, false, 1, null);
                String[] stringArray = new String[]{"\u00a77You paid \u00a7c" + slayerSpawnCostFormat + " \u00a77in total", "\u00a77for starting the slayer quests."};
                $this$drawDisplay_u24lambda_u2410.add(SearchableKt.toSearchable$default(Renderable.Companion.hoverTips$default(Renderable.Companion, " \u00a77Slayer Spawn Costs: \u00a7c" + slayerSpawnCostFormat, CollectionsKt.listOf(stringArray), null, null, null, false, false, false, null, null, 1020, null), null, 1, null));
                profit += (double)slayerSpawnCost;
            }
            long slayerCompletedCount = data2.getSlayerCompletedCount();
            String[] stringArray = new String[]{"\u00a77You killed the " + itemLogCategory + " boss", "\u00a7e" + NumberUtil.INSTANCE.addSeparators(slayerCompletedCount) + " \u00a77times."};
            $this$drawDisplay_u24lambda_u2410.add(SearchableKt.toSearchable$default(Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a77Bosses killed: \u00a7e" + NumberUtil.INSTANCE.addSeparators(slayerCompletedCount), CollectionsKt.listOf(stringArray), null, null, null, false, false, false, null, null, 1020, null), null, 1, null));
            $this$drawDisplay_u24lambda_u2410.add(tracker.addTotalProfit(profit, data2.getSlayerCompletedCount(), "boss"));
            tracker.addPriceFromButton($this$drawDisplay_u24lambda_u2410);
        }
        return CollectionsKt.build(list);
    }

    @NotNull
    public final Function1<ItemTrackerData.TrackedItem, Pair<String, List<String>>> getCoinFormat() {
        return coinFormat;
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.isEnabled()) {
                return;
            }
            if (!SlayerAPI.INSTANCE.isInCorrectArea()) {
                return;
            }
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block2;
            Position position = this.getConfig().pos;
            Intrinsics.checkNotNullExpressionValue(position, "pos");
            skyHanniItemTracker.renderDisplay(position);
        }
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.transform(10, "#profile.slayerProfitData", SlayerProfitTracker::onConfigFix$lambda$14);
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled;
    }

    public final void clearProfitCommand(@NotNull String[] args2) {
        block1: {
            Intrinsics.checkNotNullParameter(args2, "args");
            if (Intrinsics.areEqual(itemLogCategory, "")) {
                ChatUtils.INSTANCE.userError("No current slayer data found! \u00a7eGo to a slayer area and start the specific slayer type you want to reset the data of.");
                return;
            }
            SkyHanniItemTracker<Data> skyHanniItemTracker = this.getTracker();
            if (skyHanniItemTracker == null) break block1;
            skyHanniItemTracker.resetCommand();
        }
    }

    private static final Unit addSlayerCosts$lambda$1(double $price, Data it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setSlayerSpawnCost(it.getSlayerSpawnCost() + (long)((int)$price));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Data getTracker$lambda$7$lambda$4(ProfileSpecificStorage it) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(it, "it");
        Map<String, Data> map2 = it.slayerProfitData;
        Intrinsics.checkNotNullExpressionValue(map2, "slayerProfitData");
        Map<String, Data> map3 = map2;
        String key$iv = itemLogCategory;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Data answer$iv = new Data();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Data)object;
    }

    private static final Data getTracker$lambda$7$lambda$5() {
        return new Data();
    }

    private static final List getTracker$lambda$7$lambda$6(Data it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.drawDisplay(it);
    }

    private static final Unit onQuestComplete$lambda$8(Data it) {
        Intrinsics.checkNotNullParameter(it, "it");
        long l = it.getSlayerCompletedCount();
        it.setSlayerCompletedCount(l + 1L);
        return Unit.INSTANCE;
    }

    private static final boolean drawDisplay$lambda$10$lambda$9(NEUInternalName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final Pair coinFormat$lambda$11(ItemTrackerData.TrackedItem item) {
        Intrinsics.checkNotNullParameter(item, "item");
        String mobKillCoinsFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, item.getTotalAmount(), false, 1, null);
        String text = " \u00a76Mob kill coins\u00a77: \u00a76" + mobKillCoinsFormat;
        String[] stringArray = new String[]{"\u00a77Killing mobs gives you coins (more with scavenger)", "\u00a77You got \u00a7e" + mobKillCoinsFormat + " \u00a77coins in total this way"};
        List<String> lore = CollectionsKt.listOf(stringArray);
        return TuplesKt.to(text, lore);
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonElement onConfigFix$lambda$14(JsonElement old) {
        Collection collection;
        Iterator $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(old, "old");
        Set set = old.getAsJsonObject().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "entrySet(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv = object.next();
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((JsonElement)it.getValue()).getAsJsonObject());
        }
        for (JsonObject data2 : (List)destination$iv$iv) {
            void $this$mapTo$iv$iv2;
            JsonObject items = data2.get("items").getAsJsonObject();
            Set set2 = items.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, "entrySet(...)");
            Iterable $this$map$iv2 = set2;
            boolean $i$f$map2 = false;
            object = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(((JsonElement)it.getValue()).getAsJsonObject());
            }
            for (JsonObject item : (List)destination$iv$iv2) {
                JsonElement oldValue = item.get("timesDropped");
                item.add("timesGained", oldValue);
            }
            JsonElement coinAmount = data2.get("mobKillCoins");
            JsonObject coins = new JsonObject();
            coins.add("internalName", (JsonElement)new JsonPrimitive("SKYBLOCK_COIN"));
            coins.add("timesDropped", (JsonElement)new JsonPrimitive((Number)1));
            coins.add("totalAmount", coinAmount);
            items.add("SKYBLOCK_COIN", (JsonElement)coins);
        }
        return old;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(SlayerProfitTracker.class, "autoSlayerBankPattern", "getAutoSlayerBankPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new SlayerProfitTracker();
        itemLogCategory = "";
        baseSlayerType = "";
        trackers = new LinkedHashMap();
        autoSlayerBankPattern$delegate = RepoPattern.Companion.pattern("slayer.autoslayer.bank.chat", "\u00a77Took (?<coins>.+) coins from your bank for auto-slayer\\.\\.\\.");
        allowedItems = MapsKt.emptyMap();
        coinFormat = SlayerProfitTracker::coinFormat$lambda$11;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerProfitTracker$Data;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData;", "<init>", "()V", "", "resetItems", "", "timesDropped", "", "", "getDescription", "(J)Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;", "item", "getCoinName", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/lang/String;", "getCoinDescription", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/util/List;", "slayerSpawnCost", "J", "getSlayerSpawnCost", "()J", "setSlayerSpawnCost", "(J)V", "slayerCompletedCount", "getSlayerCompletedCount", "setSlayerCompletedCount", "1.8.9"})
    public static final class Data
    extends ItemTrackerData {
        @Expose
        private long slayerSpawnCost;
        @Expose
        private long slayerCompletedCount;

        @Override
        public void resetItems() {
            this.slayerSpawnCost = 0L;
            this.slayerCompletedCount = 0L;
        }

        public final long getSlayerSpawnCost() {
            return this.slayerSpawnCost;
        }

        public final void setSlayerSpawnCost(long l) {
            this.slayerSpawnCost = l;
        }

        public final long getSlayerCompletedCount() {
            return this.slayerCompletedCount;
        }

        public final void setSlayerCompletedCount(long l) {
            this.slayerCompletedCount = l;
        }

        @Override
        @NotNull
        public List<String> getDescription(long timesDropped) {
            double percentage = (double)timesDropped / (double)this.slayerCompletedCount;
            String perBoss = LorenzUtils.INSTANCE.formatPercentage(RangesKt.coerceAtMost(percentage, 1.0));
            String[] stringArray = new String[]{"\u00a77Dropped \u00a7e" + NumberUtil.INSTANCE.addSeparators(timesDropped) + " \u00a77times.", "\u00a77Your drop rate: \u00a7c" + perBoss};
            return CollectionsKt.listOf(stringArray);
        }

        @Override
        @NotNull
        public String getCoinName(@NotNull ItemTrackerData.TrackedItem item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return "\u00a76Mob Kill Coins";
        }

        @Override
        @NotNull
        public List<String> getCoinDescription(@NotNull ItemTrackerData.TrackedItem item) {
            Intrinsics.checkNotNullParameter(item, "item");
            String mobKillCoinsFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, item.getTotalAmount(), false, 1, null);
            String[] stringArray = new String[]{"\u00a77Killing mobs gives you coins (more with scavenger).", "\u00a77You got \u00a76" + mobKillCoinsFormat + " coins \u00a77that way."};
            return CollectionsKt.listOf(stringArray);
        }
    }
}

