/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.slayer.SlayerConfig;
import at.hannibal2.skyhanni.events.EntityMaxHealthUpdateEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.features.combat.damageindicator.DamageIndicatorManager;
import at.hannibal2.skyhanni.features.dungeon.DungeonAPI;
import at.hannibal2.skyhanni.mixins.hooks.RenderLivingEntityHelper;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerMiniBossFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/EntityMaxHealthUpdateEvent;", "event", "", "onEntityHealthUpdate", "(Lat/hannibal2/skyhanni/events/EntityMaxHealthUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onWorldRender", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/slayer/SlayerConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/SlayerConfig;", "config", "", "Lnet/minecraft/entity/EntityCreature;", "miniBosses", "Ljava/util/List;", "SlayerMiniBossType", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSlayerMiniBossFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlayerMiniBossFeatures.kt\nat/hannibal2/skyhanni/features/slayer/SlayerMiniBossFeatures\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,85:1\n12541#2,2:86\n*S KotlinDebug\n*F\n+ 1 SlayerMiniBossFeatures.kt\nat/hannibal2/skyhanni/features/slayer/SlayerMiniBossFeatures\n*L\n42#1:86,2\n*E\n"})
public final class SlayerMiniBossFeatures {
    @NotNull
    public static final SlayerMiniBossFeatures INSTANCE = new SlayerMiniBossFeatures();
    @NotNull
    private static List<? extends EntityCreature> miniBosses = CollectionsKt.emptyList();

    private SlayerMiniBossFeatures() {
    }

    private final SlayerConfig getConfig() {
        return SkyHanniMod.feature.slayer;
    }

    @SubscribeEvent
    public final void onEntityHealthUpdate(@NotNull EntityMaxHealthUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        EntityLivingBase entityLivingBase = event.getEntity();
        EntityCreature entityCreature = entityLivingBase instanceof EntityCreature ? (EntityCreature)entityLivingBase : null;
        if (entityCreature == null) {
            return;
        }
        EntityCreature entity = entityCreature;
        if (DamageIndicatorManager.INSTANCE.isBoss((EntityLivingBase)entity)) {
            return;
        }
        int maxHealth = event.getMaxHealth();
        for (SlayerMiniBossType bossType : SlayerMiniBossType.getEntries()) {
            boolean bl;
            block5: {
                int[] $this$any$iv = bossType.getHealth();
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    int element$iv;
                    int it = element$iv = $this$any$iv[j];
                    boolean bl2 = false;
                    if (!EntityUtils.INSTANCE.hasMaxHealth((EntityLivingBase)entity, it, true, maxHealth)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (!bl || !Intrinsics.areEqual(bossType.getClazz(), entity.getClass())) continue;
            miniBosses = CollectionUtils.INSTANCE.editCopy(miniBosses, arg_0 -> SlayerMiniBossFeatures.onEntityHealthUpdate$lambda$1(entity, arg_0));
            RenderLivingEntityHelper.INSTANCE.setEntityColorWithNoHurtTime((EntityLivingBase)entity, ColorUtils.INSTANCE.withAlpha(LorenzColor.AQUA.toColor(), 127), SlayerMiniBossFeatures::onEntityHealthUpdate$lambda$2);
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        miniBosses = CollectionsKt.emptyList();
    }

    @SubscribeEvent
    public final void onWorldRender(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.getConfig().slayerMinibossLine) {
            return;
        }
        for (EntityCreature entityCreature : miniBosses) {
            if (entityCreature.func_110143_aJ() <= 0.0f || entityCreature.field_70128_L || LocationUtils.INSTANCE.distanceToPlayer((Entity)entityCreature) > 10.0) continue;
            RenderUtils.INSTANCE.draw3DLine(event, RenderUtils.INSTANCE.exactPlayerEyeLocation(event), LorenzVec.add$default(LorenzVecKt.getLorenzVec((Entity)entityCreature), 0, 1, 0, 5, null), LorenzColor.AQUA.toColor(), this.getConfig().slayerMinibossLineWidth, true);
        }
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && !DungeonAPI.INSTANCE.inDungeon() && !LorenzUtils.INSTANCE.getInKuudraFight();
    }

    private static final Unit onEntityHealthUpdate$lambda$1(EntityCreature $entity, List $this$editCopy) {
        Intrinsics.checkNotNullParameter($entity, "$entity");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        $this$editCopy.add($entity);
        return Unit.INSTANCE;
    }

    private static final boolean onEntityHealthUpdate$lambda$2() {
        return SlayerMiniBossFeatures.INSTANCE.getConfig().slayerMinibossHighlight;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\b\u0002\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\u0012\n\u0010\u0007\u001a\u00020\u0005\"\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001f\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\r\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014\u00a8\u0006\u0015"}, d2={"Lat/hannibal2/skyhanni/features/slayer/SlayerMiniBossFeatures$SlayerMiniBossType;", "", "Ljava/lang/Class;", "Lnet/minecraft/entity/EntityCreature;", "clazz", "", "", "health", "<init>", "(Ljava/lang/String;ILjava/lang/Class;[I)V", "Ljava/lang/Class;", "getClazz", "()Ljava/lang/Class;", "[I", "getHealth", "()[I", "REVENANT", "TARANTULA", "SVEN", "VOIDLING", "INFERNAL", "1.8.9"})
    public static final class SlayerMiniBossType
    extends Enum<SlayerMiniBossType> {
        @NotNull
        private final Class<? extends EntityCreature> clazz;
        @NotNull
        private final int[] health;
        public static final /* enum */ SlayerMiniBossType REVENANT;
        public static final /* enum */ SlayerMiniBossType TARANTULA;
        public static final /* enum */ SlayerMiniBossType SVEN;
        public static final /* enum */ SlayerMiniBossType VOIDLING;
        public static final /* enum */ SlayerMiniBossType INFERNAL;
        private static final /* synthetic */ SlayerMiniBossType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SlayerMiniBossType(Class<? extends EntityCreature> clazz, int ... health) {
            this.clazz = clazz;
            this.health = health;
        }

        @NotNull
        public final Class<? extends EntityCreature> getClazz() {
            return this.clazz;
        }

        @NotNull
        public final int[] getHealth() {
            return this.health;
        }

        public static SlayerMiniBossType[] values() {
            return (SlayerMiniBossType[])$VALUES.clone();
        }

        public static SlayerMiniBossType valueOf(String value) {
            return Enum.valueOf(SlayerMiniBossType.class, value);
        }

        @NotNull
        public static EnumEntries<SlayerMiniBossType> getEntries() {
            return $ENTRIES;
        }

        static {
            int[] nArray = new int[]{24000, 90000, 360000, 600000, 2400000};
            REVENANT = new SlayerMiniBossType(EntityZombie.class, nArray);
            nArray = new int[]{54000, 144000, 576000};
            TARANTULA = new SlayerMiniBossType(EntitySpider.class, nArray);
            nArray = new int[]{45000, 120000, 480000};
            SVEN = new SlayerMiniBossType(EntityWolf.class, nArray);
            nArray = new int[]{8400000, 17500000, 52500000};
            VOIDLING = new SlayerMiniBossType(EntityEnderman.class, nArray);
            nArray = new int[]{12000000, 25000000, 75000000};
            INFERNAL = new SlayerMiniBossType(EntityBlaze.class, nArray);
            $VALUES = slayerMiniBossTypeArray = new SlayerMiniBossType[]{SlayerMiniBossType.REVENANT, SlayerMiniBossType.TARANTULA, SlayerMiniBossType.SVEN, SlayerMiniBossType.VOIDLING, SlayerMiniBossType.INFERNAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

