/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.rift.area.stillgorechateau;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.rift.area.stillgorechateau.EffigiesConfig;
import at.hannibal2.skyhanni.data.jsonobjects.repo.RiftEffigiesJson;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.RawScoreboardUpdateEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.rift.RiftAPI;
import at.hannibal2.skyhanni.features.rift.area.stillgorechateau.RiftBloodEffigies$onSecondPassed$;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001e\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"R\u001c\u0010'\u001a\n $*\u0004\u0018\u00010#0#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\"\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R\u001b\u00106\u001a\u0002018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105R\u001b\u00109\u001a\u0002018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00103\u001a\u0004\b8\u00105\u00a8\u0006:"}, d2={"Lat/hannibal2/skyhanni/features/rift/area/stillgorechateau/RiftBloodEffigies;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "event", "", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "", "", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "cleanMap", "()Ljava/util/Map;", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/RawScoreboardUpdateEvent;", "onScoreboardChange", "(Lat/hannibal2/skyhanni/events/RawScoreboardUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/rift/area/stillgorechateau/EffigiesConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/rift/area/stillgorechateau/EffigiesConfig;", "config", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "locations", "Ljava/util/List;", "effigiesTimes", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "effigiesTimerPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getEffigiesTimerPattern", "()Ljava/util/regex/Pattern;", "effigiesTimerPattern", "heartsPattern$delegate", "getHeartsPattern", "heartsPattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nRiftBloodEffigies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiftBloodEffigies.kt\nat/hannibal2/skyhanni/features/rift/area/stillgorechateau/RiftBloodEffigies\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 4 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 7 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,171:1\n1279#2,2:172\n1293#2,4:174\n295#2,2:185\n2341#2,14:194\n12#3,7:178\n8#4:187\n8#4:192\n1#5:188\n1#5:193\n144#6:189\n172#6:190\n477#7:191\n*S KotlinDebug\n*F\n+ 1 RiftBloodEffigies.kt\nat/hannibal2/skyhanni/features/rift/area/stillgorechateau/RiftBloodEffigies\n*L\n55#1:172,2\n55#1:174,4\n86#1:185,2\n118#1:194,14\n75#1:178,7\n87#1:187\n117#1:192\n87#1:188\n117#1:193\n116#1:189\n116#1:190\n116#1:191\n*E\n"})
public final class RiftBloodEffigies {
    @NotNull
    public static final RiftBloodEffigies INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static List<LorenzVec> locations;
    @NotNull
    private static Map<Integer, SimpleTimeMark> effigiesTimes;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern effigiesTimerPattern$delegate;
    @NotNull
    private static final RepoPattern heartsPattern$delegate;

    private RiftBloodEffigies() {
    }

    private final EffigiesConfig getConfig() {
        return RiftAPI.INSTANCE.getConfig().area.stillgoreChateau.bloodEffigies;
    }

    private final Pattern getEffigiesTimerPattern() {
        return (Pattern)effigiesTimerPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @NotNull
    public final Pattern getHeartsPattern() {
        return (Pattern)heartsPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        effigiesTimes = this.cleanMap();
    }

    private final Map<Integer, SimpleTimeMark> cleanMap() {
        Iterable $this$associateWith$iv = new IntRange(0, 5);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            int n = ((Number)element$iv$iv).intValue();
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            SimpleTimeMark simpleTimeMark = SimpleTimeMark.box-impl(SimpleTimeMark.Companion.farPast());
            map2.put(t, simpleTimeMark);
        }
        return result$iv;
    }

    @SubscribeEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.title("Rift Blood Effigies");
        if (!this.isEnabled()) {
            event.addIrrelevant("Not in Stillgore Ch\u00e2teau or not enabled ");
            return;
        }
        event.addData(RiftBloodEffigies::onDebugDataCollect$lambda$1);
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        RiftEffigiesJson riftEffigiesJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "RiftEffigies";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            riftEffigiesJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, RiftEffigiesJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        List<LorenzVec> newLocations = riftEffigiesJson.getLocations();
        if (newLocations.size() != 6) {
            throw new IllegalStateException(("Invalid rift effigies size: " + newLocations.size() + " (expected 6)").toString());
        }
        locations = newLocations;
    }

    @SubscribeEvent
    public final void onScoreboardChange(@NotNull RawScoreboardUpdateEvent event) {
        String string2;
        Object v0;
        block8: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!this.isEnabled()) {
                return;
            }
            Iterable $this$firstOrNull$iv = event.getRawScoreboard();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default(it, "Effigies:", false, 2, null)) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        String string3 = v0;
        if (string3 == null) {
            return;
        }
        String line = string3;
        RegexUtils $i$f$firstOrNull = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getHeartsPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(line);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onScoreboardChange_u24lambda_u243 = it$iv;
            boolean bl2 = false;
            string2 = $this$onScoreboardChange_u24lambda_u243.group("hearts");
        } else {
            string2 = null;
        }
        if (string2 == null) {
            return;
        }
        String hearts = string2;
        Object object = new String[]{"\u00a7"};
        List split = CollectionsKt.drop(StringsKt.split$default((CharSequence)hearts, (String[])object, false, 0, 6, null), 1);
        object = ((Iterable)split).iterator();
        int n = 0;
        while (object.hasNext()) {
            int index = n++;
            String s = (String)object.next();
            SimpleTimeMark simpleTimeMark = effigiesTimes.get(index);
            Intrinsics.checkNotNull(simpleTimeMark);
            long time = simpleTimeMark.unbox-impl();
            if (!SimpleTimeMark.isInPast-impl(time)) continue;
            if (Intrinsics.areEqual(s, "7")) {
                if (!SimpleTimeMark.isFarPast-impl(time)) continue;
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Effigy #" + (index + 1) + " respawned!", false, null, 6, null);
                effigiesTimes = CollectionUtils.INSTANCE.editCopy(effigiesTimes, arg_0 -> RiftBloodEffigies.onScoreboardChange$lambda$4(index, arg_0));
                continue;
            }
            if (!SimpleTimeMark.isFarPast-impl(time)) continue;
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Effigy #" + (index + 1) + " is broken!", false, null, 6, null);
            long endTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration(20, DurationUnit.MINUTES));
            effigiesTimes = CollectionUtils.INSTANCE.editCopy(effigiesTimes, arg_0 -> RiftBloodEffigies.onScoreboardChange$lambda$5(index, endTime, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        RegexUtils location$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        EntityUtils entityUtils = EntityUtils.INSTANCE;
        LorenzVec lorenzVec = LocationUtils.INSTANCE.playerLocation();
        double radius$iv2 = 6.0;
        boolean $i$f$getEntitiesNearby = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$getEntities = false;
        Sequence<Entity> $this$filterIsInstance$iv$iv$iv = this_$iv$iv.getAllEntities();
        boolean $i$f$filterIsInstance = false;
        Sequence<Entity> sequence = SequencesKt.filter($this$filterIsInstance$iv$iv$iv, onSecondPassed$$inlined$getEntitiesNearby$1.INSTANCE);
        Intrinsics.checkNotNull(sequence, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Iterator<Entity> iterator2 = SequencesKt.filter(sequence, (Function1)new Function1<EntityArmorStand, Boolean>((LorenzVec)((Object)location$iv), radius$iv2){
            final /* synthetic */ LorenzVec $location;
            final /* synthetic */ double $radius;
            {
                this.$location = $location;
                this.$radius = $radius;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Boolean invoke(Entity it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return LocationUtils.INSTANCE.distanceTo(it, this.$location) < this.$radius;
            }
        }).iterator();
        while (iterator2.hasNext()) {
            LorenzVec nearest;
            Object v1;
            String text$iv;
            void $this$matchMatcher$iv;
            EntityArmorStand entity = (EntityArmorStand)iterator2.next();
            location$iv = RegexUtils.INSTANCE;
            Pattern radius$iv2 = this.getEffigiesTimerPattern();
            Intrinsics.checkNotNullExpressionValue(entity.func_70005_c_(), "getName(...)");
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
            boolean bl = false;
            if (!it$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onSecondPassed_u24lambda_u248 = it$iv;
            boolean bl2 = false;
            Iterable $this$minByOrNull$iv = locations;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    LorenzVec it = (LorenzVec)minElem$iv;
                    boolean bl3 = false;
                    double minValue$iv = it.distanceSq(LorenzVecKt.getLorenzVec((Entity)entity));
                    do {
                        Object e$iv = iterator$iv.next();
                        LorenzVec it2 = (LorenzVec)e$iv;
                        $i$a$-minByOrNull-RiftBloodEffigies$onSecondPassed$1$nearest$1 = false;
                        double v$iv = it2.distanceSq(LorenzVecKt.getLorenzVec((Entity)entity));
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            if ((LorenzVec)v1 == null) {
                return;
            }
            int index = locations.indexOf(nearest);
            String string2 = $this$onSecondPassed_u24lambda_u248.group("time");
            Intrinsics.checkNotNull(string2);
            long time = TimeUtils.INSTANCE.getDuration-5sfh64U(string2);
            effigiesTimes = CollectionUtils.INSTANCE.editCopy(effigiesTimes, arg_0 -> RiftBloodEffigies.onSecondPassed$lambda$8$lambda$7(index, time, arg_0));
        }
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Iterator iterator2 = ((Iterable)locations).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            LorenzVec location = (LorenzVec)iterator2.next();
            String name2 = "Effigy #" + (index + 1);
            SimpleTimeMark simpleTimeMark = effigiesTimes.get(index);
            Intrinsics.checkNotNull(simpleTimeMark);
            long duration = simpleTimeMark.unbox-impl();
            if (SimpleTimeMark.isFarPast-impl(duration)) {
                if (this.getConfig().unknownTime) {
                    RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, location, LorenzColor.GRAY.toColor(), true, false, 0.0, 0.0, 0.0, 0.0f, false, 504, null);
                    RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, location, "\u00a77Unknown Time (" + name2 + ')', 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
                    continue;
                }
            } else {
                if (SimpleTimeMark.isFarPast-impl(duration)) {
                    RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, location, LorenzColor.RED.toColor(), true, false, 0.0, 0.0, 0.0, 0.0f, false, 504, null);
                    RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, location, "\u00a7cBreak " + name2 + '!', 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
                    continue;
                }
                long timeUntil = SimpleTimeMark.timeUntil-UwyO8pc(duration);
                if (this.getConfig().respawningSoon) {
                    if (Duration.compareTo-LRDsOJo(timeUntil, DurationKt.toDuration(this.getConfig().respwningSoonTime, DurationUnit.MINUTES)) <= 0) {
                        RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, location, LorenzColor.YELLOW.toColor(), true, false, 0.0, 0.0, 0.0, 0.0f, false, 504, null);
                        String time = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, timeUntil, null, false, false, 0, false, 31, null);
                        RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, location, "\u00a7e" + name2 + " is respawning \u00a7b" + time, 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
                        continue;
                    }
                }
            }
            if (!(LocationUtils.INSTANCE.distanceToPlayer(location) < 5.0)) continue;
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, location, "\u00a77" + name2, 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    public final boolean isEnabled() {
        return RiftAPI.INSTANCE.inRift() && this.getConfig().enabled && RiftAPI.INSTANCE.inStillgoreChateau();
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 9, "rift.area.stillgoreChateauConfig", "rift.area.stillgoreChateau", null, 8, null);
    }

    private static final Unit onDebugDataCollect$lambda$1(List $this$addData) {
        Intrinsics.checkNotNullParameter($this$addData, "$this$addData");
        for (Map.Entry<Integer, SimpleTimeMark> entry : effigiesTimes.entrySet()) {
            int number = ((Number)entry.getKey()).intValue();
            long duration = entry.getValue().unbox-impl();
            String time = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, SimpleTimeMark.timeUntil-UwyO8pc(duration), null, false, false, 0, false, 31, null);
            $this$addData.add(number + ": " + time + " (" + SimpleTimeMark.toString-impl(duration) + ')');
        }
        return Unit.INSTANCE;
    }

    private static final Unit onScoreboardChange$lambda$4(int $index, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        Integer n = $index;
        $this$editCopy.put(n, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.farPast()));
        return Unit.INSTANCE;
    }

    private static final Unit onScoreboardChange$lambda$5(int $index, long $endTime, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        Integer n = $index;
        SimpleTimeMark simpleTimeMark = SimpleTimeMark.box-impl($endTime);
        $this$editCopy.put(n, simpleTimeMark);
        return Unit.INSTANCE;
    }

    private static final Unit onSecondPassed$lambda$8$lambda$7(int $index, long $time, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        Integer n = $index;
        $this$editCopy.put(n, SimpleTimeMark.box-impl(SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), $time)));
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(RiftBloodEffigies.class, "effigiesTimerPattern", "getEffigiesTimerPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(RiftBloodEffigies.class, "heartsPattern", "getHeartsPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new RiftBloodEffigies();
        locations = CollectionsKt.emptyList();
        effigiesTimes = INSTANCE.cleanMap();
        patternGroup = RepoPattern.Companion.group("rift.area.stillgore.effegies");
        effigiesTimerPattern$delegate = patternGroup.pattern("respawn", "\u00a7eRespawn \u00a7c(?<time>.*) \u00a77\\(or click!\\)");
        heartsPattern$delegate = patternGroup.pattern("heart", "Effigies: (?<hearts>((\u00a7[7c])?\u29ef)*)");
    }
}

