/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest;

import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ReputationQuest;
import at.hannibal2.skyhanni.data.model.TabWidget;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.features.nether.kuudra.KuudraTier;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.DailyQuestHelper;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.DojoQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.FetchQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.KuudraQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.MiniBossQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.ProgressQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.Quest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.QuestState;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.RescueMissionQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.TrophyFishQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.UnknownQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.miniboss.CrimsonMiniBoss;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.TabListData;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\"\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010&\u001a\u00020\u00062\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010,R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010-\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/QuestLoader;", "", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/DailyQuestHelper;", "dailyQuestHelper", "<init>", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/DailyQuestHelper;)V", "", "loadFromTabList", "()V", "", "line", "readQuest", "(Ljava/lang/String;)V", "name", "", "green", "", "needAmount", "checkQuest", "(Ljava/lang/String;ZI)V", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/QuestState;", "state", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/Quest;", "addQuest", "(Ljava/lang/String;Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/QuestState;I)Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/Quest;", "getQuestByName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/Quest;", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "checkInventory", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "quest", "Lnet/minecraft/item/ItemStack;", "stack", "fixMinibossAmount", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/Quest;Lnet/minecraft/item/ItemStack;)V", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;", "storage", "loadConfig", "(Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;)V", "text", "hasGreatSpookLine", "(Ljava/lang/String;)Z", "element", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/Quest;)V", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/DailyQuestHelper;", "Companion", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nQuestLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestLoader.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/QuestLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n295#2,2:244\n1755#2,3:246\n1755#2,3:249\n1755#2,3:254\n8#3:252\n1#4:253\n*S KotlinDebug\n*F\n+ 1 QuestLoader.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/QuestLoader\n*L\n145#1:244,2\n159#1:246,3\n165#1:249,3\n201#1:254,3\n182#1:252\n182#1:253\n*E\n"})
public final class QuestLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DailyQuestHelper dailyQuestHelper;
    @NotNull
    private static final Map<String, Pair<String, ReputationQuest>> quests = new LinkedHashMap();

    public QuestLoader(@NotNull DailyQuestHelper dailyQuestHelper) {
        Intrinsics.checkNotNullParameter(dailyQuestHelper, "dailyQuestHelper");
        this.dailyQuestHelper = dailyQuestHelper;
    }

    public final void loadFromTabList() {
        this.dailyQuestHelper.setGreatSpook(false);
        int found = 0;
        for (String line : TabWidget.FACTION_QUESTS.getLines()) {
            this.readQuest(line);
            ++found;
            if (!this.dailyQuestHelper.getGreatSpook()) continue;
            return;
        }
        this.dailyQuestHelper.getReputationHelper().setTabListQuestsMissing(found == 0);
        this.dailyQuestHelper.update();
    }

    private final void readQuest(String line) {
        if (!RegexUtils.INSTANCE.matches(this.dailyQuestHelper.getReputationHelper().getTabListQuestPattern(), line)) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)line, "The Great Spook", false, 2, null)) {
            this.dailyQuestHelper.setGreatSpook(true);
            this.dailyQuestHelper.update();
            return;
        }
        String string2 = line.substring(3);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String text = string2;
        boolean green = StringsKt.startsWith$default(text, "\u00a7a", false, 2, null);
        String string3 = text.substring(2);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        text = string3;
        int amount = 0;
        String name2 = null;
        if (StringsKt.contains$default((CharSequence)text, " \u00a7r\u00a78x", false, 2, null)) {
            String[] stringArray = new String[]{" \u00a7r\u00a78x"};
            List split = StringsKt.split$default((CharSequence)text, stringArray, false, 0, 6, null);
            name2 = (String)split.get(0);
            amount = Integer.parseInt((String)split.get(1));
        } else {
            name2 = text;
            amount = 1;
        }
        this.checkQuest(name2, green, amount);
    }

    private final void checkQuest(String name2, boolean green, int needAmount) {
        Quest oldQuest = this.getQuestByName(name2);
        if (oldQuest != null) {
            if (green && oldQuest.getState() != QuestState.READY_TO_COLLECT && oldQuest.getState() != QuestState.COLLECTED) {
                oldQuest.setState(QuestState.READY_TO_COLLECT);
                this.dailyQuestHelper.update();
                ChatUtils.INSTANCE.debug("Reputation Helper: Tab-List updated " + oldQuest.getInternalName() + " (This should not happen)");
            }
            return;
        }
        QuestState state = green ? QuestState.READY_TO_COLLECT : QuestState.NOT_ACCEPTED;
        this.dailyQuestHelper.update();
        this.addQuest(this.addQuest(name2, state, needAmount));
    }

    private final Quest addQuest(String name2, QuestState state, int needAmount) {
        String dojoGoal;
        String questName;
        block20: {
            for (CrimsonMiniBoss miniBoss : this.dailyQuestHelper.getReputationHelper().getMiniBossHelper().getMiniBosses()) {
                if (!Intrinsics.areEqual(name2, miniBoss.getDisplayName())) continue;
                return new MiniBossQuest(miniBoss, state, needAmount);
            }
            for (KuudraTier kuudraTier : this.dailyQuestHelper.getReputationHelper().getKuudraBossHelper().getKuudraTiers()) {
                String kuudraName = kuudraTier.getName();
                if (!Intrinsics.areEqual(name2, "Kill Kuudra " + kuudraName + " Tier")) continue;
                return new KuudraQuest(kuudraTier, state);
            }
            questName = name2;
            dojoGoal = "";
            if (StringsKt.contains$default((CharSequence)name2, " Rank ", false, 2, null)) {
                String[] stringArray = new String[]{" Rank "};
                List split = StringsKt.split$default((CharSequence)name2, stringArray, false, 0, 6, null);
                questName = (String)split.get(0);
                dojoGoal = (String)split.get(1);
            }
            if (!quests.containsKey(questName)) break block20;
            Pair<String, ReputationQuest> pair = quests.get(questName);
            if (pair == null) {
                return new UnknownQuest(name2);
            }
            Pair<String, ReputationQuest> questInfo = pair;
            List<Double> locationInfo = questInfo.getSecond().getLocation();
            LorenzVec location = this.dailyQuestHelper.getReputationHelper().readLocationData(locationInfo);
            NEUInternalName displayItem = questInfo.getSecond().getItem();
            switch (questInfo.getFirst()) {
                case "FISHING": {
                    return new TrophyFishQuest(name2, location, displayItem, state, needAmount);
                }
                case "RESCUE": {
                    return new RescueMissionQuest(displayItem, location, state);
                }
                case "FETCH": {
                    return new FetchQuest(name2, location, displayItem, state, needAmount);
                }
                case "DOJO": {
                    return new DojoQuest(questName, location, displayItem, dojoGoal, state);
                }
            }
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to("name", name2), TuplesKt.to("questName", questName), TuplesKt.to("dojoGoal", dojoGoal), TuplesKt.to("state", state), TuplesKt.to("needAmount", needAmount), TuplesKt.to("tablist", TabListData.INSTANCE.getTabList())};
        ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Unknown Crimson Isle quest: '" + name2 + '\'', "Unknown quest detected", pairArray, false, false, false, null, 120, null);
        return new UnknownQuest(name2);
    }

    private final Quest getQuestByName(String name2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.dailyQuestHelper.getQuests();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Quest it = (Quest)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getInternalName(), name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void checkInventory(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        boolean inMageRegion = Intrinsics.areEqual(LorenzUtils.INSTANCE.getSkyBlockArea(), "Community Center");
        boolean inBarbarianRegion = Intrinsics.areEqual(LorenzUtils.INSTANCE.getSkyBlockArea(), "Dragontail");
        if (!inMageRegion && !inBarbarianRegion) {
            return;
        }
        String name2 = event.getInventoryName();
        for (Quest quest : this.dailyQuestHelper.getQuests()) {
            boolean accepted;
            boolean bl;
            ItemStack stack;
            block11: {
                boolean completed;
                block10: {
                    boolean bl2;
                    String categoryName = quest.getCategory().name();
                    if (!StringsKt.equals(categoryName, name2, true) || event.getInventoryItems().get(22) == null) continue;
                    Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.contains$default((CharSequence)it, "Completed!", false, 2, null)) continue;
                            bl2 = true;
                            break block10;
                        }
                        bl2 = completed = false;
                    }
                }
                if (completed && quest.getState() != QuestState.COLLECTED) {
                    quest.setState(QuestState.COLLECTED);
                    this.dailyQuestHelper.update();
                }
                Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl4 = false;
                        if (!StringsKt.contains$default((CharSequence)it, "Click to start!", false, 2, null)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            boolean bl5 = accepted = !bl;
            if (accepted && quest.getState() == QuestState.NOT_ACCEPTED) {
                quest.setState(QuestState.ACCEPTED);
                this.dailyQuestHelper.update();
            }
            if (!Intrinsics.areEqual(name2, "Miniboss")) continue;
            this.fixMinibossAmount(quest, stack);
        }
    }

    private final void fixMinibossAmount(Quest quest, ItemStack stack) {
        if (!(quest instanceof MiniBossQuest)) {
            return;
        }
        int storedAmount = ((MiniBossQuest)quest).getNeedAmount();
        if (storedAmount != 1) {
            return;
        }
        for (String line : ItemUtils.INSTANCE.getLore(stack)) {
            Integer n;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = this.dailyQuestHelper.getMinibossAmountPattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(line);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$fixMinibossAmount_u24lambda_u243 = it$iv;
                boolean bl2 = false;
                String string2 = $this$fixMinibossAmount_u24lambda_u243.group("amount");
                Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                n = Integer.parseInt(string2);
            } else {
                n = null;
            }
            if (n == null) {
                continue;
            }
            int realAmount = n;
            if (storedAmount == realAmount) continue;
            ChatUtils.INSTANCE.debug("Wrong amount detected! realAmount: " + realAmount + ", storedAmount: " + storedAmount);
            MiniBossQuest newQuest = new MiniBossQuest(((MiniBossQuest)quest).getMiniBoss(), quest.getState(), realAmount);
            newQuest.setHaveAmount(((MiniBossQuest)quest).getHaveAmount());
            DelayedRun.INSTANCE.runNextTick(() -> QuestLoader.fixMinibossAmount$lambda$4(this, quest, newQuest));
        }
    }

    public final void loadConfig(@NotNull ProfileSpecificStorage.CrimsonIsleStorage storage2) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter(storage2, "storage");
            if (this.dailyQuestHelper.getGreatSpook()) {
                return;
            }
            List<String> list = storage2.quests;
            Intrinsics.checkNotNullExpressionValue(list, "quests");
            Iterable $this$any$iv = CollectionsKt.toList((Iterable)list);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it);
                    if (!this.hasGreatSpookLine(it)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            this.dailyQuestHelper.setGreatSpook(true);
            return;
        }
        List<String> list = storage2.quests;
        Intrinsics.checkNotNullExpressionValue(list, "quests");
        for (String text : CollectionsKt.toList((Iterable)list)) {
            Object element$iv;
            Intrinsics.checkNotNull(text);
            element$iv = new String[]{":"};
            List split = StringsKt.split$default((CharSequence)text, element$iv, false, 0, 6, null);
            String name2 = (String)split.get(0);
            QuestState state = QuestState.valueOf((String)split.get(1));
            int needAmount = Integer.parseInt((String)split.get(2));
            Quest quest = this.addQuest(name2, state, needAmount);
            if (quest instanceof ProgressQuest && split.size() == 4) {
                try {
                    int haveAmount = Integer.parseInt((String)split.get(3));
                    ((ProgressQuest)quest).setHaveAmount(haveAmount);
                }
                catch (IndexOutOfBoundsException e) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to("text", text)};
                    ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error loading Crimson Isle Quests from config.", pairArray, false, false, false, 56, null);
                }
            }
            this.addQuest(quest);
        }
    }

    private final boolean hasGreatSpookLine(String text) {
        return StringsKt.contains$default((CharSequence)text, "The Great Spook", false, 2, null) ? true : (StringsKt.contains$default((CharSequence)text, " Days", false, 2, null) ? true : (StringsKt.contains$default((CharSequence)text, "Fear: \u00a7r", false, 2, null) ? true : StringsKt.contains$default((CharSequence)text, "Primal Fears", false, 2, null)));
    }

    private final void addQuest(Quest element) {
        this.dailyQuestHelper.getQuests().add(element);
        if (this.dailyQuestHelper.getQuests().size() > 5) {
            this.dailyQuestHelper.getReputationHelper().reset();
        }
    }

    private static final Unit fixMinibossAmount$lambda$4(QuestLoader this$0, Quest $quest, MiniBossQuest $newQuest) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($quest, "$quest");
        Intrinsics.checkNotNullParameter($newQuest, "$newQuest");
        this$0.dailyQuestHelper.getQuests().remove($quest);
        this$0.dailyQuestHelper.getQuests().add($newQuest);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Fixed wrong miniboss amount from tab list.", false, null, 6, null);
        this$0.dailyQuestHelper.update();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u00020\t2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bR/\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/QuestLoader$Companion;", "", "<init>", "()V", "", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/ReputationQuest;", "data", "questType", "", "loadQuests", "(Ljava/util/Map;Ljava/lang/String;)V", "", "Lkotlin/Pair;", "quests", "Ljava/util/Map;", "getQuests", "()Ljava/util/Map;", "1.8.9"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Pair<String, ReputationQuest>> getQuests() {
            return quests;
        }

        public final void loadQuests(@NotNull Map<String, ReputationQuest> data2, @NotNull String questType) {
            Intrinsics.checkNotNullParameter(data2, "data");
            Intrinsics.checkNotNullParameter(questType, "questType");
            for (Map.Entry<String, ReputationQuest> entry : data2.entrySet()) {
                String questName = entry.getKey();
                ReputationQuest questInfo = entry.getValue();
                this.getQuests().put(questName, new Pair<String, ReputationQuest>(questType, questInfo));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

