/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.visualwords;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigFileType;
import at.hannibal2.skyhanni.config.enums.OutsideSbFeature;
import at.hannibal2.skyhanni.config.features.gui.ModifyWordsConfig;
import at.hannibal2.skyhanni.events.HypixelJoinEvent;
import at.hannibal2.skyhanni.features.misc.visualwords.VisualWord;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeLimitedCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\u001c\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R.\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/features/misc/visualwords/ModifyVisualWords;", "", "<init>", "()V", "", "originalText", "modifyText", "(Ljava/lang/String;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/HypixelJoinEvent;", "event", "", "onHypixelJoin", "(Lat/hannibal2/skyhanni/events/HypixelJoinEvent;)V", "Lat/hannibal2/skyhanni/config/features/gui/ModifyWordsConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/gui/ModifyWordsConfig;", "config", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "textCache", "Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "getTextCache", "()Lat/hannibal2/skyhanni/utils/TimeLimitedCache;", "setTextCache", "(Lat/hannibal2/skyhanni/utils/TimeLimitedCache;)V", "", "Lat/hannibal2/skyhanni/features/misc/visualwords/VisualWord;", "modifiedWords", "Ljava/util/List;", "getModifiedWords", "()Ljava/util/List;", "setModifiedWords", "(Ljava/util/List;)V", "Lkotlin/text/Regex;", "reverseRegex", "Lkotlin/text/Regex;", "getReverseRegex", "()Lkotlin/text/Regex;", "1.8.9"})
public final class ModifyVisualWords {
    @NotNull
    public static final ModifyVisualWords INSTANCE = new ModifyVisualWords();
    @NotNull
    private static TimeLimitedCache<String, String> textCache = new TimeLimitedCache(DurationKt.toDuration(5, DurationUnit.MINUTES), null, 2, null);
    @NotNull
    private static List<VisualWord> modifiedWords = new ArrayList();
    @NotNull
    private static final Regex reverseRegex = new Regex("(\u00a7.|^|[\\s:()+-])([^\u00a7\\s:()+-]*)");

    private ModifyVisualWords() {
    }

    private final ModifyWordsConfig getConfig() {
        return SkyHanniMod.feature.gui.modifyWords;
    }

    @NotNull
    public final TimeLimitedCache<String, String> getTextCache() {
        return textCache;
    }

    public final void setTextCache(@NotNull TimeLimitedCache<String, String> timeLimitedCache) {
        Intrinsics.checkNotNullParameter(timeLimitedCache, "<set-?>");
        textCache = timeLimitedCache;
    }

    @NotNull
    public final List<VisualWord> getModifiedWords() {
        return modifiedWords;
    }

    public final void setModifiedWords(@NotNull List<VisualWord> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        modifiedWords = list;
    }

    @NotNull
    public final Regex getReverseRegex() {
        return reverseRegex;
    }

    @Nullable
    public final String modifyText(@Nullable String originalText) {
        Ref.ObjectRef modifiedText = new Ref.ObjectRef();
        String string2 = originalText;
        if (string2 == null) {
            return null;
        }
        modifiedText.element = string2;
        if (!LorenzUtils.INSTANCE.getOnHypixel()) {
            return originalText;
        }
        if (!this.getConfig().enabled) {
            return originalText;
        }
        if (!LorenzUtils.INSTANCE.getInSkyBlock() && !OutsideSbFeature.MODIFY_VISUAL_WORDS.isSelected()) {
            return originalText;
        }
        if (modifiedWords.isEmpty()) {
            List<VisualWord> list = SkyHanniMod.Companion.getVisualWordsData().modifiedWords;
            Intrinsics.checkNotNullExpressionValue(list, "modifiedWords");
            modifiedWords.addAll((Collection<VisualWord>)list);
        }
        return textCache.getOrPut(originalText, () -> ModifyVisualWords.modifyText$lambda$0(originalText, modifiedText));
    }

    @SubscribeEvent
    public final void onHypixelJoin(@NotNull HypixelJoinEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        List<VisualWord> oldModifiedWords = SkyHanniMod.feature.storage.modifiedWords;
        Intrinsics.checkNotNull(oldModifiedWords);
        if (!((Collection)oldModifiedWords).isEmpty()) {
            SkyHanniMod.Companion.getVisualWordsData().modifiedWords = oldModifiedWords;
            SkyHanniMod.feature.storage.modifiedWords = CollectionsKt.emptyList();
            SkyHanniMod.Companion.getConfigManager().saveConfig(ConfigFileType.VISUAL_WORDS, "Migrate visual words");
        }
    }

    private static final String modifyText$lambda$0(String $originalText, Ref.ObjectRef $modifiedText) {
        Intrinsics.checkNotNullParameter($modifiedText, "$modifiedText");
        if (StringsKt.startsWith$default($originalText, "\u00a7\u00a7", false, 2, null)) {
            $modifiedText.element = StringsKt.removePrefix((String)$modifiedText.element, (CharSequence)"\u00a7\u00a7");
        } else {
            for (VisualWord modifiedWord : modifiedWords) {
                String phrase;
                if (!modifiedWord.getEnabled() || ((CharSequence)(phrase = StringUtils.INSTANCE.convertToFormatted(modifiedWord.getPhrase()))).length() == 0) continue;
                $modifiedText.element = StringsKt.replace((String)$modifiedText.element, phrase, StringUtils.INSTANCE.convertToFormatted(modifiedWord.getReplacement()), modifiedWord.isCaseSensitive());
            }
        }
        return (String)$modifiedText.element;
    }
}

