/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.pets;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.misc.pets.PetExperienceToolTipConfig;
import at.hannibal2.skyhanni.events.LorenzToolTipEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LorenzRarity;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.ReflectionUtils;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ+\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001c\u0010\u001c\u001a\n \u0019*\u0004\u0018\u00010\u00180\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u0014\u0010 \u001a\u00020\f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010\u001eR\u0014\u0010\"\u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R#\u0010(\u001a\n \u0019*\u0004\u0018\u00010\u00010\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u001b\u0010-\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010%\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lat/hannibal2/skyhanni/features/misc/pets/PetExpTooltip;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;", "event", "", "onItemTooltipLow", "(Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;)V", "", "", "toolTip", "", "findIndex", "(Ljava/util/List;)Ljava/lang/Integer;", "petName", "", "petExperience", "Lkotlin/Pair;", "getMaxValues", "(Ljava/lang/String;D)Lkotlin/Pair;", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/misc/pets/PetExperienceToolTipConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/pets/PetExperienceToolTipConfig;", "config", "LEVEL_100_COMMON", "I", "LEVEL_100_LEGENDARY", "LEVEL_200_LEGENDARY", "", "isNeuExtendedExpEnabled", "()Z", "objectNeuTooltipTweaks$delegate", "Lkotlin/Lazy;", "getObjectNeuTooltipTweaks", "()Ljava/lang/Object;", "objectNeuTooltipTweaks", "Ljava/lang/reflect/Field;", "fieldPetExtendExp$delegate", "getFieldPetExtendExp", "()Ljava/lang/reflect/Field;", "fieldPetExtendExp", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPetExpTooltip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PetExpTooltip.kt\nat/hannibal2/skyhanni/features/misc/pets/PetExpTooltip\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1#2:129\n360#3,7:130\n360#3,7:137\n*S KotlinDebug\n*F\n+ 1 PetExpTooltip.kt\nat/hannibal2/skyhanni/features/misc/pets/PetExpTooltip\n*L\n75#1:130,7\n80#1:137,7\n*E\n"})
public final class PetExpTooltip {
    @NotNull
    public static final PetExpTooltip INSTANCE = new PetExpTooltip();
    private static final int LEVEL_100_COMMON = 5624785;
    private static final int LEVEL_100_LEGENDARY = 25353230;
    private static final int LEVEL_200_LEGENDARY = 210255385;
    @NotNull
    private static final Lazy objectNeuTooltipTweaks$delegate = LazyKt.lazy(PetExpTooltip::objectNeuTooltipTweaks_delegate$lambda$3);
    @NotNull
    private static final Lazy fieldPetExtendExp$delegate = LazyKt.lazy(PetExpTooltip::fieldPetExtendExp_delegate$lambda$4);

    private PetExpTooltip() {
    }

    private final PetExperienceToolTipConfig getConfig() {
        return SkyHanniMod.feature.misc.pets.petExperienceToolTip;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onItemTooltipLow(@NotNull LorenzToolTipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!this.getConfig().petDisplay) {
            return;
        }
        if (!KeyboardManager.INSTANCE.isShiftKeyDown() && !this.getConfig().showAlways) {
            return;
        }
        ItemStack itemStack2 = event.getItemStack();
        Double d = SkyBlockItemModifierUtils.INSTANCE.getPetExp(itemStack2);
        if (d == null) {
            return;
        }
        double petExperience = NumberUtil.INSTANCE.roundTo(d, 1);
        String name2 = ItemUtils.INSTANCE.getName(itemStack2);
        try {
            Integer n = this.findIndex(event.getToolTip());
            if (n == null) {
                return;
            }
            int index = n;
            Pair<Integer, Integer> pair = this.getMaxValues(name2, petExperience);
            int maxLevel = ((Number)pair.component1()).intValue();
            int maxXp = ((Number)pair.component2()).intValue();
            double percentage = petExperience / (double)maxXp;
            String percentageFormat = LorenzUtils.INSTANCE.formatPercentage(percentage);
            if (percentage < 1.0) {
                boolean bl;
                event.getToolTip().add(index, " ");
                Object progressBar2 = StringUtils.progressBar$default(StringUtils.INSTANCE, percentage, 0, 2, null);
                LorenzRarity lorenzRarity = ItemUtils.INSTANCE.getItemRarityOrNull(itemStack2);
                if (lorenzRarity != null) {
                    LorenzRarity it = lorenzRarity;
                    boolean bl2 = false;
                    bl = it.compareTo((Enum)LorenzRarity.LEGENDARY) < 0;
                } else {
                    bl = false;
                }
                boolean isBelowLegendary = bl;
                String addLegendaryColor = isBelowLegendary ? "\u00a76" : "";
                event.getToolTip().add(index, progressBar2 + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(petExperience) + "\u00a76/\u00a7e" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, maxXp, false, 1, null));
                event.getToolTip().add(index, "\u00a77Progress to " + addLegendaryColor + "Level " + maxLevel + ": \u00a7e" + percentageFormat);
            }
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("itemStack", itemStack2), TuplesKt.to("item name", name2), TuplesKt.to("petExperience", petExperience), TuplesKt.to("toolTip", event.getToolTip()), TuplesKt.to("index", this.findIndex(event.getToolTip())), TuplesKt.to("getLore", ItemUtils.INSTANCE.getLore(itemStack2))};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Could not add pet exp tooltip", pairArray, false, false, false, 56, null);
        }
    }

    private final Integer findIndex(List<String> toolTip) {
        int index;
        block7: {
            int n;
            String it;
            String item$iv;
            Iterator<String> iterator2;
            int index$iv;
            boolean $i$f$indexOfFirst;
            List<String> $this$indexOfFirst$iv;
            block6: {
                int n2;
                $this$indexOfFirst$iv = toolTip;
                $i$f$indexOfFirst = false;
                index$iv = 0;
                iterator2 = $this$indexOfFirst$iv.iterator();
                while (iterator2.hasNext()) {
                    it = item$iv = iterator2.next();
                    boolean bl = false;
                    if (StringsKt.contains$default((CharSequence)it, "MAX LEVEL", false, 2, null)) {
                        n2 = index$iv;
                        break block6;
                    }
                    ++index$iv;
                }
                n2 = index = -1;
            }
            if (index != -1) {
                return index + 2;
            }
            $this$indexOfFirst$iv = toolTip;
            $i$f$indexOfFirst = false;
            index$iv = 0;
            iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                it = item$iv = iterator2.next();
                boolean bl = false;
                if (StringsKt.contains$default((CharSequence)it, "Progress to Level", false, 2, null)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index != -1) {
            int offset = this.isNeuExtendedExpEnabled() ? 4 : 3;
            return index + offset;
        }
        return null;
    }

    private final boolean isNeuExtendedExpEnabled() {
        Object object = this.getFieldPetExtendExp().get(this.getObjectNeuTooltipTweaks());
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    private final Object getObjectNeuTooltipTweaks() {
        Lazy lazy = objectNeuTooltipTweaks$delegate;
        return lazy.getValue();
    }

    private final Field getFieldPetExtendExp() {
        Lazy lazy = fieldPetExtendExp$delegate;
        return (Field)lazy.getValue();
    }

    private final Pair<Integer, Integer> getMaxValues(String petName, double petExperience) {
        boolean useGoldenDragonLevels = StringsKt.contains$default((CharSequence)petName, "Golden Dragon", false, 2, null) && (!this.getConfig().showGoldenDragonEgg || petExperience >= 2.535323E7);
        int maxLevel = useGoldenDragonLevels ? 200 : 100;
        int maxXp = useGoldenDragonLevels ? 210255385 : (StringsKt.contains$default((CharSequence)petName, "Bingo", false, 2, null) ? 5624785 : 25353230);
        return new Pair<Integer, Integer>(maxLevel, maxXp);
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "misc.petExperienceToolTip.petDisplay", "misc.pets.petExperienceToolTip.petDisplay", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "misc.petExperienceToolTip.showAlways", "misc.pets.petExperienceToolTip.showAlways", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "misc.petExperienceToolTip.showGoldenDragonEgg", "misc.pets.petExperienceToolTip.showGoldenDragonEgg", null, 8, null);
    }

    private static final Object objectNeuTooltipTweaks_delegate$lambda$3() {
        Field field = NotEnoughUpdates.INSTANCE.config.getClass().getDeclaredField("tooltipTweaks");
        Intrinsics.checkNotNull(field);
        return ReflectionUtils.INSTANCE.makeAccessible(field).get(NotEnoughUpdates.INSTANCE.config);
    }

    private static final Field fieldPetExtendExp_delegate$lambda$4() {
        Field field = INSTANCE.getObjectNeuTooltipTweaks().getClass().getDeclaredField("petExtendExp");
        Intrinsics.checkNotNullExpressionValue(field, "getDeclaredField(...)");
        return ReflectionUtils.INSTANCE.makeAccessible(field);
    }
}

