/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.pathfind;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.model.GraphKt;
import at.hannibal2.skyhanni.data.model.GraphNode;
import at.hannibal2.skyhanni.data.model.GraphNodeTag;
import at.hannibal2.skyhanni.features.misc.IslandAreas;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.chat.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ%\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ5\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00150\u00142\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00148\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lat/hannibal2/skyhanni/features/misc/pathfind/NavigationHelper;", "", "<init>", "()V", "", "", "args", "", "onCommand", "([Ljava/lang/String;)V", "doCommandAsync", "name", "Lkotlin/Function0;", "goBack", "sendNavigateMessage", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "", "Lat/hannibal2/skyhanni/data/model/GraphNode;", "", "distances", "", "Lkotlin/Pair;", "calculateNames", "(Ljava/util/Map;)Ljava/util/List;", "searchTerm", "calculateDistances", "(Ljava/lang/String;)Ljava/util/Map;", "", "NAVIGATION_CHAT_ID", "I", "Lat/hannibal2/skyhanni/data/model/GraphNodeTag;", "allowedTags", "Ljava/util/List;", "getAllowedTags", "()Ljava/util/List;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nNavigationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigationHelper.kt\nat/hannibal2/skyhanni/features/misc/pathfind/NavigationHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,115:1\n230#2,2:116\n774#2:118\n865#2,2:119\n1557#2:121\n1628#2,3:122\n230#2,2:127\n37#3,2:125\n*S KotlinDebug\n*F\n+ 1 NavigationHelper.kt\nat/hannibal2/skyhanni/features/misc/pathfind/NavigationHelper\n*L\n84#1:116,2\n102#1:118\n102#1:119,2\n108#1:121\n108#1:122,3\n63#1:127,2\n46#1:125,2\n*E\n"})
public final class NavigationHelper {
    @NotNull
    public static final NavigationHelper INSTANCE = new NavigationHelper();
    private static final int NAVIGATION_CHAT_ID = -6457562;
    @NotNull
    private static final List<GraphNodeTag> allowedTags;

    private NavigationHelper() {
    }

    @NotNull
    public final List<GraphNodeTag> getAllowedTags() {
        return allowedTags;
    }

    public final void onCommand(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        BuildersKt.launch$default(SkyHanniMod.Companion.getCoroutineScope(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(args2, null){
            int label;
            final /* synthetic */ String[] $args;
            {
                this.$args = $args;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        NavigationHelper.access$doCommandAsync(NavigationHelper.INSTANCE, this.$args);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void doCommandAsync(String[] args2) {
        String string2 = ArraysKt.joinToString$default(args2, (CharSequence)" ", null, null, 0, null, null, 62, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String searchTerm = string2;
        Map<GraphNode, Double> distances = this.calculateDistances(searchTerm);
        List<Pair<String, GraphNode>> locations = this.calculateNames(distances);
        Function0<Unit> goBack = () -> NavigationHelper.doCommandAsync$lambda$0(searchTerm);
        String title = StringsKt.isBlank(searchTerm) ? "SkyHanni Navigation Locations" : "SkyHanni Navigation Locations Matching: \"" + searchTerm + '\"';
        Text.displayPaginatedList$default(Text.INSTANCE, title, locations, -6457562, "No locations found.", 0, 0, null, arg_0 -> NavigationHelper.doCommandAsync$lambda$3(distances, goBack, arg_0), 112, null);
    }

    private final void sendNavigateMessage(String name2, Function0<Unit> goBack) {
        ChatComponentText componentText = Text.asComponent$default(Text.INSTANCE, "\u00a77Navigating to \u00a7r" + name2, null, 1, null);
        Text.onClick-O__7yG8$default(Text.INSTANCE, (IChatComponent)componentText, 0L, false, goBack, 3, null);
        Text.INSTANCE.setHover((IChatComponent)componentText, (IChatComponent)Text.asComponent$default(Text.INSTANCE, "\u00a7eClick to stop navigating and return to previous search", null, 1, null));
        Text.INSTANCE.send((IChatComponent)componentText, -6457562);
    }

    private final List<Pair<String, GraphNode>> calculateNames(Map<GraphNode, Double> distances) {
        Map names = new LinkedHashMap();
        for (GraphNode node : CollectionUtils.INSTANCE.sorted(distances).keySet()) {
            Object element$iv2;
            block2: {
                if (Intrinsics.areEqual(node.getName(), "no_area") || Intrinsics.areEqual(node.getName(), IslandAreas.INSTANCE.getCurrentAreaName())) continue;
                Iterable $this$first$iv = node.getTags();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    GraphNodeTag it = (GraphNodeTag)((Object)element$iv2);
                    boolean bl = false;
                    if (!allowedTags.contains((Object)it)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            GraphNodeTag tag = (GraphNodeTag)((Object)element$iv2);
            String name2 = node.getName() + " \u00a77(" + tag.getDisplayName() + "\u00a77)";
            if (names.containsKey(name2)) continue;
            names.put(name2, node);
        }
        return MapsKt.toList(names);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GraphNode, Double> calculateDistances(String searchTerm) {
        List<? extends GraphNode> list = IslandGraphs.INSTANCE.getCurrentIslandGraph-ZhRhRFc();
        if (list == null) {
            return MapsKt.emptyMap();
        }
        List<? extends GraphNode> graph = list;
        GraphNode graphNode = IslandGraphs.INSTANCE.getClosedNote();
        if (graphNode == null) {
            return MapsKt.emptyMap();
        }
        GraphNode closedNote = graphNode;
        List<? extends GraphNode> nodes = graph;
        Map distances = new LinkedHashMap();
        for (GraphNode graphNode2 : nodes) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String name2;
            boolean bl;
            GraphNodeTag it;
            void $this$filterTo$iv$iv;
            if (graphNode2.getName() == null) continue;
            Iterable $this$filter$iv = graphNode2.getTags();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GraphNodeTag)((Object)element$iv$iv);
                bl = false;
                if (!allowedTags.contains((Object)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List remainingTags = (List)destination$iv$iv;
            if (remainingTags.isEmpty()) continue;
            String string2 = name2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)string2, searchTerm, false, 2, null)) {
                distances.put(graphNode2, GraphKt.findShortestDistance-LidtmbA(graph, closedNote, graphNode2));
            }
            if (remainingTags.size() == 1) continue;
            $this$filter$iv = remainingTags;
            StringBuilder stringBuilder = new StringBuilder().append("found node with invalid amount of tags: ").append(graphNode2.getName()).append(" (");
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (GraphNodeTag)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                bl = false;
                collection.add(it.getCleanName());
            }
            System.out.println((Object)stringBuilder.append((List)destination$iv$iv).toString());
        }
        return distances;
    }

    private static final Unit doCommandAsync$lambda$0(String $searchTerm) {
        Intrinsics.checkNotNullParameter($searchTerm, "$searchTerm");
        String[] stringArray = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)$searchTerm, stringArray, false, 0, 6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        INSTANCE.onCommand(thisCollection$iv.toArray(new String[0]));
        IslandGraphs.INSTANCE.stop();
        return Unit.INSTANCE;
    }

    private static final Unit doCommandAsync$lambda$3$lambda$1(GraphNode $node, String $name, Function0 $goBack) {
        Intrinsics.checkNotNullParameter($node, "$node");
        Intrinsics.checkNotNullParameter($name, "$name");
        Intrinsics.checkNotNullParameter($goBack, "$goBack");
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, $node.getPosition(), null, null, false, null, 30, null);
        INSTANCE.sendNavigateMessage($name, $goBack);
        return Unit.INSTANCE;
    }

    private static final IChatComponent doCommandAsync$lambda$3(Map $distances, Function0 $goBack, Pair pair) {
        Object element$iv2;
        ChatComponentText component;
        double distance;
        String name2;
        block1: {
            Intrinsics.checkNotNullParameter($distances, "$distances");
            Intrinsics.checkNotNullParameter($goBack, "$goBack");
            Intrinsics.checkNotNullParameter(pair, "<destruct>");
            name2 = (String)pair.component1();
            GraphNode node = (GraphNode)pair.component2();
            Object v = $distances.get(node);
            Intrinsics.checkNotNull(v);
            distance = NumberUtil.INSTANCE.roundTo(((Number)v).doubleValue(), 1);
            component = Text.asComponent$default(Text.INSTANCE, name2 + " \u00a7e" + distance, null, 1, null);
            Text.onClick-O__7yG8$default(Text.INSTANCE, (IChatComponent)component, 0L, false, () -> NavigationHelper.doCommandAsync$lambda$3$lambda$1(node, name2, $goBack), 3, null);
            Iterable $this$first$iv = node.getTags();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                GraphNodeTag it = (GraphNodeTag)((Object)element$iv2);
                boolean bl = false;
                if (!allowedTags.contains((Object)it)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        GraphNodeTag tag = (GraphNodeTag)((Object)element$iv2);
        String d = "Name: " + name2 + "\n\u00a77Type: \u00a7r" + tag.getDisplayName() + "\n\u00a77Distance: \u00a7e" + distance + " blocks\n\u00a7eClick to start navigating!";
        Text.INSTANCE.setHover((IChatComponent)component, (IChatComponent)Text.asComponent$default(Text.INSTANCE, d, null, 1, null));
        return (IChatComponent)component;
    }

    public static final /* synthetic */ void access$doCommandAsync(NavigationHelper $this, String[] args2) {
        $this.doCommandAsync(args2);
    }

    static {
        GraphNodeTag[] graphNodeTagArray = new GraphNodeTag[]{GraphNodeTag.NPC, GraphNodeTag.AREA, GraphNodeTag.SMALL_AREA, GraphNodeTag.POI, GraphNodeTag.SLAYER, GraphNodeTag.GRIND_MOBS, GraphNodeTag.GRIND_ORES, GraphNodeTag.GRIND_CROPS, GraphNodeTag.MINES_EMISSARY, GraphNodeTag.CRIMSON_MINIBOSS};
        allowedTags = CollectionsKt.listOf(graphNodeTagArray);
    }
}

