/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.items.enchants;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.inventory.EnchantParsingConfig;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ChatHoverEvent;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.item.ItemHoverEvent;
import at.hannibal2.skyhanni.features.chroma.ChromaManager;
import at.hannibal2.skyhanni.features.misc.items.enchants.Cache;
import at.hannibal2.skyhanni.features.misc.items.enchants.Enchant;
import at.hannibal2.skyhanni.features.misc.items.enchants.EnchantsJson;
import at.hannibal2.skyhanni.features.misc.items.enchants.FormattedEnchant;
import at.hannibal2.skyhanni.mixins.hooks.GuiChatHook;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.ItemCategory;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.event.HoverEvent;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J;\u0010\u001a\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ1\u0010\u001c\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010!\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b!\u0010\u001fJ\u001d\u0010\"\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b\"\u0010\u001fJ\u001d\u0010#\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b#\u0010\u001fJ\u001d\u0010$\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b$\u0010\u001fJ1\u0010*\u001a\u00020\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\n\u0010'\u001a\u00060%j\u0002`&2\u0006\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b*\u0010+J%\u0010,\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0004\b,\u0010-J'\u00100\u001a\u00020\u00162\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010/\u001a\u0004\u0018\u00010.H\u0002\u00a2\u0006\u0004\b0\u00101J\u000f\u00103\u001a\u000202H\u0002\u00a2\u0006\u0004\b3\u00104J\r\u00105\u001a\u000202\u00a2\u0006\u0004\b5\u00104J\u000f\u00106\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b6\u0010\u0003R\u001c\u0010;\u001a\n 8*\u0004\u0018\u000107078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0017\u0010=\u001a\u00020<8\u0006\u00a2\u0006\f\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@R\u001b\u0010F\u001a\u00020A8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u0010C\u001a\u0004\bD\u0010ER\u001b\u0010I\u001a\u00020A8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010C\u001a\u0004\bH\u0010ER\u0018\u0010J\u001a\u0004\u0018\u00010.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010L\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u0016\u0010N\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010MR\u0016\u0010O\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010MR\u0016\u0010P\u001a\u0002028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0016\u0010R\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010MR\u001c\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u001c\u0010W\u001a\b\u0012\u0004\u0012\u00020V0U8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bW\u0010XR\u0014\u0010Z\u001a\u00020Y8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bZ\u0010[R\u001b\u0010^\u001a\u0002028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u0010]\u001a\u0004\b^\u00104R\u0016\u0010\u0017\u001a\u00020_8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010`\u00a8\u0006a"}, d2={"Lat/hannibal2/skyhanni/features/misc/items/enchants/EnchantParser;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/item/ItemHoverEvent;", "onTooltipEvent", "(Lat/hannibal2/skyhanni/events/item/ItemHoverEvent;)V", "Lat/hannibal2/skyhanni/events/ChatHoverEvent;", "onChatHoverEvent", "(Lat/hannibal2/skyhanni/events/ChatHoverEvent;)V", "", "", "loreList", "", "", "enchants", "Lnet/minecraft/util/IChatComponent;", "chatComponent", "parseEnchants", "(Ljava/util/List;Ljava/util/Map;Lnet/minecraft/util/IChatComponent;)V", "enchantStartAndEnd", "(Ljava/util/List;Ljava/util/Map;)V", "orderEnchants", "(Ljava/util/List;)V", "insertEnchants", "formatEnchants", "normalFormatting", "compressedFormatting", "stackedFormatting", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "builder", "Lat/hannibal2/skyhanni/config/features/inventory/EnchantParsingConfig$CommaFormat;", "commaFormat", "finishFormatting", "(Ljava/util/List;Ljava/lang/StringBuilder;Lat/hannibal2/skyhanni/config/features/inventory/EnchantParsingConfig$CommaFormat;)V", "editChatComponent", "(Lnet/minecraft/util/IChatComponent;Ljava/util/List;)V", "Lnet/minecraft/item/ItemStack;", "item", "accountForAndRemoveGrayEnchants", "(Ljava/util/List;Lnet/minecraft/item/ItemStack;)I", "", "itemIsBook", "()Z", "isEnabled", "markCacheDirty", "Lat/hannibal2/skyhanni/config/features/inventory/EnchantParsingConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/EnchantParsingConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "getPatternGroup", "()Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "enchantmentPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getEnchantmentPattern", "()Ljava/util/regex/Pattern;", "enchantmentPattern", "grayEnchantPattern$delegate", "getGrayEnchantPattern", "grayEnchantPattern", "currentItem", "Lnet/minecraft/item/ItemStack;", "indexOfLastGrayEnchant", "I", "startEnchant", "endEnchant", "shouldBeSingleColumn", "Z", "maxEnchantsPerLine", "loreLines", "Ljava/util/List;", "Ljava/util/TreeSet;", "Lat/hannibal2/skyhanni/features/misc/items/enchants/FormattedEnchant;", "orderedEnchants", "Ljava/util/TreeSet;", "Lat/hannibal2/skyhanni/features/misc/items/enchants/Cache;", "loreCache", "Lat/hannibal2/skyhanni/features/misc/items/enchants/Cache;", "isSbaLoaded$delegate", "Lkotlin/Lazy;", "isSbaLoaded", "Lat/hannibal2/skyhanni/features/misc/items/enchants/EnchantsJson;", "Lat/hannibal2/skyhanni/features/misc/items/enchants/EnchantsJson;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nEnchantParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantParser.kt\nat/hannibal2/skyhanni/features/misc/items/enchants/EnchantParser\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,447:1\n12#2,7:448\n1#3:455\n*S KotlinDebug\n*F\n+ 1 EnchantParser.kt\nat/hannibal2/skyhanni/features/misc/items/enchants/EnchantParser\n*L\n76#1:448,7\n*E\n"})
public final class EnchantParser {
    @NotNull
    public static final EnchantParser INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern enchantmentPattern$delegate;
    @NotNull
    private static final RepoPattern grayEnchantPattern$delegate;
    @Nullable
    private static ItemStack currentItem;
    private static int indexOfLastGrayEnchant;
    private static int startEnchant;
    private static int endEnchant;
    private static boolean shouldBeSingleColumn;
    private static int maxEnchantsPerLine;
    @NotNull
    private static List<String> loreLines;
    @NotNull
    private static TreeSet<FormattedEnchant> orderedEnchants;
    @NotNull
    private static final Cache loreCache;
    @NotNull
    private static final Lazy isSbaLoaded$delegate;
    @NotNull
    private static EnchantsJson enchants;

    private EnchantParser() {
    }

    private final EnchantParsingConfig getConfig() {
        return SkyHanniMod.feature.inventory.enchantParsing;
    }

    @NotNull
    public final RepoPatternGroup getPatternGroup() {
        return patternGroup;
    }

    @NotNull
    public final Pattern getEnchantmentPattern() {
        return (Pattern)enchantmentPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getGrayEnchantPattern() {
        return (Pattern)grayEnchantPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    public final boolean isSbaLoaded() {
        Lazy lazy = isSbaLoaded$delegate;
        return (Boolean)lazy.getValue();
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        EnchantsJson enchantsJson;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "Enchants";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            enchantsJson = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, EnchantsJson.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        enchants = enchantsJson;
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property[] propertyArray = new Property[]{this.getConfig().colorParsing, this.getConfig().format, this.getConfig().perfectEnchantColor, this.getConfig().greatEnchantColor, this.getConfig().goodEnchantColor, this.getConfig().poorEnchantColor, this.getConfig().commaFormat, this.getConfig().hideVanillaEnchants, this.getConfig().hideEnchantDescriptions, ChromaManager.INSTANCE.getConfig().enabled};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, EnchantParser::onConfigLoad$lambda$1);
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onTooltipEvent(@NotNull ItemHoverEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!enchants.hasEnchantData()) {
            return;
        }
        currentItem = event.getItemStack();
        Map<String, Integer> map2 = SkyBlockItemModifierUtils.INSTANCE.getEnchantments(event.getItemStack());
        if (map2 == null) {
            return;
        }
        Map<String, Integer> enchants = map2;
        indexOfLastGrayEnchant = this.accountForAndRemoveGrayEnchants(event.getToolTip(), event.getItemStack());
        this.parseEnchants(event.getToolTip(), enchants, null);
    }

    @SubscribeEvent
    public final void onChatHoverEvent(@NotNull ChatHoverEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getHoverEvent().func_150701_a() != HoverEvent.Action.SHOW_TEXT) {
            return;
        }
        if (!this.isEnabled() || !enchants.hasEnchantData()) {
            return;
        }
        currentItem = null;
        String string2 = event.getHoverEvent().func_150702_b().func_150254_d();
        Intrinsics.checkNotNullExpressionValue(string2, "getFormattedText(...)");
        String[] stringArray = new String[]{"\n"};
        List<String> lore = CollectionsKt.toMutableList(StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null));
        indexOfLastGrayEnchant = this.accountForAndRemoveGrayEnchants(lore, null);
        this.parseEnchants(lore, MapsKt.emptyMap(), (IChatComponent)event.getComponent());
    }

    private final void parseEnchants(List<String> loreList, Map<String, Integer> enchants, IChatComponent chatComponent) {
        if (loreCache.isCached(loreList)) {
            loreList.clear();
            boolean bl = !((Collection)loreCache.getCachedLoreAfter()).isEmpty() ? loreList.addAll((Collection<String>)loreCache.getCachedLoreAfter()) : loreList.addAll((Collection<String>)loreCache.getCachedLoreBefore());
            if (chatComponent != null) {
                this.editChatComponent(chatComponent, loreList);
            }
            return;
        }
        loreCache.updateBefore(loreList);
        this.enchantStartAndEnd(loreList, enchants);
        if (endEnchant == -1) {
            loreCache.updateAfter(loreList);
            return;
        }
        shouldBeSingleColumn = false;
        loreLines = new ArrayList();
        orderedEnchants = new TreeSet();
        maxEnchantsPerLine = 0;
        this.orderEnchants(loreList);
        if (orderedEnchants.isEmpty()) {
            loreCache.updateAfter(loreList);
            return;
        }
        if (!((Boolean)this.getConfig().colorParsing.get()).booleanValue()) {
            if (((Boolean)this.getConfig().hideEnchantDescriptions.get()).booleanValue()) {
                if (this.itemIsBook()) {
                    loreCache.updateAfter(loreList);
                    return;
                }
                loreList.removeAll((Collection)loreLines);
                loreCache.updateAfter(loreList);
                if (chatComponent != null) {
                    this.editChatComponent(chatComponent, loreList);
                }
                return;
            }
            loreCache.updateAfter(loreList);
            return;
        }
        try {
            loreList.subList(startEnchant, endEnchant + 1).clear();
        }
        catch (IndexOutOfBoundsException e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("loreList", loreList), TuplesKt.to("startEnchant", startEnchant), TuplesKt.to("endEnchant", endEnchant)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error parsing enchantment info from item", pairArray, false, false, false, 56, null);
            return;
        }
        List insertEnchants = new ArrayList();
        try {
            this.formatEnchants(insertEnchants);
        }
        catch (ArithmeticException e) {
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to("item", currentItem);
            pairArray[1] = TuplesKt.to("loreList", loreList);
            ItemStack itemStack2 = currentItem;
            pairArray[2] = TuplesKt.to("nbt", itemStack2 != null ? SkyBlockItemModifierUtils.INSTANCE.getExtraAttributes(itemStack2) : null);
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Item has enchants in nbt but none were found?", pairArray, false, false, false, 56, null);
            return;
        }
        catch (ConcurrentModificationException e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("loreList", loreList), TuplesKt.to("format", this.getConfig().format.get()), TuplesKt.to("orderedEnchants", orderedEnchants)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "ConcurrentModificationException whilst formatting enchants", pairArray, false, false, false, 56, null);
        }
        loreList.addAll(startEnchant, insertEnchants);
        loreCache.updateAfter(loreList);
        if (chatComponent != null) {
            this.editChatComponent(chatComponent, loreList);
        }
    }

    private final void enchantStartAndEnd(List<String> loreList, Map<String, Integer> enchants) {
        int startIndex;
        int startEnchant = -1;
        int endEnchant = -1;
        int n = loreList.size();
        for (int i2 = startIndex = indexOfLastGrayEnchant == -1 ? 0 : indexOfLastGrayEnchant + 1; i2 < n; ++i2) {
            String strippedLine = StringUtils.removeColor$default(StringUtils.INSTANCE, loreList.get(i2), false, 1, null);
            if (startEnchant == -1) {
                if (!EnchantParser.enchants.containsEnchantment(enchants, loreList.get(i2))) continue;
                startEnchant = i2;
                continue;
            }
            if (!(((CharSequence)((Object)StringsKt.trim((CharSequence)strippedLine)).toString()).length() == 0) || endEnchant != -1) continue;
            endEnchant = i2 - 1;
        }
        EnchantParser.startEnchant = startEnchant;
        EnchantParser.endEnchant = endEnchant;
    }

    private final void orderEnchants(List<String> loreList) {
        FormattedEnchant lastEnchant = null;
        int i2 = startEnchant;
        int n = endEnchant;
        if (i2 <= n) {
            while (true) {
                Matcher matcher = this.getEnchantmentPattern().matcher(loreList.get(i2));
                boolean containsEnchant = false;
                int enchantsOnThisLine = 0;
                boolean isRoman = false;
                isRoman = true;
                while (matcher.find()) {
                    String string2;
                    int n2;
                    String string3 = matcher.group("enchant");
                    Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
                    Enchant enchant = enchants.getFromLore(string3);
                    try {
                        String string4 = matcher.group("levelNumeral");
                        Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
                        int it = n2 = Integer.parseInt(string4);
                        boolean bl = false;
                        isRoman = false;
                    }
                    catch (NumberFormatException e) {
                        String string5 = matcher.group("levelNumeral");
                        Intrinsics.checkNotNullExpressionValue(string5, "group(...)");
                        n2 = NumberUtil.INSTANCE.romanToDecimal(string5);
                    }
                    int level = n2;
                    String string6 = matcher.group("stacking");
                    Intrinsics.checkNotNullExpressionValue(string6, "group(...)");
                    Object object = StringUtils.removeColor$default(StringUtils.INSTANCE, ((Object)StringsKt.trimStart((CharSequence)string6)).toString(), false, 1, null);
                    if (new Regex("[\\d,]+$").matches((CharSequence)object)) {
                        shouldBeSingleColumn = true;
                        string2 = matcher.group("stacking");
                    } else {
                        string2 = "empty";
                    }
                    String stacking = string2;
                    Intrinsics.checkNotNull(stacking);
                    lastEnchant = new FormattedEnchant(enchant, level, stacking, isRoman);
                    if (!orderedEnchants.add(lastEnchant)) {
                        Iterator<FormattedEnchant> iterator2 = orderedEnchants.iterator();
                        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                        object = iterator2;
                        while (object.hasNext()) {
                            Object e = object.next();
                            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                            FormattedEnchant e2 = (FormattedEnchant)e;
                            FormattedEnchant it = lastEnchant;
                            boolean bl = false;
                            if (!(e2.compareTo(it) == 0)) continue;
                            lastEnchant = e2;
                            break;
                        }
                    }
                    containsEnchant = true;
                    ++enchantsOnThisLine;
                }
                int n3 = maxEnchantsPerLine = enchantsOnThisLine > maxEnchantsPerLine ? enchantsOnThisLine : maxEnchantsPerLine;
                if (!containsEnchant && lastEnchant != null) {
                    lastEnchant.addLore(loreList.get(i2));
                    loreLines.add(loreList.get(i2));
                }
                if (i2 == n) break;
                ++i2;
            }
        }
    }

    private final void formatEnchants(List<String> insertEnchants) {
        if (this.getConfig().format.get() == EnchantParsingConfig.EnchantFormat.NORMAL) {
            this.normalFormatting(insertEnchants);
        } else if (this.getConfig().format.get() == EnchantParsingConfig.EnchantFormat.COMPRESSED && !shouldBeSingleColumn) {
            this.compressedFormatting(insertEnchants);
        } else {
            this.stackedFormatting(insertEnchants);
        }
    }

    private final void normalFormatting(List<String> insertEnchants) {
        EnchantParsingConfig.CommaFormat commaFormat = (EnchantParsingConfig.CommaFormat)((Object)this.getConfig().commaFormat.get());
        StringBuilder builder = new StringBuilder();
        Iterator iterator2 = ((Iterable)orderedEnchants).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            FormattedEnchant orderedEnchant = (FormattedEnchant)iterator2.next();
            String comma = commaFormat == EnchantParsingConfig.CommaFormat.COPY_ENCHANT ? ", " : "\u00a79, ";
            builder.append(orderedEnchant.getFormattedString(currentItem));
            if (i2 % maxEnchantsPerLine != maxEnchantsPerLine - 1) {
                builder.append(comma);
                continue;
            }
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            insertEnchants.add(string2);
            if (!((Boolean)this.getConfig().hideEnchantDescriptions.get()).booleanValue() || this.itemIsBook()) {
                insertEnchants.addAll((Collection<String>)orderedEnchant.getLore());
            }
            builder = new StringBuilder();
        }
        Intrinsics.checkNotNull((Object)commaFormat);
        this.finishFormatting(insertEnchants, builder, commaFormat);
    }

    private final void compressedFormatting(List<String> insertEnchants) {
        EnchantParsingConfig.CommaFormat commaFormat = (EnchantParsingConfig.CommaFormat)((Object)this.getConfig().commaFormat.get());
        StringBuilder builder = new StringBuilder();
        Iterator iterator2 = ((Iterable)orderedEnchants).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i2 = n++;
            FormattedEnchant orderedEnchant = (FormattedEnchant)iterator2.next();
            String comma = commaFormat == EnchantParsingConfig.CommaFormat.COPY_ENCHANT ? ", " : "\u00a79, ";
            builder.append(orderedEnchant.getFormattedString(currentItem));
            if (this.itemIsBook() && maxEnchantsPerLine == 1) {
                String string2 = builder.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                insertEnchants.add(string2);
                insertEnchants.addAll((Collection<String>)orderedEnchant.getLore());
                builder = new StringBuilder();
                continue;
            }
            if (i2 % 3 != 2) {
                builder.append(comma);
                continue;
            }
            String string3 = builder.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            insertEnchants.add(string3);
            builder = new StringBuilder();
        }
        Intrinsics.checkNotNull((Object)commaFormat);
        this.finishFormatting(insertEnchants, builder, commaFormat);
    }

    private final void stackedFormatting(List<String> insertEnchants) {
        if (!((Boolean)this.getConfig().hideEnchantDescriptions.get()).booleanValue() || this.itemIsBook()) {
            Iterator<FormattedEnchant> iterator2 = orderedEnchants.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<FormattedEnchant> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                FormattedEnchant enchant;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                insertEnchants.add(enchant.getFormattedString(currentItem));
                insertEnchants.addAll((Collection<String>)enchant.getLore());
            }
        } else {
            Iterator<FormattedEnchant> iterator4 = orderedEnchants.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, "iterator(...)");
            Iterator<FormattedEnchant> iterator5 = iterator4;
            while (iterator5.hasNext()) {
                FormattedEnchant enchant;
                Intrinsics.checkNotNullExpressionValue(iterator5.next(), "next(...)");
                insertEnchants.add(enchant.getFormattedString(currentItem));
            }
        }
    }

    private final void finishFormatting(List<String> insertEnchants, StringBuilder builder, EnchantParsingConfig.CommaFormat commaFormat) {
        if (((CharSequence)builder).length() > 0) {
            String string2 = builder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            insertEnchants.add(string2);
        }
        if (StringsKt.last(CollectionsKt.last(insertEnchants)) == ' ') {
            insertEnchants.set(CollectionsKt.getLastIndex(insertEnchants), StringsKt.dropLast(CollectionsKt.last(insertEnchants), commaFormat == EnchantParsingConfig.CommaFormat.COPY_ENCHANT ? 2 : 4));
        }
    }

    private final void editChatComponent(IChatComponent chatComponent, List<String> loreList) {
        String text = StringsKt.dropLast(CollectionsKt.joinToString$default(loreList, "\n", null, null, 0, null, null, 62, null), 2);
        ChatComponentText chatComponentText = new ChatComponentText(text);
        HoverEvent hoverEvent = new HoverEvent(chatComponent.func_150256_b().func_150210_i().func_150701_a(), (IChatComponent)chatComponentText);
        GuiChatHook.INSTANCE.replaceOnlyHoverEvent(hoverEvent);
    }

    private final int accountForAndRemoveGrayEnchants(List<String> loreList, ItemStack item) {
        if (!(item == null || ItemUtils.INSTANCE.isEnchanted(item) && item.func_77986_q().func_74745_c() != 0)) {
            return -1;
        }
        int lastGrayEnchant = -1;
        Boolean removeGrayEnchants = (Boolean)this.getConfig().hideVanillaEnchants.get();
        int i2 = 1;
        for (int total = 0; total < 2 && i2 + 1 < loreList.size(); ++total) {
            Object object;
            String line = loreList.get(i2);
            if (this.getGrayEnchantPattern().matcher(line).matches()) {
                lastGrayEnchant = i2;
                if (removeGrayEnchants.booleanValue()) {
                    object = loreList.remove(i2);
                    continue;
                }
                object = i2++;
                continue;
            }
            object = i2++;
        }
        return removeGrayEnchants != false ? -1 : lastGrayEnchant;
    }

    private final boolean itemIsBook() {
        ItemStack itemStack2 = currentItem;
        return (itemStack2 != null ? ItemUtils.INSTANCE.getItemCategoryOrNull(itemStack2) : null) == ItemCategory.ENCHANTED_BOOK;
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock();
    }

    private final void markCacheDirty() {
        loreCache.setConfigChanged(true);
    }

    private static final boolean isSbaLoaded_delegate$lambda$0() {
        return Loader.isModLoaded((String)"skyblockaddons");
    }

    private static final void onConfigLoad$lambda$1() {
        INSTANCE.markCacheDirty();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(EnchantParser.class, "enchantmentPattern", "getEnchantmentPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(EnchantParser.class, "grayEnchantPattern", "getGrayEnchantPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new EnchantParser();
        patternGroup = RepoPattern.Companion.group("misc.items.enchantparsing");
        enchantmentPattern$delegate = patternGroup.pattern("enchants.new", "(\u00a7d\u00a7l|\u00a79)(?<enchant>[A-Za-z][A-Za-z '-]+) (?<levelNumeral>[IVXLCDM]+|[0-9]+)(?<stacking>(\u00a7r)?\u00a79, |$| \u00a78\\d{1,3}(,\\d{3})*)");
        grayEnchantPattern$delegate = patternGroup.pattern("grayenchants", "^(Respiration|Aqua Affinity|Depth Strider|Efficiency).*");
        indexOfLastGrayEnchant = -1;
        startEnchant = -1;
        endEnchant = -1;
        loreLines = new ArrayList();
        orderedEnchants = new TreeSet();
        loreCache = new Cache();
        isSbaLoaded$delegate = LazyKt.lazy(EnchantParser::isSbaLoaded_delegate$lambda$0);
        enchants = new EnchantsJson();
    }
}

