/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.compacttablist;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.misc.compacttablist.CompactTabListConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.SkipTabListLineEvent;
import at.hannibal2.skyhanni.features.misc.compacttablist.AdvancedPlayerList;
import at.hannibal2.skyhanni.features.misc.compacttablist.RenderColumn;
import at.hannibal2.skyhanni.features.misc.compacttablist.TabLine;
import at.hannibal2.skyhanni.features.misc.compacttablist.TabListReader;
import at.hannibal2.skyhanni.features.misc.compacttablist.TabStringType;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.TabListData;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0007\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00178\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u00178\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00178\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0019R\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010\"R\u001b\u0010)\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lat/hannibal2/skyhanni/features/misc/compacttablist/TabListRenderer;", "", "<init>", "()V", "Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Pre;", "event", "", "onRenderOverlay", "(Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Pre;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "drawTabList", "Lat/hannibal2/skyhanni/events/SkipTabListLineEvent;", "onSkipTablistLine", "(Lat/hannibal2/skyhanni/events/SkipTabListLineEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/misc/compacttablist/CompactTabListConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/compacttablist/CompactTabListConfig;", "config", "", "MAX_LINES", "I", "LINE_HEIGHT", "TAB_PADDING", "COLUMN_SPACING", "", "TAB_Z_OFFSET", "F", "", "isPressed", "Z", "isTabToggled", "Ljava/util/regex/Pattern;", "fireSalePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getFireSalePattern", "()Ljava/util/regex/Pattern;", "fireSalePattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nTabListRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabListRenderer.kt\nat/hannibal2/skyhanni/features/misc/compacttablist/TabListRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1#2:229\n*E\n"})
public final class TabListRenderer {
    @NotNull
    public static final TabListRenderer INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    public static final int MAX_LINES = 22;
    private static final int LINE_HEIGHT = 9;
    private static final int TAB_PADDING = 3;
    private static final int COLUMN_SPACING = 6;
    private static final float TAB_Z_OFFSET = 10.0f;
    private static boolean isPressed;
    private static boolean isTabToggled;
    @NotNull
    private static final RepoPattern fireSalePattern$delegate;

    private TabListRenderer() {
    }

    private final CompactTabListConfig getConfig() {
        return SkyHanniMod.feature.gui.compactTabList;
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull RenderGameOverlayEvent.Pre event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (event.type != RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            return;
        }
        if (!((Boolean)this.getConfig().enabled.get()).booleanValue()) {
            return;
        }
        event.setCanceled(true);
        if (this.getConfig().toggleTab) {
            return;
        }
        this.drawTabList();
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!((Boolean)this.getConfig().enabled.get()).booleanValue()) {
            return;
        }
        if (!this.getConfig().toggleTab) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        KeyBinding keyBinding = Minecraft.func_71410_x().field_71474_y.field_74321_H;
        Intrinsics.checkNotNullExpressionValue(keyBinding, "keyBindPlayerList");
        if (KeyboardManager.INSTANCE.isActive(keyBinding)) {
            if (!isPressed) {
                isPressed = true;
                isTabToggled = !isTabToggled;
            }
        } else {
            isPressed = false;
        }
        if (isTabToggled) {
            this.drawTabList();
        }
    }

    private final void drawTabList() {
        List<RenderColumn> columns = TabListReader.INSTANCE.getRenderColumns();
        if (columns.isEmpty()) {
            return;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)10.0f);
        int maxLines = 0;
        int totalWidth = -6;
        for (RenderColumn column : columns) {
            maxLines = RangesKt.coerceAtLeast(maxLines, column.size());
            totalWidth += column.getMaxWidth() + 6;
        }
        int totalHeight = maxLines * 9;
        List<String> header = CollectionsKt.emptyList();
        if (!this.getConfig().hideAdverts) {
            String[] stringArray = new String[]{"\n"};
            header = CollectionsKt.toMutableList(StringsKt.split$default((CharSequence)TabListData.INSTANCE.getHeader(), stringArray, false, 0, 6, null));
            header.removeIf(arg_0 -> TabListRenderer.drawTabList$lambda$1(TabListRenderer::drawTabList$lambda$0, arg_0));
            totalHeight += header.size() * 9 + 3;
        }
        List<String> footer = CollectionsKt.emptyList();
        if (!this.getConfig().hideAdverts) {
            String[] stringArray = new String[]{"\n"};
            footer = CollectionsKt.toMutableList(StringsKt.split$default((CharSequence)TabListData.INSTANCE.getFooter(), stringArray, false, 0, 6, null));
            footer.removeIf(arg_0 -> TabListRenderer.drawTabList$lambda$3(TabListRenderer::drawTabList$lambda$2, arg_0));
            totalHeight += footer.size() * 9 + 3;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        ScaledResolution scaledResolution = new ScaledResolution(minecraft);
        int screenWidth = scaledResolution.func_78326_a() / 2;
        int x = screenWidth - totalWidth / 2;
        int y = 10;
        Gui.func_73734_a((int)(x - 6), (int)(y - 3), (int)(screenWidth + totalWidth / 2 + 6), (int)(10 + totalHeight + 3), (int)Integer.MIN_VALUE);
        int headerY = y;
        if (!((Collection)header).isEmpty()) {
            for (String line : header) {
                minecraft.field_71466_p.func_175063_a(line, (float)x + (float)totalWidth / 2.0f - (float)minecraft.field_71466_p.func_78256_a(line) / 2.0f, (float)headerY, 0xFFFFFF);
                headerY += 9;
            }
        }
        int middleX = x;
        Ref.ObjectRef lastTitle = new Ref.ObjectRef();
        Ref.ObjectRef lastSubTitle = new Ref.ObjectRef();
        for (RenderColumn originalColumn : columns) {
            int middleY = this.getConfig().hideAdverts ? headerY : headerY + 3 + 2;
            List<TabLine> p0 = CollectionUtils.INSTANCE.filterToMutable((Collection)originalColumn.getLines(), arg_0 -> TabListRenderer.drawTabList$lambda$4(lastSubTitle, lastTitle, arg_0));
            boolean bl = false;
            RenderColumn column = new RenderColumn(p0);
            Gui.func_73734_a((int)(middleX - 3 + 1), (int)(middleY - 3 + 1), (int)(middleX + column.getMaxWidth() + 3 - 2), (int)(middleY + column.size() * 9 + 3 - 2), (int)0x20AAAAAA);
            for (TabLine tabLine : column.getLines()) {
                String text;
                boolean hideIcons;
                int savedX = middleX;
                boolean bl2 = hideIcons = this.getConfig().advancedPlayerList.hidePlayerIcons && !AdvancedPlayerList.INSTANCE.ignoreCustomTabList();
                if (tabLine.getType() == TabStringType.PLAYER && !hideIcons) {
                    NetworkPlayerInfo playerInfo = tabLine.getInfo();
                    if (playerInfo != null) {
                        minecraft.func_110434_K().func_110577_a(playerInfo.func_178837_g());
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        Gui.func_152125_a((int)middleX, (int)middleY, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                        EntityPlayer player = tabLine.getEntity(playerInfo);
                        if (player != null && player.func_175148_a(EnumPlayerModelParts.HAT)) {
                            Gui.func_152125_a((int)middleX, (int)middleY, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                        }
                    }
                    middleX += 10;
                }
                String string2 = text = AdvancedPlayerList.INSTANCE.ignoreCustomTabList() ? tabLine.getText() : tabLine.getCustomName();
                if (StringsKt.contains$default((CharSequence)text, "\u00a7l", false, 2, null)) {
                    text = "\u00a7r" + text;
                }
                int n = tabLine.getType() == TabStringType.TITLE ? minecraft.field_71466_p.func_175063_a(text, (float)middleX + (float)column.getMaxWidth() / 2.0f - (float)tabLine.getWidth() / 2.0f, (float)middleY, 0xFFFFFF) : minecraft.field_71466_p.func_175063_a(text, (float)middleX, (float)middleY, 0xFFFFFF);
                middleY += 9;
                middleX = savedX;
            }
            middleX += column.getMaxWidth() + 6;
        }
        if (!((Collection)footer).isEmpty()) {
            int footerY = y + totalHeight - footer.size() * 9 + 1 + 1;
            for (String line : footer) {
                minecraft.field_71466_p.func_175063_a(line, (float)x + (float)totalWidth / 2.0f - (float)minecraft.field_71466_p.func_78256_a(line) / 2.0f, (float)footerY, -1);
                footerY += 9;
            }
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-10.0f);
    }

    private final Pattern getFireSalePattern() {
        return (Pattern)fireSalePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @SubscribeEvent
    public final void onSkipTablistLine(@NotNull SkipTabListLineEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (this.getConfig().hideFiresales && event.getLastSubTitle() != null && RegexUtils.INSTANCE.matches(this.getFireSalePattern(), event.getLastSubTitle().getText())) {
            event.cancel();
        }
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 31, "misc.compactTabList", "gui.compactTabList", null, 8, null);
    }

    private static final boolean drawTabList$lambda$0(String line) {
        Intrinsics.checkNotNullParameter(line, "line");
        return !StringsKt.contains$default((CharSequence)line, TabListReader.INSTANCE.getHypixelAdvertisingString(), false, 2, null);
    }

    private static final boolean drawTabList$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean drawTabList$lambda$2(String line) {
        Intrinsics.checkNotNullParameter(line, "line");
        return !StringsKt.contains$default((CharSequence)line, TabListReader.INSTANCE.getHypixelAdvertisingString(), false, 2, null);
    }

    private static final boolean drawTabList$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean drawTabList$lambda$4(Ref.ObjectRef $lastSubTitle, Ref.ObjectRef $lastTitle, TabLine tabLine) {
        Intrinsics.checkNotNullParameter($lastSubTitle, "$lastSubTitle");
        Intrinsics.checkNotNullParameter($lastTitle, "$lastTitle");
        Intrinsics.checkNotNullParameter(tabLine, "tabLine");
        if (tabLine.getType() == TabStringType.TITLE) {
            $lastSubTitle.element = null;
            $lastTitle.element = tabLine;
        }
        if (tabLine.getType() == TabStringType.SUB_TITLE) {
            $lastSubTitle.element = tabLine;
        }
        return !new SkipTabListLineEvent(tabLine, (TabLine)$lastSubTitle.element, (TabLine)$lastTitle.element).postAndCatch();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(TabListRenderer.class, "fireSalePattern", "getFireSalePattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new TabListRenderer();
        fireSalePattern$delegate = RepoPattern.Companion.pattern("tablist.firesaletitle", "\u00a7.\u00a7lFire Sales: \u00a7r\u00a7f\\([0-9]+\\)");
    }
}

