/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.enums.OutsideSbFeature;
import at.hannibal2.skyhanni.config.features.gui.GUIConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001f\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010!\u001a\u00020 8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020 8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b#\u0010\"R\u0016\u0010$\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010\"R\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020 0%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010\"R\u0016\u0010)\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/features/misc/TpsCounter;", "", "<init>", "()V", "", "tpsCommand", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "event", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "onPacketReceive", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "tps", "", "getColor", "(D)Ljava/lang/String;", "Lat/hannibal2/skyhanni/config/features/gui/GUIConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/gui/GUIConfig;", "config", "", "MIN_DATA_AMOUNT", "I", "WAIT_AFTER_WORLD_SWITCH", "packetsFromLastSecond", "", "tpsList", "Ljava/util/List;", "ignoreFirstTicks", "hasPacketReceived", "Z", "display", "Ljava/lang/String;", "1.8.9"})
public final class TpsCounter {
    @NotNull
    public static final TpsCounter INSTANCE;
    private static final int MIN_DATA_AMOUNT = 5;
    private static final int WAIT_AFTER_WORLD_SWITCH = 6;
    private static int packetsFromLastSecond;
    @NotNull
    private static List<Integer> tpsList;
    private static int ignoreFirstTicks;
    private static boolean hasPacketReceived;
    @NotNull
    private static String display;

    private TpsCounter() {
    }

    private final GUIConfig getConfig() {
        return SkyHanniMod.feature.gui;
    }

    public final void tpsCommand() {
        if (((CharSequence)display).length() == 0) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7cNo tps data available, make sure you have the setting on.", false, null, 6, null);
            return;
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, display, false, null, 6, null);
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        tpsList.clear();
        packetsFromLastSecond = 0;
        ignoreFirstTicks = 6;
        display = "";
    }

    @HandleEvent(priority=1, receiveCancelled=true)
    public final void onPacketReceive(@NotNull PacketReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        hasPacketReceived = true;
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Position position = this.getConfig().tpsDisplayPosition;
        Intrinsics.checkNotNullExpressionValue(position, "tpsDisplayPosition");
        RenderUtils.renderString$default(RenderUtils.INSTANCE, position, display, 0, 0, "Tps Display", 6, null);
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getOnHypixel() && this.getConfig().tpsDisplay && (LorenzUtils.INSTANCE.getInSkyBlock() || OutsideSbFeature.TPS_DISPLAY.isSelected());
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.tpsDisplayEnabled", "gui.tpsDisplay", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.tpsDisplayPosition", "gui.tpsDisplayPosition", null, 8, null);
    }

    private final String getColor(double tps) {
        return tps > 19.8 ? "\u00a72" : (tps > 19.0 ? "\u00a7a" : (tps > 17.5 ? "\u00a76" : (tps > 12.0 ? "\u00a7c" : "\u00a74")));
    }

    public static final /* synthetic */ int access$getPacketsFromLastSecond$p() {
        return packetsFromLastSecond;
    }

    public static final /* synthetic */ int access$getIgnoreFirstTicks$p() {
        return ignoreFirstTicks;
    }

    public static final /* synthetic */ void access$setIgnoreFirstTicks$p(int n) {
        ignoreFirstTicks = n;
    }

    public static final /* synthetic */ void access$setDisplay$p(String string2) {
        display = string2;
    }

    public static final /* synthetic */ void access$setPacketsFromLastSecond$p(int n) {
        packetsFromLastSecond = n;
    }

    public static final /* synthetic */ List access$getTpsList$p() {
        return tpsList;
    }

    public static final /* synthetic */ void access$setTpsList$p(List list) {
        tpsList = list;
    }

    public static final /* synthetic */ String access$getColor(TpsCounter $this, double tps) {
        return $this.getColor(tps);
    }

    public static final /* synthetic */ boolean access$getHasPacketReceived$p() {
        return hasPacketReceived;
    }

    public static final /* synthetic */ void access$setHasPacketReceived$p(boolean bl) {
        hasPacketReceived = bl;
    }

    static {
        Timer timer;
        INSTANCE = new TpsCounter();
        tpsList = new ArrayList();
        ignoreFirstTicks = 6;
        display = "";
        String string2 = "skyhanni-tps-counter-seconds";
        long l = 1000L;
        boolean bl = false;
        long l2 = 0L;
        Timer timer2 = timer = TimersKt.timer(string2, bl);
        timer2.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                TimerTask $this$_init__u24lambda_u240 = this;
                boolean bl = false;
                if (LorenzUtils.INSTANCE.getInSkyBlock() && TpsCounter.access$getPacketsFromLastSecond$p() != 0) {
                    if (TpsCounter.access$getIgnoreFirstTicks$p() > 0) {
                        int n = TpsCounter.access$getIgnoreFirstTicks$p();
                        TpsCounter.access$setIgnoreFirstTicks$p(n + -1);
                        int current = TpsCounter.access$getIgnoreFirstTicks$p() + 5;
                        TpsCounter.access$setDisplay$p("\u00a7eTPS: \u00a7f(" + current + "s)");
                        TpsCounter.access$setPacketsFromLastSecond$p(0);
                    } else {
                        String string2;
                        TpsCounter.access$getTpsList$p().add(TpsCounter.access$getPacketsFromLastSecond$p());
                        TpsCounter.access$setPacketsFromLastSecond$p(0);
                        if (TpsCounter.access$getTpsList$p().size() > 10) {
                            TpsCounter.access$setTpsList$p(CollectionsKt.toMutableList((Collection)CollectionsKt.drop(TpsCounter.INSTANCE.access$getTpsList$p(), 1)));
                        }
                        if (TpsCounter.INSTANCE.access$getTpsList$p().size() < 5) {
                            int current = 5 - TpsCounter.access$getTpsList$p().size();
                            string2 = "\u00a7eTPS: \u00a7f(" + current + "s)";
                        } else {
                            double sum = CollectionsKt.sumOfInt(TpsCounter.access$getTpsList$p());
                            double tps = NumberUtil.INSTANCE.roundTo(sum / (double)TpsCounter.access$getTpsList$p().size(), 1);
                            if (tps > 20.0) {
                                tps = 20.0;
                            }
                            String color = TpsCounter.access$getColor(TpsCounter.INSTANCE, tps);
                            string2 = "\u00a7eTPS: " + color + tps;
                        }
                        TpsCounter.access$setDisplay$p(string2);
                    }
                }
            }
        }, l2, l);
        string2 = "skyhanni-tps-counter-ticks";
        l = 50L;
        bl = false;
        l2 = 0L;
        timer2 = timer = TimersKt.timer(string2, bl);
        timer2.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                TimerTask $this$_init__u24lambda_u241 = this;
                boolean bl = false;
                if (LorenzUtils.INSTANCE.getInSkyBlock() && TpsCounter.access$getHasPacketReceived$p()) {
                    TpsCounter.access$setHasPacketReceived$p(false);
                    int n = TpsCounter.access$getPacketsFromLastSecond$p();
                    TpsCounter.access$setPacketsFromLastSecond$p(n + 1);
                }
            }
        }, l2, l);
    }
}

