/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.misc.MiscConfig;
import at.hannibal2.skyhanni.events.CheckRenderEntityEvent;
import at.hannibal2.skyhanni.events.EntityEquipmentChangeEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\n\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0016\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/features/misc/LesserOrbHider;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/EntityEquipmentChangeEvent;", "event", "", "onArmorChange", "(Lat/hannibal2/skyhanni/events/EntityEquipmentChangeEvent;)V", "Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;", "onCheckRender", "(Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;)V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "config", "", "Lnet/minecraft/entity/item/EntityArmorStand;", "hiddenEntities", "Ljava/util/Set;", "", "LESSER_TEXTURE", "Ljava/lang/String;", "1.8.9"})
public final class LesserOrbHider {
    @NotNull
    public static final LesserOrbHider INSTANCE = new LesserOrbHider();
    @NotNull
    private static final Set<EntityArmorStand> hiddenEntities = CollectionUtils.INSTANCE.weakReferenceList();
    @NotNull
    private static final String LESSER_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjgzMjM2NjM5NjA3MDM2YzFiYTM5MWMyYjQ2YTljN2IwZWZkNzYwYzhiZmEyOTk2YTYwNTU1ODJiNGRhNSJ9fX0=";

    private LesserOrbHider() {
    }

    private final MiscConfig getConfig() {
        return SkyHanniMod.feature.misc;
    }

    @SubscribeEvent
    public final void onArmorChange(@NotNull EntityEquipmentChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Entity entity = event.getEntity();
        ItemStack itemStack2 = event.getNewItemStack();
        if (itemStack2 == null) {
            return;
        }
        ItemStack itemStack3 = itemStack2;
        if (entity instanceof EntityArmorStand && event.isHand() && Intrinsics.areEqual(ItemUtils.INSTANCE.getSkullTexture(itemStack3), LESSER_TEXTURE)) {
            hiddenEntities.add((EntityArmorStand)entity);
        }
    }

    @SubscribeEvent
    public final void onCheckRender(@NotNull CheckRenderEntityEvent<?> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (CollectionsKt.contains((Iterable)hiddenEntities, event.getEntity())) {
            event.cancel();
        }
    }

    @SubscribeEvent
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getType() != EnumParticleTypes.REDSTONE) {
            return;
        }
        for (EntityArmorStand armorStand : hiddenEntities) {
            double distance = LocationUtils.INSTANCE.distanceTo((Entity)armorStand, event.getLocation());
            if (!(distance < 4.0)) continue;
            event.cancel();
        }
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().lesserOrbHider;
    }
}

