/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.CollectionAPI;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u000f\u0010\u0013\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u000f\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0003J\u000f\u0010\u001f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0003J\u0017\u0010!\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\u00148\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b&\u0010'R\"\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00170\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0018\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010,R\u0016\u0010.\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0016\u00100\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010/R\u0016\u00101\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u0010'R\u0016\u00102\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u0010'R\u0016\u00103\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u0010/\u00a8\u00064"}, d2={"Lat/hannibal2/skyhanni/features/misc/CollectionTracker;", "", "<init>", "()V", "", "", "args", "", "command", "([Ljava/lang/String;)V", "rawName", "fixTypo", "(Ljava/lang/String;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "internalName", "name", "setNewCollection", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;Ljava/lang/String;)V", "resetData", "updateDisplay", "", "countCurrentlyInInventory", "()I", "", "handleTabComplete", "(Ljava/lang/String;)Ljava/util/List;", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "event", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "compareInventory", "updateGain", "amount", "gainItems", "(I)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "RECENT_GAIN_TIME", "I", "display", "Ljava/util/List;", "itemName", "Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "", "itemAmount", "J", "goalAmount", "lastAmountInInventory", "recentGain", "lastGainTime", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nCollectionTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionTracker.kt\nat/hannibal2/skyhanni/features/misc/CollectionTracker\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n37#2,2:235\n1611#3,9:237\n1863#3:246\n1864#3:248\n1620#3:249\n1557#3:250\n1628#3,3:251\n1#4:247\n*S KotlinDebug\n*F\n+ 1 CollectionTracker.kt\nat/hannibal2/skyhanni/features/misc/CollectionTracker\n*L\n64#1:235,2\n182#1:237,9\n182#1:246\n182#1:248\n182#1:249\n183#1:250\n183#1:251,3\n182#1:247\n*E\n"})
public final class CollectionTracker {
    @NotNull
    public static final CollectionTracker INSTANCE = new CollectionTracker();
    private static final int RECENT_GAIN_TIME = 1500;
    @NotNull
    private static List<? extends List<? extends Object>> display = CollectionsKt.emptyList();
    @NotNull
    private static String itemName = "";
    @Nullable
    private static NEUInternalName internalName;
    private static long itemAmount;
    private static long goalAmount;
    private static int lastAmountInInventory;
    private static int recentGain;
    private static long lastGainTime;

    private CollectionTracker() {
    }

    public final void command(@NotNull String[] args2) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(args2, "args");
        if (args2.length == 0) {
            if (internalName == null) {
                ChatUtils.INSTANCE.userError("/shtrackcollection <item name> [goal amount]");
                return;
            }
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Stopped collection tracker.", false, null, 6, null);
            this.resetData();
            return;
        }
        String lastArg = ArraysKt.last(args2);
        if (NumberUtil.INSTANCE.isFormatNumber(lastArg)) {
            long goal = NumberUtil.INSTANCE.formatLong(lastArg);
            if (goal <= 0L) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Invalid Amount for Goal.", false, null, 6, null);
                return;
            }
            goalAmount = goal;
            Collection $this$toTypedArray$iv = ArraysKt.dropLast(args2, 1);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new String[0]);
        } else {
            goalAmount = -1L;
            objectArray = args2;
        }
        Object[] nameArgs = objectArray;
        String string2 = ArraysKt.joinToString$default(nameArgs, (CharSequence)" ", null, null, 0, null, null, 62, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String rawName = this.fixTypo(StringsKt.replace$default(string2, "_", " ", false, 4, null));
        if (Intrinsics.areEqual(rawName, "gemstone")) {
            ChatUtils.INSTANCE.userError("Gemstone collection is not supported!");
            return;
        }
        if (Intrinsics.areEqual(rawName, "mushroom")) {
            ChatUtils.INSTANCE.userError("Mushroom collection is not supported!");
            return;
        }
        NEUInternalName foundInternalName = NEUInternalName.Companion.fromItemNameOrNull(rawName);
        if (foundInternalName == null) {
            ChatUtils.INSTANCE.userError("Item '" + rawName + "' does not exist!");
            return;
        }
        ItemStack stack = NEUItems.INSTANCE.getItemStackOrNull(foundInternalName);
        if (stack == null) {
            ChatUtils.INSTANCE.userError("Item '" + rawName + "' does not exist!");
            return;
        }
        this.setNewCollection(foundInternalName, StringUtils.removeColor$default(StringUtils.INSTANCE, ItemUtils.INSTANCE.getName(stack), false, 1, null));
    }

    private final String fixTypo(String rawName) {
        String string2;
        switch (rawName) {
            case "carrots": {
                string2 = "carrot";
                break;
            }
            case "melons": {
                string2 = "melon";
                break;
            }
            case "seed": {
                string2 = "seeds";
                break;
            }
            case "iron": {
                string2 = "iron ingot";
                break;
            }
            case "gold": {
                string2 = "gold ingot";
                break;
            }
            case "sugar": {
                string2 = "sugar cane";
                break;
            }
            case "cocoa": 
            case "cocoa bean": {
                string2 = "cocoa beans";
                break;
            }
            case "lapis": {
                string2 = "lapis lazuli";
                break;
            }
            case "cacti": {
                string2 = "cactus";
                break;
            }
            case "pumpkins": {
                string2 = "pumpkin";
                break;
            }
            case "potatoes": {
                string2 = "potato";
                break;
            }
            case "nether warts": 
            case "wart": 
            case "warts": {
                string2 = "nether wart";
                break;
            }
            case "stone": {
                string2 = "cobblestone";
                break;
            }
            case "mushrooms": 
            case "brown mushroom": 
            case "red mushroom": {
                string2 = "mushroom";
                break;
            }
            case "gemstones": {
                string2 = "gemstone";
                break;
            }
            case "caducous": {
                string2 = "caducous stem";
                break;
            }
            case "agaricus": {
                string2 = "agaricus cap";
                break;
            }
            case "quartz": {
                string2 = "nether quartz";
                break;
            }
            case "glowstone": {
                string2 = "glowstone dust";
                break;
            }
            default: {
                string2 = rawName;
            }
        }
        return string2;
    }

    private final void setNewCollection(NEUInternalName internalName, String name2) {
        Long foundAmount = CollectionAPI.INSTANCE.getCollectionCounter(internalName);
        if (foundAmount == null) {
            ChatUtils.INSTANCE.userError(name2 + " collection not found. Try to open the collection inventory!");
            return;
        }
        CollectionTracker.internalName = internalName;
        itemName = name2;
        itemAmount = foundAmount;
        lastAmountInInventory = this.countCurrentlyInInventory();
        this.updateDisplay();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Started tracking " + itemName + " \u00a7ecollection.", false, null, 6, null);
    }

    private final void resetData() {
        itemAmount = -1L;
        goalAmount = -1L;
        internalName = null;
        lastAmountInInventory = -1;
        display = CollectionsKt.emptyList();
        recentGain = 0;
    }

    private final void updateDisplay() {
        List<Object> list;
        String format = NumberUtil.INSTANCE.addSeparators(itemAmount);
        String gainText = null;
        gainText = "";
        if (recentGain != 0) {
            gainText = "\u00a7a+" + NumberUtil.INSTANCE.addSeparators(recentGain);
        }
        if (goalAmount != -1L && itemAmount >= goalAmount) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Collection goal of \u00a7a" + NumberUtil.INSTANCE.addSeparators(goalAmount) + " reached!", false, null, 6, null);
            goalAmount = -1L;
        }
        String goal = goalAmount == -1L ? "" : " \u00a7f/ \u00a7b" + NumberUtil.INSTANCE.addSeparators(goalAmount) + " \u00a7f(\u00a7a" + NumberUtil.INSTANCE.percentWithColorCode(itemAmount, goalAmount, 1) + "\u00a7f)";
        List<Object> $this$updateDisplay_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        NEUInternalName nEUInternalName = internalName;
        if (nEUInternalName != null) {
            NEUInternalName it = nEUInternalName;
            boolean bl2 = false;
            $this$updateDisplay_u24lambda_u241.add(NEUItems.INSTANCE.getItemStack(it));
        }
        $this$updateDisplay_u24lambda_u241.add(itemName + " collection: \u00a7e" + format + goal + ' ' + gainText);
        display = Collections.singletonList(CollectionsKt.build(list));
    }

    private final int countCurrentlyInInventory() {
        NEUInternalName cactus = NEUInternalName.Companion.asInternalName("CACTUS");
        NEUInternalName cactusGreen = NEUInternalName.Companion.asInternalName("INK_SACK-2");
        return InventoryUtils.INSTANCE.countItemsInLowerInventory(arg_0 -> CollectionTracker.countCurrentlyInInventory$lambda$2(cactus, cactusGreen, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> handleTabComplete(@NotNull String command2) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(command2, "command");
        if (!Intrinsics.areEqual(command2, "shtrackcollection")) {
            return null;
        }
        Iterable $this$mapNotNull$iv = CollectionAPI.INSTANCE.getCollectionValue().keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        ItemStack itemStack2 = $this$forEach$iv$iv$iv.iterator();
        while (itemStack2.hasNext()) {
            ItemStack it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = itemStack2.next();
            boolean bl = false;
            NEUInternalName it = (NEUInternalName)element$iv$iv;
            boolean bl2 = false;
            if (NEUItems.INSTANCE.getItemStackOrNull(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            itemStack2 = (ItemStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
            collection.add(StringsKt.replace$default(StringUtils.removeColor$default(StringUtils.INSTANCE, string2, false, 1, null), " ", "_", false, 4, null));
        }
        return (List)destination$iv$iv;
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
        if (entityPlayerSP == null) {
            return;
        }
        EntityPlayerSP thePlayer = entityPlayerSP;
        if (thePlayer.field_70170_p == null) {
            return;
        }
        this.compareInventory();
        this.updateGain();
    }

    private final void compareInventory() {
        if (lastAmountInInventory == -1) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        int currentlyInInventory = this.countCurrentlyInInventory();
        int diff = currentlyInInventory - lastAmountInInventory;
        if (diff != 0 && diff > 0) {
            this.gainItems(diff);
        }
        lastAmountInInventory = currentlyInInventory;
    }

    private final void updateGain() {
        if (recentGain != 0 && System.currentTimeMillis() > lastGainTime + (long)1500) {
            recentGain = 0;
            this.updateDisplay();
        }
    }

    private final void gainItems(int amount) {
        itemAmount += (long)amount;
        if (System.currentTimeMillis() > lastGainTime + (long)1500) {
            recentGain = 0;
        }
        lastGainTime = System.currentTimeMillis();
        recentGain += amount;
        this.updateDisplay();
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        Position position = SkyHanniMod.feature.misc.collectionCounterPos;
        Intrinsics.checkNotNullExpressionValue(position, "collectionCounterPos");
        RenderUtils.renderStringsAndItems$default(RenderUtils.INSTANCE, position, display, 0, 0.0, "Collection Tracker", 6, null);
    }

    private static final boolean countCurrentlyInInventory$lambda$2(NEUInternalName $cactus, NEUInternalName $cactusGreen, ItemStack it) {
        Intrinsics.checkNotNullParameter($cactus, "$cactus");
        Intrinsics.checkNotNullParameter($cactusGreen, "$cactusGreen");
        Intrinsics.checkNotNullParameter(it, "it");
        if (Intrinsics.areEqual(internalName, $cactus) && Intrinsics.areEqual(ItemUtils.INSTANCE.getInternalName(it), $cactusGreen)) {
            return true;
        }
        return Intrinsics.areEqual(ItemUtils.INSTANCE.getInternalName(it), internalName);
    }

    static {
        itemAmount = -1L;
        goalAmount = -1L;
        lastAmountInInventory = -1;
        lastGainTime = -1L;
    }
}

