/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.inventory.AuctionHousePriceComparisonConfig;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryOpenEvent;
import at.hannibal2.skyhanni.events.LorenzToolTipEvent;
import at.hannibal2.skyhanni.features.inventory.AuctionsHighlighter;
import at.hannibal2.skyhanni.features.misc.items.EstimatedItemValueCalculator;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.client.player.inventory.ContainerLocalMenu;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ7\u0010\u0010\u001a\u00020\u0006*\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J'\u0010%\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b(\u0010)R\u001c\u0010.\u001a\n +*\u0004\u0018\u00010*0*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\"\u00100\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00104\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00103R\u0016\u00105\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106\u00a8\u00067"}, d2={"Lat/hannibal2/skyhanni/features/misc/AuctionHousePriceComparison;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryOpenEvent;", "event", "", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryOpenEvent;)V", "", "", "", "Lnet/minecraft/item/ItemStack;", "stack", "binPrice", "slot", "add", "(Ljava/util/Map;Lnet/minecraft/item/ItemStack;JI)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;", "onTooltip", "(Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Ljava/awt/Color;", "color1", "color2", "", "percentage", "getColorInBetween", "(Ljava/awt/Color;Ljava/awt/Color;D)Ljava/awt/Color;", "delta", "start", "end", "lerp", "(DII)D", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/AuctionHousePriceComparisonConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/AuctionHousePriceComparisonConfig;", "config", "", "slotPriceMap", "Ljava/util/Map;", "bestPrice", "J", "worstPrice", "inInventory", "Z", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nAuctionHousePriceComparison.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuctionHousePriceComparison.kt\nat/hannibal2/skyhanni/features/misc/AuctionHousePriceComparison\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n8#2:151\n8#2:153\n1#3:152\n1#3:154\n*S KotlinDebug\n*F\n+ 1 AuctionHousePriceComparison.kt\nat/hannibal2/skyhanni/features/misc/AuctionHousePriceComparison\n*L\n47#1:151\n50#1:153\n47#1:152\n50#1:154\n*E\n"})
public final class AuctionHousePriceComparison {
    @NotNull
    public static final AuctionHousePriceComparison INSTANCE = new AuctionHousePriceComparison();
    @NotNull
    private static Map<Integer, Long> slotPriceMap = MapsKt.emptyMap();
    private static long bestPrice;
    private static long worstPrice;
    private static boolean inInventory;

    private AuctionHousePriceComparison() {
    }

    private final AuctionHousePriceComparisonConfig getConfig() {
        return SkyHanniMod.feature.inventory.auctions.auctionsPriceComparison;
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inInventory = false;
        if (!StringsKt.startsWith$default(event.getInventoryName(), "Auctions", false, 2, null)) {
            return;
        }
        inInventory = true;
        bestPrice = 0L;
        worstPrice = 0L;
        Map map2 = new LinkedHashMap();
        for (Map.Entry<Integer, ItemStack> entry : event.getInventoryItems().entrySet()) {
            int slot = ((Number)entry.getKey()).intValue();
            ItemStack stack = entry.getValue();
            for (String line : ItemUtils.INSTANCE.getLore(stack)) {
                RegexUtils regexUtils = RegexUtils.INSTANCE;
                Pattern $this$matchMatcher$iv = AuctionsHighlighter.INSTANCE.getBuyItNowPattern();
                boolean $i$f$matchMatcher = false;
                Matcher it$iv = $this$matchMatcher$iv.matcher(line);
                boolean bl = false;
                if (it$iv.matches()) {
                    Intrinsics.checkNotNull(it$iv);
                    Matcher $this$onInventoryOpen_u24lambda_u240 = it$iv;
                    boolean bl2 = false;
                    String string2 = $this$onInventoryOpen_u24lambda_u240.group("coins");
                    Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                    INSTANCE.add(map2, stack, NumberUtil.INSTANCE.formatLong(string2), slot);
                }
                RegexUtils this_$iv = RegexUtils.INSTANCE;
                $this$matchMatcher$iv = AuctionsHighlighter.INSTANCE.getAuctionPattern();
                $i$f$matchMatcher = false;
                it$iv = $this$matchMatcher$iv.matcher(line);
                bl = false;
                if (!it$iv.matches()) continue;
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$onInventoryOpen_u24lambda_u241 = it$iv;
                boolean bl3 = false;
                String string3 = $this$onInventoryOpen_u24lambda_u241.group("coins");
                Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
                INSTANCE.add(map2, stack, NumberUtil.INSTANCE.formatLong(string3), slot);
            }
        }
        slotPriceMap = map2;
    }

    private final void add(Map<Integer, Long> $this$add, ItemStack stack, long binPrice, int slot) {
        double basePrice;
        Pair<Double, Double> pair = EstimatedItemValueCalculator.INSTANCE.calculate(stack, new ArrayList());
        double totalPrice = ((Number)pair.component1()).doubleValue();
        if (totalPrice == (basePrice = ((Number)pair.component2()).doubleValue())) {
            return;
        }
        long estimatedPrice = (long)totalPrice;
        long diff = estimatedPrice - binPrice;
        Integer n = slot;
        Long l = diff;
        $this$add.put(n, l);
        if (diff >= 0L) {
            if (diff > bestPrice) {
                bestPrice = diff;
            }
        } else if (diff < worstPrice) {
            worstPrice = diff;
        }
    }

    @SubscribeEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        String string2 = this.getConfig().good;
        Intrinsics.checkNotNullExpressionValue(string2, "good");
        Color good = ColorUtils.INSTANCE.toChromaColor(string2);
        String string3 = this.getConfig().veryGood;
        Intrinsics.checkNotNullExpressionValue(string3, "veryGood");
        Color veryGood = ColorUtils.INSTANCE.toChromaColor(string3);
        String string4 = this.getConfig().bad;
        Intrinsics.checkNotNullExpressionValue(string4, "bad");
        Color bad = ColorUtils.INSTANCE.toChromaColor(string4);
        String string5 = this.getConfig().veryBad;
        Intrinsics.checkNotNullExpressionValue(string5, "veryBad");
        Color veryBad = ColorUtils.INSTANCE.toChromaColor(string5);
        for (Slot slot : InventoryUtils.INSTANCE.getItemsInOpenChest()) {
            Long l = slotPriceMap.get(slot.getSlotIndex());
            if (l == null) {
                continue;
            }
            long diff = l;
            if (diff == 0L) {
                RenderUtils.INSTANCE.highlight(slot, good);
                continue;
            }
            boolean isGood = diff >= 0L;
            double percentage = isGood ? (double)diff / (double)bestPrice : -((double)diff) / (double)(-worstPrice);
            Color color = isGood ? this.getColorInBetween(good, veryGood, percentage) : this.getColorInBetween(bad, veryBad, percentage);
            RenderUtils.INSTANCE.highlight(slot, color);
        }
    }

    @SubscribeEvent
    public final void onTooltip(@NotNull LorenzToolTipEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Long l = slotPriceMap.get(event.getSlot().getSlotIndex());
        if (l == null) {
            return;
        }
        long diff = l;
        if (!(event.getSlot().field_75224_c instanceof ContainerLocalMenu)) {
            return;
        }
        event.getToolTip().add("");
        if (diff >= 0L) {
            event.getToolTip().add("\u00a7aThis item is \u00a76" + NumberUtil.INSTANCE.addSeparators(diff) + " coins \u00a7acheaper");
            bl = event.getToolTip().add("\u00a7athan the estimated item value!");
        } else {
            event.getToolTip().add("\u00a7cThis item is \u00a76" + NumberUtil.INSTANCE.addSeparators(-diff) + " coins \u00a7cmore");
            bl = event.getToolTip().add("\u00a7cexpensive than the estimated item value!");
        }
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 31, "inventory.auctionsPriceComparison", "inventory.auctions.auctionsPriceComparison", null, 8, null);
    }

    private final Color getColorInBetween(Color color1, Color color2, double percentage) {
        int r1 = color1.getRed();
        int g1 = color1.getGreen();
        int b1 = color1.getBlue();
        int r2 = color2.getRed();
        int g2 = color2.getGreen();
        int b2 = color2.getBlue();
        int newRed = RangesKt.coerceIn((int)this.lerp(percentage, r1, r2), 0, 255);
        int newGreen = RangesKt.coerceIn((int)this.lerp(percentage, g1, g2), 0, 255);
        int newBlue = RangesKt.coerceIn((int)this.lerp(percentage, b1, b2), 0, 255);
        return new Color(newRed, newGreen, newBlue);
    }

    private final double lerp(double delta, int start2, int end) {
        return (double)start2 + delta * (double)(end - start2);
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled && inInventory;
    }
}

