/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.GetFromSackAPI;
import at.hannibal2.skyhanni.config.features.mining.MiningNotificationsConfig;
import at.hannibal2.skyhanni.data.MiningAPI;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ColdUpdateEvent;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.PrimitiveItemStack;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001b\u0010\u001b\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001b\u0010$\u001a\u00020\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001b\u0010'\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010!\u001a\u0004\b&\u0010#R\u001b\u0010*\u001a\u00020\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010!\u001a\u0004\b)\u0010#R\u001b\u0010-\u001a\u00020\u001f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010!\u001a\u0004\b,\u0010#R\u001c\u00102\u001a\n /*\u0004\u0018\u00010.0.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0016\u00104\u001a\u0002038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0016\u00106\u001a\u0002038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00105\u00a8\u00068"}, d2={"Lat/hannibal2/skyhanni/features/mining/MiningNotifications;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/events/ColdUpdateEvent;", "onColdUpdate", "(Lat/hannibal2/skyhanni/events/ColdUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/features/mining/MiningNotifications$MiningNotificationList;", "type", "sendNotification", "(Lat/hannibal2/skyhanni/features/mining/MiningNotifications$MiningNotificationList;)V", "Lat/hannibal2/skyhanni/utils/PrimitiveItemStack;", "ASCENSION_ROPE$delegate", "Lkotlin/Lazy;", "getASCENSION_ROPE", "()Lat/hannibal2/skyhanni/utils/PrimitiveItemStack;", "ASCENSION_ROPE", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "mineshaftSpawn$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getMineshaftSpawn", "()Ljava/util/regex/Pattern;", "mineshaftSpawn", "scrapDrop$delegate", "getScrapDrop", "scrapDrop", "goldenGoblinSpawn$delegate", "getGoldenGoblinSpawn", "goldenGoblinSpawn", "diamondGoblinSpawn$delegate", "getDiamondGoblinSpawn", "diamondGoblinSpawn", "Lat/hannibal2/skyhanni/config/features/mining/MiningNotificationsConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/MiningNotificationsConfig;", "config", "", "hasSentCold", "Z", "hasSentAscensionRope", "MiningNotificationList", "1.8.9"})
public final class MiningNotifications {
    @NotNull
    public static final MiningNotifications INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final Lazy ASCENSION_ROPE$delegate;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern mineshaftSpawn$delegate;
    @NotNull
    private static final RepoPattern scrapDrop$delegate;
    @NotNull
    private static final RepoPattern goldenGoblinSpawn$delegate;
    @NotNull
    private static final RepoPattern diamondGoblinSpawn$delegate;
    private static boolean hasSentCold;
    private static boolean hasSentAscensionRope;

    private MiningNotifications() {
    }

    private final PrimitiveItemStack getASCENSION_ROPE() {
        Lazy lazy = ASCENSION_ROPE$delegate;
        return (PrimitiveItemStack)lazy.getValue();
    }

    @NotNull
    public final Pattern getMineshaftSpawn() {
        return (Pattern)mineshaftSpawn$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getScrapDrop() {
        return (Pattern)scrapDrop$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @NotNull
    public final Pattern getGoldenGoblinSpawn() {
        return (Pattern)goldenGoblinSpawn$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    @NotNull
    public final Pattern getDiamondGoblinSpawn() {
        return (Pattern)diamondGoblinSpawn$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    private final MiningNotificationsConfig getConfig() {
        return SkyHanniMod.feature.mining.notifications;
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.inMiningIsland()) {
            return;
        }
        if (!this.getConfig().enabled) {
            return;
        }
        String message = event.getMessage();
        if (RegexUtils.INSTANCE.matches(this.getMineshaftSpawn(), message)) {
            this.sendNotification(MiningNotificationList.MINESHAFT_SPAWN);
        } else if (RegexUtils.INSTANCE.matches(this.getScrapDrop(), message)) {
            this.sendNotification(MiningNotificationList.SCRAP);
        } else if (RegexUtils.INSTANCE.matches(this.getGoldenGoblinSpawn(), message)) {
            this.sendNotification(MiningNotificationList.GOLDEN_GOBLIN);
        } else if (RegexUtils.INSTANCE.matches(this.getDiamondGoblinSpawn(), message)) {
            this.sendNotification(MiningNotificationList.DIAMOND_GOBLIN);
        }
    }

    @SubscribeEvent
    public final void onColdUpdate(@NotNull ColdUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!MiningAPI.INSTANCE.inGlaciteArea()) {
            return;
        }
        if (!this.getConfig().enabled) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(MiningAPI.INSTANCE.getLastColdReset-uFjCsEo()), DurationKt.toDuration(1, DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (event.getCold() >= ((Number)this.getConfig().coldThreshold.get()).intValue() && !hasSentCold) {
            hasSentCold = true;
            this.sendNotification(MiningNotificationList.COLD);
        }
        if (MiningAPI.INSTANCE.inMineshaft() && this.getConfig().getAscensionRope && event.getCold() >= this.getConfig().coldAmount && !hasSentAscensionRope) {
            hasSentAscensionRope = true;
            DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(0.5, DurationUnit.SECONDS), MiningNotifications::onColdUpdate$lambda$1);
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        hasSentCold = false;
        hasSentAscensionRope = false;
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property[] propertyArray = new Property[]{this.getConfig().coldThreshold};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, MiningNotifications::onConfigLoad$lambda$2);
    }

    private final void sendNotification(MiningNotificationList type2) {
        if (!this.getConfig().notifications.contains((Object)type2)) {
            return;
        }
        LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, type2.getNotification(), DurationKt.toDuration(1500, DurationUnit.MILLISECONDS), 0.0, 0.0f, 12, null);
        if (this.getConfig().playSound) {
            SoundUtils.INSTANCE.playPlingSound();
        }
    }

    private static final PrimitiveItemStack ASCENSION_ROPE_delegate$lambda$0() {
        return PrimitiveItemStack.Companion.makePrimitiveStack(NEUInternalName.Companion.asInternalName("ASCENSION_ROPE"), 1);
    }

    private static final Unit onColdUpdate$lambda$1() {
        GetFromSackAPI.getFromChatMessageSackItems$default(GetFromSackAPI.INSTANCE, INSTANCE.getASCENSION_ROPE(), null, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final void onConfigLoad$lambda$2() {
        Integer n = (Integer)MiningNotifications.INSTANCE.getConfig().coldThreshold.get();
        if (n == null || MiningAPI.INSTANCE.getCold() != n.intValue()) {
            hasSentCold = false;
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MiningNotifications.class, "mineshaftSpawn", "getMineshaftSpawn()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MiningNotifications.class, "scrapDrop", "getScrapDrop()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MiningNotifications.class, "goldenGoblinSpawn", "getGoldenGoblinSpawn()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(MiningNotifications.class, "diamondGoblinSpawn", "getDiamondGoblinSpawn()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new MiningNotifications();
        ASCENSION_ROPE$delegate = LazyKt.lazy(MiningNotifications::ASCENSION_ROPE_delegate$lambda$0);
        patternGroup = RepoPattern.Companion.group("mining.notifications");
        mineshaftSpawn$delegate = patternGroup.pattern("mineshaft.spawn", "\u00a75\u00a7lWOW! \u00a7r\u00a7aYou found a \u00a7r\u00a7bGlacite Mineshaft \u00a7r\u00a7aportal!");
        scrapDrop$delegate = patternGroup.pattern("scrapdrop", "\u00a76\u00a7lEXCAVATOR! \u00a7r\u00a7fYou found a \u00a7r\u00a79Suspicious Scrap\u00a7r\u00a7f!");
        goldenGoblinSpawn$delegate = patternGroup.pattern("goblin.goldspawn", "\u00a76A Golden Goblin has spawned!");
        diamondGoblinSpawn$delegate = patternGroup.pattern("goblin.diamondspawn", "\u00a76A \u00a7r\u00a7bDiamond Goblin \u00a7r\u00a76has spawned!");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\t\u001a\u0004\b\n\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\u000b\u0010\bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lat/hannibal2/skyhanni/features/mining/MiningNotifications$MiningNotificationList;", "", "", "str", "notification", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getStr", "getNotification", "MINESHAFT_SPAWN", "SCRAP", "GOLDEN_GOBLIN", "DIAMOND_GOBLIN", "COLD", "1.8.9"})
    public static final class MiningNotificationList
    extends Enum<MiningNotificationList> {
        @NotNull
        private final String str;
        @NotNull
        private final String notification;
        public static final /* enum */ MiningNotificationList MINESHAFT_SPAWN = new MiningNotificationList("\u00a7bGlacite Mineshaft", "\u00a7bMineshaft");
        public static final /* enum */ MiningNotificationList SCRAP = new MiningNotificationList("\u00a79Suspicious Scrap", "\u00a79Suspicious Scrap");
        public static final /* enum */ MiningNotificationList GOLDEN_GOBLIN = new MiningNotificationList("\u00a76Golden Goblin", "\u00a76Golden Goblin");
        public static final /* enum */ MiningNotificationList DIAMOND_GOBLIN = new MiningNotificationList("\u00a7bDiamond Goblin", "\u00a7bDiamond Goblin");
        public static final /* enum */ MiningNotificationList COLD = new MiningNotificationList("\u00a7bCold", "\u00a7bCold");
        private static final /* synthetic */ MiningNotificationList[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MiningNotificationList(String str, String notification) {
            this.str = str;
            this.notification = notification;
        }

        @NotNull
        public final String getStr() {
            return this.str;
        }

        @NotNull
        public final String getNotification() {
            return this.notification;
        }

        @NotNull
        public String toString() {
            return this.str;
        }

        public static MiningNotificationList[] values() {
            return (MiningNotificationList[])$VALUES.clone();
        }

        public static MiningNotificationList valueOf(String value) {
            return Enum.valueOf(MiningNotificationList.class, value);
        }

        @NotNull
        public static EnumEntries<MiningNotificationList> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = miningNotificationListArray = new MiningNotificationList[]{MiningNotificationList.MINESHAFT_SPAWN, MiningNotificationList.SCRAP, MiningNotificationList.GOLDEN_GOBLIN, MiningNotificationList.DIAMOND_GOBLIN, MiningNotificationList.COLD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

