/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.experimentationtable;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.inventory.experimentationtable.ExperimentsProfitTrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryUpdatedEvent;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.features.inventory.experimentationtable.ExperimentMessages;
import at.hannibal2.skyhanni.features.inventory.experimentationtable.ExperimentationTableAPI;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemPriceUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import at.hannibal2.skyhanni.utils.tracker.ItemTrackerData;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniItemTracker;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001AB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u000b\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\u0006\u00a2\u0006\u0004\b\"\u0010\u0003J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0013\u0010(\u001a\u00020#*\u00020'H\u0002\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020#H\u0002\u00a2\u0006\u0004\b*\u0010+R\u001c\u00100\u001a\n -*\u0004\u0018\u00010,0,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\"\u00102\u001a\u0010\u0012\f\u0012\n -*\u0004\u0018\u00010\u00160\u0016018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u001c\u00106\u001a\b\u0012\u0004\u0012\u000205048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00109\u001a\u0002088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\"\u0010>\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020=0;8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\"\u0010@\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020=0;8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010?\u00a8\u0006B"}, d2={"Lat/hannibal2/skyhanni/features/inventory/experimentationtable/ExperimentsProfitTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "", "reward", "handleDrop", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "onItemClick", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "onInventoryUpdated", "(Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/features/inventory/experimentationtable/ExperimentsProfitTracker$Data;", "data", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/inventory/experimentationtable/ExperimentsProfitTracker$Data;)Ljava/util/List;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "resetCommand", "", "addToTracker", "handleExpBottles", "(Z)V", "Lat/hannibal2/skyhanni/features/inventory/experimentationtable/ExperimentMessages;", "isSelected", "(Lat/hannibal2/skyhanni/features/inventory/experimentationtable/ExperimentMessages;)Z", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/experimentationtable/ExperimentsProfitTrackerConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/experimentationtable/ExperimentsProfitTrackerConfig;", "config", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "tracker", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "", "Lnet/minecraft/item/ItemStack;", "lastSplashes", "Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastSplashTime", "J", "", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "", "lastBottlesInInventory", "Ljava/util/Map;", "currentBottlesInInventory", "Data", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nExperimentsProfitTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExperimentsProfitTracker.kt\nat/hannibal2/skyhanni/features/inventory/experimentationtable/ExperimentsProfitTracker\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n8#2:264\n8#2:266\n8#2:268\n1#3:265\n1#3:267\n1#3:269\n*S KotlinDebug\n*F\n+ 1 ExperimentsProfitTracker.kt\nat/hannibal2/skyhanni/features/inventory/experimentationtable/ExperimentsProfitTracker\n*L\n107#1:264\n112#1:266\n129#1:268\n107#1:265\n112#1:267\n129#1:269\n*E\n"})
public final class ExperimentsProfitTracker {
    @NotNull
    public static final ExperimentsProfitTracker INSTANCE = new ExperimentsProfitTracker();
    @NotNull
    private static final SkyHanniItemTracker<Data> tracker = new SkyHanniItemTracker<Data>("Experiments Profit Tracker", ExperimentsProfitTracker::tracker$lambda$0, ExperimentsProfitTracker::tracker$lambda$1, new Pair[0], ExperimentsProfitTracker::tracker$lambda$2);
    @NotNull
    private static List<ItemStack> lastSplashes = new ArrayList();
    private static long lastSplashTime = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static Map<NEUInternalName, Integer> lastBottlesInInventory = new LinkedHashMap();
    @NotNull
    private static Map<NEUInternalName, Integer> currentBottlesInInventory = new LinkedHashMap();

    private ExperimentsProfitTracker() {
    }

    private final ExperimentsProfitTrackerConfig getConfig() {
        return SkyHanniMod.feature.inventory.experimentationTable.experimentsProfitTracker;
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        String message = StringUtils.removeColor$default(StringUtils.INSTANCE, event.getMessage(), false, 1, null);
        if (RegexUtils.INSTANCE.matches(ExperimentationTableAPI.INSTANCE.getClaimMessagePattern(), message) && this.isSelected(ExperimentMessages.DONE)) {
            event.setBlockedReason("CLAIM_MESSAGE");
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = ExperimentationTableAPI.INSTANCE.getExperimentsDropPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(message);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u243 = it$iv;
            boolean bl2 = false;
            String string2 = $this$onChat_u24lambda_u243.group("reward");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            INSTANCE.handleDrop(event, string2);
            return;
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = ExperimentationTableAPI.INSTANCE.getExperimentRenewPattern();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(message);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u245 = it$iv;
            boolean bl3 = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to(1, 150), TuplesKt.to(2, 300), TuplesKt.to(3, 500)};
            Map increments = MapsKt.mapOf(pairArray);
            tracker.modify(arg_0 -> ExperimentsProfitTracker.onChat$lambda$5$lambda$4(increments, $this$onChat_u24lambda_u245, arg_0));
        }
    }

    private final void handleDrop(LorenzChatEvent $this$handleDrop, String reward) {
        String[] stringArray;
        $this$handleDrop.setBlockedReason(RegexUtils.INSTANCE.matches(ExperimentationTableAPI.INSTANCE.getEnchantingExpPattern(), reward) && this.isSelected(ExperimentMessages.EXPERIENCE) ? "EXPERIENCE_DROP" : (RegexUtils.INSTANCE.matches(ExperimentationTableAPI.INSTANCE.getExperienceBottlePattern(), reward) && this.isSelected(ExperimentMessages.BOTTLES) ? "BOTTLE_DROP" : (CollectionsKt.listOf(stringArray = new String[]{"Metaphysical Serum", "Experiment The Fish"}).contains(reward) && this.isSelected(ExperimentMessages.MISC) ? "MISC_DROP" : (this.isSelected(ExperimentMessages.ENCHANTMENTS) ? "ENCHANT_DROP" : ""))));
        stringArray = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = ExperimentationTableAPI.INSTANCE.getEnchantingExpPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(reward);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$handleDrop_u24lambda_u247 = it$iv;
            boolean bl2 = false;
            tracker.modify(arg_0 -> ExperimentsProfitTracker.handleDrop$lambda$7$lambda$6($this$handleDrop_u24lambda_u247, arg_0));
            return;
        }
        NEUInternalName nEUInternalName = NEUInternalName.Companion.fromItemNameOrNull(reward);
        if (nEUInternalName == null) {
            return;
        }
        NEUInternalName internalName = nEUInternalName;
        if (!RegexUtils.INSTANCE.matches(ExperimentationTableAPI.INSTANCE.getExperienceBottlePattern(), reward)) {
            tracker.addItem(internalName, 1, false);
        } else {
            SimpleTimeMark.box-impl(DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration(100, DurationUnit.MILLISECONDS), ExperimentsProfitTracker::handleDrop$lambda$8));
        }
    }

    @SubscribeEvent
    public final void onItemClick(@NotNull ItemClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getClickType() == ClickType.RIGHT_CLICK) {
            ItemStack itemStack2 = event.getItemInHand();
            if (itemStack2 == null) {
                return;
            }
            ItemStack item = itemStack2;
            Pattern pattern = ExperimentationTableAPI.INSTANCE.getExperienceBottlePattern();
            String string2 = item.func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
            if (RegexUtils.INSTANCE.matches(pattern, StringUtils.removeColor$default(StringUtils.INSTANCE, string2, false, 1, null))) {
                lastSplashTime = SimpleTimeMark.Companion.now-uFjCsEo();
                lastSplashes.add(item);
            }
        }
    }

    @SubscribeEvent
    public final void onInventoryUpdated(@NotNull InventoryUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (RegexUtils.INSTANCE.matches(ExperimentationTableAPI.INSTANCE.getInventoriesPattern(), event.getInventoryName())) {
            Ref.IntRef startCostTemp = new Ref.IntRef();
            Iterator<ItemStack> iterator2 = lastSplashes.iterator();
            while (iterator2.hasNext()) {
                ItemStack item = iterator2.next();
                NEUInternalName internalName = ItemUtils.INSTANCE.getInternalName(item);
                double price = ItemPriceUtils.getPrice$default(ItemPriceUtils.INSTANCE, internalName, null, null, 3, null);
                Double d = ItemPriceUtils.INSTANCE.getNpcPriceOrNull(internalName);
                double npcPrice = d != null ? d : 0.0;
                double maxPrice = RangesKt.coerceAtLeast(npcPrice, price);
                startCostTemp.element += (int)NumberUtil.INSTANCE.roundTo(maxPrice, 0);
                iterator2.remove();
            }
            tracker.modify(arg_0 -> ExperimentsProfitTracker.onInventoryUpdated$lambda$9(startCostTemp, arg_0));
            lastSplashTime = SimpleTimeMark.Companion.farPast();
        }
        this.handleExpBottles(false);
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (ExperimentationTableAPI.INSTANCE.getCurrentExperiment() != null) {
            tracker.modify(ExperimentsProfitTracker::onInventoryClose$lambda$10);
        }
    }

    private final List<Searchable> drawDisplay(Data data2) {
        List<Searchable> list;
        List<Searchable> $this$drawDisplay_u24lambda_u2412 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u2412, "\u00a7e\u00a7lExperiments Profit Tracker", null, null, null, 14, null);
        double profit = tracker.drawItems((Data)((ItemTrackerData)data2), ExperimentsProfitTracker::drawDisplay$lambda$12$lambda$11, $this$drawDisplay_u24lambda_u2412) + (double)data2.getStartCost();
        long experimentsDone = data2.getExperimentsDone();
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u2412, "", null, null, null, 14, null);
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u2412, "\u00a7eExperiments Done: \u00a7a" + NumberUtil.INSTANCE.addSeparators(experimentsDone), null, null, null, 14, null);
        String startCostFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, Math.abs(data2.getStartCost()), false, 1, null);
        String bitCostFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, data2.getBitCost(), false, 1, null);
        String[] stringArray = new String[]{"\u00a77You paid \u00a7c" + startCostFormat + " \u00a77coins and", "\u00a7b" + bitCostFormat + " \u00a77bits for starting", "\u00a77experiments."};
        $this$drawDisplay_u24lambda_u2412.add(SearchableKt.toSearchable$default(Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a7eTotal Cost: \u00a7c-" + startCostFormat + "\u00a7e/\u00a7b-" + bitCostFormat, CollectionsKt.listOf(stringArray), null, null, null, false, false, false, null, null, 1020, null), null, 1, null));
        $this$drawDisplay_u24lambda_u2412.add(tracker.addTotalProfit(profit, data2.getExperimentsDone(), "experiment"));
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u2412, "\u00a7eTotal Enchanting Exp: \u00a7b" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, data2.getXpGained(), false, 1, null), null, null, null, 14, null);
        tracker.addPriceFromButton($this$drawDisplay_u24lambda_u2412);
        return CollectionsKt.build(list);
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        tracker.renderDisplay(position);
    }

    @SubscribeEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getNewIsland() == IslandType.PRIVATE_ISLAND) {
            tracker.firstUpdate();
        }
    }

    public final void resetCommand() {
        tracker.resetCommand();
    }

    private final void handleExpBottles(boolean addToTracker) {
        NEUInternalName internalName;
        for (ItemStack entry : InventoryUtils.INSTANCE.getItemsInOwnInventory()) {
            if (ItemUtils.INSTANCE.getInternalNameOrNull(entry) == null) continue;
            String[] stringArray = new String[]{"EXP_BOTTLE", "GRAND_EXP_BOTTLE", "TITANIC_EXP_BOTTLE"};
            if (!CollectionsKt.listOf(stringArray).contains(internalName.asString())) continue;
            CollectionUtils.INSTANCE.addOrPut(currentBottlesInInventory, internalName, entry.field_77994_a);
        }
        for (Map.Entry entry : currentBottlesInInventory.entrySet()) {
            Integer n;
            internalName = (NEUInternalName)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            int lastInInv = ((Number)lastBottlesInInventory.getOrDefault(internalName, 0)).intValue();
            if (lastInInv >= amount) {
                currentBottlesInInventory.put(internalName, 0);
                n = amount;
                lastBottlesInInventory.put(internalName, n);
                continue;
            }
            if (lastInInv == 0) {
                currentBottlesInInventory.put(internalName, 0);
                n = amount;
                lastBottlesInInventory.put(internalName, n);
                if (!addToTracker) continue;
                tracker.addItem(internalName, amount, false);
                continue;
            }
            currentBottlesInInventory.put(internalName, 0);
            n = amount;
            lastBottlesInInventory.put(internalName, n);
            if (!addToTracker) continue;
            tracker.addItem(internalName, amount - lastInInv, false);
        }
    }

    private final boolean isSelected(ExperimentMessages $this$isSelected) {
        return this.getConfig().hideMessages.contains((Object)$this$isSelected);
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled && ExperimentationTableAPI.INSTANCE.inDistanceToTable(LorenzVec.Companion.getBlockBelowPlayer(), 5.0);
    }

    private static final Data tracker$lambda$0() {
        return new Data();
    }

    private static final Data tracker$lambda$1(ProfileSpecificStorage it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.experimentation.experimentsProfitTracker;
    }

    private static final List tracker$lambda$2(Data it) {
        Intrinsics.checkNotNull(it);
        return INSTANCE.drawDisplay(it);
    }

    private static final Unit onChat$lambda$5$lambda$4(Map $increments, Matcher $this_matchMatcher, Data it) {
        Intrinsics.checkNotNullParameter($increments, "$increments");
        Intrinsics.checkNotNullParameter($this_matchMatcher, "$this_matchMatcher");
        long l = it.getBitCost();
        String string2 = $this_matchMatcher.group("current");
        Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
        it.setBitCost(l + ((Number)MapsKt.getValue($increments, Integer.parseInt(string2))).longValue());
        return Unit.INSTANCE;
    }

    private static final Unit handleDrop$lambda$7$lambda$6(Matcher $this_matchMatcher, Data it) {
        Intrinsics.checkNotNullParameter($this_matchMatcher, "$this_matchMatcher");
        long l = it.getXpGained();
        String string2 = $this_matchMatcher.group("amount");
        Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
        it.setXpGained(l + (long)(Integer.parseInt(StringsKt.substringBefore$default(string2, ",", null, 2, null)) * 1000));
        return Unit.INSTANCE;
    }

    private static final Unit handleDrop$lambda$8() {
        INSTANCE.handleExpBottles(true);
        return Unit.INSTANCE;
    }

    private static final Unit onInventoryUpdated$lambda$9(Ref.IntRef $startCostTemp, Data it) {
        Intrinsics.checkNotNullParameter($startCostTemp, "$startCostTemp");
        it.setStartCost(it.getStartCost() - (long)$startCostTemp.element);
        return Unit.INSTANCE;
    }

    private static final Unit onInventoryClose$lambda$10(Data it) {
        long l = it.getExperimentsDone();
        it.setExperimentsDone(l + 1L);
        return Unit.INSTANCE;
    }

    private static final boolean drawDisplay$lambda$12$lambda$11(NEUInternalName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\"\u0010\u001b\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0013\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u0017R\"\u0010\u001e\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0013\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017\u00a8\u0006!"}, d2={"Lat/hannibal2/skyhanni/features/inventory/experimentationtable/ExperimentsProfitTracker$Data;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData;", "<init>", "()V", "", "resetItems", "", "timesGained", "", "", "getDescription", "(J)Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;", "item", "getCoinName", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/lang/String;", "getCoinDescription", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/util/List;", "experimentsDone", "J", "getExperimentsDone", "()J", "setExperimentsDone", "(J)V", "xpGained", "getXpGained", "setXpGained", "bitCost", "getBitCost", "setBitCost", "startCost", "getStartCost", "setStartCost", "1.8.9"})
    public static final class Data
    extends ItemTrackerData {
        @Expose
        private long experimentsDone;
        @Expose
        private long xpGained;
        @Expose
        private long bitCost;
        @Expose
        private long startCost;

        @Override
        public void resetItems() {
            this.experimentsDone = 0L;
            this.xpGained = 0L;
            this.bitCost = 0L;
            this.startCost = 0L;
        }

        @Override
        @NotNull
        public List<String> getDescription(long timesGained) {
            double percentage = (double)timesGained / (double)this.experimentsDone;
            String dropRate = LorenzUtils.INSTANCE.formatPercentage(RangesKt.coerceAtMost(percentage, 1.0));
            String[] stringArray = new String[]{"\u00a77Dropped \u00a7e" + NumberUtil.INSTANCE.addSeparators(timesGained) + " \u00a77times.", "\u00a77Your drop rate: \u00a7c" + dropRate + '.'};
            return CollectionsKt.listOf(stringArray);
        }

        @Override
        @NotNull
        public String getCoinName(@NotNull ItemTrackerData.TrackedItem item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return "";
        }

        @Override
        @NotNull
        public List<String> getCoinDescription(@NotNull ItemTrackerData.TrackedItem item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return CollectionsKt.emptyList();
        }

        public final long getExperimentsDone() {
            return this.experimentsDone;
        }

        public final void setExperimentsDone(long l) {
            this.experimentsDone = l;
        }

        public final long getXpGained() {
            return this.xpGained;
        }

        public final void setXpGained(long l) {
            this.xpGained = l;
        }

        public final long getBitCost() {
            return this.bitCost;
        }

        public final void setBitCost(long l) {
            this.bitCost = l;
        }

        public final long getStartCost() {
            return this.startCost;
        }

        public final void setStartCost(long l) {
            this.startCost = l;
        }
    }
}

