/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.craft;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.inventory.CraftableItemListConfig;
import at.hannibal2.skyhanni.data.SackAPI;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryOpenEvent;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.PrimitiveItemStack;
import at.hannibal2.skyhanni.utils.PrimitiveRecipe;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ7\u0010\u000f\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010JI\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00112\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0016\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010\f\u001a\u00020\u000b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u0013H\u0002\u00a2\u0006\u0004\b\f\u0010\u001eJ7\u0010!\u001a\u00020\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u00132\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001b\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'J\r\u0010)\u001a\u00020(\u00a2\u0006\u0004\b)\u0010*R\u001c\u0010/\u001a\n ,*\u0004\u0018\u00010+0+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\r008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00103\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u001b\u0010:\u001a\u0002058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109\u00a8\u0006;"}, d2={"Lat/hannibal2/skyhanni/features/inventory/craft/CraftableItemList;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryOpenEvent;", "event", "", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryOpenEvent;)V", "", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "", "pricePer", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "lines", "loadItems", "(Ljava/util/Map;Ljava/util/Map;)V", "Lat/hannibal2/skyhanni/utils/PrimitiveRecipe;", "recipe", "", "", "availableMaterial", "internalName", "createItemRenderable", "(Lat/hannibal2/skyhanni/utils/PrimitiveRecipe;Ljava/util/Map;Ljava/util/Map;Lat/hannibal2/skyhanni/utils/NEUInternalName;)Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "", "neededItems", "(Ljava/util/Map;)D", "need", "available", "canCraftAmount", "(Ljava/util/Map;Ljava/util/Map;)I", "readItems", "()Ljava/util/Map;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/CraftableItemListConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/CraftableItemListConfig;", "config", "", "display", "Ljava/util/List;", "inInventory", "Z", "Ljava/util/regex/Pattern;", "craftItemPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getCraftItemPattern", "()Ljava/util/regex/Pattern;", "craftItemPattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nCraftableItemList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CraftableItemList.kt\nat/hannibal2/skyhanni/features/inventory/craft/CraftableItemList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,163:1\n1557#2:164\n1628#2,3:165\n126#3:168\n153#3,3:169\n*S KotlinDebug\n*F\n+ 1 CraftableItemList.kt\nat/hannibal2/skyhanni/features/inventory/craft/CraftableItemList\n*L\n56#1:164\n56#1:165,3\n127#1:168\n127#1:169,3\n*E\n"})
public final class CraftableItemList {
    @NotNull
    public static final CraftableItemList INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static List<? extends Renderable> display;
    private static boolean inInventory;
    @NotNull
    private static final RepoPattern craftItemPattern$delegate;

    private CraftableItemList() {
    }

    private final CraftableItemListConfig getConfig() {
        return SkyHanniMod.feature.inventory.craftableItemList;
    }

    private final Pattern getCraftItemPattern() {
        return (Pattern)craftItemPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        List<Renderable> list;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(this.getCraftItemPattern(), event.getInventoryName())) {
            return;
        }
        inInventory = true;
        Map pricePer = new LinkedHashMap();
        Map lines = new LinkedHashMap();
        this.loadItems(pricePer, lines);
        if (lines.isEmpty()) {
            list = CollectionsKt.listOf(Renderable.Companion.string$default(Renderable.Companion, "\u00a77No Items to craft", 0.0, null, null, null, 30, null));
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionUtils.INSTANCE.sortedDesc(pricePer).keySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NEUInternalName nEUInternalName = (NEUInternalName)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Renderable renderable2 = (Renderable)lines.get(it);
                if (renderable2 == null) {
                    throw new IllegalStateException("impossible".toString());
                }
                collection.add(renderable2);
            }
            List items = (List)destination$iv$iv;
            Renderable[] renderableArray = new Renderable[]{Renderable.Companion.string$default(Renderable.Companion, "\u00a7eCraftable items (" + items.size() + ')', 0.0, null, null, null, 30, null), Renderable.Companion.scrollList$default(Renderable.Companion, items, 250, null, 20.0, null, false, null, null, 244, null)};
            list = CollectionsKt.listOf(renderableArray);
        }
        display = list;
    }

    private final void loadItems(Map<NEUInternalName, Double> pricePer, Map<NEUInternalName, Renderable> lines) {
        Map<NEUInternalName, Long> availableMaterial = this.readItems();
        for (NEUInternalName internalName : NEUItems.INSTANCE.getAllInternalNames()) {
            if (this.getConfig().excludeVanillaItems && NEUItems.INSTANCE.isVanillaItem(internalName)) continue;
            Set<PrimitiveRecipe> recipes = NEUItems.INSTANCE.getRecipes(internalName);
            for (PrimitiveRecipe recipe : recipes) {
                Renderable renderable2;
                if (!recipe.isCraftingRecipe() || this.createItemRenderable(recipe, availableMaterial, pricePer, internalName) == null) continue;
                lines.put(internalName, renderable2);
            }
        }
    }

    private final Renderable createItemRenderable(PrimitiveRecipe recipe, Map<NEUInternalName, Long> availableMaterial, Map<NEUInternalName, Double> pricePer, NEUInternalName internalName) {
        Map<NEUInternalName, Integer> neededItems = ItemUtils.INSTANCE.neededItems(recipe);
        if (neededItems.isEmpty()) {
            return null;
        }
        int canCraftAmount = this.canCraftAmount(neededItems, availableMaterial);
        if (canCraftAmount <= 0) {
            return null;
        }
        String amountFormat = NumberUtil.INSTANCE.addSeparators(canCraftAmount);
        double totalPrice = this.pricePer(neededItems);
        Object object = totalPrice;
        pricePer.put(internalName, (Double)object);
        Object $this$createItemRenderable_u24lambda_u241 = object = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$createItemRenderable_u24lambda_u241.add(ItemUtils.INSTANCE.getItemName(internalName));
        $this$createItemRenderable_u24lambda_u241.add("");
        $this$createItemRenderable_u24lambda_u241.add("\u00a77Craft cost: \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, totalPrice, false, 1, null));
        for (Map.Entry<NEUInternalName, Integer> entry : neededItems.entrySet()) {
            NEUInternalName item = entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            String name2 = ItemUtils.INSTANCE.getItemName(item);
            double price = NEUItems.getPrice$default(NEUItems.INSTANCE, item, null, null, 3, null) * (double)amount;
            $this$createItemRenderable_u24lambda_u241.add(" \u00a78x" + NumberUtil.INSTANCE.addSeparators(amount) + ' ' + name2 + " \u00a77(\u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, price, false, 1, null) + "\u00a77)");
        }
        $this$createItemRenderable_u24lambda_u241.add("");
        $this$createItemRenderable_u24lambda_u241.add("\u00a77You have enough materials");
        String timeName = StringUtils.pluralize$default(StringUtils.INSTANCE, canCraftAmount, "time", "times", false, 8, null);
        $this$createItemRenderable_u24lambda_u241.add("\u00a77to craft this item " + amountFormat + ' ' + timeName + '!');
        $this$createItemRenderable_u24lambda_u241.add("");
        $this$createItemRenderable_u24lambda_u241.add("\u00a7eClick to craft!");
        List tooltip = CollectionsKt.build(object);
        return Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a78x" + amountFormat + ' ' + ItemUtils.INSTANCE.getItemName(internalName), tooltip, false, () -> CraftableItemList.createItemRenderable$lambda$2(internalName), null, 20, null);
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        inInventory = false;
    }

    /*
     * WARNING - void declaration
     */
    private final double pricePer(Map<NEUInternalName, Integer> neededItems) {
        void $this$mapTo$iv$iv;
        Map<NEUInternalName, Integer> $this$map$iv = neededItems;
        boolean $i$f$map = false;
        Map<NEUInternalName, Integer> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NEUItems.getPrice$default(NEUItems.INSTANCE, (NEUInternalName)it.getKey(), null, null, 3, null) * ((Number)it.getValue()).doubleValue());
        }
        return CollectionsKt.sumOfDouble((List)destination$iv$iv);
    }

    private final int canCraftAmount(Map<NEUInternalName, Integer> need, Map<NEUInternalName, Long> available) {
        List canCraftTotal = new ArrayList();
        for (Map.Entry<NEUInternalName, Integer> entry : need.entrySet()) {
            NEUInternalName name2 = entry.getKey();
            int neededAmount = ((Number)entry.getValue()).intValue();
            Long l = available.get(name2);
            long inventory = l != null ? l : 0L;
            int sacks = this.getConfig().includeSacks ? SackAPI.INSTANCE.getAmountInSacks(name2) : 0;
            long having = inventory + (long)sacks;
            int canCraft = (int)Math.floor((double)having / (double)neededAmount);
            canCraftTotal.add(canCraft);
        }
        return ((Number)CollectionsKt.minOrThrow(canCraftTotal)).intValue();
    }

    private final Map<NEUInternalName, Long> readItems() {
        Map materials = new LinkedHashMap();
        for (ItemStack stack : InventoryUtils.INSTANCE.getItemsInOwnInventory()) {
            PrimitiveItemStack item;
            if (PrimitiveItemStack.Companion.toPrimitiveStackOrNull(stack) == null) continue;
            CollectionUtils.INSTANCE.addOrPut(materials, item.getInternalName(), (long)item.getAmount());
        }
        return materials;
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!inInventory) {
            return;
        }
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, 0, "Craft Materials From Bazaar", false, 10, null);
    }

    public final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled;
    }

    private static final Unit createItemRenderable$lambda$2(NEUInternalName $internalName) {
        Intrinsics.checkNotNullParameter($internalName, "$internalName");
        HypixelCommands.INSTANCE.viewRecipe($internalName.asString());
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CraftableItemList.class, "craftItemPattern", "getCraftItemPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new CraftableItemList();
        display = CollectionsKt.emptyList();
        craftItemPattern$delegate = RepoPattern.Companion.pattern("craftableitemlist.craftitem", "Craft Item");
    }
}

