/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateFactoryConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.events.LorenzToolTipEvent;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryAPI;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryUpgrade;
import at.hannibal2.skyhanni.utils.NumberUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryTooltip;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;", "event", "", "onTooltip", "(Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;)V", "", "chocPerTimeTower", "()I", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateFactoryConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateFactoryConfig;", "config", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nChocolateFactoryTooltip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChocolateFactoryTooltip.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryTooltip\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class ChocolateFactoryTooltip {
    @NotNull
    public static final ChocolateFactoryTooltip INSTANCE = new ChocolateFactoryTooltip();

    private ChocolateFactoryTooltip() {
    }

    private final ChocolateFactoryConfig getConfig() {
        return ChocolateFactoryAPI.INSTANCE.getConfig();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onTooltip(@NotNull LorenzToolTipEvent event) {
        Object v0;
        int slotIndex;
        block11: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            if (!ChocolateFactoryAPI.INSTANCE.getInChocolateFactory()) {
                return;
            }
            if (!this.getConfig().extraTooltipStats) {
                return;
            }
            slotIndex = event.getSlot().field_75222_d;
            if (!ChocolateFactoryAPI.INSTANCE.getOtherUpgradeSlots().contains(slotIndex)) {
                Integer n = slotIndex;
                if (!ChocolateFactoryAPI.INSTANCE.getRabbitSlots().containsKey(n)) {
                    return;
                }
            }
            Iterable iterable = ChocolateFactoryAPI.INSTANCE.getFactoryUpgrades();
            for (Object t : iterable) {
                ChocolateFactoryUpgrade it = (ChocolateFactoryUpgrade)t;
                boolean bl = false;
                if (!(it.getSlotIndex() == slotIndex)) continue;
                v0 = t;
                break block11;
            }
            v0 = null;
        }
        ChocolateFactoryUpgrade chocolateFactoryUpgrade = v0;
        if (chocolateFactoryUpgrade == null) {
            return;
        }
        ChocolateFactoryUpgrade upgradeInfo = chocolateFactoryUpgrade;
        if (slotIndex == ChocolateFactoryAPI.INSTANCE.getTimeTowerIndex() && upgradeInfo.isMaxed()) {
            event.getToolTip().add("\u00a78\u00a7m-----------------");
            event.getToolTip().add("\u00a77One charge will give: \u00a76" + NumberUtil.INSTANCE.addSeparators(this.chocPerTimeTower()));
        }
        if (upgradeInfo.isMaxed()) {
            return;
        }
        event.getToolTip().add("\u00a78\u00a7m-----------------");
        event.getToolTip().add("\u00a77Time until upgrade: \u00a7e" + upgradeInfo.formattedTimeUntilGoal());
        if (upgradeInfo.getEffectiveCost() == null) {
            return;
        }
        Double d = upgradeInfo.getExtraPerSecond();
        event.getToolTip().add("\u00a77Extra: \u00a76" + (d != null ? Double.valueOf(NumberUtil.INSTANCE.roundTo(d, 2)) : "N/A") + " \u00a77choc/s");
        List<String> list = event.getToolTip();
        StringBuilder stringBuilder = new StringBuilder().append("\u00a77Effective Cost: \u00a76");
        String string2 = NumberUtil.INSTANCE.addSeparators(upgradeInfo.getEffectiveCost());
        if (string2 == null) {
            string2 = "N/A";
        }
        list.add(stringBuilder.append(string2).toString());
        if (slotIndex == ChocolateFactoryAPI.INSTANCE.getTimeTowerIndex()) {
            event.getToolTip().add("\u00a77One charge will give: \u00a76" + NumberUtil.INSTANCE.addSeparators(this.chocPerTimeTower()));
        }
    }

    private final int chocPerTimeTower() {
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = ChocolateFactoryAPI.INSTANCE.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return 0;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        double amountPerSecond = (double)profileStorage.rawChocPerSecond * ChocolateFactoryAPI.INSTANCE.timeTowerMultiplier();
        double amountPerHour = amountPerSecond * (double)60 * (double)60;
        return (int)amountPerHour;
    }
}

