/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateFactoryConfig;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.ChocolateFactoryRabbitWarningConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryUpdatedEvent;
import at.hannibal2.skyhanni.events.LorenzWorldChangeEvent;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateAmount;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryAPI;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryBarnManager;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryStats;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryTimeTowerManager;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryUpgrade;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.ChocolateFactoryUpgradeWarning;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b9\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0003J!\u0010\u001a\u001a\u00020\u00062\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\"\u001a\u00020\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b$\u0010\u001eJ\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b%\u0010\u001eJ\u0017\u0010&\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b&\u0010\u001eJ\u0017\u0010'\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b'\u0010\u001eJ1\u0010(\u001a\u00020\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002\u00a2\u0006\u0004\b(\u0010)J-\u0010+\u001a\u00020\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b+\u0010,JG\u00105\u001a\u00020\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010.\u001a\u00020-2\u0006\u0010*\u001a\u00020\u00172\u0006\u00100\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u0001012\u0006\u00104\u001a\u000203H\u0002\u00a2\u0006\u0004\b5\u00106JG\u00107\u001a\u00020\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010.\u001a\u00020-2\u0006\u0010*\u001a\u00020\u00172\u0006\u00100\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u0001012\u0006\u00104\u001a\u000203H\u0002\u00a2\u0006\u0004\b7\u00106JO\u0010;\u001a\u00020\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010*\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u00172\b\u00102\u001a\u0004\u0018\u0001012\u0006\u00104\u001a\u0002032\u0006\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020/H\u0002\u00a2\u0006\u0004\b;\u0010<J\u001f\u0010=\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b=\u0010>J\u001d\u0010@\u001a\u00020\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0?H\u0002\u00a2\u0006\u0004\b@\u0010AR\u0014\u0010E\u001a\u00020B8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0016\u0010I\u001a\u0004\u0018\u00010F8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010HR\u001b\u0010O\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bK\u0010L\u001a\u0004\bM\u0010NR\u001b\u0010R\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bP\u0010L\u001a\u0004\bQ\u0010NR\u001b\u0010U\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bS\u0010L\u001a\u0004\bT\u0010NR\u001b\u0010X\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bV\u0010L\u001a\u0004\bW\u0010NR\u001b\u0010[\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bY\u0010L\u001a\u0004\bZ\u0010NR\u001b\u0010^\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u0010L\u001a\u0004\b]\u0010NR\u001b\u0010a\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b_\u0010L\u001a\u0004\b`\u0010NR\u001b\u0010d\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bb\u0010L\u001a\u0004\bc\u0010NR\u001b\u0010g\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\be\u0010L\u001a\u0004\bf\u0010NR\u001b\u0010j\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bh\u0010L\u001a\u0004\bi\u0010NR\u001b\u0010m\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bk\u0010L\u001a\u0004\bl\u0010NR\u001b\u0010p\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bn\u0010L\u001a\u0004\bo\u0010NR\u001b\u0010s\u001a\u00020J8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bq\u0010L\u001a\u0004\br\u0010NR\u001b\u0010v\u001a\u00020J8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bt\u0010L\u001a\u0004\bu\u0010NR\u001b\u0010y\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bw\u0010L\u001a\u0004\bx\u0010NR\u001b\u0010|\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bz\u0010L\u001a\u0004\b{\u0010NR\u001b\u0010\u007f\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b}\u0010L\u001a\u0004\b~\u0010NR\u001e\u0010\u0082\u0001\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0080\u0001\u0010L\u001a\u0005\b\u0081\u0001\u0010N\u00a8\u0006\u0083\u0001"}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryDataLoader;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;", "event", "", "onInventoryUpdated", "(Lat/hannibal2/skyhanni/events/InventoryUpdatedEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;", "onWorldChange", "(Lat/hannibal2/skyhanni/events/LorenzWorldChangeEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "clearData", "", "", "Lnet/minecraft/item/ItemStack;", "inventory", "updateInventoryItems", "(Ljava/util/Map;)V", "item", "processChocolateItem", "(Lnet/minecraft/item/ItemStack;)V", "", "Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryUpgrade;", "list", "processPrestigeItem", "(Ljava/util/List;Lnet/minecraft/item/ItemStack;)V", "processProductionItem", "processLeaderboardItem", "processBarnItem", "processTimeTowerItem", "processInventory", "(Ljava/util/List;Ljava/util/Map;)V", "slotIndex", "processItem", "(Ljava/util/List;Lnet/minecraft/item/ItemStack;I)V", "", "itemName", "", "isMaxed", "", "upgradeCost", "", "averageChocolate", "handleRabbitSlot", "(Ljava/util/List;Ljava/lang/String;IZLjava/lang/Long;D)V", "handleOtherUpgradeSlot", "level", "newAverageChocolate", "isRabbit", "addUpgradeToList", "(Ljava/util/List;IILjava/lang/Long;DDZ)V", "handleRabbitWarnings", "(Lnet/minecraft/item/ItemStack;I)V", "", "findBestUpgrades", "(Ljava/util/List;)V", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateFactoryConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/ChocolateFactoryConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$ChocolateFactoryStorage;", "getProfileStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$ChocolateFactoryStorage;", "profileStorage", "Ljava/util/regex/Pattern;", "chocolatePerSecondPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getChocolatePerSecondPattern", "()Ljava/util/regex/Pattern;", "chocolatePerSecondPattern", "chocolateAllTimePattern$delegate", "getChocolateAllTimePattern", "chocolateAllTimePattern", "prestigeLevelPattern$delegate", "getPrestigeLevelPattern", "prestigeLevelPattern", "chocolateThisPrestigePattern$delegate", "getChocolateThisPrestigePattern", "chocolateThisPrestigePattern", "chocolateForPrestigePattern$delegate", "getChocolateForPrestigePattern", "chocolateForPrestigePattern", "chocolateMultiplierPattern$delegate", "getChocolateMultiplierPattern", "chocolateMultiplierPattern", "leaderboardPlacePattern$delegate", "getLeaderboardPlacePattern", "leaderboardPlacePattern", "leaderboardPercentilePattern$delegate", "getLeaderboardPercentilePattern", "leaderboardPercentilePattern", "barnAmountPattern$delegate", "getBarnAmountPattern", "barnAmountPattern", "timeTowerAmountPattern$delegate", "getTimeTowerAmountPattern", "timeTowerAmountPattern", "timeTowerStatusPattern$delegate", "getTimeTowerStatusPattern", "timeTowerStatusPattern", "timeTowerRechargePattern$delegate", "getTimeTowerRechargePattern", "timeTowerRechargePattern", "clickMeRabbitPattern$delegate", "getClickMeRabbitPattern", "clickMeRabbitPattern", "clickMeGoldenRabbitPattern$delegate", "getClickMeGoldenRabbitPattern", "clickMeGoldenRabbitPattern", "rabbitAmountPattern$delegate", "getRabbitAmountPattern", "rabbitAmountPattern", "upgradeTierPattern$delegate", "getUpgradeTierPattern", "upgradeTierPattern", "unemployedRabbitPattern$delegate", "getUnemployedRabbitPattern", "unemployedRabbitPattern", "otherUpgradePattern$delegate", "getOtherUpgradePattern", "otherUpgradePattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nChocolateFactoryDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChocolateFactoryDataLoader.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryDataLoader\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,464:1\n8#2:465\n8#2:467\n8#2:469\n8#2:471\n8#2:473\n8#2:475\n32#2,3:477\n18#2,2:480\n21#2:483\n8#2:484\n8#2:486\n32#2,3:488\n18#2,2:491\n21#2:494\n8#2:495\n8#2:497\n8#2:499\n8#2:501\n8#2:503\n1#3:466\n1#3:468\n1#3:470\n1#3:472\n1#3:474\n1#3:476\n1#3:482\n1#3:485\n1#3:487\n1#3:493\n1#3:496\n1#3:498\n1#3:500\n1#3:502\n1#3:504\n1#3:542\n774#4:505\n865#4,2:506\n774#4:508\n865#4,2:509\n2341#4,14:511\n774#4:525\n865#4,2:526\n2341#4,14:528\n*S KotlinDebug\n*F\n+ 1 ChocolateFactoryDataLoader.kt\nat/hannibal2/skyhanni/features/inventory/chocolatefactory/ChocolateFactoryDataLoader\n*L\n209#1:465\n213#1:467\n216#1:469\n225#1:471\n230#1:473\n233#1:475\n250#1:477,3\n250#1:480,2\n250#1:483\n267#1:484\n270#1:486\n279#1:488,3\n279#1:491,2\n279#1:494\n290#1:495\n295#1:497\n308#1:499\n355#1:501\n380#1:503\n209#1:466\n213#1:468\n216#1:470\n225#1:472\n230#1:474\n233#1:476\n250#1:482\n267#1:485\n270#1:487\n279#1:493\n290#1:496\n295#1:498\n308#1:500\n355#1:502\n380#1:504\n444#1:505\n444#1:506,2\n448#1:508\n448#1:509,2\n452#1:511,14\n460#1:525\n460#1:526,2\n460#1:528,14\n*E\n"})
public final class ChocolateFactoryDataLoader {
    @NotNull
    public static final ChocolateFactoryDataLoader INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern chocolatePerSecondPattern$delegate;
    @NotNull
    private static final RepoPattern chocolateAllTimePattern$delegate;
    @NotNull
    private static final RepoPattern prestigeLevelPattern$delegate;
    @NotNull
    private static final RepoPattern chocolateThisPrestigePattern$delegate;
    @NotNull
    private static final RepoPattern chocolateForPrestigePattern$delegate;
    @NotNull
    private static final RepoPattern chocolateMultiplierPattern$delegate;
    @NotNull
    private static final RepoPattern leaderboardPlacePattern$delegate;
    @NotNull
    private static final RepoPattern leaderboardPercentilePattern$delegate;
    @NotNull
    private static final RepoPattern barnAmountPattern$delegate;
    @NotNull
    private static final RepoPattern timeTowerAmountPattern$delegate;
    @NotNull
    private static final RepoPattern timeTowerStatusPattern$delegate;
    @NotNull
    private static final RepoPattern timeTowerRechargePattern$delegate;
    @NotNull
    private static final RepoPattern clickMeRabbitPattern$delegate;
    @NotNull
    private static final RepoPattern clickMeGoldenRabbitPattern$delegate;
    @NotNull
    private static final RepoPattern rabbitAmountPattern$delegate;
    @NotNull
    private static final RepoPattern upgradeTierPattern$delegate;
    @NotNull
    private static final RepoPattern unemployedRabbitPattern$delegate;
    @NotNull
    private static final RepoPattern otherUpgradePattern$delegate;

    private ChocolateFactoryDataLoader() {
    }

    private final ChocolateFactoryConfig getConfig() {
        return ChocolateFactoryAPI.INSTANCE.getConfig();
    }

    private final ProfileSpecificStorage.ChocolateFactoryStorage getProfileStorage() {
        return ChocolateFactoryAPI.INSTANCE.getProfileStorage();
    }

    private final Pattern getChocolatePerSecondPattern() {
        return (Pattern)chocolatePerSecondPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getChocolateAllTimePattern() {
        return (Pattern)chocolateAllTimePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getPrestigeLevelPattern() {
        return (Pattern)prestigeLevelPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getChocolateThisPrestigePattern() {
        return (Pattern)chocolateThisPrestigePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    private final Pattern getChocolateForPrestigePattern() {
        return (Pattern)chocolateForPrestigePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[4]);
    }

    private final Pattern getChocolateMultiplierPattern() {
        return (Pattern)chocolateMultiplierPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[5]);
    }

    private final Pattern getLeaderboardPlacePattern() {
        return (Pattern)leaderboardPlacePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[6]);
    }

    private final Pattern getLeaderboardPercentilePattern() {
        return (Pattern)leaderboardPercentilePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[7]);
    }

    private final Pattern getBarnAmountPattern() {
        return (Pattern)barnAmountPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[8]);
    }

    private final Pattern getTimeTowerAmountPattern() {
        return (Pattern)timeTowerAmountPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[9]);
    }

    private final Pattern getTimeTowerStatusPattern() {
        return (Pattern)timeTowerStatusPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[10]);
    }

    private final Pattern getTimeTowerRechargePattern() {
        return (Pattern)timeTowerRechargePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[11]);
    }

    @NotNull
    public final Pattern getClickMeRabbitPattern() {
        return (Pattern)clickMeRabbitPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[12]);
    }

    @NotNull
    public final Pattern getClickMeGoldenRabbitPattern() {
        return (Pattern)clickMeGoldenRabbitPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[13]);
    }

    private final Pattern getRabbitAmountPattern() {
        return (Pattern)rabbitAmountPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[14]);
    }

    private final Pattern getUpgradeTierPattern() {
        return (Pattern)upgradeTierPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[15]);
    }

    private final Pattern getUnemployedRabbitPattern() {
        return (Pattern)unemployedRabbitPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[16]);
    }

    private final Pattern getOtherUpgradePattern() {
        return (Pattern)otherUpgradePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[17]);
    }

    @SubscribeEvent
    public final void onInventoryUpdated(@NotNull InventoryUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!ChocolateFactoryAPI.INSTANCE.getInChocolateFactory()) {
            return;
        }
        this.updateInventoryItems(event.getInventoryItems());
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull LorenzWorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.clearData();
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.clearData();
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 47, "inventory.chocolateFactory.rabbitWarning", "inventory.chocolateFactory.rabbitWarning.rabbitWarning", null, 8, null);
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property<String> soundProperty = this.getConfig().rabbitWarning.specialRabbitSound;
        Property[] propertyArray = new Property[]{soundProperty};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, () -> ChocolateFactoryDataLoader.onConfigLoad$lambda$0(soundProperty));
        this.getConfig().chocolateUpgradeWarnings.upgradeWarningTimeTower.whenChanged(ChocolateFactoryDataLoader::onConfigLoad$lambda$5);
    }

    private final void clearData() {
        ChocolateFactoryAPI.INSTANCE.setInChocolateFactory(false);
        ChocolateFactoryAPI.INSTANCE.setChocolateFactoryPaused(false);
        ChocolateFactoryAPI.INSTANCE.setFactoryUpgrades(CollectionsKt.emptyList());
        ChocolateFactoryAPI.INSTANCE.setBestAffordableSlot(-1);
        ChocolateFactoryAPI.INSTANCE.setBestPossibleSlot(-1);
    }

    public final void updateInventoryItems(@NotNull Map<Integer, ItemStack> inventory) {
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        ItemStack itemStack2 = InventoryUtils.INSTANCE.getItemAtSlotIndex(ChocolateFactoryAPI.INSTANCE.getInfoIndex());
        if (itemStack2 == null) {
            return;
        }
        ItemStack chocolateItem = itemStack2;
        ItemStack itemStack3 = InventoryUtils.INSTANCE.getItemAtSlotIndex(ChocolateFactoryAPI.INSTANCE.getPrestigeIndex());
        if (itemStack3 == null) {
            return;
        }
        ItemStack prestigeItem = itemStack3;
        ItemStack itemStack4 = InventoryUtils.INSTANCE.getItemAtSlotIndex(ChocolateFactoryAPI.INSTANCE.getTimeTowerIndex());
        if (itemStack4 == null) {
            return;
        }
        ItemStack timeTowerItem = itemStack4;
        ItemStack itemStack5 = InventoryUtils.INSTANCE.getItemAtSlotIndex(ChocolateFactoryAPI.INSTANCE.getProductionInfoIndex());
        if (itemStack5 == null) {
            return;
        }
        ItemStack productionInfoItem = itemStack5;
        ItemStack itemStack6 = InventoryUtils.INSTANCE.getItemAtSlotIndex(ChocolateFactoryAPI.INSTANCE.getLeaderboardIndex());
        if (itemStack6 == null) {
            return;
        }
        ItemStack leaderboardItem = itemStack6;
        ItemStack itemStack7 = InventoryUtils.INSTANCE.getItemAtSlotIndex(ChocolateFactoryAPI.INSTANCE.getBarnIndex());
        if (itemStack7 == null) {
            return;
        }
        ItemStack barnItem = itemStack7;
        ChocolateFactoryAPI.INSTANCE.setFactoryUpgrades(CollectionsKt.emptyList());
        this.processChocolateItem(chocolateItem);
        List list = new ArrayList();
        this.processPrestigeItem(list, prestigeItem);
        this.processTimeTowerItem(timeTowerItem);
        this.processProductionItem(productionInfoItem);
        this.processLeaderboardItem(leaderboardItem);
        this.processBarnItem(barnItem);
        profileStorage.rawChocPerSecond = (int)(ChocolateFactoryAPI.INSTANCE.getChocolatePerSecond() / profileStorage.chocolateMultiplier + 0.01);
        profileStorage.lastDataSave = SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo());
        ChocolateFactoryStats.INSTANCE.updateDisplay();
        this.processInventory(list, inventory);
        this.findBestUpgrades(list);
        ChocolateFactoryAPI.INSTANCE.setFactoryUpgrades(list);
    }

    /*
     * WARNING - void declaration
     */
    private final void processChocolateItem(ItemStack item) {
        void $this$matchMatcher$iv;
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = ChocolateFactoryAPI.INSTANCE.getChocolateAmountPattern();
        Object text$iv = StringUtils.removeColor$default(StringUtils.INSTANCE, ItemUtils.INSTANCE.getName(item), false, 1, null);
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher((CharSequence)text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$processChocolateItem_u24lambda_u246 = it$iv;
            boolean bl2 = false;
            String string2 = $this$processChocolateItem_u24lambda_u246.group("amount");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            profileStorage.currentChocolate = NumberUtil.INSTANCE.formatLong(string2);
        }
        for (String line : ItemUtils.INSTANCE.getLore(item)) {
            text$iv = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv2 = this.getChocolatePerSecondPattern();
            boolean $i$f$matchMatcher2 = false;
            Matcher it$iv2 = $this$matchMatcher$iv2.matcher(line);
            $i$a$-let-RegexUtils$matchMatcher$1$iv = false;
            if (it$iv2.matches()) {
                Intrinsics.checkNotNull(it$iv2);
                Matcher $this$processChocolateItem_u24lambda_u247 = it$iv2;
                boolean bl3 = false;
                String string3 = $this$processChocolateItem_u24lambda_u247.group("amount");
                Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
                ChocolateFactoryAPI.INSTANCE.setChocolatePerSecond(NumberUtil.INSTANCE.formatDouble(string3));
            }
            RegexUtils this_$iv = RegexUtils.INSTANCE;
            $this$matchMatcher$iv2 = this.getChocolateAllTimePattern();
            $i$f$matchMatcher2 = false;
            it$iv2 = $this$matchMatcher$iv2.matcher(line);
            $i$a$-let-RegexUtils$matchMatcher$1$iv = false;
            if (!it$iv2.matches()) continue;
            Intrinsics.checkNotNull(it$iv2);
            Matcher $this$processChocolateItem_u24lambda_u248 = it$iv2;
            boolean bl4 = false;
            String string4 = $this$processChocolateItem_u24lambda_u248.group("amount");
            Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
            profileStorage.chocolateAllTime = NumberUtil.INSTANCE.formatLong(string4);
        }
    }

    private final void processPrestigeItem(List<ChocolateFactoryUpgrade> list, ItemStack item) {
        Iterator<String> $this$matchMatcher$iv;
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getPrestigeLevelPattern();
        String text$iv = ItemUtils.INSTANCE.getName(item);
        boolean $i$f$matchMatcher2 = false;
        Matcher it$iv = ((Pattern)((Object)$this$matchMatcher$iv)).matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$processPrestigeItem_u24lambda_u249 = it$iv;
            boolean bl2 = false;
            String string2 = $this$processPrestigeItem_u24lambda_u249.group("prestige");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            ChocolateFactoryAPI.INSTANCE.setCurrentPrestige(NumberUtil.INSTANCE.romanToDecimal(string2));
        }
        Long prestigeCost = null;
        for (String line : ItemUtils.INSTANCE.getLore(item)) {
            RegexUtils $i$f$matchMatcher2 = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv2 = this.getChocolateThisPrestigePattern();
            boolean $i$f$matchMatcher3 = false;
            Matcher it$iv2 = $this$matchMatcher$iv2.matcher(line);
            $i$a$-let-RegexUtils$matchMatcher$1$iv = false;
            if (it$iv2.matches()) {
                Intrinsics.checkNotNull(it$iv2);
                Matcher $this$processPrestigeItem_u24lambda_u2410 = it$iv2;
                boolean bl3 = false;
                String string3 = $this$processPrestigeItem_u24lambda_u2410.group("amount");
                Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
                profileStorage.chocolateThisPrestige = NumberUtil.INSTANCE.formatLong(string3);
            }
            RegexUtils this_$iv = RegexUtils.INSTANCE;
            $this$matchMatcher$iv2 = this.getChocolateForPrestigePattern();
            $i$f$matchMatcher3 = false;
            it$iv2 = $this$matchMatcher$iv2.matcher(line);
            $i$a$-let-RegexUtils$matchMatcher$1$iv = false;
            if (!it$iv2.matches()) continue;
            Intrinsics.checkNotNull(it$iv2);
            Matcher $this$processPrestigeItem_u24lambda_u2411 = it$iv2;
            boolean bl4 = false;
            String string4 = $this$processPrestigeItem_u24lambda_u2411.group("amount");
            Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
            ChocolateFactoryAPI.INSTANCE.setChocolateForPrestige(NumberUtil.INSTANCE.formatLong(string4));
            prestigeCost = ChocolateFactoryAPI.INSTANCE.getChocolateForPrestige();
        }
        ChocolateFactoryUpgrade prestigeUpgrade = new ChocolateFactoryUpgrade(ChocolateFactoryAPI.INSTANCE.getPrestigeIndex(), ChocolateFactoryAPI.INSTANCE.getCurrentPrestige(), prestigeCost, null, null, false, true, 56, null);
        list.add(prestigeUpgrade);
    }

    /*
     * WARNING - void declaration
     */
    private final void processProductionItem(ItemStack item) {
        void $this$matchFirst$iv;
        void this_$iv$iv;
        void this_$iv;
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        List<String> list = ItemUtils.INSTANCE.getLore(item);
        Pattern pattern$iv = this.getChocolateMultiplierPattern();
        boolean $i$f$matchFirst = false;
        void var7_7 = this_$iv;
        Pattern $this$firstMatcher$iv$iv = pattern$iv;
        boolean $i$f$firstMatcher = false;
        void var10_10 = this_$iv$iv;
        Pattern pattern = $this$firstMatcher$iv$iv;
        Sequence sequence$iv$iv$iv = CollectionsKt.asSequence((Iterable)$this$matchFirst$iv);
        boolean $i$f$firstMatcher2 = false;
        Iterator iterator2 = sequence$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            double currentMultiplier;
            void $this$firstMatcher$iv$iv$iv;
            String line$iv$iv$iv = (String)iterator2.next();
            Matcher it$iv$iv$iv = $this$firstMatcher$iv$iv$iv.matcher(line$iv$iv$iv);
            boolean bl = false;
            if (!it$iv$iv$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv$iv$iv);
            Matcher $this$processProductionItem_u24lambda_u2412 = it$iv$iv$iv;
            boolean bl2 = false;
            String string2 = $this$processProductionItem_u24lambda_u2412.group("amount");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            profileStorage.chocolateMultiplier = currentMultiplier = NumberUtil.INSTANCE.formatDouble(string2);
            if (ChocolateFactoryTimeTowerManager.INSTANCE.timeTowerActive()) {
                profileStorage.rawChocolateMultiplier = currentMultiplier - (double)profileStorage.timeTowerLevel * 0.1;
                break;
            }
            profileStorage.rawChocolateMultiplier = currentMultiplier;
            break;
        }
    }

    private final void processLeaderboardItem(ItemStack item) {
        ChocolateFactoryAPI.INSTANCE.setLeaderboardPosition(null);
        ChocolateFactoryAPI.INSTANCE.setLeaderboardPercentile(null);
        for (String line : ItemUtils.INSTANCE.getLore(item)) {
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = this.getLeaderboardPlacePattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(line);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$processLeaderboardItem_u24lambda_u2413 = it$iv;
                boolean bl2 = false;
                String string2 = $this$processLeaderboardItem_u24lambda_u2413.group("position");
                Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                ChocolateFactoryAPI.INSTANCE.setLeaderboardPosition(NumberUtil.INSTANCE.formatInt(string2));
            }
            RegexUtils this_$iv = RegexUtils.INSTANCE;
            $this$matchMatcher$iv = this.getLeaderboardPercentilePattern();
            $i$f$matchMatcher = false;
            it$iv = $this$matchMatcher$iv.matcher(line);
            bl = false;
            if (!it$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$processLeaderboardItem_u24lambda_u2414 = it$iv;
            boolean bl3 = false;
            String string3 = $this$processLeaderboardItem_u24lambda_u2414.group("percent");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            ChocolateFactoryAPI.INSTANCE.setLeaderboardPercentile(NumberUtil.INSTANCE.formatDouble(string3));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processBarnItem(ItemStack item) {
        void $this$matchFirst$iv;
        void this_$iv$iv;
        void this_$iv;
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        List<String> list = ItemUtils.INSTANCE.getLore(item);
        Pattern pattern$iv = this.getBarnAmountPattern();
        boolean $i$f$matchFirst = false;
        void var7_7 = this_$iv;
        Pattern $this$firstMatcher$iv$iv = pattern$iv;
        boolean $i$f$firstMatcher = false;
        void var10_10 = this_$iv$iv;
        Pattern pattern = $this$firstMatcher$iv$iv;
        Sequence sequence$iv$iv$iv = CollectionsKt.asSequence((Iterable)$this$matchFirst$iv);
        boolean $i$f$firstMatcher2 = false;
        Iterator iterator2 = sequence$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$firstMatcher$iv$iv$iv;
            String line$iv$iv$iv = (String)iterator2.next();
            Matcher it$iv$iv$iv = $this$firstMatcher$iv$iv$iv.matcher(line$iv$iv$iv);
            boolean bl = false;
            if (!it$iv$iv$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv$iv$iv);
            Matcher $this$processBarnItem_u24lambda_u2415 = it$iv$iv$iv;
            boolean bl2 = false;
            String string2 = $this$processBarnItem_u24lambda_u2415.group("rabbits");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            profileStorage.currentRabbits = NumberUtil.INSTANCE.formatInt(string2);
            String string3 = $this$processBarnItem_u24lambda_u2415.group("max");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            profileStorage.maxRabbits = NumberUtil.INSTANCE.formatInt(string3);
            ChocolateFactoryBarnManager.INSTANCE.trySendBarnFullMessage(true);
            break;
        }
    }

    private final void processTimeTowerItem(ItemStack item) {
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        for (String line : ItemUtils.INSTANCE.getLore(item)) {
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = this.getTimeTowerAmountPattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(line);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$processTimeTowerItem_u24lambda_u2416 = it$iv;
                boolean bl2 = false;
                String string2 = $this$processTimeTowerItem_u24lambda_u2416.group("uses");
                Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                profileStorage.currentTimeTowerUses = NumberUtil.INSTANCE.formatInt(string2);
                String string3 = $this$processTimeTowerItem_u24lambda_u2416.group("max");
                Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
                profileStorage.maxTimeTowerUses = NumberUtil.INSTANCE.formatInt(string3);
                ChocolateFactoryTimeTowerManager.INSTANCE.checkTimeTowerWarning(true);
            }
            RegexUtils this_$iv = RegexUtils.INSTANCE;
            $this$matchMatcher$iv = this.getTimeTowerStatusPattern();
            $i$f$matchMatcher = false;
            it$iv = $this$matchMatcher$iv.matcher(line);
            bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$processTimeTowerItem_u24lambda_u2417 = it$iv;
                boolean bl3 = false;
                String activeTime = $this$processTimeTowerItem_u24lambda_u2417.group("acitveTime");
                Intrinsics.checkNotNull(activeTime);
                if (((CharSequence)activeTime).length() > 0) {
                    String formattedGroup = StringsKt.replace$default(StringsKt.replace$default(activeTime, "h", "h ", false, 4, null), "m", "m ", false, 4, null);
                    long activeDuration = TimeUtils.INSTANCE.getDuration-5sfh64U(formattedGroup);
                    long activeUntil = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), activeDuration);
                    profileStorage.currentTimeTowerEnds = SimpleTimeMark.box-impl(activeUntil);
                } else {
                    profileStorage.currentTimeTowerEnds = SimpleTimeMark.box-impl(SimpleTimeMark.Companion.farPast());
                }
            }
            this_$iv = RegexUtils.INSTANCE;
            $this$matchMatcher$iv = this.getTimeTowerRechargePattern();
            $i$f$matchMatcher = false;
            it$iv = $this$matchMatcher$iv.matcher(line);
            bl = false;
            if (!it$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$processTimeTowerItem_u24lambda_u2418 = it$iv;
            boolean bl4 = false;
            String string4 = $this$processTimeTowerItem_u24lambda_u2418.group("duration");
            Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
            String formattedGroup = StringsKt.replace$default(StringsKt.replace$default(string4, "h", "h ", false, 4, null), "m", "m ", false, 4, null);
            long timeUntilTower = TimeUtils.INSTANCE.getDuration-5sfh64U(formattedGroup);
            long nextTimeTower = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), timeUntilTower);
            profileStorage.nextTimeTower = SimpleTimeMark.box-impl(nextTimeTower);
        }
    }

    private final void processInventory(List<ChocolateFactoryUpgrade> list, Map<Integer, ItemStack> inventory) {
        ChocolateFactoryAPI.INSTANCE.setClickRabbitSlot(null);
        for (Map.Entry<Integer, ItemStack> entry : inventory.entrySet()) {
            int slotIndex = ((Number)entry.getKey()).intValue();
            ItemStack item = entry.getValue();
            this.processItem(list, item, slotIndex);
        }
    }

    private final void processItem(List<ChocolateFactoryUpgrade> list, ItemStack item, int slotIndex) {
        if (slotIndex == ChocolateFactoryAPI.INSTANCE.getPrestigeIndex()) {
            return;
        }
        this.handleRabbitWarnings(item, slotIndex);
        if (!ChocolateFactoryAPI.INSTANCE.getOtherUpgradeSlots().contains(slotIndex)) {
            Integer n = slotIndex;
            if (!ChocolateFactoryAPI.INSTANCE.getRabbitSlots().containsKey(n)) {
                return;
            }
        }
        String itemName = StringUtils.removeColor$default(StringUtils.INSTANCE, ItemUtils.INSTANCE.getName(item), false, 1, null);
        List<String> lore = ItemUtils.INSTANCE.getLore(item);
        Long upgradeCost = ChocolateFactoryAPI.INSTANCE.getChocolateBuyCost(lore);
        double averageChocolate = NumberUtil.INSTANCE.roundTo(ChocolateAmount.Companion.averageChocPerSecond$default(ChocolateAmount.Companion, 0.0, 0, false, 7, null), 2);
        boolean isMaxed = upgradeCost == null;
        Integer n = slotIndex;
        if (ChocolateFactoryAPI.INSTANCE.getRabbitSlots().containsKey(n)) {
            this.handleRabbitSlot(list, itemName, slotIndex, isMaxed, upgradeCost, averageChocolate);
        } else if (ChocolateFactoryAPI.INSTANCE.getOtherUpgradeSlots().contains(slotIndex)) {
            this.handleOtherUpgradeSlot(list, itemName, slotIndex, isMaxed, upgradeCost, averageChocolate);
        }
    }

    private final void handleRabbitSlot(List<ChocolateFactoryUpgrade> list, String itemName, int slotIndex, boolean isMaxed, Long upgradeCost, double averageChocolate) {
        int n;
        Integer n2;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getRabbitAmountPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(itemName);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$handleRabbitSlot_u24lambda_u2419 = it$iv;
            boolean bl2 = false;
            String string2 = $this$handleRabbitSlot_u24lambda_u2419.group("amount");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            n2 = NumberUtil.INSTANCE.formatInt(string2);
        } else {
            n2 = null;
        }
        if (n2 != null) {
            n = n2;
        } else {
            ChocolateFactoryDataLoader $this$handleRabbitSlot_u24lambda_u2420 = this;
            boolean bl3 = false;
            Integer n3 = RegexUtils.INSTANCE.matches($this$handleRabbitSlot_u24lambda_u2420.getUnemployedRabbitPattern(), itemName) ? Integer.valueOf(0) : null;
            if (n3 != null) {
                n = n3;
            } else {
                return;
            }
        }
        int level = n;
        if (isMaxed) {
            ChocolateFactoryUpgrade rabbitUpgradeItem = new ChocolateFactoryUpgrade(slotIndex, level, null, null, null, true, false, 88, null);
            list.add(rabbitUpgradeItem);
            return;
        }
        Integer n4 = ChocolateFactoryAPI.INSTANCE.getRabbitSlots().get(slotIndex);
        int chocolateIncrease = n4 != null ? n4 : 0;
        double newAverageChocolate = ChocolateAmount.Companion.averageChocPerSecond$default(ChocolateAmount.Companion, 0.0, chocolateIncrease, false, 5, null);
        this.addUpgradeToList(list, slotIndex, level, upgradeCost, averageChocolate, newAverageChocolate, true);
    }

    private final void handleOtherUpgradeSlot(List<ChocolateFactoryUpgrade> list, String itemName, int slotIndex, boolean isMaxed, Long upgradeCost, double averageChocolate) {
        double d;
        int n;
        Integer n2;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getUpgradeTierPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(itemName);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$handleOtherUpgradeSlot_u24lambda_u2421 = it$iv;
            boolean bl2 = false;
            String string2 = $this$handleOtherUpgradeSlot_u24lambda_u2421.group("tier");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            n2 = NumberUtil.INSTANCE.romanToDecimal(string2);
        } else {
            n2 = null;
        }
        if (n2 != null) {
            n = n2;
        } else {
            ChocolateFactoryDataLoader $this$handleOtherUpgradeSlot_u24lambda_u2422 = this;
            boolean bl3 = false;
            Integer n3 = RegexUtils.INSTANCE.matches($this$handleOtherUpgradeSlot_u24lambda_u2422.getOtherUpgradePattern(), itemName) ? Integer.valueOf(0) : null;
            if (n3 != null) {
                n = n3;
            } else {
                return;
            }
        }
        int level = n;
        if (slotIndex == ChocolateFactoryAPI.INSTANCE.getTimeTowerIndex() && this.getProfileStorage() != null) {
            this.getProfileStorage().timeTowerLevel = level;
        }
        if (isMaxed) {
            ChocolateFactoryUpgrade otherUpgrade = new ChocolateFactoryUpgrade(slotIndex, level, null, null, null, false, false, 120, null);
            list.add(otherUpgrade);
            return;
        }
        int n4 = slotIndex;
        if (n4 == ChocolateFactoryAPI.INSTANCE.getTimeTowerIndex()) {
            d = ChocolateAmount.Companion.averageChocPerSecond$default(ChocolateAmount.Companion, 0.0, 0, true, 3, null);
        } else if (n4 == ChocolateFactoryAPI.INSTANCE.getCoachRabbitIndex()) {
            d = ChocolateAmount.Companion.averageChocPerSecond$default(ChocolateAmount.Companion, 0.01, 0, false, 6, null);
        } else {
            ChocolateFactoryUpgrade otherUpgrade = new ChocolateFactoryUpgrade(slotIndex, level, upgradeCost, null, null, false, false, 120, null);
            list.add(otherUpgrade);
            return;
        }
        double newAverageChocolate = d;
        this.addUpgradeToList(list, slotIndex, level, upgradeCost, averageChocolate, newAverageChocolate, false);
    }

    private final void addUpgradeToList(List<ChocolateFactoryUpgrade> list, int slotIndex, int level, Long upgradeCost, double averageChocolate, double newAverageChocolate, boolean isRabbit) {
        double extra = NumberUtil.INSTANCE.roundTo(newAverageChocolate - averageChocolate, 2);
        Long l = upgradeCost;
        Intrinsics.checkNotNull(l);
        double effectiveCost = NumberUtil.INSTANCE.roundTo((double)l.longValue() / extra, 2);
        ChocolateFactoryUpgrade upgrade = new ChocolateFactoryUpgrade(slotIndex, level, upgradeCost, extra, effectiveCost, isRabbit, false, 64, null);
        list.add(upgrade);
    }

    private final void handleRabbitWarnings(ItemStack item, int slotIndex) {
        boolean isGoldenRabbit = RegexUtils.INSTANCE.matches(this.getClickMeGoldenRabbitPattern(), ItemUtils.INSTANCE.getName(item));
        ChocolateFactoryRabbitWarningConfig warningConfig = this.getConfig().rabbitWarning;
        if (RegexUtils.INSTANCE.matches(this.getClickMeRabbitPattern(), ItemUtils.INSTANCE.getName(item)) || isGoldenRabbit) {
            if (this.getConfig().rabbitWarning.rabbitWarning) {
                SoundUtils.INSTANCE.playBeepSound();
            }
            if (warningConfig.specialRabbitWarning && (isGoldenRabbit || CollectionsKt.contains((Iterable)ChocolateFactoryAPI.INSTANCE.getSpecialRabbitTextures(), ItemUtils.INSTANCE.getSkullTexture(item)))) {
                SoundUtils.INSTANCE.repeatSound(100L, warningConfig.repeatSound, ChocolateFactoryAPI.INSTANCE.getWarningSound());
            }
            ChocolateFactoryAPI.INSTANCE.setClickRabbitSlot(slotIndex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findBestUpgrades(List<ChocolateFactoryUpgrade> list) {
        ChocolateFactoryUpgrade affordAbleUpgrade;
        Object v9;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        ChocolateFactoryUpgrade bestUpgrade;
        Object object;
        Object v1;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        ProfileSpecificStorage.ChocolateFactoryStorage chocolateFactoryStorage = this.getProfileStorage();
        if (chocolateFactoryStorage == null) {
            return;
        }
        ProfileSpecificStorage.ChocolateFactoryStorage profileStorage = chocolateFactoryStorage;
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            ChocolateFactoryUpgrade it = (ChocolateFactoryUpgrade)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)ChocolateFactoryDataLoader.INSTANCE.getConfig().chocolateUpgradeWarnings.upgradeWarningTimeTower.get() != false || it.getSlotIndex() != ChocolateFactoryAPI.INSTANCE.getTimeTowerIndex())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ttFiltered = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = ttFiltered;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            ChocolateFactoryUpgrade it = (ChocolateFactoryUpgrade)element$iv$iv;
            boolean bl = false;
            if (!(!it.isMaxed() && it.getEffectiveCost() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List notMaxed = (List)destination$iv$iv2;
        Iterable $this$minByOrNull$iv2 = notMaxed;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv2.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                ChocolateFactoryUpgrade it = (ChocolateFactoryUpgrade)minElem$iv;
                boolean bl = false;
                Double d = it.getEffectiveCost();
                double minValue$iv = d != null ? d : Double.MAX_VALUE;
                do {
                    double v$iv;
                    Object e$iv = iterator$iv.next();
                    ChocolateFactoryUpgrade it2 = (ChocolateFactoryUpgrade)e$iv;
                    $i$a$-minByOrNull-ChocolateFactoryDataLoader$findBestUpgrades$bestUpgrade$1 = false;
                    Double d2 = it2.getEffectiveCost();
                    double d3 = v$iv = d2 != null ? d2 : Double.MAX_VALUE;
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        profileStorage.bestUpgradeAvailableAt = SimpleTimeMark.box-impl((object = (bestUpgrade = (ChocolateFactoryUpgrade)v1)) != null && (object = ((ChocolateFactoryUpgrade)object).getCanAffordAt-4Jv_qQw()) != null ? ((SimpleTimeMark)object).unbox-impl() : SimpleTimeMark.Companion.farPast());
        Object object2 = bestUpgrade;
        profileStorage.bestUpgradeCost = object2 != null && (object2 = ((ChocolateFactoryUpgrade)object2).getPrice()) != null ? (Long)object2 : 0L;
        ChocolateFactoryUpgrade chocolateFactoryUpgrade = bestUpgrade;
        ChocolateFactoryAPI.INSTANCE.setBestPossibleSlot(chocolateFactoryUpgrade != null ? chocolateFactoryUpgrade.getValidUpgradeIndex() : -1);
        ChocolateFactoryUpgrade chocolateFactoryUpgrade2 = bestUpgrade;
        int bestUpgradeLevel = chocolateFactoryUpgrade2 != null ? chocolateFactoryUpgrade2.getLevel() : 0;
        ChocolateFactoryUpgradeWarning.INSTANCE.checkUpgradeChange(ChocolateFactoryAPI.INSTANCE.getBestPossibleSlot(), bestUpgradeLevel);
        Iterable $this$filter$iv3 = notMaxed;
        boolean $i$f$filter3 = false;
        Iterable minValue$iv = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChocolateFactoryUpgrade it = (ChocolateFactoryUpgrade)element$iv$iv;
            boolean bl = false;
            if (!it.canAfford()) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv3 = (List)destination$iv$iv3;
        boolean $i$f$minByOrNull2 = false;
        Iterator iterator$iv2 = $this$minByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v9 = null;
        } else {
            Object minElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v9 = minElem$iv;
            } else {
                ChocolateFactoryUpgrade it = (ChocolateFactoryUpgrade)minElem$iv;
                boolean bl = false;
                Double d = it.getEffectiveCost();
                double minValue$iv2 = d != null ? d : Double.MAX_VALUE;
                do {
                    double v$iv;
                    Object e$iv = iterator$iv2.next();
                    ChocolateFactoryUpgrade it3 = (ChocolateFactoryUpgrade)e$iv;
                    $i$a$-minByOrNull-ChocolateFactoryDataLoader$findBestUpgrades$affordAbleUpgrade$2 = false;
                    Double d4 = it3.getEffectiveCost();
                    double d5 = v$iv = d4 != null ? d4 : Double.MAX_VALUE;
                    if (Double.compare(minValue$iv2, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv2 = v$iv;
                } while (iterator$iv2.hasNext());
                v9 = minElem$iv;
            }
        }
        ChocolateFactoryUpgrade chocolateFactoryUpgrade3 = affordAbleUpgrade = (ChocolateFactoryUpgrade)v9;
        ChocolateFactoryAPI.INSTANCE.setBestAffordableSlot(chocolateFactoryUpgrade3 != null ? chocolateFactoryUpgrade3.getValidUpgradeIndex() : -1);
    }

    private static final void onConfigLoad$lambda$0(Property $soundProperty) {
        Object t = $soundProperty.get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        ChocolateFactoryAPI.INSTANCE.setWarningSound(SoundUtils.createSound$default(SoundUtils.INSTANCE, (String)t, 1.0f, 0.0f, 4, null));
    }

    private static final Unit onConfigLoad$lambda$5$lambda$4$lambda$3() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }

    private static final void onConfigLoad$lambda$5(Boolean bl, Boolean bl2) {
        List<ChocolateFactoryUpgrade> list;
        List<ChocolateFactoryUpgrade> it = list = ChocolateFactoryAPI.INSTANCE.getFactoryUpgrades();
        boolean bl3 = false;
        List<ChocolateFactoryUpgrade> list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 != null) {
            List<ChocolateFactoryUpgrade> it2 = list2;
            boolean bl4 = false;
            INSTANCE.findBestUpgrades(it2);
        } else {
            ChocolateFactoryDataLoader $this$onConfigLoad_u24lambda_u245_u24lambda_u244 = INSTANCE;
            boolean bl5 = false;
            ChatUtils.clickableChat-gdl2klw$default(ChatUtils.INSTANCE, "Could not determine your current statistics to get next upgrade. Open CF to fix this!", ChocolateFactoryDataLoader::onConfigLoad$lambda$5$lambda$4$lambda$3, "\u00a7eClick to run /cf!", 0L, false, null, false, 120, null);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "chocolatePerSecondPattern", "getChocolatePerSecondPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "chocolateAllTimePattern", "getChocolateAllTimePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "prestigeLevelPattern", "getPrestigeLevelPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "chocolateThisPrestigePattern", "getChocolateThisPrestigePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "chocolateForPrestigePattern", "getChocolateForPrestigePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "chocolateMultiplierPattern", "getChocolateMultiplierPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "leaderboardPlacePattern", "getLeaderboardPlacePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "leaderboardPercentilePattern", "getLeaderboardPercentilePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "barnAmountPattern", "getBarnAmountPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "timeTowerAmountPattern", "getTimeTowerAmountPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "timeTowerStatusPattern", "getTimeTowerStatusPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "timeTowerRechargePattern", "getTimeTowerRechargePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "clickMeRabbitPattern", "getClickMeRabbitPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "clickMeGoldenRabbitPattern", "getClickMeGoldenRabbitPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "rabbitAmountPattern", "getRabbitAmountPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "upgradeTierPattern", "getUpgradeTierPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "unemployedRabbitPattern", "getUnemployedRabbitPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(ChocolateFactoryDataLoader.class, "otherUpgradePattern", "getOtherUpgradePattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new ChocolateFactoryDataLoader();
        chocolatePerSecondPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("chocolate.persecond", "\u00a76(?<amount>[\\d.,]+) \u00a78per second");
        chocolateAllTimePattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("chocolate.alltime", "\u00a77All-time Chocolate: \u00a76(?<amount>[\\d,]+)");
        prestigeLevelPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("prestige.level", "\u00a76Chocolate Factory (?<prestige>[IVX]+)");
        chocolateThisPrestigePattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("chocolate.thisprestige", "\u00a77Chocolate this Prestige: \u00a76(?<amount>[\\d,]+)");
        chocolateForPrestigePattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("chocolate.forprestige", "\u00a77\u00a7cRequires (?<amount>\\w+) Chocolate this.*");
        chocolateMultiplierPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("chocolate.multiplier", "\u00a77Total Multiplier: \u00a76(?<amount>[\\d.]+)x");
        leaderboardPlacePattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("leaderboard.place", "(?:\u00a7.)+You are \u00a78#\u00a7b(?<position>[\\d,]+)(?: \u00a77in all-time)?(?: Chocolate\\.)?");
        leaderboardPercentilePattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("leaderboard.percentile", "\u00a77\u00a78You are in the top \u00a7.(?<percent>[\\d.]+)%\u00a78 of players!");
        barnAmountPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("barn.amount", "\u00a77Your Barn: \u00a7.(?<rabbits>\\d+)\u00a77/\u00a7.(?<max>\\d+) Rabbits");
        timeTowerAmountPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("timetower.amount", "\u00a77Charges: \u00a7.(?<uses>\\d+)\u00a77/\u00a7a(?<max>\\d+)");
        timeTowerStatusPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("timetower.status", "\u00a77Status: \u00a7.\u00a7l(?<status>INACTIVE|ACTIVE)(?: \u00a7f)?(?<acitveTime>\\w*)");
        timeTowerRechargePattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("timetower.recharge", "\u00a77Next Charge: \u00a7a(?<duration>\\w+)");
        clickMeRabbitPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("rabbit.clickme", "\u00a7e\u00a7lCLICK ME!");
        clickMeGoldenRabbitPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("rabbit.clickme.golden", "\u00a76\u00a7lGolden Rabbit \u00a78- \u00a7a(?<name>.*)");
        rabbitAmountPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("rabbit.amount", "Rabbit \\S+ - \\[(?<amount>\\d+)].*");
        upgradeTierPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("upgradetier", ".*\\s(?<tier>[IVXLC]+)");
        unemployedRabbitPattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("rabbit.unemployed", "Rabbit \\w+ - Unemployed");
        otherUpgradePattern$delegate = ChocolateFactoryAPI.INSTANCE.getPatternGroup().pattern("other.upgrade", "Rabbit Shrine|Coach Jackrabbit");
    }
}

