/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.bazaar;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarApi;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarData;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ3\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u001b\u0010\u001a\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001d\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0017\u001a\u0004\b\u001c\u0010\u0019R\u001b\u0010 \u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0017\u001a\u0004\b\u001f\u0010\u0019\u00a8\u0006!"}, d2={"Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarOrderHelper;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "event", "", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "", "itemName", "Lnet/minecraft/inventory/Slot;", "slot", "Lkotlin/Pair;", "", "buyOrSell", "highlightItem", "(Ljava/lang/String;Lnet/minecraft/inventory/Slot;Lkotlin/Pair;)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "bazaarItemNamePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getBazaarItemNamePattern", "()Ljava/util/regex/Pattern;", "bazaarItemNamePattern", "filledPattern$delegate", "getFilledPattern", "filledPattern", "pricePattern$delegate", "getPricePattern", "pricePattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nBazaarOrderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazaarOrderHelper.kt\nat/hannibal2/skyhanni/features/inventory/bazaar/BazaarOrderHelper\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n8#2:81\n8#2:84\n8#2:86\n1#3:82\n1#3:83\n1#3:85\n1#3:87\n*S KotlinDebug\n*F\n+ 1 BazaarOrderHelper.kt\nat/hannibal2/skyhanni/features/inventory/bazaar/BazaarOrderHelper\n*L\n51#1:81\n65#1:84\n70#1:86\n51#1:82\n65#1:85\n70#1:87\n*E\n"})
public final class BazaarOrderHelper {
    @NotNull
    public static final BazaarOrderHelper INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern bazaarItemNamePattern$delegate;
    @NotNull
    private static final RepoPattern filledPattern$delegate;
    @NotNull
    private static final RepoPattern pricePattern$delegate;

    private BazaarOrderHelper() {
    }

    private final Pattern getBazaarItemNamePattern() {
        return (Pattern)bazaarItemNamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getFilledPattern() {
        return (Pattern)filledPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getPricePattern() {
        return (Pattern)pricePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!LorenzUtils.INSTANCE.getInSkyBlock()) {
            return;
        }
        if (!SkyHanniMod.feature.inventory.bazaar.orderHelper) {
            return;
        }
        if (!(event.getGui() instanceof GuiChest)) {
            return;
        }
        GuiContainer guiChest = event.getGui();
        Container container = guiChest.field_147002_h;
        Intrinsics.checkNotNull(container, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
        ContainerChest chest = (ContainerChest)container;
        String inventoryName = InventoryUtils.INSTANCE.getInventoryName(chest);
        if (!BazaarApi.INSTANCE.isBazaarOrderInventory(inventoryName)) {
            return;
        }
        for (Map.Entry<Slot, ItemStack> entry : InventoryUtils.INSTANCE.getUpperItems(chest).entrySet()) {
            void $this$matchMatcher$iv;
            Slot slot = entry.getKey();
            ItemStack stack = entry.getValue();
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern pattern = this.getBazaarItemNamePattern();
            String text$iv = ItemUtils.INSTANCE.getName(stack);
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
            boolean bl = false;
            if (!it$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onBackgroundDrawn_u24lambda_u242 = it$iv;
            boolean bl2 = false;
            Object it = $this$onBackgroundDrawn_u24lambda_u242.group("type");
            boolean bl3 = false;
            Pair<Boolean, Boolean> buyOrSell = TuplesKt.to(Intrinsics.areEqual(it, "BUY"), Intrinsics.areEqual(it, "SELL"));
            it = buyOrSell;
            boolean bl4 = false;
            boolean bl5 = !((Boolean)((Pair)it).getFirst()).booleanValue() && !((Boolean)((Pair)it).getSecond()).booleanValue();
            if (bl5) {
                return;
            }
            String string2 = $this$onBackgroundDrawn_u24lambda_u242.group("name");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            INSTANCE.highlightItem(string2, slot, buyOrSell);
        }
    }

    private final void highlightItem(String itemName, Slot slot, Pair<Boolean, Boolean> buyOrSell) {
        BazaarData data2 = BazaarApi.INSTANCE.getBazaarDataOrError(NEUInternalName.Companion.fromItemName(itemName));
        ItemStack itemStack2 = slot.func_75211_c();
        Intrinsics.checkNotNullExpressionValue(itemStack2, "getStack(...)");
        List<String> itemLore = ItemUtils.INSTANCE.getLore(itemStack2);
        for (String line : itemLore) {
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = this.getFilledPattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(line);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$highlightItem_u24lambda_u243 = it$iv;
                boolean bl2 = false;
                RenderUtils.INSTANCE.highlight(slot, LorenzColor.GREEN);
                return;
            }
            RegexUtils this_$iv = RegexUtils.INSTANCE;
            $this$matchMatcher$iv = this.getPricePattern();
            $i$f$matchMatcher = false;
            it$iv = $this$matchMatcher$iv.matcher(line);
            bl = false;
            if (!it$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$highlightItem_u24lambda_u244 = it$iv;
            boolean bl3 = false;
            String string2 = $this$highlightItem_u24lambda_u244.group("number");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            double price = NumberUtil.INSTANCE.formatDouble(string2);
            if (!(buyOrSell.getFirst() != false && price < data2.getInstantBuyPrice()) && (!buyOrSell.getSecond().booleanValue() || !(price > data2.getSellOfferPrice()))) continue;
            RenderUtils.INSTANCE.highlight(slot, LorenzColor.GOLD);
            return;
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(BazaarOrderHelper.class, "bazaarItemNamePattern", "getBazaarItemNamePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(BazaarOrderHelper.class, "filledPattern", "getFilledPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(BazaarOrderHelper.class, "pricePattern", "getPricePattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new BazaarOrderHelper();
        patternGroup = RepoPattern.Companion.group("bazaar.orderhelper");
        bazaarItemNamePattern$delegate = patternGroup.pattern("itemname", "\u00a7.\u00a7l(?<type>BUY|SELL) (?<name>.*)");
        filledPattern$delegate = patternGroup.pattern("filled", "\u00a77Filled: \u00a7[a6].*\u00a77/.* \u00a7a\u00a7l100%!");
        pricePattern$delegate = patternGroup.pattern("price", "\u00a77Price per unit: \u00a76(?<number>.*) coins");
    }
}

