/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.inventory.SackDisplayConfig;
import at.hannibal2.skyhanni.data.SackAPI;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemPriceSource;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003:;<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J?\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00028\u00000\u001e\"\b\b\u0000\u0010\u001a*\u00020\u00192\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00028\u00000\u001b0\u0010H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J%\u0010\"\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\u0006\u0010!\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u001d\u0010$\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0002\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010&\u001a\u00020\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0002\u00a2\u0006\u0004\b&\u0010'J!\u0010)\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00110\u00142\u0006\u0010(\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b.\u0010/J\u0017\u00101\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000200H\u0007\u00a2\u0006\u0004\b1\u00102R\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u001c\u00109\u001a\n 6*\u0004\u0018\u000105058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006="}, d2={"Lat/hannibal2/skyhanni/features/inventory/SackDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "event", "", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "", "savingSacks", "update", "(Z)V", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "drawDisplay", "(Z)Ljava/util/List;", "", "list", "", "drawNormalList", "(ZLjava/util/List;)J", "Lat/hannibal2/skyhanni/data/SackAPI$AbstractSackItem;", "T", "Lkotlin/Pair;", "", "sackItems", "", "sort", "(Ljava/util/List;)Ljava/util/Map;", "totalPrice", "drawOptions", "(Ljava/util/List;J)V", "drawRunesDisplay", "(Ljava/util/List;)V", "drawGemstoneDisplay", "(Ljava/util/List;)J", "string", "addAlignedNumber", "(Ljava/util/List;Ljava/lang/String;)V", "price", "format", "(J)Ljava/lang/String;", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "display", "Ljava/util/List;", "Lat/hannibal2/skyhanni/config/features/inventory/SackDisplayConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/SackDisplayConfig;", "config", "SortType", "PriceFormat", "NumberFormat", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSackDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SackDisplay.kt\nat/hannibal2/skyhanni/features/inventory/SackDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nat/hannibal2/skyhanni/utils/CollectionUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,331:1\n1755#2,3:332\n1062#2:335\n1053#2:336\n1062#2:337\n1053#2:338\n1062#2:339\n308#3:340\n326#3,26:341\n309#3:367\n354#3,28:368\n308#3:396\n326#3,26:397\n309#3:423\n354#3,28:424\n1#4:452\n*S KotlinDebug\n*F\n+ 1 SackDisplay.kt\nat/hannibal2/skyhanni/features/inventory/SackDisplay\n*L\n55#1:332,3\n171#1:335\n172#1:336\n173#1:337\n174#1:338\n175#1:339\n190#1:340\n190#1:341,26\n190#1:367\n198#1:368,28\n210#1:396\n210#1:397,26\n210#1:423\n217#1:424,28\n*E\n"})
public final class SackDisplay {
    @NotNull
    public static final SackDisplay INSTANCE = new SackDisplay();
    @NotNull
    private static List<? extends Renderable> display = CollectionsKt.emptyList();

    private SackDisplay() {
    }

    private final SackDisplayConfig getConfig() {
        return SkyHanniMod.feature.inventory.sackDisplay;
    }

    @SubscribeEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (SackAPI.INSTANCE.getInSackInventory()) {
            if (!this.isEnabled()) {
                return;
            }
            Position position = this.getConfig().position;
            Intrinsics.checkNotNullExpressionValue(position, "position");
            RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, display, this.getConfig().extraSpace, "Sacks Items", false, 8, null);
        }
    }

    @SubscribeEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!SackAPI.INSTANCE.getInSackInventory()) {
            return;
        }
        if (!this.getConfig().highlightFull) {
            return;
        }
        for (Slot slot : InventoryUtils.INSTANCE.getItemsInOpenChest()) {
            boolean bl;
            block6: {
                ItemStack itemStack2 = slot.func_75211_c();
                Intrinsics.checkNotNullExpressionValue(itemStack2, "getStack(...)");
                List<String> lore = ItemUtils.INSTANCE.getLore(itemStack2);
                Iterable $this$any$iv = lore;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default(it, "\u00a77Stored: \u00a7a", false, 2, null)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            RenderUtils.INSTANCE.highlight(slot, LorenzColor.RED);
        }
    }

    public final void update(boolean savingSacks) {
        display = this.drawDisplay(savingSacks);
    }

    private final List<Renderable> drawDisplay(boolean savingSacks) {
        List list = new ArrayList();
        long totalPrice = 0L;
        totalPrice += this.drawNormalList(savingSacks, list);
        this.drawRunesDisplay(list);
        this.drawOptions(list, totalPrice += this.drawGemstoneDisplay(list));
        return list;
    }

    private final long drawNormalList(boolean savingSacks, List<Renderable> list) {
        SackAPI.INSTANCE.getSacksData(savingSacks);
        List<Pair<String, SackAPI.SackOtherItem>> sackItems = MapsKt.toList(SackAPI.INSTANCE.getSackItem());
        if (sackItems.isEmpty()) {
            return 0L;
        }
        long totalPrice = 0L;
        int rendered = 0;
        long totalMagmaFish = 0L;
        Map<String, SackAPI.SackOtherItem> sortedPairs = this.sort(sackItems);
        int amountShowing = this.getConfig().itemToShow > sortedPairs.size() ? sortedPairs.size() : this.getConfig().itemToShow;
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, list, "\u00a77Items in Sacks: \u00a7o(Rendering " + amountShowing + " of " + sortedPairs.size() + " items)", null, null, 6, null);
        Map table2 = new LinkedHashMap();
        for (Map.Entry<String, SackAPI.SackOtherItem> entry : sortedPairs.entrySet()) {
            List<Renderable> list2;
            String itemName = entry.getKey();
            SackAPI.SackOtherItem item = entry.getValue();
            NEUInternalName internalName = item.component1();
            String colorCode = item.component2();
            int total = item.component3();
            int magmaFish = item.component4();
            int stored = item.getStored();
            long price = item.getPrice();
            int slot = item.getSlot();
            totalPrice += price;
            if (rendered >= this.getConfig().itemToShow || stored == 0 && !this.getConfig().showEmpty) continue;
            Map map2 = table2;
            List<Renderable> $this$drawNormalList_u24lambda_u243 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$drawNormalList_u24lambda_u243, " \u00a77- ", null, null, 6, null);
            CollectionUtils.INSTANCE.addItemStack($this$drawNormalList_u24lambda_u243, internalName);
            Renderable nameText = Renderable.Companion.optionalLink$default(Renderable.Companion, StringsKt.replace$default(itemName, "\u00a7k", "", false, 4, null), () -> SackDisplay.drawNormalList$lambda$3$lambda$1(itemName), false, CollectionsKt.listOf(slot), SackDisplay::drawNormalList$lambda$3$lambda$2, 4, null);
            $this$drawNormalList_u24lambda_u243.add(nameText);
            SackDisplayConfig.NumberFormatEntry numberFormatEntry = SackDisplay.INSTANCE.getConfig().numberFormat;
            switch (numberFormatEntry == null ? -1 : WhenMappings.$EnumSwitchMapping$0[numberFormatEntry.ordinal()]) {
                case 1: {
                    INSTANCE.addAlignedNumber($this$drawNormalList_u24lambda_u243, colorCode + NumberUtil.INSTANCE.addSeparators(stored));
                    CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$drawNormalList_u24lambda_u243, "\u00a77/", null, null, 6, null);
                    INSTANCE.addAlignedNumber($this$drawNormalList_u24lambda_u243, "\u00a7b" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, total, false, 1, null));
                    break;
                }
                case 2: {
                    INSTANCE.addAlignedNumber($this$drawNormalList_u24lambda_u243, colorCode + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, stored, false, 1, null));
                    CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$drawNormalList_u24lambda_u243, "\u00a77/", null, null, 6, null);
                    INSTANCE.addAlignedNumber($this$drawNormalList_u24lambda_u243, "\u00a7b" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, total, false, 1, null));
                    break;
                }
                case 3: {
                    INSTANCE.addAlignedNumber($this$drawNormalList_u24lambda_u243, colorCode + NumberUtil.INSTANCE.addSeparators(stored));
                    CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$drawNormalList_u24lambda_u243, "\u00a77/", null, null, 6, null);
                    INSTANCE.addAlignedNumber($this$drawNormalList_u24lambda_u243, "\u00a7b" + NumberUtil.INSTANCE.addSeparators(total));
                    break;
                }
                default: {
                    INSTANCE.addAlignedNumber($this$drawNormalList_u24lambda_u243, colorCode + NumberUtil.INSTANCE.addSeparators(stored));
                    CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$drawNormalList_u24lambda_u243, "\u00a77/", null, null, 6, null);
                    INSTANCE.addAlignedNumber($this$drawNormalList_u24lambda_u243, "\u00a7b" + NumberUtil.INSTANCE.addSeparators(total));
                }
            }
            if (SackAPI.INSTANCE.isTrophySack() && magmaFish > 0) {
                totalMagmaFish += (long)magmaFish;
                String string2 = "\u00a7d" + magmaFish;
                RenderUtils.HorizontalAlignment horizontalAlignment = SackDisplay.INSTANCE.getConfig().alignment;
                Intrinsics.checkNotNullExpressionValue((Object)horizontalAlignment, "alignment");
                String[] stringArray = new String[]{"\u00a76Magmafish: \u00a7b" + NumberUtil.INSTANCE.addSeparators(magmaFish), "\u00a76Magmafish value: \u00a7b" + price / (long)magmaFish, "\u00a76Magmafish per: \u00a7b" + magmaFish / stored};
                $this$drawNormalList_u24lambda_u243.add(Renderable.Companion.hoverTips$default(Renderable.Companion, Renderable.Companion.string$default(Renderable.Companion, string2, 0.0, null, horizontalAlignment, null, 22, null), CollectionsKt.listOf(stringArray), null, null, null, false, false, false, null, null, 1020, null));
                CollectionUtils.INSTANCE.addItemStack($this$drawNormalList_u24lambda_u243, NEUInternalName.Companion.asInternalName("MAGMA_FISH"));
            }
            if (SackDisplay.INSTANCE.getConfig().showPrice && price != 0L) {
                INSTANCE.addAlignedNumber($this$drawNormalList_u24lambda_u243, "\u00a76" + INSTANCE.format(price));
            }
            list2 = CollectionsKt.build(list2);
            map2.put(list2, itemName);
            ++rendered;
        }
        list.add(SearchableKt.buildSearchableTable(table2));
        if (SackAPI.INSTANCE.isTrophySack()) {
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, list, "\u00a7cTotal Magmafish: \u00a76" + NumberUtil.INSTANCE.addSeparators(totalMagmaFish), null, null, 6, null);
        }
        return totalPrice;
    }

    private final <T extends SackAPI.AbstractSackItem> Map<String, T> sort(List<? extends Pair<String, ? extends T>> sackItems) {
        List list;
        SackDisplayConfig.SortingTypeEntry sortingTypeEntry = this.getConfig().sortingType;
        switch (sortingTypeEntry == null ? -1 : WhenMappings.$EnumSwitchMapping$1[sortingTypeEntry.ordinal()]) {
            case 1: {
                Iterable $this$sortedByDescending$iv = sackItems;
                boolean $i$f$sortedByDescending = false;
                list = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(((SackAPI.AbstractSackItem)it.getSecond()).getStored());
                        it = (Pair)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, ((SackAPI.AbstractSackItem)it.getSecond()).getStored());
                    }
                });
                break;
            }
            case 2: {
                Iterable $this$sortedBy$iv = sackItems;
                boolean $i$f$sortedBy = false;
                list = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(((SackAPI.AbstractSackItem)it.getSecond()).getStored());
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, ((SackAPI.AbstractSackItem)it.getSecond()).getStored());
                    }
                });
                break;
            }
            case 3: {
                Iterable $this$sortedByDescending$iv = sackItems;
                boolean $i$f$sortedByDescending = false;
                list = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(((SackAPI.AbstractSackItem)it.getSecond()).getPrice());
                        it = (Pair)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, ((SackAPI.AbstractSackItem)it.getSecond()).getPrice());
                    }
                });
                break;
            }
            case 4: {
                Iterable $this$sortedBy$iv = sackItems;
                boolean $i$f$sortedBy = false;
                list = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(((SackAPI.AbstractSackItem)it.getSecond()).getPrice());
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, ((SackAPI.AbstractSackItem)it.getSecond()).getPrice());
                    }
                });
                break;
            }
            default: {
                Iterable $this$sortedByDescending$iv = sackItems;
                boolean $i$f$sortedByDescending = false;
                list = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)b;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(((SackAPI.AbstractSackItem)it.getSecond()).getStored());
                        it = (Pair)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, ((SackAPI.AbstractSackItem)it.getSecond()).getStored());
                    }
                });
            }
        }
        Map sortedPairs = MapsKt.toMutableMap(MapsKt.toMap(list));
        for (Pair pair : MapsKt.toList(sortedPairs)) {
            String k = (String)pair.component1();
            SackAPI.AbstractSackItem v = (SackAPI.AbstractSackItem)pair.component2();
            if (v.getStored() != 0 || this.getConfig().showEmpty) continue;
            sortedPairs.remove(k);
        }
        return sortedPairs;
    }

    /*
     * WARNING - void declaration
     */
    private final void drawOptions(List<Renderable> list, long totalPrice) {
        void getName$iv;
        List<Renderable> prefix$iv;
        void $this$addButton_u24lambda_u2422$iv;
        Object it;
        String display$iv$iv$iv;
        SortType type2;
        Object entry$iv$iv$iv;
        int n;
        void this_$iv$iv;
        String $this$addSelector$iv;
        CollectionUtils this_$iv;
        String name2 = ((SortType)((Object)SortType.getEntries().get(this.getConfig().sortingType.ordinal()))).getLongName();
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, list, "\u00a77Sorted By: \u00a7c" + name2, null, null, 6, null);
        CollectionUtils collectionUtils = CollectionUtils.INSTANCE;
        List<Renderable> list2 = list;
        String prefix$iv2 = " ";
        boolean $i$f$addSelector = false;
        void var9_11 = this_$iv;
        Renderable.Companion companion = Renderable.Companion;
        List<Renderable> list3 = $this$addSelector$iv;
        boolean $i$f$buildSelector22 = false;
        Renderable.Companion companion2 = this_$iv$iv;
        Object universe$iv$iv$iv = SortType.values();
        boolean $i$f$buildSelector = false;
        Object object = CollectionsKt.createListBuilder();
        List<Renderable> $this$buildSelector_u24lambda_u2421$iv$iv$iv = object;
        boolean bl = false;
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, prefix$iv2, null, null, 6, null);
        int n2 = ((SortType[])universe$iv$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            type2 = entry$iv$iv$iv = universe$iv$iv$iv[n];
            boolean bl2 = false;
            display$iv$iv$iv = type2.getShortName();
            it = entry$iv$iv$iv;
            boolean bl3 = false;
            if (((Enum)it).ordinal() == SackDisplay.INSTANCE.getConfig().sortingType.ordinal()) {
                CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, "\u00a7a[" + display$iv$iv$iv + "\u00a7a]", null, null, 6, null);
            } else {
                CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, "\u00a7e[", null, null, 6, null);
                $this$buildSelector_u24lambda_u2421$iv$iv$iv.add(Renderable.Companion.link$default(Renderable.Companion, "\u00a7e" + display$iv$iv$iv, false, new Function0<Unit>(entry$iv$iv$iv){
                    final /* synthetic */ Object $entry;
                    {
                        this.$entry = $entry;
                    }

                    public final void invoke() {
                        SortType it = (SortType)((Object)this.$entry);
                        boolean bl = false;
                        SackDisplay.access$getConfig((SackDisplay)SackDisplay.INSTANCE).sortingType = (SackDisplayConfig.SortingTypeEntry)EntriesMappings.entries$0.get(it.ordinal());
                        SackDisplay.INSTANCE.update(false);
                    }
                }, 2, null));
                CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, "\u00a7e]", null, null, 6, null);
            }
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, " ", null, null, 6, null);
        }
        it = CollectionsKt.build(object);
        list3.add(Renderable.Companion.horizontalContainer$default(companion, it, 0, null, null, 14, null));
        this_$iv = CollectionUtils.INSTANCE;
        $this$addSelector$iv = "\u00a77Number format: ";
        prefix$iv2 = ((NumberFormat)((Object)NumberFormat.getEntries().get(this.getConfig().numberFormat.ordinal()))).getDisplayName();
        List tips$iv = CollectionsKt.emptyList();
        boolean $i$f$addButton2 = false;
        Object onClick$iv = new Function0<Unit>(){

            public final void invoke() {
                if (System.currentTimeMillis() - ChatUtils.INSTANCE.getLastButtonClicked() > 150L) {
                    boolean bl = false;
                    SackDisplay.access$getConfig((SackDisplay)SackDisplay.INSTANCE).numberFormat = (SackDisplayConfig.NumberFormatEntry)EntriesMappings.entries$1.get((SackDisplay.access$getConfig((SackDisplay)SackDisplay.INSTANCE).numberFormat.ordinal() + 1) % 3);
                    SackDisplay.INSTANCE.update(false);
                    SoundUtils.INSTANCE.playClickSound();
                    ChatUtils.INSTANCE.setLastButtonClicked(System.currentTimeMillis());
                }
            }
        };
        list3 = CollectionsKt.createListBuilder();
        List $i$f$buildSelector22 = list3;
        Renderable.Companion this_$iv$iv$iv = Renderable.Companion;
        universe$iv$iv$iv = list;
        boolean bl4 = false;
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$addButton_u24lambda_u2422$iv, (String)((Object)prefix$iv), null, null, 6, null);
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$addButton_u24lambda_u2422$iv, "\u00a7a[", null, null, 6, null);
        boolean bl5 = tips$iv.isEmpty() ? $this$addButton_u24lambda_u2422$iv.add(Renderable.Companion.link("\u00a7e" + (String)getName$iv, false, (Function0<Unit>)onClick$iv)) : $this$addButton_u24lambda_u2422$iv.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7e" + (String)getName$iv, tips$iv, false, (Function0)onClick$iv, null, 16, null));
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$addButton_u24lambda_u2422$iv, "\u00a7a]", null, null, 6, null);
        object = Unit.INSTANCE;
        universe$iv$iv$iv.add(Renderable.Companion.horizontalContainer$default(this_$iv$iv$iv, CollectionsKt.build(list3), 0, null, null, 14, null));
        if (this.getConfig().showPrice) {
            CollectionUtils $this$iv = CollectionUtils.INSTANCE;
            prefix$iv = list;
            prefix$iv2 = " ";
            $i$f$addSelector = false;
            CollectionUtils $i$f$addButton2 = this_$iv;
            onClick$iv = Renderable.Companion;
            list3 = $this$addSelector$iv;
            boolean $i$f$buildSelector32 = false;
            this_$iv$iv$iv = this_$iv$iv;
            universe$iv$iv$iv = ItemPriceSource.values();
            $i$f$buildSelector = false;
            object = CollectionsKt.createListBuilder();
            $this$buildSelector_u24lambda_u2421$iv$iv$iv = object;
            bl = false;
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, prefix$iv2, null, null, 6, null);
            n2 = ((Object)universe$iv$iv$iv).length;
            for (n = 0; n < n2; ++n) {
                type2 = entry$iv$iv$iv = universe$iv$iv$iv[n];
                boolean bl6 = false;
                display$iv$iv$iv = ((ItemPriceSource)((Object)type2)).getSellName();
                it = entry$iv$iv$iv;
                boolean bl7 = false;
                if (((Enum)it).ordinal() == SackDisplay.INSTANCE.getConfig().priceSource.ordinal()) {
                    CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, "\u00a7a[" + display$iv$iv$iv + "\u00a7a]", null, null, 6, null);
                } else {
                    CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, "\u00a7e[", null, null, 6, null);
                    $this$buildSelector_u24lambda_u2421$iv$iv$iv.add(Renderable.Companion.link$default(Renderable.Companion, "\u00a7e" + display$iv$iv$iv, false, new Function0<Unit>(entry$iv$iv$iv){
                        final /* synthetic */ Object $entry;
                        {
                            this.$entry = $entry;
                        }

                        public final void invoke() {
                            ItemPriceSource it = (ItemPriceSource)((Object)this.$entry);
                            boolean bl = false;
                            SackDisplay.access$getConfig((SackDisplay)SackDisplay.INSTANCE).priceSource = (ItemPriceSource)((Object)ItemPriceSource.getEntries().get(it.ordinal()));
                            SackDisplay.INSTANCE.update(false);
                        }
                    }, 2, null));
                    CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, "\u00a7e]", null, null, 6, null);
                }
                CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$buildSelector_u24lambda_u2421$iv$iv$iv, " ", null, null, 6, null);
            }
            List list4 = CollectionsKt.build(object);
            list3.add(Renderable.Companion.horizontalContainer$default((Renderable.Companion)onClick$iv, list4, 0, null, null, 14, null));
            this_$iv = CollectionUtils.INSTANCE;
            $this$addSelector$iv = "\u00a77Price Format: ";
            prefix$iv2 = ((PriceFormat)((Object)PriceFormat.getEntries().get(this.getConfig().priceFormat.ordinal()))).getDisplayName();
            tips$iv = CollectionsKt.emptyList();
            boolean $i$f$addButton22 = false;
            onClick$iv = new Function0<Unit>(){

                public final void invoke() {
                    if (System.currentTimeMillis() - ChatUtils.INSTANCE.getLastButtonClicked() > 150L) {
                        boolean bl = false;
                        SackDisplay.access$getConfig((SackDisplay)SackDisplay.INSTANCE).priceFormat = (SackDisplayConfig.PriceFormatEntry)EntriesMappings.entries$2.get((SackDisplay.access$getConfig((SackDisplay)SackDisplay.INSTANCE).priceFormat.ordinal() + 1) % 2);
                        SackDisplay.INSTANCE.update(false);
                        SoundUtils.INSTANCE.playClickSound();
                        ChatUtils.INSTANCE.setLastButtonClicked(System.currentTimeMillis());
                    }
                }
            };
            List<Renderable> $i$f$buildSelector32 = list3 = CollectionsKt.createListBuilder();
            companion2 = Renderable.Companion;
            List<Renderable> list5 = list;
            bl4 = false;
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$addButton_u24lambda_u2422$iv, prefix$iv, null, null, 6, null);
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$addButton_u24lambda_u2422$iv, "\u00a7a[", null, null, 6, null);
            boolean bl8 = tips$iv.isEmpty() ? $this$addButton_u24lambda_u2422$iv.add(Renderable.Companion.link("\u00a7e" + (String)getName$iv, false, (Function0<Unit>)onClick$iv)) : $this$addButton_u24lambda_u2422$iv.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7e" + (String)getName$iv, tips$iv, false, (Function0)onClick$iv, null, 16, null));
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$addButton_u24lambda_u2422$iv, "\u00a7a]", null, null, 6, null);
            object = Unit.INSTANCE;
            list5.add(Renderable.Companion.horizontalContainer$default(companion2, CollectionsKt.build(list3), 0, null, null, 14, null));
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, list, "\u00a7eTotal price: \u00a76" + this.format(totalPrice), null, null, 6, null);
        }
    }

    private final void drawRunesDisplay(List<Renderable> list) {
        if (SackAPI.INSTANCE.getRuneItem().isEmpty()) {
            return;
        }
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, list, "\u00a77Runes:", null, null, 6, null);
        Map table2 = new LinkedHashMap();
        for (Map.Entry<String, SackAPI.SackRune> entry : this.sort(MapsKt.toList(SackAPI.INSTANCE.getRuneItem())).entrySet()) {
            List<Renderable> list2;
            String name2 = entry.getKey();
            SackAPI.SackRune rune = entry.getValue();
            ItemStack stack = rune.component1();
            int lv1 = rune.component2();
            int lv2 = rune.component3();
            int lv3 = rune.component4();
            Map map2 = table2;
            List<Renderable> $this$drawRunesDisplay_u24lambda_u2419 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$drawRunesDisplay_u24lambda_u2419, " \u00a77- ", null, null, 6, null);
            if (stack != null) {
                ItemStack it;
                boolean bl2 = false;
                CollectionUtils.addItemStack$default(CollectionUtils.INSTANCE, $this$drawRunesDisplay_u24lambda_u2419, it, false, 0.0, 6, null);
            }
            $this$drawRunesDisplay_u24lambda_u2419.add(Renderable.Companion.optionalLink$default(Renderable.Companion, name2, SackDisplay::drawRunesDisplay$lambda$19$lambda$18, false, CollectionsKt.listOf(rune.getSlot()), null, 20, null));
            INSTANCE.addAlignedNumber($this$drawRunesDisplay_u24lambda_u2419, "\u00a7e" + lv1);
            INSTANCE.addAlignedNumber($this$drawRunesDisplay_u24lambda_u2419, "\u00a7e" + lv2);
            INSTANCE.addAlignedNumber($this$drawRunesDisplay_u24lambda_u2419, "\u00a7e" + lv3);
            list2 = CollectionsKt.build(list2);
            map2.put(list2, name2);
        }
        list.add(SearchableKt.buildSearchableTable(table2));
    }

    private final long drawGemstoneDisplay(List<Renderable> list) {
        if (SackAPI.INSTANCE.getGemstoneItem().isEmpty()) {
            return 0L;
        }
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, list, "\u00a77Gemstones:", null, null, 6, null);
        long totalPrice = 0L;
        Map table2 = new LinkedHashMap();
        for (Map.Entry<String, SackAPI.SackGemstone> entry : this.sort(MapsKt.toList(SackAPI.INSTANCE.getGemstoneItem())).entrySet()) {
            List<Renderable> list2;
            String name2 = entry.getKey();
            SackAPI.SackGemstone gem = entry.getValue();
            NEUInternalName internalName = gem.component1();
            int rough = gem.component2();
            int flawed = gem.component3();
            int fine = gem.component4();
            long roughprice = gem.component5();
            long flawedprice = gem.component6();
            long fineprice = gem.component7();
            Map map2 = table2;
            List<Renderable> $this$drawGemstoneDisplay_u24lambda_u2422 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$drawGemstoneDisplay_u24lambda_u2422, " \u00a77- ", null, null, 6, null);
            CollectionUtils.INSTANCE.addItemStack($this$drawGemstoneDisplay_u24lambda_u2422, internalName);
            $this$drawGemstoneDisplay_u24lambda_u2422.add(Renderable.Companion.optionalLink$default(Renderable.Companion, name2, () -> SackDisplay.drawGemstoneDisplay$lambda$22$lambda$20(name2), false, CollectionsKt.listOf(gem.getSlot()), SackDisplay::drawGemstoneDisplay$lambda$22$lambda$21, 4, null));
            INSTANCE.addAlignedNumber($this$drawGemstoneDisplay_u24lambda_u2422, NumberUtil.INSTANCE.addSeparators(rough));
            INSTANCE.addAlignedNumber($this$drawGemstoneDisplay_u24lambda_u2422, "\u00a7a" + NumberUtil.INSTANCE.addSeparators(flawed));
            INSTANCE.addAlignedNumber($this$drawGemstoneDisplay_u24lambda_u2422, "\u00a79" + NumberUtil.INSTANCE.addSeparators(fine));
            long price = roughprice + flawedprice + fineprice;
            totalPrice += price;
            if (SackDisplay.INSTANCE.getConfig().showPrice && price != 0L) {
                INSTANCE.addAlignedNumber($this$drawGemstoneDisplay_u24lambda_u2422, "\u00a77(\u00a76" + INSTANCE.format(price) + "\u00a77)");
            }
            list2 = CollectionsKt.build(list2);
            map2.put(list2, name2);
        }
        list.add(SearchableKt.buildSearchableTable(table2));
        return totalPrice;
    }

    private final void addAlignedNumber(List<Renderable> $this$addAlignedNumber, String string2) {
        RenderUtils.HorizontalAlignment horizontalAlignment = this.getConfig().alignment;
        Intrinsics.checkNotNullExpressionValue((Object)horizontalAlignment, "alignment");
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, $this$addAlignedNumber, string2, horizontalAlignment, null, 4, null);
    }

    private final String format(long price) {
        return this.getConfig().priceFormat == SackDisplayConfig.PriceFormatEntry.FORMATTED ? NumberUtil.shortFormat$default(NumberUtil.INSTANCE, price, false, 1, null) : NumberUtil.INSTANCE.addSeparators(price);
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled;
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.transform(15, "inventory.sackDisplay.numberFormat", SackDisplay::onConfigFix$lambda$23);
        event.transform(15, "inventory.sackDisplay.priceFormat", SackDisplay::onConfigFix$lambda$24);
        event.transform(15, "inventory.sackDisplay.sortingType", SackDisplay::onConfigFix$lambda$25);
    }

    private static final Unit drawNormalList$lambda$3$lambda$1(String $itemName) {
        Intrinsics.checkNotNullParameter($itemName, "$itemName");
        if (!SackAPI.INSTANCE.isTrophySack()) {
            BazaarApi.searchForBazaarItem$default(BazaarApi.INSTANCE, $itemName, 0, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean drawNormalList$lambda$3$lambda$2() {
        return !NEUItems.INSTANCE.neuHasFocus();
    }

    private static final Unit drawRunesDisplay$lambda$19$lambda$18() {
        return Unit.INSTANCE;
    }

    private static final Unit drawGemstoneDisplay$lambda$22$lambda$20(String $name) {
        Intrinsics.checkNotNullParameter($name, "$name");
        BazaarApi.searchForBazaarItem$default(BazaarApi.INSTANCE, StringsKt.dropLast($name, 1), 0, 2, null);
        return Unit.INSTANCE;
    }

    private static final boolean drawGemstoneDisplay$lambda$22$lambda$21() {
        return !NEUItems.INSTANCE.neuHasFocus();
    }

    private static final JsonElement onConfigFix$lambda$23(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntToEnum(element, SackDisplayConfig.NumberFormatEntry.class);
    }

    private static final JsonElement onConfigFix$lambda$24(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntToEnum(element, SackDisplayConfig.PriceFormatEntry.class);
    }

    private static final JsonElement onConfigFix$lambda$25(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntToEnum(element, SackDisplayConfig.SortingTypeEntry.class);
    }

    public static final /* synthetic */ SackDisplayConfig access$getConfig(SackDisplay $this) {
        return $this.getConfig();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<SackDisplayConfig.SortingTypeEntry> entries$0;
        public static final /* synthetic */ EnumEntries<SackDisplayConfig.NumberFormatEntry> entries$1;
        public static final /* synthetic */ EnumEntries<SackDisplayConfig.PriceFormatEntry> entries$2;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])SackDisplayConfig.SortingTypeEntry.values());
            entries$1 = EnumEntriesKt.enumEntries((Enum[])SackDisplayConfig.NumberFormatEntry.values());
            entries$2 = EnumEntriesKt.enumEntries((Enum[])SackDisplayConfig.PriceFormatEntry.values());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lat/hannibal2/skyhanni/features/inventory/SackDisplay$NumberFormat;", "", "", "displayName", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getDisplayName", "()Ljava/lang/String;", "DEFAULT", "FORMATTED", "UNFORMATTED", "1.8.9"})
    public static final class NumberFormat
    extends Enum<NumberFormat> {
        @NotNull
        private final String displayName;
        public static final /* enum */ NumberFormat DEFAULT = new NumberFormat("Default");
        public static final /* enum */ NumberFormat FORMATTED = new NumberFormat("Formatted");
        public static final /* enum */ NumberFormat UNFORMATTED = new NumberFormat("Unformatted");
        private static final /* synthetic */ NumberFormat[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private NumberFormat(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static NumberFormat[] values() {
            return (NumberFormat[])$VALUES.clone();
        }

        public static NumberFormat valueOf(String value) {
            return Enum.valueOf(NumberFormat.class, value);
        }

        @NotNull
        public static EnumEntries<NumberFormat> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = numberFormatArray = new NumberFormat[]{NumberFormat.DEFAULT, NumberFormat.FORMATTED, NumberFormat.UNFORMATTED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lat/hannibal2/skyhanni/features/inventory/SackDisplay$PriceFormat;", "", "", "displayName", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getDisplayName", "()Ljava/lang/String;", "FORMATED", "UNFORMATED", "1.8.9"})
    public static final class PriceFormat
    extends Enum<PriceFormat> {
        @NotNull
        private final String displayName;
        public static final /* enum */ PriceFormat FORMATED = new PriceFormat("Formatted");
        public static final /* enum */ PriceFormat UNFORMATED = new PriceFormat("Unformatted");
        private static final /* synthetic */ PriceFormat[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PriceFormat(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static PriceFormat[] values() {
            return (PriceFormat[])$VALUES.clone();
        }

        public static PriceFormat valueOf(String value) {
            return Enum.valueOf(PriceFormat.class, value);
        }

        @NotNull
        public static EnumEntries<PriceFormat> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = priceFormatArray = new PriceFormat[]{PriceFormat.FORMATED, PriceFormat.UNFORMATED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\n\u0010\tj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lat/hannibal2/skyhanni/features/inventory/SackDisplay$SortType;", "", "", "shortName", "longName", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "Ljava/lang/String;", "getShortName", "()Ljava/lang/String;", "getLongName", "STORED_DESC", "STORED_ASC", "PRICE_DESC", "PRICE_ASC", "1.8.9"})
    public static final class SortType
    extends Enum<SortType> {
        @NotNull
        private final String shortName;
        @NotNull
        private final String longName;
        public static final /* enum */ SortType STORED_DESC = new SortType("Stored D", "Stored Descending");
        public static final /* enum */ SortType STORED_ASC = new SortType("Stored A", "Stored Ascending");
        public static final /* enum */ SortType PRICE_DESC = new SortType("Price D", "Price Descending");
        public static final /* enum */ SortType PRICE_ASC = new SortType("Price A", "Price Ascending");
        private static final /* synthetic */ SortType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SortType(String shortName, String longName) {
            this.shortName = shortName;
            this.longName = longName;
        }

        @NotNull
        public final String getShortName() {
            return this.shortName;
        }

        @NotNull
        public final String getLongName() {
            return this.longName;
        }

        public static SortType[] values() {
            return (SortType[])$VALUES.clone();
        }

        public static SortType valueOf(String value) {
            return Enum.valueOf(SortType.class, value);
        }

        @NotNull
        public static EnumEntries<SortType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sortTypeArray = new SortType[]{SortType.STORED_DESC, SortType.STORED_ASC, SortType.PRICE_DESC, SortType.PRICE_ASC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SackDisplayConfig.NumberFormatEntry.values().length];
            try {
                nArray[SackDisplayConfig.NumberFormatEntry.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SackDisplayConfig.NumberFormatEntry.FORMATTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SackDisplayConfig.NumberFormatEntry.UNFORMATTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[SackDisplayConfig.SortingTypeEntry.values().length];
            try {
                nArray[SackDisplayConfig.SortingTypeEntry.DESC_STORED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SackDisplayConfig.SortingTypeEntry.ASC_STORED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SackDisplayConfig.SortingTypeEntry.DESC_PRICE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SackDisplayConfig.SortingTypeEntry.ASC_PRICE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

