/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.features.inventory.InventoryConfig;
import at.hannibal2.skyhanni.data.repo.RepoError;
import at.hannibal2.skyhanni.data.repo.RepoManager;
import at.hannibal2.skyhanni.data.repo.RepoUtils;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.LorenzToolTipEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u0007*\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0011\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001c\u0010\"\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020&0#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010%\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/features/inventory/QuickCraftFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/features/inventory/QuickCraftFeatures$InventoryType;", "", "slotNumber", "", "ignoreSlot", "(Lat/hannibal2/skyhanni/features/inventory/QuickCraftFeatures$InventoryType;Ljava/lang/Integer;)Z", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;", "onToolTip", "(Lat/hannibal2/skyhanni/events/LorenzToolTipEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$ForegroundDrawnEvent;", "onForegroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$ForegroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "Lnet/minecraft/item/ItemStack;", "item", "needsQuickCraftConfirmation", "(Lnet/minecraft/item/ItemStack;)Z", "getInventoryType", "()Lat/hannibal2/skyhanni/features/inventory/QuickCraftFeatures$InventoryType;", "Lat/hannibal2/skyhanni/config/features/inventory/InventoryConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/InventoryConfig;", "config", "", "quickCraftSlots", "Ljava/util/List;", "", "quickCraftableItems", "InventoryType", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nQuickCraftFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuickCraftFeatures.kt\nat/hannibal2/skyhanni/features/inventory/QuickCraftFeatures\n+ 2 RepositoryReloadEvent.kt\nat/hannibal2/skyhanni/events/RepositoryReloadEvent\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n12#2,7:99\n295#3,2:106\n*S KotlinDebug\n*F\n+ 1 QuickCraftFeatures.kt\nat/hannibal2/skyhanni/features/inventory/QuickCraftFeatures\n*L\n42#1:99,7\n95#1:106,2\n*E\n"})
public final class QuickCraftFeatures {
    @NotNull
    public static final QuickCraftFeatures INSTANCE = new QuickCraftFeatures();
    @NotNull
    private static final List<Integer> quickCraftSlots;
    @NotNull
    private static List<String> quickCraftableItems;

    private QuickCraftFeatures() {
    }

    private final InventoryConfig getConfig() {
        return SkyHanniMod.feature.inventory;
    }

    private final boolean ignoreSlot(InventoryType $this$ignoreSlot, Integer slotNumber) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$ignoreSlot.ordinal()]) {
            case 1: {
                if (!CollectionsKt.contains((Iterable)quickCraftSlots, slotNumber)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                IntRange intRange = new IntRange(10, 44);
                if (!(slotNumber != null && intRange.contains(slotNumber))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @SubscribeEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        List list;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        String constant$iv = "QuickCraftableItems";
        Type type$iv = null;
        Gson gson$iv = event.getGson();
        boolean $i$f$getConstant = false;
        try {
            RepoManager.Companion.setLastConstant(constant$iv);
            if (!event.getRepoLocation().exists()) {
                throw new RepoError("Repo folder does not exist!");
            }
            list = RepoUtils.INSTANCE.getConstant(event.getRepoLocation(), constant$iv, gson$iv, List.class, type$iv);
        }
        catch (Exception e$iv) {
            throw new RepoError("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv);
        }
        quickCraftableItems = list;
    }

    @SubscribeEvent
    public final void onToolTip(@NotNull LorenzToolTipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        InventoryType inventoryType = this.getInventoryType();
        if (inventoryType == null) {
            return;
        }
        InventoryType inventoryType2 = inventoryType;
        if (this.ignoreSlot(inventoryType2, event.getSlot().field_75222_d)) {
            return;
        }
        if (this.needsQuickCraftConfirmation(event.getItemStack())) {
            event.getToolTip().replaceAll(QuickCraftFeatures::onToolTip$lambda$0);
        }
    }

    @SubscribeEvent
    public final void onForegroundDrawn(@NotNull GuiContainerEvent.ForegroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        InventoryType inventoryType = this.getInventoryType();
        if (inventoryType == null) {
            return;
        }
        InventoryType inventoryType2 = inventoryType;
        if (KeyboardManager.INSTANCE.isModifierKeyDown()) {
            return;
        }
        if (!(event.getGui() instanceof GuiChest)) {
            return;
        }
        Container container = event.getGui().field_147002_h;
        Intrinsics.checkNotNull(container, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
        ContainerChest chest = (ContainerChest)container;
        for (Map.Entry<Slot, ItemStack> entry : InventoryUtils.INSTANCE.getAllItems(chest).entrySet()) {
            Slot slot = entry.getKey();
            ItemStack stack = entry.getValue();
            if (this.ignoreSlot(inventoryType2, slot.field_75222_d) || Intrinsics.areEqual(ItemUtils.INSTANCE.getName(stack), "\u00a7cQuick Crafting Slot") || !this.needsQuickCraftConfirmation(stack)) continue;
            RenderUtils.INSTANCE.highlight(slot, LorenzColor.DARK_GRAY.addOpacity(180));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        InventoryType inventoryType = this.getInventoryType();
        if (inventoryType == null) {
            return;
        }
        InventoryType inventoryType2 = inventoryType;
        Slot slot = event.getSlot();
        if (this.ignoreSlot(inventoryType2, slot != null ? Integer.valueOf(slot.field_75222_d) : null)) {
            return;
        }
        Slot slot2 = event.getSlot();
        if (slot2 == null || (slot2 = slot2.func_75211_c()) == null) {
            return;
        }
        Slot clickedItem = slot2;
        if (!KeyboardManager.INSTANCE.isModifierKeyDown() && this.needsQuickCraftConfirmation((ItemStack)clickedItem)) {
            event.cancel();
        }
    }

    private final boolean needsQuickCraftConfirmation(ItemStack item) {
        String string2 = item.func_82833_r();
        Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
        return !quickCraftableItems.contains(StringUtils.removeColor$default(StringUtils.INSTANCE, string2, false, 1, null));
    }

    private final InventoryType getInventoryType() {
        Object v0;
        block2: {
            if (!LorenzUtils.INSTANCE.getInSkyBlock() || !this.getConfig().quickCraftingConfirmation) {
                return null;
            }
            String inventoryName = InventoryUtils.INSTANCE.openInventoryName();
            Iterable $this$firstOrNull$iv = InventoryType.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                InventoryType it = (InventoryType)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getInventoryName(), inventoryName)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    private static final String onToolTip$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringsKt.replace$default(it, "Click to craft!", "\u00a7c" + KeyboardManager.INSTANCE.getModifierKeyName() + " + Click to craft!", false, 4, null);
    }

    static {
        Integer[] integerArray = new Integer[]{16, 25, 34};
        quickCraftSlots = CollectionsKt.listOf(integerArray);
        quickCraftableItems = CollectionsKt.emptyList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lat/hannibal2/skyhanni/features/inventory/QuickCraftFeatures$InventoryType;", "", "", "inventoryName", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getInventoryName", "()Ljava/lang/String;", "CRAFT_ITEM", "MORE_QUICK_CRAFT_OPTIONS", "1.8.9"})
    public static final class InventoryType
    extends Enum<InventoryType> {
        @NotNull
        private final String inventoryName;
        public static final /* enum */ InventoryType CRAFT_ITEM = new InventoryType("Craft Item");
        public static final /* enum */ InventoryType MORE_QUICK_CRAFT_OPTIONS = new InventoryType("Quick Crafting");
        private static final /* synthetic */ InventoryType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private InventoryType(String inventoryName) {
            this.inventoryName = inventoryName;
        }

        @NotNull
        public final String getInventoryName() {
            return this.inventoryName;
        }

        public static InventoryType[] values() {
            return (InventoryType[])$VALUES.clone();
        }

        public static InventoryType valueOf(String value) {
            return Enum.valueOf(InventoryType.class, value);
        }

        @NotNull
        public static EnumEntries<InventoryType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = inventoryTypeArray = new InventoryType[]{InventoryType.CRAFT_ITEM, InventoryType.MORE_QUICK_CRAFT_OPTIONS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InventoryType.values().length];
            try {
                nArray[InventoryType.CRAFT_ITEM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InventoryType.MORE_QUICK_CRAFT_OPTIONS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

