/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.inventory.ChestValueConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryOpenEvent;
import at.hannibal2.skyhanni.events.LorenzTickEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonAPI;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarApi;
import at.hannibal2.skyhanni.features.minion.MinionFeatures;
import at.hannibal2.skyhanni.features.misc.items.EstimatedItemValue;
import at.hannibal2.skyhanni.features.misc.items.EstimatedItemValueCalculator;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NEUItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004@ABCB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u001b\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00160\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J#\u0010\u001b\u001a\u00020\u00062\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00160\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0016H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0018J#\u0010\u001f\u001a\u00020\u00062\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00160\u0019H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001cJ\u000f\u0010 \u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b \u0010\u0003J\u0013\u0010\"\u001a\u00020\t*\u00020!H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b%\u0010&J#\u0010+\u001a\u00020\t*\u00020\t2\u0006\u0010(\u001a\u00020'2\u0006\u0010*\u001a\u00020)H\u0002\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020$H\u0002\u00a2\u0006\u0004\b-\u0010&J\u0017\u0010/\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020.H\u0007\u00a2\u0006\u0004\b/\u00100R\u001c\u00105\u001a\n 2*\u0004\u0018\u000101018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\"\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00160\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R \u00109\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001d088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0014\u0010<\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010&R\u0016\u0010=\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0016\u0010?\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b?\u0010>\u00a8\u0006D"}, d2={"Lat/hannibal2/skyhanni/features/inventory/ChestValue;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "event", "", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "", "featureName", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/LorenzTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/LorenzTickEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryOpenEvent;", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryOpenEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "update", "", "drawDisplay", "()Ljava/util/List;", "", "newDisplay", "addList", "(Ljava/util/List;)V", "Lat/hannibal2/skyhanni/features/inventory/ChestValue$Item;", "sortedList", "addButton", "init", "", "formatPrice", "(D)Ljava/lang/String;", "", "isValidStorage", "()Z", "", "targetLength", "", "char", "reduceStringLength", "(Ljava/lang/String;IC)Ljava/lang/String;", "isEnabled", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/inventory/ChestValueConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/ChestValueConfig;", "config", "display", "Ljava/util/List;", "", "chestItems", "Ljava/util/Map;", "getInInventory", "inInventory", "inOwnInventory", "Z", "compactInventory", "SortType", "FormatType", "DisplayType", "Item", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nChestValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChestValue.kt\nat/hannibal2/skyhanni/features/inventory/ChestValue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LorenzUtils.kt\nat/hannibal2/skyhanni/utils/LorenzUtils\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,309:1\n1062#2:310\n1053#2:311\n1062#2:312\n774#2:394\n865#2,2:395\n1863#2,2:397\n251#3,27:313\n251#3,27:340\n251#3,27:367\n381#4,7:399\n*S KotlinDebug\n*F\n+ 1 ChestValue.kt\nat/hannibal2/skyhanni/features/inventory/ChestValue\n*L\n149#1:310\n150#1:311\n151#1:312\n191#1:394\n191#1:395,2\n196#1:397,2\n155#1:313,27\n165#1:340,27\n175#1:367,27\n211#1:399,7\n*E\n"})
public final class ChestValue {
    @NotNull
    public static final ChestValue INSTANCE = new ChestValue();
    @NotNull
    private static List<? extends List<? extends Object>> display = CollectionsKt.emptyList();
    @NotNull
    private static final Map<String, Item> chestItems = new LinkedHashMap();
    private static boolean inOwnInventory;
    private static boolean compactInventory;

    private ChestValue() {
    }

    private final ChestValueConfig getConfig() {
        return SkyHanniMod.feature.inventory.chestValueConfig;
    }

    private final boolean getInInventory() {
        return this.isValidStorage();
    }

    @SubscribeEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (DungeonAPI.INSTANCE.inDungeon() && !this.getConfig().enableInDungeons) {
            return;
        }
        if (!inOwnInventory && Intrinsics.areEqual(InventoryUtils.INSTANCE.openInventoryName(), "")) {
            return;
        }
        if (!this.getConfig().showDuringEstimatedItemValue && EstimatedItemValue.INSTANCE.isCurrentlyShowing()) {
            return;
        }
        if (this.getInInventory()) {
            Position position = this.getConfig().position;
            Intrinsics.checkNotNullExpressionValue(position, "position");
            RenderUtils.INSTANCE.renderStringsAndItems(position, display, -1, 0.7, this.featureName());
        }
    }

    @NotNull
    public final String featureName() {
        return inOwnInventory ? "Estimated Inventory Value" : "Estimated Chest Value";
    }

    @SubscribeEvent
    public final void onTick(@NotNull LorenzTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!LorenzTickEvent.isMod$default(event, 5, 0, 2, null)) {
            return;
        }
        boolean inInv = Minecraft.func_71410_x().field_71462_r instanceof GuiInventory;
        boolean bl = inOwnInventory = inInv && this.getConfig().enableInOwnInventory;
        if (!this.getInInventory()) {
            return;
        }
        this.update();
    }

    @SubscribeEvent
    public final void onInventoryOpen(@NotNull InventoryOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (this.getInInventory()) {
            this.update();
        }
    }

    @SubscribeEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        chestItems.clear();
    }

    private final void update() {
        display = this.drawDisplay();
    }

    private final List<List<Object>> drawDisplay() {
        List newDisplay = new ArrayList();
        this.init();
        if (chestItems.isEmpty()) {
            return newDisplay;
        }
        this.addList(newDisplay);
        this.addButton(newDisplay);
        return newDisplay;
    }

    /*
     * WARNING - void declaration
     */
    private final void addList(List<List<Object>> newDisplay) {
        List<Item> sortedList = this.sortedList();
        double totalPrice = 0.0;
        int rendered = 0;
        int amountShowing = this.getConfig().itemToShow > sortedList.size() ? sortedList.size() : this.getConfig().itemToShow;
        CollectionUtils.INSTANCE.addAsSingletonList(newDisplay, "\u00a77" + this.featureName() + ": \u00a7o(Showing " + amountShowing + " of " + sortedList.size() + " items)");
        for (Item item : sortedList) {
            void $this$addList_u24lambda_u240;
            List list;
            List<Integer> index = item.component1();
            int amount = item.component2();
            ItemStack stack = item.component3();
            double total = item.component4();
            List<String> tips = item.component5();
            totalPrice += total;
            if (rendered >= this.getConfig().itemToShow || total < (double)this.getConfig().hideBelow) continue;
            String textAmount = " \u00a77x" + NumberUtil.INSTANCE.addSeparators(amount) + ':';
            int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(textAmount);
            String name2 = this.reduceStringLength(ItemUtils.INSTANCE.getItemName(stack), this.getConfig().nameLength - width, ' ') + ' ' + textAmount;
            String price = "\u00a76" + this.formatPrice(total);
            String text = this.getConfig().alignedDisplay ? name2 + ' ' + price : ItemUtils.INSTANCE.getItemName(stack) + " \u00a77x" + amount + ": \u00a76" + this.formatPrice(total);
            List list2 = list = CollectionsKt.createListBuilder();
            List list3 = newDisplay;
            boolean bl = false;
            Renderable.Companion companion = Renderable.Companion;
            List<Integer> list4 = ChestValue.INSTANCE.getConfig().enableHighlight ? index : CollectionsKt.emptyList();
            Renderable renderable2 = Renderable.Companion.hoverTips$default(companion, text, tips, list4, stack, null, false, false, false, null, null, 1008, null);
            $this$addList_u24lambda_u240.add(" \u00a77- ");
            if (ChestValue.INSTANCE.getConfig().showStacks) {
                $this$addList_u24lambda_u240.add(stack);
            }
            $this$addList_u24lambda_u240.add(renderable2);
            list3.add(CollectionsKt.build(list));
            ++rendered;
        }
        CollectionUtils.INSTANCE.addAsSingletonList(newDisplay, "\u00a7aTotal value: \u00a76" + this.formatPrice(totalPrice) + " coins");
    }

    private final List<Item> sortedList() {
        List<Item> list;
        ChestValueConfig.SortingTypeEntry sortingTypeEntry = this.getConfig().sortingType;
        switch (sortingTypeEntry == null ? -1 : WhenMappings.$EnumSwitchMapping$0[sortingTypeEntry.ordinal()]) {
            case 1: {
                Iterable $this$sortedByDescending$iv = chestItems.values();
                boolean $i$f$sortedByDescending = false;
                list = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Item it = (Item)b;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.getTotal());
                        it = (Item)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getTotal());
                    }
                });
                break;
            }
            case 2: {
                Iterable $this$sortedBy$iv = chestItems.values();
                boolean $i$f$sortedBy = false;
                list = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Item it = (Item)a;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.getTotal());
                        it = (Item)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getTotal());
                    }
                });
                break;
            }
            default: {
                Iterable $this$sortedByDescending$iv = chestItems.values();
                boolean $i$f$sortedByDescending = false;
                list = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Item it = (Item)b;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.getTotal());
                        it = (Item)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getTotal());
                    }
                });
            }
        }
        return list;
    }

    private final void addButton(List<List<Object>> newDisplay) {
        String getName$iv;
        String prefix$iv;
        List<Object> $this$addButton_u24lambda_u244$iv;
        List<Object> list;
        LorenzUtils lorenzUtils = LorenzUtils.INSTANCE;
        String string2 = "\u00a77Sorted By: ";
        String string3 = ((SortType)((Object)SortType.getEntries().get(this.getConfig().sortingType.ordinal()))).getLongName();
        List tips$iv = CollectionsKt.emptyList();
        boolean $i$f$addButton = false;
        Function0 onClick$iv = new Function0<Unit>(){

            public final void invoke() {
                if (System.currentTimeMillis() - ChatUtils.INSTANCE.getLastButtonClicked() > 150L) {
                    boolean bl = false;
                    ChestValue.access$getConfig((ChestValue)ChestValue.INSTANCE).sortingType = (ChestValueConfig.SortingTypeEntry)EntriesMappings.entries$0.get((ChestValue.access$getConfig((ChestValue)ChestValue.INSTANCE).sortingType.ordinal() + 1) % 2);
                    ChestValue.access$update(ChestValue.INSTANCE);
                    SoundUtils.INSTANCE.playClickSound();
                    ChatUtils.INSTANCE.setLastButtonClicked(System.currentTimeMillis());
                }
            }
        };
        List<Object> list2 = list = CollectionsKt.createListBuilder();
        List<List<Object>> list3 = newDisplay;
        boolean bl = false;
        $this$addButton_u24lambda_u244$iv.add(prefix$iv);
        $this$addButton_u24lambda_u244$iv.add("\u00a7a[");
        boolean bl2 = tips$iv.isEmpty() ? $this$addButton_u24lambda_u244$iv.add(Renderable.Companion.link("\u00a7e" + getName$iv, false, onClick$iv)) : $this$addButton_u24lambda_u244$iv.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7e" + getName$iv, tips$iv, false, onClick$iv, null, 16, null));
        $this$addButton_u24lambda_u244$iv.add("\u00a7a]");
        list3.add(CollectionsKt.build(list));
        LorenzUtils $this$iv = LorenzUtils.INSTANCE;
        prefix$iv = "\u00a77Value format: ";
        getName$iv = ((FormatType)((Object)FormatType.getEntries().get(this.getConfig().formatType.ordinal()))).getType();
        tips$iv = CollectionsKt.emptyList();
        $i$f$addButton = false;
        onClick$iv = new Function0<Unit>(){

            public final void invoke() {
                if (System.currentTimeMillis() - ChatUtils.INSTANCE.getLastButtonClicked() > 150L) {
                    boolean bl = false;
                    ChestValue.access$getConfig((ChestValue)ChestValue.INSTANCE).formatType = (ChestValueConfig.NumberFormatEntry)EntriesMappings.entries$1.get((ChestValue.access$getConfig((ChestValue)ChestValue.INSTANCE).formatType.ordinal() + 1) % 2);
                    ChestValue.access$update(ChestValue.INSTANCE);
                    SoundUtils.INSTANCE.playClickSound();
                    ChatUtils.INSTANCE.setLastButtonClicked(System.currentTimeMillis());
                }
            }
        };
        $this$addButton_u24lambda_u244$iv = list = CollectionsKt.createListBuilder();
        list3 = newDisplay;
        bl = false;
        $this$addButton_u24lambda_u244$iv.add(prefix$iv);
        $this$addButton_u24lambda_u244$iv.add("\u00a7a[");
        boolean bl3 = tips$iv.isEmpty() ? $this$addButton_u24lambda_u244$iv.add(Renderable.Companion.link("\u00a7e" + getName$iv, false, onClick$iv)) : $this$addButton_u24lambda_u244$iv.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7e" + getName$iv, tips$iv, false, onClick$iv, null, 16, null));
        $this$addButton_u24lambda_u244$iv.add("\u00a7a]");
        list3.add(CollectionsKt.build(list));
        $this$iv = LorenzUtils.INSTANCE;
        prefix$iv = "\u00a77Display Type: ";
        getName$iv = ((DisplayType)((Object)DisplayType.getEntries().get(this.getConfig().alignedDisplay ? 1 : 0))).getType();
        tips$iv = CollectionsKt.emptyList();
        $i$f$addButton = false;
        onClick$iv = new Function0<Unit>(){

            public final void invoke() {
                if (System.currentTimeMillis() - ChatUtils.INSTANCE.getLastButtonClicked() > 150L) {
                    boolean bl = false;
                    ChestValue.access$getConfig((ChestValue)ChestValue.INSTANCE).alignedDisplay = !ChestValue.access$getConfig((ChestValue)ChestValue.INSTANCE).alignedDisplay;
                    ChestValue.access$update(ChestValue.INSTANCE);
                    SoundUtils.INSTANCE.playClickSound();
                    ChatUtils.INSTANCE.setLastButtonClicked(System.currentTimeMillis());
                }
            }
        };
        $this$addButton_u24lambda_u244$iv = list = CollectionsKt.createListBuilder();
        list3 = newDisplay;
        bl = false;
        $this$addButton_u24lambda_u244$iv.add(prefix$iv);
        $this$addButton_u24lambda_u244$iv.add("\u00a7a[");
        boolean bl4 = tips$iv.isEmpty() ? $this$addButton_u24lambda_u244$iv.add(Renderable.Companion.link("\u00a7e" + getName$iv, false, onClick$iv)) : $this$addButton_u24lambda_u244$iv.add(Renderable.Companion.clickAndHover$default(Renderable.Companion, "\u00a7e" + getName$iv, tips$iv, false, onClick$iv, null, 16, null));
        $this$addButton_u24lambda_u244$iv.add("\u00a7a]");
        list3.add(CollectionsKt.build(list));
    }

    /*
     * WARNING - void declaration
     */
    private final void init() {
        Slot it;
        List list;
        if (!this.getInInventory()) {
            return;
        }
        if (inOwnInventory) {
            list = InventoryUtils.INSTANCE.getSlotsInOwnInventory();
        } else {
            void $this$filterTo$iv$iv;
            boolean isMinion = StringsKt.contains$default((CharSequence)InventoryUtils.INSTANCE.openInventoryName(), " Minion ", false, 2, null);
            Iterable $this$filter$iv = InventoryUtils.INSTANCE.getItemsInOpenChest();
            boolean bl = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Slot)element$iv$iv;
                boolean bl2 = false;
                if (!(it.func_75216_d() && !Intrinsics.areEqual(it.field_75224_c, Minecraft.func_71410_x().field_71439_g.field_71071_by) && (!isMinion || it.field_75222_d % 9 != 1))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List slots = list;
        Map<Integer, ItemStack> map2 = MapsKt.createMapBuilder();
        Map<Integer, ItemStack> entry = map2;
        boolean bl = false;
        Iterable $this$forEach$iv = slots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Slot)element$iv;
            boolean bl2 = false;
            entry.put(it.getSlotIndex(), it.func_75211_c());
        }
        Map stacks = MapsKt.build(map2);
        chestItems.clear();
        for (Map.Entry entry2 : stacks.entrySet()) {
            Item item;
            NEUInternalName internalName;
            int i2 = ((Number)entry2.getKey()).intValue();
            ItemStack stack = (ItemStack)entry2.getValue();
            Intrinsics.checkNotNull(stack);
            if (ItemUtils.INSTANCE.getInternalNameOrNull(stack) == null || NEUItems.INSTANCE.getItemStackOrNull(internalName) == null) continue;
            List list2 = new ArrayList();
            double total = ((Number)EstimatedItemValueCalculator.INSTANCE.calculate(stack, list2).getFirst()).doubleValue();
            String key = "" + internalName + '+' + total;
            if (Intrinsics.areEqual(stack.func_77973_b(), Items.field_151134_bR)) {
                total /= (double)2;
            }
            list2.add("\u00a7aTotal: \u00a76\u00a7l" + this.formatPrice(total) + " coins");
            if (total == 0.0) continue;
            Map<String, Item> $this$getOrPut$iv = chestItems;
            boolean $i$f$getOrPut = false;
            Item value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl3 = false;
                Item answer$iv = new Item(new ArrayList(), 0, stack, 0.0, list2);
                $this$getOrPut$iv.put(key, answer$iv);
                item = answer$iv;
            } else {
                item = value$iv;
            }
            Item item2 = item;
            item2.getIndex().add(i2);
            item2.setAmount(item2.getAmount() + stack.field_77994_a);
            item2.setTotal(item2.getTotal() + total * (double)stack.field_77994_a);
        }
    }

    private final String formatPrice(double $this$formatPrice) {
        String string2;
        ChestValueConfig.NumberFormatEntry numberFormatEntry = this.getConfig().formatType;
        switch (numberFormatEntry == null ? -1 : WhenMappings.$EnumSwitchMapping$1[numberFormatEntry.ordinal()]) {
            case 1: {
                if ($this$formatPrice > 1.0E9) {
                    string2 = NumberUtil.INSTANCE.shortFormat($this$formatPrice, true);
                    break;
                }
                string2 = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, $this$formatPrice, false, 1, null);
                break;
            }
            case 2: {
                string2 = NumberUtil.INSTANCE.addSeparators($this$formatPrice);
                break;
            }
            default: {
                string2 = "0";
            }
        }
        return string2;
    }

    private final boolean isValidStorage() {
        if (inOwnInventory) {
            return true;
        }
        String name2 = StringUtils.removeColor$default(StringUtils.INSTANCE, InventoryUtils.INSTANCE.openInventoryName(), false, 1, null);
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) {
            return false;
        }
        if (BazaarApi.INSTANCE.getInBazaarInventory()) {
            return false;
        }
        if (MinionFeatures.INSTANCE.getMinionInventoryOpen()) {
            return false;
        }
        if (MinionFeatures.INSTANCE.getMinionStorageInventoryOpen()) {
            return false;
        }
        if ((StringsKt.contains$default((CharSequence)name2, "Backpack", false, 2, null) && StringsKt.contains$default((CharSequence)name2, "Slot #", false, 2, null) || StringsKt.startsWith$default(name2, "Ender Chest (", false, 2, null)) && !InventoryUtils.INSTANCE.isNeuStorageEnabled()) {
            return true;
        }
        boolean inMinion = StringsKt.contains$default((CharSequence)name2, "Minion", false, 2, null) && !StringsKt.contains$default((CharSequence)name2, "Recipe", false, 2, null) && LorenzUtils.INSTANCE.isInIsland(IslandType.PRIVATE_ISLAND);
        return Intrinsics.areEqual(name2, "Chest") || Intrinsics.areEqual(name2, "Large Chest") || inMinion || Intrinsics.areEqual(name2, "Personal Vault");
    }

    private final String reduceStringLength(String $this$reduceStringLength, int targetLength, char c) {
        Minecraft mc = Minecraft.func_71410_x();
        int spaceWidth = mc.field_71466_p.func_78263_a(c);
        String currentString = $this$reduceStringLength;
        int currentLength = mc.field_71466_p.func_78256_a(currentString);
        while (currentLength > targetLength) {
            currentString = StringsKt.dropLast(currentString, 1);
            currentLength = mc.field_71466_p.func_78256_a(currentString);
        }
        int difference = targetLength - currentLength;
        if (difference > 0) {
            int numSpacesToAdd = difference / spaceWidth;
            String spaces = StringsKt.repeat(" ", numSpacesToAdd);
            return currentString + spaces;
        }
        return currentString;
    }

    private final boolean isEnabled() {
        return LorenzUtils.INSTANCE.getInSkyBlock() && this.getConfig().enabled;
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.transform(17, "inventory.chestValueConfig.formatType", ChestValue::onConfigFix$lambda$11);
        event.transform(15, "inventory.chestValueConfig.sortingType", ChestValue::onConfigFix$lambda$12);
    }

    private static final JsonElement onConfigFix$lambda$11(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntToEnum(element, ChestValueConfig.NumberFormatEntry.class);
    }

    private static final JsonElement onConfigFix$lambda$12(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntToEnum(element, ChestValueConfig.SortingTypeEntry.class);
    }

    public static final /* synthetic */ ChestValueConfig access$getConfig(ChestValue $this) {
        return $this.getConfig();
    }

    public static final /* synthetic */ void access$update(ChestValue $this) {
        $this.update();
    }

    static {
        compactInventory = true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lat/hannibal2/skyhanni/features/inventory/ChestValue$DisplayType;", "", "", "type", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getType", "()Ljava/lang/String;", "NORMAL", "COMPACT", "1.8.9"})
    public static final class DisplayType
    extends Enum<DisplayType> {
        @NotNull
        private final String type;
        public static final /* enum */ DisplayType NORMAL = new DisplayType("Normal");
        public static final /* enum */ DisplayType COMPACT = new DisplayType("Aligned");
        private static final /* synthetic */ DisplayType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DisplayType(String type2) {
            this.type = type2;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public static DisplayType[] values() {
            return (DisplayType[])$VALUES.clone();
        }

        public static DisplayType valueOf(String value) {
            return Enum.valueOf(DisplayType.class, value);
        }

        @NotNull
        public static EnumEntries<DisplayType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = displayTypeArray = new DisplayType[]{DisplayType.NORMAL, DisplayType.COMPACT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<ChestValueConfig.SortingTypeEntry> entries$0;
        public static final /* synthetic */ EnumEntries<ChestValueConfig.NumberFormatEntry> entries$1;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])ChestValueConfig.SortingTypeEntry.values());
            entries$1 = EnumEntriesKt.enumEntries((Enum[])ChestValueConfig.NumberFormatEntry.values());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lat/hannibal2/skyhanni/features/inventory/ChestValue$FormatType;", "", "", "type", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getType", "()Ljava/lang/String;", "SHORT", "LONG", "1.8.9"})
    public static final class FormatType
    extends Enum<FormatType> {
        @NotNull
        private final String type;
        public static final /* enum */ FormatType SHORT = new FormatType("Formatted");
        public static final /* enum */ FormatType LONG = new FormatType("Unformatted");
        private static final /* synthetic */ FormatType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private FormatType(String type2) {
            this.type = type2;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public static FormatType[] values() {
            return (FormatType[])$VALUES.clone();
        }

        public static FormatType valueOf(String value) {
            return Enum.valueOf(FormatType.class, value);
        }

        @NotNull
        public static EnumEntries<FormatType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = formatTypeArray = new FormatType[]{FormatType.SHORT, FormatType.LONG};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0013\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u000fJN\u0010\u0017\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0011J\u0010\u0010\u001e\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010 \u001a\u0004\b!\u0010\u000fR\"\u0010\u0005\u001a\u00020\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010\u0011\"\u0004\b$\u0010%R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010&\u001a\u0004\b'\u0010\u0013R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010(\u001a\u0004\b)\u0010\u0015\"\u0004\b*\u0010+R\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010 \u001a\u0004\b,\u0010\u000f\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/features/inventory/ChestValue$Item;", "", "", "", "index", "amount", "Lnet/minecraft/item/ItemStack;", "stack", "", "total", "", "tips", "<init>", "(Ljava/util/List;ILnet/minecraft/item/ItemStack;DLjava/util/List;)V", "component1", "()Ljava/util/List;", "component2", "()I", "component3", "()Lnet/minecraft/item/ItemStack;", "component4", "()D", "component5", "copy", "(Ljava/util/List;ILnet/minecraft/item/ItemStack;DLjava/util/List;)Lat/hannibal2/skyhanni/features/inventory/ChestValue$Item;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getIndex", "I", "getAmount", "setAmount", "(I)V", "Lnet/minecraft/item/ItemStack;", "getStack", "D", "getTotal", "setTotal", "(D)V", "getTips", "1.8.9"})
    public static final class Item {
        @NotNull
        private final List<Integer> index;
        private int amount;
        @NotNull
        private final ItemStack stack;
        private double total;
        @NotNull
        private final List<String> tips;

        public Item(@NotNull List<Integer> index, int amount, @NotNull ItemStack stack, double total, @NotNull List<String> tips) {
            Intrinsics.checkNotNullParameter(index, "index");
            Intrinsics.checkNotNullParameter(stack, "stack");
            Intrinsics.checkNotNullParameter(tips, "tips");
            this.index = index;
            this.amount = amount;
            this.stack = stack;
            this.total = total;
            this.tips = tips;
        }

        @NotNull
        public final List<Integer> getIndex() {
            return this.index;
        }

        public final int getAmount() {
            return this.amount;
        }

        public final void setAmount(int n) {
            this.amount = n;
        }

        @NotNull
        public final ItemStack getStack() {
            return this.stack;
        }

        public final double getTotal() {
            return this.total;
        }

        public final void setTotal(double d) {
            this.total = d;
        }

        @NotNull
        public final List<String> getTips() {
            return this.tips;
        }

        @NotNull
        public final List<Integer> component1() {
            return this.index;
        }

        public final int component2() {
            return this.amount;
        }

        @NotNull
        public final ItemStack component3() {
            return this.stack;
        }

        public final double component4() {
            return this.total;
        }

        @NotNull
        public final List<String> component5() {
            return this.tips;
        }

        @NotNull
        public final Item copy(@NotNull List<Integer> index, int amount, @NotNull ItemStack stack, double total, @NotNull List<String> tips) {
            Intrinsics.checkNotNullParameter(index, "index");
            Intrinsics.checkNotNullParameter(stack, "stack");
            Intrinsics.checkNotNullParameter(tips, "tips");
            return new Item(index, amount, stack, total, tips);
        }

        public static /* synthetic */ Item copy$default(Item item, List list, int n, ItemStack itemStack2, double d, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = item.index;
            }
            if ((n2 & 2) != 0) {
                n = item.amount;
            }
            if ((n2 & 4) != 0) {
                itemStack2 = item.stack;
            }
            if ((n2 & 8) != 0) {
                d = item.total;
            }
            if ((n2 & 0x10) != 0) {
                list2 = item.tips;
            }
            return item.copy(list, n, itemStack2, d, list2);
        }

        @NotNull
        public String toString() {
            return "Item(index=" + this.index + ", amount=" + this.amount + ", stack=" + this.stack + ", total=" + this.total + ", tips=" + this.tips + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.index).hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.amount);
            result2 = result2 * 31 + this.stack.hashCode();
            result2 = result2 * 31 + Double.hashCode(this.total);
            result2 = result2 * 31 + ((Object)this.tips).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Item)) {
                return false;
            }
            Item item = (Item)other;
            if (!Intrinsics.areEqual(this.index, item.index)) {
                return false;
            }
            if (this.amount != item.amount) {
                return false;
            }
            if (!Intrinsics.areEqual(this.stack, item.stack)) {
                return false;
            }
            if (Double.compare(this.total, item.total) != 0) {
                return false;
            }
            return Intrinsics.areEqual(this.tips, item.tips);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\n\u0010\tj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lat/hannibal2/skyhanni/features/inventory/ChestValue$SortType;", "", "", "shortName", "longName", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "Ljava/lang/String;", "getShortName", "()Ljava/lang/String;", "getLongName", "PRICE_DESC", "PRICE_ASC", "1.8.9"})
    public static final class SortType
    extends Enum<SortType> {
        @NotNull
        private final String shortName;
        @NotNull
        private final String longName;
        public static final /* enum */ SortType PRICE_DESC = new SortType("Price D", "Price Descending");
        public static final /* enum */ SortType PRICE_ASC = new SortType("Price A", "Price Ascending");
        private static final /* synthetic */ SortType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SortType(String shortName, String longName) {
            this.shortName = shortName;
            this.longName = longName;
        }

        @NotNull
        public final String getShortName() {
            return this.shortName;
        }

        @NotNull
        public final String getLongName() {
            return this.longName;
        }

        public static SortType[] values() {
            return (SortType[])$VALUES.clone();
        }

        public static SortType valueOf(String value) {
            return Enum.valueOf(SortType.class, value);
        }

        @NotNull
        public static EnumEntries<SortType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sortTypeArray = new SortType[]{SortType.PRICE_DESC, SortType.PRICE_ASC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ChestValueConfig.SortingTypeEntry.values().length];
            try {
                nArray[ChestValueConfig.SortingTypeEntry.DESCENDING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChestValueConfig.SortingTypeEntry.ASCENDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ChestValueConfig.NumberFormatEntry.values().length];
            try {
                nArray[ChestValueConfig.NumberFormatEntry.SHORT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChestValueConfig.NumberFormatEntry.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

