/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.pests;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.pests.PestSpawnConfig;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.garden.pests.PestSpawnEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.pests.PestAPI;
import at.hannibal2.skyhanni.features.garden.pests.PestSpawnTimer;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010!\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ-\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0019\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001b\u0010\"\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u001b\u0010%\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001f\u001a\u0004\b$\u0010!R\u001b\u0010(\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u001f\u001a\u0004\b'\u0010!R\u001b\u0010+\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u001f\u001a\u0004\b*\u0010!R\u001b\u0010.\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u001f\u001a\u0004\b-\u0010!R\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u00100\u00a8\u00061"}, d2={"Lat/hannibal2/skyhanni/features/garden/pests/PestSpawn;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "", "amount", "", "", "plotNames", "", "unknownAmount", "pestSpawn", "(ILjava/util/List;Z)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/pests/PestSpawnConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/pests/PestSpawnConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "onePestPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getOnePestPattern", "()Ljava/util/regex/Pattern;", "onePestPattern", "onePestBarnPattern$delegate", "getOnePestBarnPattern", "onePestBarnPattern", "multiplePestsSpawn$delegate", "getMultiplePestsSpawn", "multiplePestsSpawn", "multiplePestsBarnSpawn$delegate", "getMultiplePestsBarnSpawn", "multiplePestsBarnSpawn", "offlinePestsSpawn$delegate", "getOfflinePestsSpawn", "offlinePestsSpawn", "", "Ljava/util/List;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPestSpawn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PestSpawn.kt\nat/hannibal2/skyhanni/features/garden/pests/PestSpawn\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n8#2:152\n8#2:154\n8#2:156\n8#2:158\n8#2:160\n1#3:153\n1#3:155\n1#3:157\n1#3:159\n1#3:161\n*S KotlinDebug\n*F\n+ 1 PestSpawn.kt\nat/hannibal2/skyhanni/features/garden/pests/PestSpawn\n*L\n77#1:152\n83#1:154\n89#1:156\n96#1:158\n103#1:160\n77#1:153\n83#1:155\n89#1:157\n96#1:159\n103#1:161\n*E\n"})
public final class PestSpawn {
    @NotNull
    public static final PestSpawn INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern onePestPattern$delegate;
    @NotNull
    private static final RepoPattern onePestBarnPattern$delegate;
    @NotNull
    private static final RepoPattern multiplePestsSpawn$delegate;
    @NotNull
    private static final RepoPattern multiplePestsBarnSpawn$delegate;
    @NotNull
    private static final RepoPattern offlinePestsSpawn$delegate;
    @NotNull
    private static List<String> plotNames;

    private PestSpawn() {
    }

    private final PestSpawnConfig getConfig() {
        return PestAPI.INSTANCE.getConfig().pestSpawn;
    }

    private final Pattern getOnePestPattern() {
        return (Pattern)onePestPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getOnePestBarnPattern() {
        return (Pattern)onePestBarnPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getMultiplePestsSpawn() {
        return (Pattern)multiplePestsSpawn$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getMultiplePestsBarnSpawn() {
        return (Pattern)multiplePestsBarnSpawn$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    private final Pattern getOfflinePestsSpawn() {
        return (Pattern)offlinePestsSpawn$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[4]);
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        int amount;
        String plotName;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        String message = event.getMessage();
        boolean blocked = false;
        plotNames.clear();
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getOnePestPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(message);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            plotName = $this$onChat_u24lambda_u240.group("plot");
            Intrinsics.checkNotNull(plotName);
            plotNames.add(plotName);
            INSTANCE.pestSpawn(1, plotNames, false);
            blocked = true;
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getOnePestBarnPattern();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(message);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u241 = it$iv;
            boolean bl3 = false;
            plotName = $this$onChat_u24lambda_u241.group("plot");
            Intrinsics.checkNotNull(plotName);
            plotNames.add(plotName);
            INSTANCE.pestSpawn(1, plotNames, false);
            blocked = true;
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getMultiplePestsSpawn();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(message);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u242 = it$iv;
            boolean bl4 = false;
            plotName = $this$onChat_u24lambda_u242.group("plot");
            Intrinsics.checkNotNull(plotName);
            plotNames.add(plotName);
            String string2 = $this$onChat_u24lambda_u242.group("amount");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            amount = Integer.parseInt(string2);
            INSTANCE.pestSpawn(amount, plotNames, false);
            blocked = true;
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getMultiplePestsBarnSpawn();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(message);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u243 = it$iv;
            boolean bl5 = false;
            plotName = $this$onChat_u24lambda_u243.group("plot");
            Intrinsics.checkNotNull(plotName);
            plotNames.add(plotName);
            String string3 = $this$onChat_u24lambda_u243.group("amount");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            amount = Integer.parseInt(string3);
            INSTANCE.pestSpawn(amount, plotNames, false);
            blocked = true;
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getOfflinePestsSpawn();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(message);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u244 = it$iv;
            boolean bl6 = false;
            String plots = $this$onChat_u24lambda_u244.group("plots");
            Intrinsics.checkNotNull(plots);
            String[] stringArray = new String[]{", ", " and "};
            plotNames = CollectionsKt.toMutableList(StringsKt.split$default((CharSequence)StringUtils.removeColor$default(StringUtils.INSTANCE, plots, false, 1, null), stringArray, false, 0, 6, null));
            INSTANCE.pestSpawn(0, plotNames, true);
        }
        if (Intrinsics.areEqual(event.getMessage(), "  \u00a7r\u00a7e\u00a7lCLICK HERE \u00a7eto teleport to the plot!")) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(PestSpawnTimer.INSTANCE.getLastSpawnTime-uFjCsEo()), DurationKt.toDuration(1, DurationUnit.SECONDS)) < 0) {
                blocked = true;
            }
        }
        if (blocked && this.getConfig().chatMessageFormat != PestSpawnConfig.ChatMessageFormatEntry.HYPIXEL) {
            event.setBlockedReason("pests_spawn");
        }
    }

    private final void pestSpawn(int amount, List<String> plotNames, boolean unknownAmount) {
        new PestSpawnEvent(amount, plotNames, unknownAmount).post();
        if (unknownAmount) {
            return;
        }
        String string2 = CollectionsKt.firstOrNull(plotNames);
        if (string2 == null) {
            throw new IllegalStateException("first plot name is null".toString());
        }
        String plotName = string2;
        String pestName = StringUtils.pluralize$default(StringUtils.INSTANCE, amount, "Pest", null, false, 12, null);
        String message = "\u00a7e" + amount + " \u00a7a" + pestName + " Spawned in \u00a7b" + plotName + "\u00a7a!";
        if (this.getConfig().showTitle) {
            LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, message, DurationKt.toDuration(7, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
        }
        if (this.getConfig().chatMessageFormat == PestSpawnConfig.ChatMessageFormatEntry.COMPACT) {
            ChatUtils.clickableChat-gdl2klw$default(ChatUtils.INSTANCE, message, () -> PestSpawn.pestSpawn$lambda$5(plotName), "\u00a7eClick to run /plottp " + plotName + '!', 0L, false, null, false, 120, null);
        }
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        event.transform(15, "garden.pests.pestSpawn.chatMessageFormat", PestSpawn::onConfigFix$lambda$6);
    }

    private static final Unit pestSpawn$lambda$5(String $plotName) {
        Intrinsics.checkNotNullParameter($plotName, "$plotName");
        HypixelCommands.INSTANCE.teleportToPlot($plotName);
        return Unit.INSTANCE;
    }

    private static final JsonElement onConfigFix$lambda$6(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntToEnum(element, PestSpawnConfig.ChatMessageFormatEntry.class);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(PestSpawn.class, "onePestPattern", "getOnePestPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PestSpawn.class, "onePestBarnPattern", "getOnePestBarnPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PestSpawn.class, "multiplePestsSpawn", "getMultiplePestsSpawn()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PestSpawn.class, "multiplePestsBarnSpawn", "getMultiplePestsBarnSpawn()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(PestSpawn.class, "offlinePestsSpawn", "getOfflinePestsSpawn()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new PestSpawn();
        patternGroup = RepoPattern.Companion.group("garden.pests.spawn");
        onePestPattern$delegate = patternGroup.pattern("one", "\u00a76\u00a7l.*! \u00a77A \u00a76Pest \u00a77has appeared in \u00a7aPlot \u00a77- \u00a7b(?<plot>.*)\u00a77!");
        onePestBarnPattern$delegate = patternGroup.pattern("onebarn", "\u00a76\u00a7l.*! \u00a77A \u00a76Pest \u00a77has appeared in \u00a7a(?<plot>The Barn)\u00a77!");
        multiplePestsSpawn$delegate = patternGroup.pattern("multiple", "\u00a76\u00a7l.*! \u00a76(?<amount>\\d) Pests \u00a77have spawned in \u00a7aPlot \u00a77- \u00a7b(?<plot>.*)\u00a77!");
        multiplePestsBarnSpawn$delegate = patternGroup.pattern("multiplebarn", "\u00a76\u00a7l.*! \u00a76(?<amount>\\d) Pests \u00a77have spawned in \u00a7a(?<plot>The Barn)\u00a77!");
        offlinePestsSpawn$delegate = patternGroup.pattern("offline", "\u00a76\u00a7l.*! \u00a77While you were offline, \u00a76Pests \u00a77spawned in \u00a7aPlots (?<plots>.*)!");
        plotNames = new ArrayList();
    }
}

