/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.pests;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.garden.pests.PestProfitTrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ItemAddManager;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.events.ItemAddEvent;
import at.hannibal2.skyhanni.events.LorenzChatEvent;
import at.hannibal2.skyhanni.events.PurseChangeCause;
import at.hannibal2.skyhanni.events.PurseChangeEvent;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.pests.PestAPI;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NEUInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import at.hannibal2.skyhanni.utils.tracker.ItemTrackerData;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniItemTracker;
import com.google.gson.annotations.Expose;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\r\u0010$\u001a\u00020\u0006\u00a2\u0006\u0004\b$\u0010\u0003J\r\u0010%\u001a\u00020\u0010\u00a2\u0006\u0004\b%\u0010&R\u0019\u0010+\u001a\n (*\u0004\u0018\u00010'0'8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010-\u001a\u00020,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u001b\u00104\u001a\u00020/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0016\u00106\u001a\u0002058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\"\u00109\u001a\u0010\u0012\f\u0012\n (*\u0004\u0018\u00010\u00150\u0015088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:\u00a8\u0006<"}, d2={"Lat/hannibal2/skyhanni/features/garden/pests/PestProfitTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ItemAddEvent;", "event", "", "onItemAdd", "(Lat/hannibal2/skyhanni/events/ItemAddEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/LorenzChatEvent;)V", "Lat/hannibal2/skyhanni/utils/NEUInternalName;", "internalName", "", "amount", "", "command", "tryAddItem", "(Lat/hannibal2/skyhanni/utils/NEUInternalName;IZ)V", "addKill", "Lat/hannibal2/skyhanni/features/garden/pests/PestProfitTracker$Data;", "data", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/garden/pests/PestProfitTracker$Data;)Ljava/util/List;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "Lat/hannibal2/skyhanni/events/PurseChangeEvent;", "onPurseChange", "(Lat/hannibal2/skyhanni/events/PurseChangeEvent;)V", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "resetCommand", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/garden/pests/PestProfitTrackerConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/pests/PestProfitTrackerConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "pestRareDropPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getPestRareDropPattern", "()Ljava/util/regex/Pattern;", "pestRareDropPattern", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastPestKillTime", "J", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "tracker", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "Data", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPestProfitTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PestProfitTracker.kt\nat/hannibal2/skyhanni/features/garden/pests/PestProfitTracker\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n8#2:171\n8#2:173\n1#3:172\n1#3:174\n*S KotlinDebug\n*F\n+ 1 PestProfitTracker.kt\nat/hannibal2/skyhanni/features/garden/pests/PestProfitTracker\n*L\n95#1:171\n103#1:173\n95#1:172\n103#1:174\n*E\n"})
public final class PestProfitTracker {
    @NotNull
    public static final PestProfitTracker INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern pestRareDropPattern$delegate;
    private static long lastPestKillTime;
    @NotNull
    private static final SkyHanniItemTracker<Data> tracker;

    private PestProfitTracker() {
    }

    public final PestProfitTrackerConfig getConfig() {
        return SkyHanniMod.feature.garden.pests.pestProfitTacker;
    }

    private final Pattern getPestRareDropPattern() {
        return (Pattern)pestRareDropPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    @SubscribeEvent
    public final void onItemAdd(@NotNull ItemAddEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        NEUInternalName internalName = event.getInternalName();
        if (event.getSource() == ItemAddManager.Source.COMMAND) {
            this.tryAddItem(internalName, event.getAmount(), true);
        }
    }

    @SubscribeEvent
    public final void onChat(@NotNull LorenzChatEvent event) {
        Pattern $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = PestAPI.INSTANCE.getPestDeathChatPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u243 = it$iv;
            boolean bl2 = false;
            String string2 = $this$onChat_u24lambda_u243.group("amount");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            int amount = Integer.parseInt(string2);
            String string3 = $this$onChat_u24lambda_u243.group("item");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            NEUInternalName nEUInternalName = NEUInternalName.Companion.fromItemNameOrNull(string3);
            if (nEUInternalName == null) {
                return;
            }
            NEUInternalName internalName = nEUInternalName;
            INSTANCE.tryAddItem(internalName, amount, false);
            INSTANCE.addKill();
            if (PestProfitTracker.INSTANCE.getConfig().hideChat) {
                event.setBlockedReason("pest_drop");
            }
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getPestRareDropPattern();
        text$iv = event.getMessage();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u244 = it$iv;
            boolean bl3 = false;
            String string4 = $this$onChat_u24lambda_u244.group("item");
            Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
            NEUInternalName nEUInternalName = NEUInternalName.Companion.fromItemNameOrNull(string4);
            if (nEUInternalName == null) {
                return;
            }
            NEUInternalName internalName = nEUInternalName;
            INSTANCE.tryAddItem(internalName, 1, false);
        }
    }

    private final void tryAddItem(NEUInternalName internalName, int amount, boolean command2) {
        tracker.addItem(internalName, amount, command2);
    }

    private final void addKill() {
        tracker.modify(PestProfitTracker::addKill$lambda$5);
        lastPestKillTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    private final List<Searchable> drawDisplay(Data data2) {
        List<Searchable> list;
        List<Searchable> $this$drawDisplay_u24lambda_u247 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        CollectionUtils.addSearchString$default(CollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u247, "\u00a7e\u00a7lPest Profit Tracker", null, null, null, 14, null);
        double profit = tracker.drawItems((Data)((ItemTrackerData)data2), PestProfitTracker::drawDisplay$lambda$7$lambda$6, $this$drawDisplay_u24lambda_u247);
        long pestsKilled = data2.getTotalPestsKills();
        $this$drawDisplay_u24lambda_u247.add(SearchableKt.toSearchable$default(Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a77Pests killed: \u00a7e" + NumberUtil.INSTANCE.addSeparators(pestsKilled), CollectionsKt.listOf("\u00a77You killed pests \u00a7e" + NumberUtil.INSTANCE.addSeparators(pestsKilled) + " \u00a77times."), null, null, null, false, false, false, null, null, 1020, null), null, 1, null));
        $this$drawDisplay_u24lambda_u247.add(tracker.addTotalProfit(profit, data2.getTotalPestsKills(), "kill"));
        tracker.addPriceFromButton($this$drawDisplay_u24lambda_u247);
        return CollectionsKt.build(list);
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (GardenAPI.INSTANCE.isCurrentlyFarming()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastPestKillTime), DurationKt.toDuration(this.getConfig().timeDisplayed, DurationUnit.SECONDS)) > 0 && !PestAPI.INSTANCE.hasVacuumInHand()) {
            return;
        }
        Position position = this.getConfig().position;
        Intrinsics.checkNotNullExpressionValue(position, "position");
        tracker.renderDisplay(position);
    }

    @SubscribeEvent
    public final void onPurseChange(@NotNull PurseChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        double coins = event.getCoins();
        if (coins > 1000.0) {
            return;
        }
        if (event.getReason() == PurseChangeCause.GAIN_MOB_KILL) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastPestKillTime), DurationKt.toDuration(2, DurationUnit.SECONDS)) < 0) {
                this.tryAddItem(NEUInternalName.Companion.getSKYBLOCK_COIN(), (int)coins, false);
            }
        }
    }

    @SubscribeEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (event.getNewIsland() == IslandType.GARDEN) {
            tracker.firstUpdate();
        }
    }

    public final void resetCommand() {
        tracker.resetCommand();
    }

    public final boolean isEnabled() {
        return GardenAPI.INSTANCE.inGarden() && this.getConfig().enabled;
    }

    private static final Data tracker$lambda$0() {
        return new Data();
    }

    private static final Data tracker$lambda$1(ProfileSpecificStorage it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.garden.pestProfitTracker;
    }

    private static final List tracker$lambda$2(Data it) {
        Intrinsics.checkNotNull(it);
        return INSTANCE.drawDisplay(it);
    }

    private static final Unit addKill$lambda$5(Data it) {
        long l = it.getTotalPestsKills();
        it.setTotalPestsKills(l + 1L);
        return Unit.INSTANCE;
    }

    private static final boolean drawDisplay$lambda$7$lambda$6(NEUInternalName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(PestProfitTracker.class, "pestRareDropPattern", "getPestRareDropPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new PestProfitTracker();
        patternGroup = RepoPattern.Companion.group("garden.pests.tracker");
        pestRareDropPattern$delegate = patternGroup.pattern("raredrop", "\u00a76\u00a7l(?:RARE|PET) DROP! (?:\u00a7r)?(?<item>.+) \u00a76\\(\u00a76\\+.*\u2618\\)");
        lastPestKillTime = SimpleTimeMark.Companion.farPast();
        tracker = new SkyHanniItemTracker<Data>("Pest Profit Tracker", PestProfitTracker::tracker$lambda$0, PestProfitTracker::tracker$lambda$1, new Pair[0], PestProfitTracker::tracker$lambda$2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lat/hannibal2/skyhanni/features/garden/pests/PestProfitTracker$Data;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData;", "<init>", "()V", "", "resetItems", "", "timesGained", "", "", "getDescription", "(J)Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;", "item", "getCoinName", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/lang/String;", "getCoinDescription", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/util/List;", "totalPestsKills", "J", "getTotalPestsKills", "()J", "setTotalPestsKills", "(J)V", "1.8.9"})
    public static final class Data
    extends ItemTrackerData {
        @Expose
        private long totalPestsKills;

        @Override
        public void resetItems() {
            this.totalPestsKills = 0L;
        }

        @Override
        @NotNull
        public List<String> getDescription(long timesGained) {
            double percentage = (double)timesGained / (double)this.totalPestsKills;
            String dropRate = LorenzUtils.INSTANCE.formatPercentage(RangesKt.coerceAtMost(percentage, 1.0));
            String[] stringArray = new String[]{"\u00a77Dropped \u00a7e" + NumberUtil.INSTANCE.addSeparators(timesGained) + " \u00a77times.", "\u00a77Your drop rate: \u00a7c" + dropRate + '.'};
            return CollectionsKt.listOf(stringArray);
        }

        @Override
        @NotNull
        public String getCoinName(@NotNull ItemTrackerData.TrackedItem item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return "\u00a76Pest Kill Coins";
        }

        @Override
        @NotNull
        public List<String> getCoinDescription(@NotNull ItemTrackerData.TrackedItem item) {
            Intrinsics.checkNotNullParameter(item, "item");
            String pestsCoinsFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, item.getTotalAmount(), false, 1, null);
            String[] stringArray = new String[]{"\u00a77Killing pests gives you coins.", "\u00a77You got \u00a76" + pestsCoinsFormat + " coins \u00a77that way."};
            return CollectionsKt.listOf(stringArray);
        }

        public final long getTotalPestsKills() {
            return this.totalPestsKills;
        }

        public final void setTotalPestsKills(long l) {
            this.totalPestsKills = l;
        }
    }
}

