/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.config.features.garden.CropStartLocationConfig;
import at.hannibal2.skyhanni.config.features.garden.GardenConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.events.CropClickEvent;
import at.hannibal2.skyhanni.events.LorenzRenderWorldEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\r\u0010\u0012\u001a\u00020\r\u00a2\u0006\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0017\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/GardenStartLocation;", "", "<init>", "()V", "", "setLocationCommand", "Lat/hannibal2/skyhanni/events/CropClickEvent;", "event", "onCropClick", "(Lat/hannibal2/skyhanni/events/CropClickEvent;)V", "Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/LorenzRenderWorldEvent;)V", "", "shouldShowBoth", "()Z", "showStartWaypoint", "showLastFarmedWaypoint", "isEnabled", "Lat/hannibal2/skyhanni/config/features/garden/CropStartLocationConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/CropStartLocationConfig;", "config", "shouldShowLastFarmedWaypoint", "Z", "1.8.9"})
public final class GardenStartLocation {
    @NotNull
    public static final GardenStartLocation INSTANCE = new GardenStartLocation();
    private static boolean shouldShowLastFarmedWaypoint;

    private GardenStartLocation() {
    }

    private final CropStartLocationConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().cropStartLocation;
    }

    public final void setLocationCommand() {
        Map<CropType, LorenzVec> startLocations;
        if (!GardenAPI.INSTANCE.inGarden()) {
            ChatUtils.INSTANCE.userError("This Command only works in the garden!");
            return;
        }
        if (!this.getConfig().enabled) {
            ChatUtils.INSTANCE.chatAndOpenConfig("This feature is disabled. Enable it in the config: \u00a7e/sh crop start location", new MutablePropertyReference0Impl(GardenAPI.INSTANCE.getConfig()){

                public Object get() {
                    return ((GardenConfig)this.receiver).cropStartLocation;
                }

                public void set(Object value) {
                    ((GardenConfig)this.receiver).cropStartLocation = (CropStartLocationConfig)value;
                }
            });
            return;
        }
        ProfileSpecificStorage.GardenStorage gardenStorage = GardenAPI.INSTANCE.getStorage();
        Map<CropType, LorenzVec> map2 = startLocations = gardenStorage != null ? gardenStorage.cropStartLocations : null;
        if (startLocations == null) {
            ChatUtils.INSTANCE.userError("The config is not yet loaded, retry in a second.");
            return;
        }
        CropType crop = GardenAPI.INSTANCE.getCurrentlyFarmedCrop();
        if (crop == null) {
            ChatUtils.INSTANCE.userError("Hold a crop specific farming tool in the hand!");
            return;
        }
        startLocations.put(crop, LocationUtils.INSTANCE.playerLocation());
        ChatUtils.chat$default(ChatUtils.INSTANCE, "You changed your Crop Start Location for " + crop.getCropName() + '!', false, null, 6, null);
    }

    @SubscribeEvent
    public final void onCropClick(@NotNull CropClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getClickType() != ClickType.LEFT_CLICK || !GardenAPI.INSTANCE.hasFarmingToolInHand()) {
            return;
        }
        Object object = GardenAPI.INSTANCE.getStorage();
        if (object == null || (object = ((ProfileSpecificStorage.GardenStorage)object).cropStartLocations) == null) {
            return;
        }
        Object startLocations = object;
        Object object2 = GardenAPI.INSTANCE.getStorage();
        if (object2 == null || (object2 = ((ProfileSpecificStorage.GardenStorage)object2).cropLastFarmedLocations) == null) {
            return;
        }
        Object lastFarmedLocations = object2;
        CropType cropType = GardenAPI.INSTANCE.getCurrentlyFarmedCrop();
        if (cropType == null) {
            return;
        }
        CropType crop = cropType;
        if (crop != GardenCropSpeed.INSTANCE.getLastBrokenCrop()) {
            return;
        }
        if (!startLocations.containsKey((Object)crop)) {
            startLocations.put(crop, LocationUtils.INSTANCE.playerLocation());
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Auto updated your Crop Start Location for " + crop.getCropName(), false, null, 6, null);
        }
        lastFarmedLocations.put(crop, LorenzVec.Companion.getBlockBelowPlayer().add(0.0, 1.0, 0.0));
        shouldShowLastFarmedWaypoint = false;
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull LorenzRenderWorldEvent event) {
        LorenzVec lorenzVec;
        LorenzVec lorenzVec2;
        Map<CropType, LorenzVec> map2;
        ProfileSpecificStorage.GardenStorage gardenStorage;
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        CropType cropType = GardenAPI.INSTANCE.getCropInHand();
        if (cropType == null) {
            return;
        }
        CropType crop = cropType;
        if (this.showStartWaypoint() && (gardenStorage = GardenAPI.INSTANCE.getStorage()) != null && (map2 = gardenStorage.cropStartLocations) != null && (lorenzVec2 = map2.get((Object)crop)) != null && (lorenzVec = lorenzVec2.roundLocationToBlock()) != null) {
            LorenzVec lorenzVec3;
            LorenzVec it = lorenzVec3 = lorenzVec;
            boolean bl = false;
            RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, it, LorenzColor.WHITE.toColor(), false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
            RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, it, "\u00a7b" + crop.getCropName(), 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            if (INSTANCE.shouldShowBoth()) {
                RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, it, "\u00a7aStart Location", 1.1, 12.0f, 0.0, 0.0, false, false, null, 496, null);
            }
        }
        if (this.showLastFarmedWaypoint()) {
            LorenzVec location;
            Object object = GardenAPI.INSTANCE.getStorage();
            LorenzVec lorenzVec4 = object != null && (object = ((ProfileSpecificStorage.GardenStorage)object).cropLastFarmedLocations) != null ? (LorenzVec)object.get((Object)crop) : (location = null);
            if (location != null) {
                if (LocationUtils.INSTANCE.distanceSqToPlayer(location) >= 100.0) {
                    shouldShowLastFarmedWaypoint = true;
                }
                if (shouldShowLastFarmedWaypoint) {
                    RenderUtils.drawWaypointFilled$default(RenderUtils.INSTANCE, event, location, LorenzColor.LIGHT_PURPLE.toColor(), true, true, 0.0, 0.0, 0.0, 0.0f, false, 496, null);
                    RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, location, "\u00a7b" + crop.getCropName(), 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
                    if (this.shouldShowBoth()) {
                        RenderUtils.drawDynamicText$default(RenderUtils.INSTANCE, event, location, "\u00a7eLast Farmed", 1.1, 12.0f, 0.0, 0.0, false, false, null, 496, null);
                    }
                }
            }
        }
    }

    private final boolean shouldShowBoth() {
        return this.getConfig().mode == CropStartLocationConfig.CropLocationMode.BOTH;
    }

    private final boolean showStartWaypoint() {
        return this.getConfig().mode != CropStartLocationConfig.CropLocationMode.LAST_FARMED;
    }

    private final boolean showLastFarmedWaypoint() {
        return this.getConfig().mode != CropStartLocationConfig.CropLocationMode.START;
    }

    public final boolean isEnabled() {
        return GardenAPI.INSTANCE.inGarden() && this.getConfig().enabled;
    }
}

