/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.CropMilestonesConfig;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.CropMilestonesOverflowConfig;
import at.hannibal2.skyhanni.config.features.garden.cropmilestones.MushroomPetPerkConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.GardenCropMilestones;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.CropMilestoneUpdateEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.OwnInventoryItemUpdateEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.FarmingFortuneDisplay;
import at.hannibal2.skyhanni.features.garden.GardenAPI;
import at.hannibal2.skyhanni.features.garden.farming.FarmingWeightDisplay;
import at.hannibal2.skyhanni.features.garden.farming.GardenBestCropTime;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.CollectionUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.LorenzUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.TimeUnit;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010 \u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J)\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00190\"H\u0002\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b'\u0010\u0003J\u000f\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020+H\u0007\u00a2\u0006\u0004\b,\u0010-R\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u001c\u00100\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010/R \u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001c0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u001c\u00107\u001a\n 4*\u0004\u0018\u000103038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u001c\u0010;\u001a\n 4*\u0004\u0018\u000108088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:RV\u0010@\u001aD\u0012\f\u0012\n 4*\u0004\u0018\u00010\u00160\u0016\u0012\f\u0012\n 4*\u0004\u0018\u00010<0<\u0018\u0001 4* \u0012\f\u0012\n 4*\u0004\u0018\u00010\u00160\u0016\u0012\f\u0012\n 4*\u0004\u0018\u00010<0<\u0018\u00010=0\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0016\u0010B\u001a\u00020A8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010D\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0016\u0010F\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0016\u0010H\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010GR\u0016\u0010I\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010GR\u0016\u0010J\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010G\u00a8\u0006K"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/GardenCropMilestoneDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "event", "", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/CropMilestoneUpdateEvent;", "onCropMilestoneUpdate", "(Lat/hannibal2/skyhanni/events/CropMilestoneUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/OwnInventoryItemUpdateEvent;", "onOwnInventoryItemUpdate", "(Lat/hannibal2/skyhanni/events/OwnInventoryItemUpdateEvent;)V", "update", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "drawProgressDisplay", "(Lat/hannibal2/skyhanni/features/garden/CropType;)Ljava/util/List;", "", "millis", "", "title", "tryWarn", "(JLjava/lang/String;)V", "", "Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesConfig$MilestoneTextEntry;", "lineMap", "formatDisplay", "(Ljava/util/Map;)Ljava/util/List;", "addMushroomCowData", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "progressDisplay", "Ljava/util/List;", "mushroomCowPerkDisplay", "cultivatingData", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesConfig;", "kotlin.jvm.PlatformType", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesConfig;", "config", "Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesOverflowConfig;", "getOverflowConfig", "()Lat/hannibal2/skyhanni/config/features/garden/cropmilestones/CropMilestonesOverflowConfig;", "overflowConfig", "", "", "getStorage", "()Ljava/util/Map;", "storage", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastPlaySoundTime", "J", "needsInventory", "Z", "lastWarnedLevel", "I", "previousNext", "lastMushWarnedLevel", "previousMushNext", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGardenCropMilestoneDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenCropMilestoneDisplay.kt\nat/hannibal2/skyhanni/features/garden/farming/GardenCropMilestoneDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,375:1\n1611#2,9:376\n1863#2:385\n1864#2:387\n1620#2:388\n1611#2,9:389\n1863#2:398\n1864#2:400\n1620#2:401\n1#3:386\n1#3:399\n*S KotlinDebug\n*F\n+ 1 GardenCropMilestoneDisplay.kt\nat/hannibal2/skyhanni/features/garden/farming/GardenCropMilestoneDisplay\n*L\n267#1:376,9\n267#1:385\n267#1:387\n267#1:388\n332#1:389,9\n332#1:398\n332#1:400\n332#1:401\n267#1:386\n332#1:399\n*E\n"})
public final class GardenCropMilestoneDisplay {
    @NotNull
    public static final GardenCropMilestoneDisplay INSTANCE = new GardenCropMilestoneDisplay();
    @NotNull
    private static List<? extends Renderable> progressDisplay = CollectionsKt.emptyList();
    @NotNull
    private static List<? extends Renderable> mushroomCowPerkDisplay = CollectionsKt.emptyList();
    @NotNull
    private static final Map<CropType, Long> cultivatingData = new LinkedHashMap();
    private static long lastPlaySoundTime = SimpleTimeMark.Companion.farPast();
    private static boolean needsInventory;
    private static int lastWarnedLevel;
    private static int previousNext;
    private static int lastMushWarnedLevel;
    private static int previousMushNext;

    private GardenCropMilestoneDisplay() {
    }

    private final CropMilestonesConfig getConfig() {
        return GardenAPI.INSTANCE.getConfig().cropMilestones;
    }

    private final CropMilestonesOverflowConfig getOverflowConfig() {
        return this.getConfig().overflow;
    }

    private final Map<CropType, Integer> getStorage() {
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        return object != null && (object = ((ProfileSpecificStorage)object).garden) != null ? ((ProfileSpecificStorage.GardenStorage)object).customGoalMilestone : null;
    }

    @SubscribeEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Property[] propertyArray = new Property[]{this.getConfig().bestShowMaxedNeeded, this.getConfig().highestTimeFormat};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, GardenCropMilestoneDisplay::onConfigLoad$lambda$0);
    }

    @SubscribeEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (GardenAPI.INSTANCE.hideExtraGuis()) {
            return;
        }
        Position position = this.getConfig().progressDisplayPos;
        Intrinsics.checkNotNullExpressionValue(position, "progressDisplayPos");
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position, progressDisplay, 0, "Crop Milestone Progress", false, 10, null);
        if (this.getConfig().mushroomPetPerk.enabled) {
            Position position2 = this.getConfig().mushroomPetPerk.pos;
            Intrinsics.checkNotNullExpressionValue(position2, "pos");
            RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, position2, mushroomCowPerkDisplay, 0, "Mushroom Cow Perk", false, 10, null);
        }
        if (this.getConfig().next.bestDisplay) {
            Position position3 = this.getConfig().next.displayPos;
            Intrinsics.checkNotNullExpressionValue(position3, "displayPos");
            RenderUtils.renderStringsAndItems$default(RenderUtils.INSTANCE, position3, GardenBestCropTime.INSTANCE.getDisplay(), 0, 0.0, "Best Crop Time", 6, null);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, "event");
            Map<CropType, Long> map2 = GardenCropMilestones.INSTANCE.getCropCounter();
            if (map2 == null) break block1;
            Map<CropType, Long> it = map2;
            boolean bl = false;
            if (CollectionsKt.sumOfLong((Iterable<Long>)it.values()) == 0L) {
                needsInventory = true;
            }
        }
    }

    @SubscribeEvent
    public final void onCropMilestoneUpdate(@NotNull CropMilestoneUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        needsInventory = false;
        GardenBestCropTime.INSTANCE.updateTimeTillNextCrop();
        this.update();
    }

    @SubscribeEvent
    public final void onOwnInventoryItemUpdate(@NotNull OwnInventoryItemUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        if (!GardenAPI.INSTANCE.inGarden()) {
            return;
        }
        try {
            ItemStack item = event.getItemStack();
            long counter = GardenAPI.INSTANCE.readCounter(item);
            if (counter == -1L) {
                return;
            }
            CropType cropType = GardenAPI.INSTANCE.getCropType(item);
            if (cropType == null) {
                return;
            }
            CropType crop = cropType;
            if (cultivatingData.containsKey((Object)crop)) {
                Long l = cultivatingData.get((Object)crop);
                Intrinsics.checkNotNull(l);
                long old = ((Number)l).longValue();
                int addedCounter = (int)(counter - old);
                FarmingWeightDisplay.INSTANCE.addCrop(crop, addedCounter);
                this.update();
                GardenCropMilestones.INSTANCE.setCounter(crop, GardenCropMilestones.INSTANCE.getCounter(crop) + (long)addedCounter);
            }
            Long l = counter;
            cultivatingData.put(crop, l);
        }
        catch (Throwable e) {
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Updating crop counter by reading farming tool nbt data.", new Pair[0], false, false, false, 56, null);
        }
    }

    public final void update() {
        CropType currentCrop;
        progressDisplay = CollectionsKt.emptyList();
        mushroomCowPerkDisplay = CollectionsKt.emptyList();
        GardenBestCropTime.INSTANCE.setDisplay(CollectionsKt.emptyList());
        CropType cropType = currentCrop = GardenAPI.INSTANCE.getCurrentlyFarmedCrop();
        if (cropType != null) {
            CropType it = cropType;
            boolean bl = false;
            progressDisplay = INSTANCE.drawProgressDisplay(it);
        }
        if (this.getConfig().next.bestDisplay && this.getConfig().next.bestAlwaysOn || currentCrop != null) {
            GardenBestCropTime.INSTANCE.setDisplay(GardenBestCropTime.INSTANCE.drawBestDisplay(currentCrop));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Renderable> drawProgressDisplay(CropType crop) {
        Renderable renderable2;
        Object haveFormat;
        Pair<Long, Long> pair;
        void $this$drawProgressDisplay_u24lambda_u243;
        Object object;
        long counter = GardenCropMilestones.INSTANCE.getCounter(crop);
        Map lineMap = new LinkedHashMap();
        lineMap.put(CropMilestonesConfig.MilestoneTextEntry.TITLE, Renderable.Companion.string$default(Renderable.Companion, "\u00a76Crop Milestones", 0.0, null, null, null, 30, null));
        Map<CropType, Integer> map2 = this.getStorage();
        int customTargetLevel = map2 != null && (map2 = map2.get((Object)crop)) != null ? (Integer)((Object)map2) : 0;
        boolean overflowDisplay = this.getOverflowConfig().cropMilestoneDisplay;
        boolean allowOverflow = overflowDisplay || customTargetLevel != 0;
        int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(counter, crop, allowOverflow);
        int nextTier = 0;
        int nextRealTier = nextTier = (Boolean)this.getConfig().bestShowMaxedNeeded.get() != false && currentTier <= 46 ? 46 : currentTier + 1;
        boolean useCustomGoal = customTargetLevel != 0 && customTargetLevel > currentTier;
        nextTier = useCustomGoal ? customTargetLevel : nextTier;
        Map map3 = lineMap;
        CropMilestonesConfig.MilestoneTextEntry milestoneTextEntry = CropMilestonesConfig.MilestoneTextEntry.MILESTONE_TIER;
        Object object2 = object = CollectionsKt.createListBuilder();
        Renderable.Companion companion = Renderable.Companion;
        boolean bl = false;
        GardenAPI.addCropIconRenderable$default(GardenAPI.INSTANCE, (List)$this$drawProgressDisplay_u24lambda_u243, crop, 0.0, false, 6, null);
        if (GardenCropMilestones.INSTANCE.isMaxed(crop, overflowDisplay) && !overflowDisplay) {
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$drawProgressDisplay_u24lambda_u243, "\u00a77" + crop.getCropName() + " \u00a7eMAXED", null, null, 6, null);
        } else {
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$drawProgressDisplay_u24lambda_u243, "\u00a77" + crop.getCropName() + " \u00a78" + currentTier + "\u279c\u00a73" + nextTier, null, null, 6, null);
        }
        object = Renderable.Companion.horizontalContainer$default(companion, CollectionsKt.build(object), 0, null, null, 14, null);
        map3.put(milestoneTextEntry, object);
        boolean allowOverflowOrCustom = overflowDisplay || useCustomGoal;
        long cropsForNextTier = GardenCropMilestones.INSTANCE.getCropsForTier(nextTier, crop, allowOverflowOrCustom);
        if (((Boolean)this.getConfig().bestShowMaxedNeeded.get()).booleanValue() && !overflowDisplay) {
            pair = new Pair<Long, Long>(counter, cropsForNextTier);
        } else {
            long cropsForCurrentTier = GardenCropMilestones.INSTANCE.getCropsForTier(currentTier, crop, allowOverflowOrCustom);
            long have = useCustomGoal ? counter : counter - cropsForCurrentTier;
            long need2 = useCustomGoal ? cropsForNextTier : cropsForNextTier - cropsForCurrentTier;
            pair = new Pair<Long, Long>(have, need2);
        }
        object2 = pair;
        long have = ((Number)((Pair)object2).component1()).longValue();
        long need = ((Number)((Pair)object2).component2()).longValue();
        Map need2 = lineMap;
        CropMilestonesConfig.MilestoneTextEntry milestoneTextEntry2 = CropMilestonesConfig.MilestoneTextEntry.NUMBER_OUT_OF_TOTAL;
        if (GardenCropMilestones.INSTANCE.isMaxed(crop, overflowDisplay) && !overflowDisplay) {
            haveFormat = NumberUtil.INSTANCE.addSeparators(counter);
            renderable2 = Renderable.Companion.string$default(Renderable.Companion, "\u00a77Counter: \u00a7e" + (String)haveFormat, 0.0, null, null, null, 30, null);
        } else {
            haveFormat = NumberUtil.INSTANCE.addSeparators(have);
            String needFormat = NumberUtil.INSTANCE.addSeparators(need);
            renderable2 = Renderable.Companion.string$default(Renderable.Companion, "\u00a7e" + (String)haveFormat + "\u00a78/\u00a7e" + needFormat, 0.0, null, null, null, 30, null);
        }
        haveFormat = renderable2;
        need2.put(milestoneTextEntry2, haveFormat);
        double farmingFortune = FarmingFortuneDisplay.INSTANCE.getCurrentFarmingFortune();
        double speed = GardenCropSpeed.INSTANCE.getAverageBlocksPerSecond();
        int farmingFortuneSpeed = (int)NumberUtil.INSTANCE.roundTo((100.0 + farmingFortune) * crop.getBaseDrops() * speed / (double)100, 1);
        if (farmingFortuneSpeed > 0) {
            GardenCropSpeed.INSTANCE.setSpeed(crop, farmingFortuneSpeed);
            if (!GardenCropMilestones.INSTANCE.isMaxed(crop, overflowDisplay) || overflowDisplay) {
                long missing = need - have;
                long missingTime = DurationKt.toDuration(missing / (long)farmingFortuneSpeed, DurationUnit.SECONDS);
                long millis = Duration.getInWholeMilliseconds-impl(missingTime);
                Long l = millis;
                GardenBestCropTime.INSTANCE.getTimeTillNextCrop().put(crop, l);
                TimeUnit biggestUnit = (TimeUnit)((Object)TimeUnit.getEntries().get(((CropMilestonesConfig.TimeFormatEntry)this.getConfig().highestTimeFormat.get()).ordinal()));
                String duration = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, missingTime, biggestUnit, false, false, 0, false, 30, null);
                this.tryWarn(millis, "\u00a7b" + crop.getCropName() + ' ' + nextTier + " in " + duration);
                String speedText = "\u00a77In \u00a7b" + duration;
                lineMap.put(CropMilestonesConfig.MilestoneTextEntry.TIME, Renderable.Companion.string$default(Renderable.Companion, speedText, 0.0, null, null, null, 30, null));
                ItemStack itemStack2 = GardenAPI.INSTANCE.getItemInHand();
                if (itemStack2 != null) {
                    ItemStack it = itemStack2;
                    boolean bl2 = false;
                    if (GardenAPI.INSTANCE.readCounter(it) == -1L) {
                        lineMap.put(CropMilestonesConfig.MilestoneTextEntry.TIME, Renderable.Companion.string$default(Renderable.Companion, speedText + " \u00a77Inaccurate!", 0.0, null, null, null, 30, null));
                    }
                }
            }
            String secondFormat = NumberUtil.INSTANCE.addSeparators(farmingFortuneSpeed);
            lineMap.put(CropMilestonesConfig.MilestoneTextEntry.CROPS_PER_SECOND, Renderable.Companion.string$default(Renderable.Companion, "\u00a77Crops/Second\u00a78: \u00a7e" + secondFormat, 0.0, null, null, null, 30, null));
            String minuteFormat = NumberUtil.INSTANCE.addSeparators(farmingFortuneSpeed * 60);
            lineMap.put(CropMilestonesConfig.MilestoneTextEntry.CROPS_PER_MINUTE, Renderable.Companion.string$default(Renderable.Companion, "\u00a77Crops/Minute\u00a78: \u00a7e" + minuteFormat, 0.0, null, null, null, 30, null));
            String hourFormat = NumberUtil.INSTANCE.addSeparators(farmingFortuneSpeed * 60 * 60);
            lineMap.put(CropMilestonesConfig.MilestoneTextEntry.CROPS_PER_HOUR, Renderable.Companion.string$default(Renderable.Companion, "\u00a77Crops/Hour\u00a78: \u00a7e" + hourFormat, 0.0, null, null, null, 30, null));
            String formatBps = NumberUtil.INSTANCE.addSeparators(NumberUtil.INSTANCE.roundTo(speed, this.getConfig().blocksBrokenPrecision));
            lineMap.put(CropMilestonesConfig.MilestoneTextEntry.BLOCKS_PER_SECOND, Renderable.Companion.string$default(Renderable.Companion, "\u00a77Blocks/Second\u00a78: \u00a7e" + formatBps, 0.0, null, null, null, 30, null));
        }
        String percentageFormat = LorenzUtils.INSTANCE.formatPercentage((double)have / (double)need);
        lineMap.put(CropMilestonesConfig.MilestoneTextEntry.PERCENTAGE, GardenCropMilestones.INSTANCE.isMaxed(crop, overflowDisplay) && !overflowDisplay ? Renderable.Companion.string$default(Renderable.Companion, "\u00a77Percentage: \u00a7e100%", 0.0, null, null, null, 30, null) : Renderable.Companion.string$default(Renderable.Companion, "\u00a77Percentage: \u00a7e" + percentageFormat, 0.0, null, null, null, 30, null));
        if (this.getOverflowConfig().chat && currentTier > 46 && currentTier == previousNext && nextRealTier == currentTier + 1 && lastWarnedLevel != currentTier) {
            GardenCropMilestones.INSTANCE.onOverflowLevelUp(crop, currentTier - 1, nextRealTier - 1);
            lastWarnedLevel = currentTier;
        }
        if (GardenAPI.INSTANCE.getMushroomCowPet() && crop != CropType.MUSHROOM) {
            this.addMushroomCowData();
        }
        previousNext = nextRealTier;
        return this.formatDisplay(lineMap);
    }

    private final void tryWarn(long millis, String title) {
        if (!this.getConfig().warnClose) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(GardenCropSpeed.INSTANCE.getLastBrokenTime-uFjCsEo()), DurationKt.toDuration(500, DurationUnit.MILLISECONDS)) > 0) {
            return;
        }
        if (millis > 5900L) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastPlaySoundTime), DurationKt.toDuration(1, DurationUnit.SECONDS)) > 0) {
            lastPlaySoundTime = SimpleTimeMark.Companion.now-uFjCsEo();
            SoundUtils.INSTANCE.playBeepSound();
        }
        if (!needsInventory) {
            LorenzUtils.sendTitle-dWUq8MI$default(LorenzUtils.INSTANCE, title, DurationKt.toDuration(1.5, DurationUnit.SECONDS), 0.0, 0.0f, 12, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Renderable> formatDisplay(Map<CropMilestonesConfig.MilestoneTextEntry, Renderable> lineMap) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List newList = new ArrayList();
        List<CropMilestonesConfig.MilestoneTextEntry> list = this.getConfig().text;
        Intrinsics.checkNotNullExpressionValue(list, "text");
        Iterable iterable = list;
        List list2 = newList;
        boolean $i$f$mapNotNull = false;
        void var5_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Renderable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CropMilestonesConfig.MilestoneTextEntry it = (CropMilestonesConfig.MilestoneTextEntry)element$iv$iv;
            boolean bl2 = false;
            if (lineMap.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        list2.addAll((List)destination$iv$iv);
        if (needsInventory) {
            CollectionUtils.addString$default(CollectionUtils.INSTANCE, newList, "\u00a7cOpen \u00a7e/cropmilestones \u00a7cto update!", null, null, 6, null);
        }
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMushroomCowData() {
        void $this$mapNotNullTo$iv$iv;
        void $this$addMushroomCowData_u24lambda_u246;
        CropType mushroom = CropType.MUSHROOM;
        boolean allowOverflow = this.getOverflowConfig().cropMilestoneDisplay;
        if (GardenCropMilestones.INSTANCE.isMaxed(mushroom, allowOverflow)) {
            Renderable[] renderableArray = new Renderable[]{Renderable.Companion.string$default(Renderable.Companion, "\u00a76Mooshroom Cow Perk", 0.0, null, null, null, 30, null), Renderable.Companion.string$default(Renderable.Companion, "\u00a7eMushroom crop is maxed!", 0.0, null, null, null, 30, null)};
            mushroomCowPerkDisplay = CollectionsKt.listOf(renderableArray);
            return;
        }
        HashMap lineMap = new HashMap();
        long counter = GardenCropMilestones.INSTANCE.getCounter(mushroom);
        int currentTier = GardenCropMilestones.INSTANCE.getTierForCropCount(counter, mushroom, allowOverflow);
        int nextTier = currentTier + 1;
        long cropsForCurrentTier = GardenCropMilestones.INSTANCE.getCropsForTier(currentTier, mushroom, allowOverflow);
        long cropsForNextTier = GardenCropMilestones.INSTANCE.getCropsForTier(nextTier, mushroom, allowOverflow);
        long have = counter - cropsForCurrentTier;
        long need = cropsForNextTier - cropsForCurrentTier;
        String haveFormat = NumberUtil.INSTANCE.addSeparators(have);
        String needFormat = NumberUtil.INSTANCE.addSeparators(need);
        long missing = need - have;
        ((Map)lineMap).put(MushroomPetPerkConfig.MushroomTextEntry.TITLE, Renderable.Companion.string$default(Renderable.Companion, "\u00a76Mooshroom Cow Perk", 0.0, null, null, null, 30, null));
        Map map2 = lineMap;
        MushroomPetPerkConfig.MushroomTextEntry mushroomTextEntry = MushroomPetPerkConfig.MushroomTextEntry.MUSHROOM_TIER;
        Object object = CollectionsKt.createListBuilder();
        List list = object;
        Renderable.Companion companion = Renderable.Companion;
        boolean bl = false;
        GardenAPI.addCropIconRenderable$default(GardenAPI.INSTANCE, (List)$this$addMushroomCowData_u24lambda_u246, mushroom, 0.0, false, 6, null);
        CollectionUtils.addString$default(CollectionUtils.INSTANCE, (List)$this$addMushroomCowData_u24lambda_u246, "\u00a77Mushroom Milestone " + nextTier, null, null, 6, null);
        object = Renderable.Companion.horizontalContainer$default(companion, CollectionsKt.build(object), 0, null, null, 14, null);
        map2.put(mushroomTextEntry, object);
        ((Map)lineMap).put(MushroomPetPerkConfig.MushroomTextEntry.NUMBER_OUT_OF_TOTAL, Renderable.Companion.string$default(Renderable.Companion, "\u00a7e" + haveFormat + "\u00a78/\u00a7e" + needFormat, 0.0, null, null, null, 30, null));
        double speed = GardenCropSpeed.INSTANCE.getAverageBlocksPerSecond();
        if (!(speed == 0.0)) {
            CropType cropType = GardenAPI.INSTANCE.getCurrentlyFarmedCrop();
            double blocksPerSecond = speed * (double)(cropType != null ? cropType.getMultiplier() : 1);
            long missingTime = DurationKt.toDuration((double)missing / blocksPerSecond, DurationUnit.SECONDS);
            TimeUnit biggestUnit = (TimeUnit)((Object)TimeUnit.getEntries().get(((CropMilestonesConfig.TimeFormatEntry)this.getConfig().highestTimeFormat.get()).ordinal()));
            String duration = TimeUtils.format-bz6L7rs$default(TimeUtils.INSTANCE, missingTime, biggestUnit, false, false, 0, false, 30, null);
            ((Map)lineMap).put(MushroomPetPerkConfig.MushroomTextEntry.TIME, Renderable.Companion.string$default(Renderable.Companion, "\u00a77In \u00a7b" + duration, 0.0, null, null, null, 30, null));
        }
        String percentageFormat = LorenzUtils.INSTANCE.formatPercentage((double)have / (double)need);
        ((Map)lineMap).put(MushroomPetPerkConfig.MushroomTextEntry.PERCENTAGE, Renderable.Companion.string$default(Renderable.Companion, "\u00a77Percentage: \u00a7e" + percentageFormat, 0.0, null, null, null, 30, null));
        if (currentTier > 46 && currentTier == previousMushNext && nextTier == currentTier + 1 && lastMushWarnedLevel != currentTier) {
            GardenCropMilestones.INSTANCE.onOverflowLevelUp(mushroom, currentTier - 1, nextTier - 1);
            lastMushWarnedLevel = currentTier;
        }
        previousMushNext = nextTier;
        List<MushroomPetPerkConfig.MushroomTextEntry> list2 = this.getConfig().mushroomPetPerk.text;
        Intrinsics.checkNotNullExpressionValue(list2, "text");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Renderable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            MushroomPetPerkConfig.MushroomTextEntry it = (MushroomPetPerkConfig.MushroomTextEntry)element$iv$iv;
            boolean bl3 = false;
            if ((Renderable)lineMap.get(it) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        mushroomCowPerkDisplay = (List)destination$iv$iv;
    }

    private final boolean isEnabled() {
        return GardenAPI.INSTANCE.inGarden() && this.getConfig().progress;
    }

    @SubscribeEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneProgress", "garden.cropMilestones.progress", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneWarnClose", "garden.cropMilestones.warnClose", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneHighestTimeFormat", "garden.cropMilestones.highestTimeFormat", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestShowMaxedNeeded", "garden.cropMilestones.bestShowMaxedNeeded", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneText", "garden.cropMilestones.text", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.blocksBrokenPrecision", "garden.cropMilestones.blocksBrokenPrecision", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneProgressDisplayPos", "garden.cropMilestones.progressDisplayPos", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestDisplay", "garden.cropMilestones.next.bestDisplay", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneBestAlwaysOn", "garden.cropMilestones.next.bestAlwaysOn", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneNextDisplayPos", "garden.cropMilestones.next.displayPos", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneMushroomPetPerkEnabled", "garden.cropMilestones.mushroomPetPerk.enabled", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneMushroomPetPerkText", "garden.cropMilestones.mushroomPetPerk.text", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "garden.cropMilestoneMushroomPetPerkPos", "garden.cropMilestones.mushroomPetPerk.pos", null, 8, null);
        event.move(11, "garden.cropMilestones.highestTimeFormat", "garden.cropMilestones.highestTimeFormat", GardenCropMilestoneDisplay::onConfigFix$lambda$8);
        event.move(11, "garden.cropMilestones.text", "garden.cropMilestones.text", GardenCropMilestoneDisplay::onConfigFix$lambda$9);
        event.move(11, "garden.cropMilestones.mushroomPetPerk.text", "garden.cropMilestones.mushroomPetPerk.text", GardenCropMilestoneDisplay::onConfigFix$lambda$10);
    }

    private static final void onConfigLoad$lambda$0() {
        GardenBestCropTime.INSTANCE.updateTimeTillNextCrop();
        INSTANCE.update();
    }

    private static final JsonElement onConfigFix$lambda$8(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntToEnum(element, CropMilestonesConfig.TimeFormatEntry.class);
    }

    private static final JsonElement onConfigFix$lambda$9(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntArrayListToEnumArrayList(element, CropMilestonesConfig.MilestoneTextEntry.class);
    }

    private static final JsonElement onConfigFix$lambda$10(JsonElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return ConfigUtils.INSTANCE.migrateIntArrayListToEnumArrayList(element, MushroomPetPerkConfig.MushroomTextEntry.class);
    }

    static {
        lastWarnedLevel = -1;
        lastMushWarnedLevel = -1;
    }
}

